/*
 * Decompiled with CFR 0.152.
 */
package jpen.internal;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public final class ActiveWindowProperty
implements PropertyChangeListener,
Runnable {
    private final Listener listener;
    private Window activeWindow;
    private final ScheduledExecutorService nullWindowScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, "jpen-ActiveWindow-filter");
            t.setDaemon(true);
            return t;
        }
    });
    private ScheduledFuture nullWindowTask;
    private final Runnable nullWindowRunnable = new Runnable(){

        public void run() {
            ActiveWindowProperty.this.set(null);
        }
    };

    public ActiveWindowProperty(Listener listener) {
        this.listener = listener;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener("activeWindow", this);
        this.activeWindow = keyboardFocusManager.getActiveWindow();
    }

    public synchronized Window get() {
        return this.activeWindow;
    }

    private synchronized void set(Window activeWindow) {
        this.activeWindow = activeWindow;
        this.listener.activeWindowChanged(activeWindow);
    }

    public void propertyChange(PropertyChangeEvent ev) {
        Window activeWindow = (Window)ev.getNewValue();
        if (activeWindow == this.activeWindow) {
            return;
        }
        if (activeWindow == null) {
            if (this.nullWindowTask == null || this.nullWindowTask.isDone()) {
                this.nullWindowTask = this.nullWindowScheduler.schedule(this, 50L, TimeUnit.MILLISECONDS);
            }
            return;
        }
        if (this.nullWindowTask != null) {
            this.nullWindowTask.cancel(false);
            this.nullWindowTask = null;
        }
        this.set(activeWindow);
    }

    public void run() {
        try {
            SwingUtilities.invokeAndWait(this.nullWindowRunnable);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static interface Listener {
        public void activeWindowChanged(Window var1);
    }
}

