/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpen.PButton;
import jpen.PButtonEvent;
import jpen.PKind;
import jpen.PLevel;
import jpen.Pen;
import jpen.PenState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PLevelEmulator {
    static final Logger L = Logger.getLogger(PLevelEmulator.class.getName());
    final Pen pen;
    private final List<List<ButtonTriggerPolicy>> kindTypeToButtonTypeToButtonTriggerPolicy = new ArrayList<List<ButtonTriggerPolicy>>();
    private final List<ButtonTriggerPolicy> activeButtonTriggerPolicies = new ArrayList<ButtonTriggerPolicy>();
    private final BitSet activeLevelTypes = new BitSet();
    private final List<ButtonTriggerPolicy> kindTypeToAlwaysActiveButtonTriggerPolicy = new ArrayList<ButtonTriggerPolicy>();

    PLevelEmulator(Pen pen) {
        this.pen = pen;
    }

    public void setPressureTriggerForLeftCursorButton(float pressure) {
        this.setTriggerForLeftCursorButton(new ButtonTriggerPolicy(PLevel.Type.PRESSURE.ordinal(), pressure, 0.0f));
    }

    public void setTriggerForLeftCursorButton(ButtonTriggerPolicy triggerPolicy) {
        this.setTrigger(PKind.Type.CURSOR.ordinal(), PButton.Type.LEFT.ordinal(), triggerPolicy, true);
    }

    public void setTrigger(PKind.Type kindType, PButton.Type buttonType, ButtonTriggerPolicy triggerPolicy) {
        this.setTrigger(kindType.ordinal(), buttonType.ordinal(), triggerPolicy);
    }

    public synchronized void setTrigger(int kindType, int buttonType, ButtonTriggerPolicy triggerPolicy) {
        this.setTrigger(kindType, buttonType, triggerPolicy, false);
    }

    public synchronized void setTrigger(int kindType, int buttonType, ButtonTriggerPolicy triggerPolicy, boolean alwaysActiveOnKind) {
        List<ButtonTriggerPolicy> buttonTypeToButtonTriggerPolicy = this.getButtonTypeToButtonTriggerPolicy(kindType);
        PLevelEmulator.ensureListSize(buttonTypeToButtonTriggerPolicy, buttonType);
        ButtonTriggerPolicy oldPolicy = buttonTypeToButtonTriggerPolicy.set(buttonType, triggerPolicy);
        PLevelEmulator.ensureListSize(this.kindTypeToAlwaysActiveButtonTriggerPolicy, kindType);
        if (oldPolicy != null && this.kindTypeToAlwaysActiveButtonTriggerPolicy.get(kindType) == oldPolicy) {
            this.kindTypeToAlwaysActiveButtonTriggerPolicy.set(kindType, null);
        }
        if (triggerPolicy != null && alwaysActiveOnKind) {
            this.kindTypeToAlwaysActiveButtonTriggerPolicy.set(kindType, triggerPolicy);
        }
    }

    public ButtonTriggerPolicy getButtonTriggerPolicy(PKind.Type kindType, PButton.Type buttonType) {
        return this.getButtonTriggerPolicy(kindType, buttonType);
    }

    public synchronized ButtonTriggerPolicy getButtonTriggerPolicy(int kindType, int buttonType) {
        List<ButtonTriggerPolicy> buttonTypeToButtonTriggerPolicy = this.getButtonTypeToButtonTriggerPolicy(kindType);
        PLevelEmulator.ensureListSize(buttonTypeToButtonTriggerPolicy, buttonType);
        return buttonTypeToButtonTriggerPolicy.get(buttonType);
    }

    private List<ButtonTriggerPolicy> getButtonTypeToButtonTriggerPolicy(int kindType) {
        PLevelEmulator.ensureListSize(this.kindTypeToButtonTypeToButtonTriggerPolicy, kindType);
        List<ButtonTriggerPolicy> buttonTypeToButtonTriggerPolicy = this.kindTypeToButtonTypeToButtonTriggerPolicy.get(kindType);
        if (buttonTypeToButtonTriggerPolicy == null) {
            buttonTypeToButtonTriggerPolicy = new ArrayList<ButtonTriggerPolicy>();
            this.kindTypeToButtonTypeToButtonTriggerPolicy.set(kindType, buttonTypeToButtonTriggerPolicy);
        }
        return buttonTypeToButtonTriggerPolicy;
    }

    private static void ensureListSize(List<?> list, int index) {
        while (list.size() <= index) {
            list.add(null);
        }
    }

    void scheduleEmulatedEvent(PButtonEvent buttonEvent) {
        PLevel emulatedLevel = null;
        emulatedLevel = (Boolean)buttonEvent.button.value != false ? this.emulateOnPress(buttonEvent.button.typeNumber) : this.emulateOnRelease(buttonEvent.button.typeNumber);
        if (emulatedLevel != null) {
            this.pen.penManager.scheduleLevelEvent(this.pen.penManager.emulationDevice, buttonEvent.time, Collections.singleton(emulatedLevel));
        }
    }

    private PLevel emulateOnPress(int buttonType) {
        PenState lastScheduledState = this.pen.lastScheduledState;
        ButtonTriggerPolicy triggerPolicy = this.getButtonTriggerPolicy(lastScheduledState.getKind().typeNumber, buttonType);
        if (L.isLoggable(Level.FINE)) {
            L.fine("triggerPolicy: " + triggerPolicy + ", buttonType: " + buttonType);
        }
        if (triggerPolicy != null) {
            this.setActiveButtonTriggerPolicy(buttonType, triggerPolicy);
            if (lastScheduledState.getLevelValue(triggerPolicy.levelType) == triggerPolicy.onPressValue) {
                return null;
            }
            return new PLevel(triggerPolicy.levelType, triggerPolicy.onPressValue);
        }
        return null;
    }

    private void setActiveButtonTriggerPolicy(int buttonType, ButtonTriggerPolicy policy) {
        PLevelEmulator.ensureListSize(this.activeButtonTriggerPolicies, buttonType);
        ButtonTriggerPolicy oldPolicy = this.activeButtonTriggerPolicies.set(buttonType, policy);
        if (oldPolicy != null) {
            this.activeLevelTypes.set(oldPolicy.levelType, false);
        }
        if (policy != null) {
            this.activeLevelTypes.set(policy.levelType, true);
        }
    }

    private PLevel emulateOnRelease(int buttonType) {
        PLevelEmulator.ensureListSize(this.activeButtonTriggerPolicies, buttonType);
        ButtonTriggerPolicy triggerPolicy = this.getActiveButtonTriggerPolicy(buttonType);
        if (L.isLoggable(Level.FINE)) {
            L.fine("triggerPolicy: " + triggerPolicy + ", buttonType: " + buttonType);
        }
        if (triggerPolicy != null) {
            this.setActiveButtonTriggerPolicy(buttonType, null);
            PLevel pLevel = new PLevel(triggerPolicy.levelType, triggerPolicy.onReleaseValue);
            return pLevel;
        }
        return null;
    }

    private ButtonTriggerPolicy getActiveButtonTriggerPolicy(int buttonType) {
        PLevelEmulator.ensureListSize(this.activeButtonTriggerPolicies, buttonType);
        ButtonTriggerPolicy buttonTriggerPolicy = this.activeButtonTriggerPolicies.get(buttonType);
        return buttonTriggerPolicy;
    }

    boolean onActivePolicy(int kindType, int levelType) {
        return this.onAlwaysActivePolicy(kindType, levelType) || this.activeLevelTypes.get(levelType);
    }

    private boolean onAlwaysActivePolicy(int kindType, int levelType) {
        PLevelEmulator.ensureListSize(this.kindTypeToAlwaysActiveButtonTriggerPolicy, kindType);
        ButtonTriggerPolicy alwaysActivePolicy = this.kindTypeToAlwaysActiveButtonTriggerPolicy.get(kindType);
        return alwaysActivePolicy == null ? false : alwaysActivePolicy.levelType == levelType;
    }

    public static class ButtonTriggerPolicy {
        public final int levelType;
        public final float onPressValue;
        public final float onReleaseValue;

        public ButtonTriggerPolicy(PLevel.Type levelType, float onPressValue, float onReleaseValue) {
            this(levelType.ordinal(), onPressValue, onReleaseValue);
        }

        public ButtonTriggerPolicy(int levelType, float onPressValue, float onReleaseValue) {
            this.levelType = levelType;
            this.onPressValue = onPressValue;
            this.onReleaseValue = onReleaseValue;
        }

        public String toString() {
            return "( levelType=" + this.levelType + ", onPressValue=" + this.onPressValue + ", onReleaseValue=" + this.onReleaseValue + " )";
        }
    }
}

