/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.pepsoft.minecraft.Java115Level;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.RegionFile;
import org.pepsoft.util.ColourUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.WorldRegion;

public class Mapper {
    private static int minHeight;
    private static int maxHeight;
    private static final Set<Integer> TERRAIN_BLOCKS;

    public static void main(String[] args) throws IOException, InterruptedException {
        File worldDir = null;
        int dim = 0;
        File output = null;
        block12: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i].trim()) {
                case "-d": {
                    if (i < args.length - 1) {
                        ++i;
                        try {
                            dim = Integer.parseInt(args[i].trim());
                        }
                        catch (NumberFormatException e) {
                            Mapper.error("Invalid argument to -d option: \"" + args[i] + "\"");
                        }
                        continue block12;
                    }
                    Mapper.error("Missing argument to -d option");
                    continue block12;
                }
                case "-c": {
                    if (i < args.length - 1) {
                        ++i;
                        continue block12;
                    }
                    Mapper.error("Missing argument to -c option");
                    continue block12;
                }
                case "-o": {
                    if (i < args.length - 1) {
                        String outputName;
                        if (!(outputName = args[++i].trim()).toLowerCase().endsWith(".png")) {
                            Mapper.error("Only PNG format suppored for output file");
                        }
                        if ((output = new File(outputName)).getParentFile() == null) continue block12;
                        if (!output.isDirectory()) {
                            Mapper.error("Parent directory of output file does not exist or is not a directory: \"" + output.getParentFile() + "\"");
                            continue block12;
                        }
                        if (output.canWrite()) continue block12;
                        Mapper.error("Parent directory of output file is not writeable: \"" + output.getParentFile() + "\"");
                        continue block12;
                    }
                    Mapper.error("Missing argument to -o option");
                    continue block12;
                }
                default: {
                    if (worldDir != null) {
                        Mapper.error("Unrecognised option: \"" + arg + "\"");
                        continue block12;
                    }
                    worldDir = new File(arg);
                }
            }
        }
        if (worldDir == null) {
            Mapper.error("Map directory not specified");
        } else if (!worldDir.isDirectory()) {
            Mapper.error("Map directory does not exist or is not a directory: \"" + worldDir + "\"");
        }
        if (dim < 0 || dim > 2) {
            Mapper.error("Invalid dimension specified: " + dim);
        }
        System.out.println("WorldPainter Mapper tool - version " + Version.VERSION + " - \u00a9 2012 - 2014 pepsoft.org");
        ColourScheme colourScheme = ColourScheme.DEFAULT;
        if (output == null) {
            output = new File(worldDir.getName().toLowerCase() + ".png");
        }
        Mapper.map(worldDir, dim, colourScheme, output);
    }

    private static void map(File worldDir, int dim, ColourScheme colourScheme, File output) throws IOException, InterruptedException {
        int z;
        int x;
        int chunkZ;
        Throwable throwable;
        RegionFile region;
        int regionChunkZ;
        int regionChunkX;
        File file;
        File dimensionDir;
        File levelDatFile = new File(worldDir, "level.dat");
        JavaLevel level = JavaLevel.load((File)levelDatFile);
        Platform platform = level.getVersion() == 19132 ? DefaultPlugin.JAVA_MCREGION : DefaultPlugin.JAVA_ANVIL;
        minHeight = level.getMinHeight();
        maxHeight = level.getMaxHeight();
        switch (dim) {
            case 0: {
                dimensionDir = worldDir;
                break;
            }
            case 1: {
                dimensionDir = new File(worldDir, "DIM-1");
                break;
            }
            case 2: {
                dimensionDir = new File(worldDir, "DIM1");
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(dim));
            }
        }
        File regionDir = new File(dimensionDir, "region");
        if (!regionDir.exists()) {
            Mapper.error("Map does not have dimension " + dim);
        }
        System.out.println("Mapping " + worldDir);
        System.out.println("Name: " + level.getName());
        System.out.println("Seed: " + level.getSeed());
        if (level instanceof Java115Level && ((Java115Level)level).getGeneratorName() != null) {
            System.out.println("Generator: " + ((Java115Level)level).getGeneratorName() + " (version " + ((Java115Level)level).getGeneratorVersion() + ")");
        }
        System.out.println("Map build limits: " + minHeight + " - " + maxHeight);
        System.out.println("Storage format: " + (platform == DefaultPlugin.JAVA_MCREGION ? "McRegion (Minecraft 1.1 or earlier)" : "Anvil (Minecraft 1.2 or later)"));
        File[] regionFiles = regionDir.listFiles(platform == DefaultPlugin.JAVA_MCREGION ? (dir, name) -> name.toLowerCase().endsWith(".mcr") : (dir, name) -> name.toLowerCase().endsWith(".mca"));
        int tmpLowestRegionX = Integer.MAX_VALUE;
        int tmpHighestRegionX = Integer.MIN_VALUE;
        int tmpLowestRegionZ = Integer.MAX_VALUE;
        int tmpHighestRegionZ = Integer.MIN_VALUE;
        for (File regionFile : regionFiles) {
            String[] parts = regionFile.getName().split("\\.");
            int regionX = Integer.parseInt(parts[1]);
            int regionZ = Integer.parseInt(parts[2]);
            if (regionX < tmpLowestRegionX) {
                tmpLowestRegionX = regionX;
            }
            if (regionX > tmpHighestRegionX) {
                tmpHighestRegionX = regionX;
            }
            if (regionZ < tmpLowestRegionZ) {
                tmpLowestRegionZ = regionZ;
            }
            if (regionZ <= tmpHighestRegionZ) continue;
            tmpHighestRegionZ = regionZ;
        }
        int lowestRegionX = tmpLowestRegionX;
        int highestRegionX = tmpHighestRegionX;
        int lowestRegionZ = tmpLowestRegionZ;
        int highestRegionZ = tmpHighestRegionZ;
        int tmpLowestChunkX = Integer.MAX_VALUE;
        int tmpHighestChunkX = Integer.MIN_VALUE;
        int tmpLowestChunkZ = Integer.MAX_VALUE;
        int tmpHighestChunkZ = Integer.MIN_VALUE;
        for (int regionX = lowestRegionX; regionX <= highestRegionX; ++regionX) {
            int chunkX2;
            file = new File(regionDir, "r." + regionX + "." + lowestRegionZ + (platform == DefaultPlugin.JAVA_MCREGION ? ".mcr" : ".mca"));
            if (file.exists()) {
                regionChunkX = regionX << 5;
                regionChunkZ = lowestRegionZ << 5;
                region = new RegionFile(file);
                throwable = null;
                try {
                    for (chunkX2 = 0; chunkX2 < 32; ++chunkX2) {
                        for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                            if (!region.containsChunk(chunkX2, chunkZ)) continue;
                            x = regionChunkX + chunkX2;
                            z = regionChunkZ + chunkZ;
                            if (x < tmpLowestChunkX) {
                                tmpLowestChunkX = x;
                            }
                            if (x > tmpHighestChunkX) {
                                tmpHighestChunkX = x;
                            }
                            if (z < tmpLowestChunkZ) {
                                tmpLowestChunkZ = z;
                            }
                            if (z <= tmpHighestChunkZ) continue;
                            tmpHighestChunkZ = z;
                        }
                    }
                }
                catch (Throwable chunkX2) {
                    throwable = chunkX2;
                    throw chunkX2;
                }
                finally {
                    if (region != null) {
                        if (throwable != null) {
                            try {
                                region.close();
                            }
                            catch (Throwable chunkX2) {
                                throwable.addSuppressed(chunkX2);
                            }
                        } else {
                            region.close();
                        }
                    }
                }
            }
            if (!(file = new File(regionDir, "r." + regionX + "." + highestRegionZ + (platform == DefaultPlugin.JAVA_MCREGION ? ".mcr" : ".mca"))).exists()) continue;
            regionChunkX = regionX << 5;
            regionChunkZ = highestRegionZ << 5;
            region = new RegionFile(file);
            throwable = null;
            try {
                for (chunkX2 = 0; chunkX2 < 32; ++chunkX2) {
                    for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                        if (!region.containsChunk(chunkX2, chunkZ)) continue;
                        x = regionChunkX + chunkX2;
                        z = regionChunkZ + chunkZ;
                        if (x < tmpLowestChunkX) {
                            tmpLowestChunkX = x;
                        }
                        if (x > tmpHighestChunkX) {
                            tmpHighestChunkX = x;
                        }
                        if (z < tmpLowestChunkZ) {
                            tmpLowestChunkZ = z;
                        }
                        if (z <= tmpHighestChunkZ) continue;
                        tmpHighestChunkZ = z;
                    }
                }
                continue;
            }
            catch (Throwable chunkX3) {
                throwable = chunkX3;
                throw chunkX3;
            }
            finally {
                if (region != null) {
                    if (throwable != null) {
                        try {
                            region.close();
                        }
                        catch (Throwable chunkX3) {
                            throwable.addSuppressed(chunkX3);
                        }
                    } else {
                        region.close();
                    }
                }
            }
        }
        for (int regionZ = lowestRegionZ + 1; regionZ <= highestRegionZ - 1; ++regionZ) {
            file = new File(regionDir, "r." + lowestRegionX + "." + regionZ + (platform == DefaultPlugin.JAVA_MCREGION ? ".mcr" : ".mca"));
            if (file.exists()) {
                regionChunkX = lowestRegionX << 5;
                regionChunkZ = regionZ << 5;
                region = new RegionFile(file);
                throwable = null;
                try {
                    for (int chunkX = 0; chunkX < 32; ++chunkX) {
                        for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                            if (!region.containsChunk(chunkX, chunkZ)) continue;
                            x = regionChunkX + chunkX;
                            z = regionChunkZ + chunkZ;
                            if (x < tmpLowestChunkX) {
                                tmpLowestChunkX = x;
                            }
                            if (x > tmpHighestChunkX) {
                                tmpHighestChunkX = x;
                            }
                            if (z < tmpLowestChunkZ) {
                                tmpLowestChunkZ = z;
                            }
                            if (z <= tmpHighestChunkZ) continue;
                            tmpHighestChunkZ = z;
                        }
                    }
                }
                catch (Throwable chunkX) {
                    throwable = chunkX;
                    throw chunkX;
                }
                finally {
                    if (region != null) {
                        if (throwable != null) {
                            try {
                                region.close();
                            }
                            catch (Throwable chunkX) {
                                throwable.addSuppressed(chunkX);
                            }
                        } else {
                            region.close();
                        }
                    }
                }
            }
            if (!(file = new File(regionDir, "r." + highestRegionX + "." + regionZ + (platform == DefaultPlugin.JAVA_MCREGION ? ".mcr" : ".mca"))).exists()) continue;
            regionChunkX = highestRegionX << 5;
            regionChunkZ = regionZ << 5;
            region = new RegionFile(file);
            throwable = null;
            try {
                for (int chunkX = 0; chunkX < 32; ++chunkX) {
                    for (chunkZ = 0; chunkZ < 32; ++chunkZ) {
                        if (!region.containsChunk(chunkX, chunkZ)) continue;
                        x = regionChunkX + chunkX;
                        z = regionChunkZ + chunkZ;
                        if (x < tmpLowestChunkX) {
                            tmpLowestChunkX = x;
                        }
                        if (x > tmpHighestChunkX) {
                            tmpHighestChunkX = x;
                        }
                        if (z < tmpLowestChunkZ) {
                            tmpLowestChunkZ = z;
                        }
                        if (z <= tmpHighestChunkZ) continue;
                        tmpHighestChunkZ = z;
                    }
                }
                continue;
            }
            catch (Throwable chunkX) {
                throwable = chunkX;
                throw chunkX;
            }
            finally {
                if (region != null) {
                    if (throwable != null) {
                        try {
                            region.close();
                        }
                        catch (Throwable chunkX) {
                            throwable.addSuppressed(chunkX);
                        }
                    } else {
                        region.close();
                    }
                }
            }
        }
        int lowestChunkX = tmpLowestChunkX;
        int lowestChunkZ = tmpLowestChunkZ;
        int widthChunks = tmpHighestChunkX - tmpLowestChunkX + 1;
        int heightChunks = tmpHighestChunkZ - tmpLowestChunkZ + 1;
        System.out.println("Width: " + (widthChunks << 4));
        System.out.println("Height: " + (heightChunks << 4));
        BufferedImage image = new BufferedImage(widthChunks << 4, heightChunks << 4, 2);
        int imageOffsetX = lowestChunkX << 4;
        int imageOffsetY = lowestChunkZ << 4;
        int waterColour = colourScheme.getColour(Material.WATER);
        int lavaColour = colourScheme.getColour(Material.LAVA);
        int snowColour = colourScheme.getColour(Material.SNOW);
        int threads = Runtime.getRuntime().availableProcessors();
        System.out.print("Mapping");
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        File[] fileArray = regionFiles;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file2;
            File finalFile = file2 = fileArray[i];
            executorService.submit(() -> {
                try {
                    String[] parts = finalFile.getName().split("\\.");
                    int regionX = Integer.parseInt(parts[1]);
                    int regionY = Integer.parseInt(parts[2]);
                    WorldRegion world = new WorldRegion(worldDir, dim, regionX, regionY, minHeight, maxHeight, platform);
                    int[][] heightCache = new int[544][544];
                    for (int i = 0; i < 544; ++i) {
                        Arrays.fill(heightCache[i], -1);
                    }
                    for (int chunkX = 0; chunkX < 32; ++chunkX) {
                        for (int chunkY = 0; chunkY < 32; ++chunkY) {
                            int worldChunkX = regionX << 5 | chunkX;
                            int worldChunkY = regionY << 5 | chunkY;
                            if (!world.isChunkPresent(worldChunkX, worldChunkY)) continue;
                            for (int x = 0; x < 16; ++x) {
                                block6: for (int y = 0; y < 16; ++y) {
                                    int worldX = worldChunkX << 4 | x;
                                    int worldY = worldChunkY << 4 | y;
                                    boolean snow = false;
                                    boolean water = false;
                                    boolean lava = false;
                                    int waterLevel = 0;
                                    for (int height = maxHeight - 1; height >= minHeight; --height) {
                                        int colour;
                                        int fluidAlpha;
                                        int depth;
                                        int data;
                                        int blockType = world.getBlockTypeAt(worldX, worldY, height);
                                        if (blockType == 0) continue;
                                        if (blockType == 78) {
                                            snow = true;
                                            continue;
                                        }
                                        if (blockType == 9 || blockType == 8 || blockType == 11 || blockType == 10) {
                                            if (world.getDataAt(worldX, worldY, height) != 0 || waterLevel != 0) continue;
                                            waterLevel = height;
                                            if (blockType == 10 || blockType == 11) {
                                                lava = true;
                                                continue;
                                            }
                                            water = true;
                                            continue;
                                        }
                                        if (TERRAIN_BLOCKS.contains(blockType)) {
                                            data = world.getDataAt(worldX, worldY, height);
                                            depth = waterLevel - height;
                                            fluidAlpha = 255 >> Math.min(depth, 3);
                                            colour = colourScheme.getColour(Material.get((int)blockType, (int)data));
                                            if (depth > 0) {
                                                colour = ColourUtils.multiply((int)colour, (int)Mapper.getBrightenAmount((MinecraftWorld)world, heightCache, chunkX + 1 << 4 | x, chunkY + 1 << 4 | y, regionX, regionY));
                                            }
                                            if (water) {
                                                colour = ColourUtils.mix((int)colour, (int)waterColour, (int)fluidAlpha);
                                            } else if (lava) {
                                                colour = ColourUtils.mix((int)colour, (int)lavaColour, (int)fluidAlpha);
                                            }
                                            if (snow) {
                                                colour = ColourUtils.mix((int)colour, (int)snowColour, (int)64);
                                            }
                                            if (depth <= 0) {
                                                colour = ColourUtils.multiply((int)colour, (int)Mapper.getBrightenAmount((MinecraftWorld)world, heightCache, chunkX + 1 << 4 | x, chunkY + 1 << 4 | y, regionX, regionY));
                                            }
                                            image.setRGB(worldX - imageOffsetX, worldY - imageOffsetY, 0xFF000000 | colour);
                                            continue block6;
                                        }
                                        data = world.getDataAt(worldX, worldY, height);
                                        depth = waterLevel - height;
                                        fluidAlpha = 255 >> Math.min(depth, 3);
                                        colour = colourScheme.getColour(Material.get((int)blockType, (int)data));
                                        if (water) {
                                            colour = ColourUtils.mix((int)colour, (int)waterColour, (int)fluidAlpha);
                                        } else if (lava) {
                                            colour = ColourUtils.mix((int)colour, (int)lavaColour, (int)fluidAlpha);
                                        }
                                        if (snow) {
                                            colour = ColourUtils.mix((int)colour, (int)snowColour);
                                        }
                                        image.setRGB(worldX - imageOffsetX, worldY - imageOffsetY, 0xFF000000 | colour);
                                        continue block6;
                                    }
                                }
                            }
                        }
                    }
                    System.out.print('.');
                    System.out.flush();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    System.exit(1);
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.DAYS);
        System.out.println();
        System.out.println("Saving image to " + output + "...");
        ImageIO.write((RenderedImage)image, "PNG", output);
        System.out.println("Finished");
    }

    private static void error(String message) {
        System.err.println(message);
        System.exit(2);
    }

    private static int getBrightenAmount(MinecraftWorld world, int[][] heightCache, int x, int y, int regionX, int regionY) {
        return Math.max(0, (Mapper.getHeight(world, heightCache, x + 1, y, regionX, regionY) - Mapper.getHeight(world, heightCache, x - 1, y, regionX, regionY) + Mapper.getHeight(world, heightCache, x, y + 1, regionX, regionY) - Mapper.getHeight(world, heightCache, x, y - 1, regionX, regionY) << 5) + 256);
    }

    private static int getHeight(MinecraftWorld world, int[][] heightCache, int x, int y, int regionX, int regionY) {
        if (heightCache[x][y] == -1) {
            int worldX = (regionX << 9) + x - 16;
            int worldY = (regionY << 9) + y - 16;
            for (int height = maxHeight - 1; height >= minHeight; --height) {
                if (!TERRAIN_BLOCKS.contains(world.getBlockTypeAt(worldX, worldY, height))) continue;
                heightCache[x][y] = height;
                return height;
            }
            heightCache[x][y] = 62;
        }
        return heightCache[x][y];
    }

    static {
        TERRAIN_BLOCKS = new HashSet<Integer>();
        TERRAIN_BLOCKS.add(1);
        TERRAIN_BLOCKS.add(2);
        TERRAIN_BLOCKS.add(3);
        TERRAIN_BLOCKS.add(7);
        TERRAIN_BLOCKS.add(12);
        TERRAIN_BLOCKS.add(13);
        TERRAIN_BLOCKS.add(14);
        TERRAIN_BLOCKS.add(15);
        TERRAIN_BLOCKS.add(16);
        TERRAIN_BLOCKS.add(21);
        TERRAIN_BLOCKS.add(24);
        TERRAIN_BLOCKS.add(49);
        TERRAIN_BLOCKS.add(56);
        TERRAIN_BLOCKS.add(60);
        TERRAIN_BLOCKS.add(73);
        TERRAIN_BLOCKS.add(74);
        TERRAIN_BLOCKS.add(80);
        TERRAIN_BLOCKS.add(82);
        TERRAIN_BLOCKS.add(87);
        TERRAIN_BLOCKS.add(88);
        TERRAIN_BLOCKS.add(110);
    }
}

