/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.painting;

import java.awt.Rectangle;
import java.awt.Window;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Queue;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.swing.ProgressDialog;
import org.pepsoft.util.swing.ProgressTask;

public class GeneralQueueLinearFloodFiller {
    private int width;
    private int height;
    private int offsetX;
    private int offsetY;
    private BitSet blocksChecked;
    private Queue<FloodFillRange> ranges;
    private boolean boundsTooLarge;
    private boolean boundsHit;
    private final FillMethod fillMethod;
    private static final int MAX_INT_SQUARE_SIDE = 46340;

    public GeneralQueueLinearFloodFiller(FillMethod fillMethod) {
        this.fillMethod = fillMethod;
    }

    public boolean floodFill(int x, int y, Window parent) {
        Rectangle largestPossibleFloodArea = new Rectangle(x - 23170, y - 23170, 46340, 46340);
        Rectangle fillBounds = this.fillMethod.getBounds();
        if (!largestPossibleFloodArea.contains(fillBounds)) {
            this.boundsTooLarge = true;
            Rectangle floodArea = largestPossibleFloodArea.intersection(fillBounds);
            this.width = floodArea.width;
            this.height = floodArea.height;
            this.offsetX = floodArea.x;
            this.offsetY = floodArea.y;
        } else {
            this.width = fillBounds.width;
            this.height = fillBounds.height;
            this.offsetX = fillBounds.x;
            this.offsetY = fillBounds.y;
        }
        this.prepare();
        long start = System.currentTimeMillis();
        this.linearFill(x -= this.offsetX, y -= this.offsetY);
        while (this.ranges.size() > 0) {
            FloodFillRange range = this.ranges.remove();
            this.processRange(range);
            long lap = System.currentTimeMillis();
            if (lap - start <= 2000L) continue;
            return ProgressDialog.executeTask((Window)parent, (ProgressTask)new ProgressTask<FillMethod>(){

                public String getName() {
                    return GeneralQueueLinearFloodFiller.this.fillMethod.getDescription();
                }

                public FillMethod execute(ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
                    while (GeneralQueueLinearFloodFiller.this.ranges.size() > 0) {
                        FloodFillRange range = (FloodFillRange)GeneralQueueLinearFloodFiller.this.ranges.remove();
                        GeneralQueueLinearFloodFiller.this.processRange(range);
                        progressReceiver.checkForCancellation();
                    }
                    return GeneralQueueLinearFloodFiller.this.fillMethod;
                }
            }, (ProgressDialog.Option[])new ProgressDialog.Option[0]) != null;
        }
        return true;
    }

    public boolean isBoundsHit() {
        return this.boundsTooLarge && this.boundsHit;
    }

    private synchronized void prepare() {
        this.blocksChecked = new BitSet(this.width * this.height);
        this.ranges = new LinkedList<FloodFillRange>();
    }

    private synchronized void processRange(FloodFillRange range) {
        int downPxIdx = this.width * (range.Y + 1) + range.startX;
        int upPxIdx = this.width * (range.Y - 1) + range.startX;
        int upY = range.Y - 1;
        int downY = range.Y + 1;
        for (int i = range.startX; i <= range.endX; ++i) {
            if (range.Y > 0) {
                if (!this.blocksChecked.get(upPxIdx) && !this.fillMethod.isBoundary(this.offsetX + i, this.offsetY + upY)) {
                    this.linearFill(i, upY);
                }
            } else {
                this.boundsHit = true;
            }
            if (range.Y < this.height - 1) {
                if (!this.blocksChecked.get(downPxIdx) && !this.fillMethod.isBoundary(this.offsetX + i, this.offsetY + downY)) {
                    this.linearFill(i, downY);
                }
            } else {
                this.boundsHit = true;
            }
            ++downPxIdx;
            ++upPxIdx;
        }
    }

    private synchronized void linearFill(int x, int y) {
        int lFillLoc = x;
        int pxIdx = this.width * y + x;
        do {
            this.fillMethod.fill(this.offsetX + lFillLoc, this.offsetY + y);
            this.blocksChecked.set(pxIdx);
        } while (--lFillLoc >= 0 && !this.blocksChecked.get(--pxIdx) && !this.fillMethod.isBoundary(this.offsetX + lFillLoc, this.offsetY + y));
        if (lFillLoc == 0) {
            this.boundsHit = true;
        }
        ++lFillLoc;
        int rFillLoc = x;
        pxIdx = this.width * y + x;
        do {
            this.fillMethod.fill(this.offsetX + rFillLoc, this.offsetY + y);
            this.blocksChecked.set(pxIdx);
        } while (++rFillLoc < this.width && !this.blocksChecked.get(++pxIdx) && !this.fillMethod.isBoundary(this.offsetX + rFillLoc, this.offsetY + y));
        if (rFillLoc == this.width - 1) {
            this.boundsHit = true;
        }
        FloodFillRange r = new FloodFillRange(lFillLoc, --rFillLoc, y);
        this.ranges.offer(r);
    }

    public static interface FillMethod {
        public String getDescription();

        public Rectangle getBounds();

        public boolean isBoundary(int var1, int var2);

        public void fill(int var1, int var2);
    }

    static class FloodFillRange {
        public int startX;
        public int endX;
        public int Y;

        public FloodFillRange(int startX, int endX, int y) {
            this.startX = startX;
            this.endX = endX;
            this.Y = y;
        }
    }
}

