/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.painting;

import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.painting.Paint;

public abstract class AbstractPaint
implements Paint {
    protected Filter filter;
    protected Brush brush;
    protected boolean dither;
    protected boolean filterEnabled;

    @Override
    public final Brush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(Brush brush) {
        this.brush = brush;
    }

    @Override
    public final Filter getFilter() {
        return this.filter;
    }

    @Override
    public final void setFilter(Filter filter) {
        this.filter = filter;
        this.filterEnabled = filter != null;
    }

    @Override
    public boolean isDither() {
        return this.dither;
    }

    @Override
    public void setDither(boolean dither) {
        this.dither = dither;
    }

    public String toString() {
        return this.getId();
    }

    protected final float getStrength(int centerX, int centerY, int x, int y) {
        return this.filterEnabled ? this.filter.modifyStrength(x, y, this.brush.getStrength(x - centerX, y - centerY)) : this.brush.getStrength(x - centerX, y - centerY);
    }

    protected final float getFullStrength(int centerX, int centerY, int x, int y) {
        return this.filterEnabled ? this.filter.modifyStrength(x, y, this.brush.getFullStrength(x - centerX, y - centerY)) : this.brush.getFullStrength(x - centerX, y - centerY);
    }
}

