/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.brushes.Brush;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.AnnotationsExporter;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.operations.AbstractBrushOperation;
import org.pepsoft.worldpainter.operations.PaintOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;
import org.pepsoft.worldpainter.operations.TextDialog;
import org.pepsoft.worldpainter.painting.DimensionPainter;
import org.pepsoft.worldpainter.painting.Paint;
import org.pepsoft.worldpainter.painting.PaintFactory;

public class Text
extends AbstractBrushOperation
implements PaintOperation {
    private final DimensionPainter painter = new DimensionPainter();
    private String savedText;
    private static final JPanel OPTIONS_PANEL = new StandardOptionsPanel("Text", "<p>Click to form text with the currently selected paint with its top left corner at the indicated location");

    public Text(WorldPainterView view) {
        super("Text", "Draw text using any layer or terrain at different sizes, fonts and angles", view, "operation.text");
    }

    @Override
    public Paint getPaint() {
        return this.painter.getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
        if (this.getBrush() != null) {
            paint.setBrush(this.getBrush());
        }
        this.painter.setPaint(paint);
    }

    @Override
    public JPanel getOptionsPanel() {
        return OPTIONS_PANEL;
    }

    @Override
    protected void brushChanged(Brush newBrush) {
        if (this.painter.getPaint() != null) {
            this.painter.getPaint().setBrush(newBrush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        if (this.painter.getPaint() instanceof PaintFactory.NullPaint) {
            return;
        }
        AnnotationsExporter.AnnotationsSettings settings = (AnnotationsExporter.AnnotationsSettings)this.getDimension().getLayerSettings((Layer)Annotations.INSTANCE);
        if (settings == null) {
            settings = new AnnotationsExporter.AnnotationsSettings();
        }
        TextDialog dialog = new TextDialog(SwingUtilities.getWindowAncestor((Component)this.getView()), settings.getDefaultFont(), settings.getDefaultSize(), this.savedText);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            Font font = dialog.getSelectedFont();
            settings.setDefaultFont(font.getFamily());
            settings.setDefaultSize(font.getSize());
            dimension.setLayerSettings((Layer)Annotations.INSTANCE, (ExporterSettings)settings);
            this.savedText = dialog.getText();
            if (!this.savedText.trim().isEmpty()) {
                this.painter.setFont(font);
                this.painter.setTextAngle(dialog.getSelectedAngle());
                dimension.setEventsInhibited(true);
                try {
                    this.painter.drawText(dimension, centreX, centreY, this.savedText);
                }
                finally {
                    dimension.setEventsInhibited(false);
                }
            }
        }
    }
}

