/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import javax.swing.JPanel;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;

public class RaisePyramid
extends MouseOrTabletOperation {
    private static final StandardOptionsPanel OPTIONS_PANEL = new StandardOptionsPanel("Raise Pyramid", "<p>Click to raise a four-sided sandstone pyramid from the ground");

    public RaisePyramid(WorldPainter worldPainter) {
        super("Raise Pyramid", "Raises a square pyramid out of the ground", worldPainter, 100, "operation.raisePyramid", "pyramid");
    }

    @Override
    public JPanel getOptionsPanel() {
        return OPTIONS_PANEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        float height = dimension.getHeightAt(centreX, centreY);
        dimension.setEventsInhibited(true);
        try {
            if (height < (float)dimension.getMaxHeight() - 1.5f) {
                dimension.setHeightAt(centreX, centreY, height + 1.0f);
            }
            dimension.setTerrainAt(centreX, centreY, Terrain.SANDSTONE);
            int maxR = dimension.getMaxHeight() - dimension.getMinHeight();
            for (int r = 1; r < maxR; ++r) {
                float f = height;
                height = f - 1.0f;
                if (this.raiseRing(dimension, centreX, centreY, r, f)) continue;
                break;
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }

    private boolean raiseRing(Dimension dimension, int x, int y, int r, float desiredHeight) {
        float actualHeight;
        int i;
        boolean raised = false;
        for (i = -r; i <= r; ++i) {
            actualHeight = dimension.getHeightAt(x + i, y - r);
            if (actualHeight < desiredHeight) {
                raised = true;
                dimension.setHeightAt(x + i, y - r, desiredHeight);
                dimension.setTerrainAt(x + i, y - r, Terrain.SANDSTONE);
            }
            if (!((actualHeight = dimension.getHeightAt(x + i, y + r)) < desiredHeight)) continue;
            raised = true;
            dimension.setHeightAt(x + i, y + r, desiredHeight);
            dimension.setTerrainAt(x + i, y + r, Terrain.SANDSTONE);
        }
        for (i = -r + 1; i < r; ++i) {
            actualHeight = dimension.getHeightAt(x - r, y + i);
            if (actualHeight < desiredHeight) {
                raised = true;
                dimension.setHeightAt(x - r, y + i, desiredHeight);
                dimension.setTerrainAt(x - r, y + i, Terrain.SANDSTONE);
            }
            if (!((actualHeight = dimension.getHeightAt(x + r, y + i)) < desiredHeight)) continue;
            raised = true;
            dimension.setHeightAt(x + r, y + i, desiredHeight);
            dimension.setTerrainAt(x + r, y + i, Terrain.SANDSTONE);
        }
        return raised;
    }
}

