/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;
import org.pepsoft.worldpainter.operations.StandardOptionsPanel;
import org.pepsoft.worldpainter.painting.GeneralQueueLinearFloodFiller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flood
extends MouseOrTabletOperation {
    private boolean alreadyFlooding;
    private final boolean floodWithLava;
    private final StandardOptionsPanel optionsPanel;
    private static final Logger logger = LoggerFactory.getLogger(Flood.class);

    public Flood(WorldPainter view, boolean floodWithLava) {
        super(floodWithLava ? "Lava" : "Flood", "Flood an area with " + (floodWithLava ? "lava" : "water"), (WorldPainterView)view, "operation.flood." + (floodWithLava ? "lava" : "water"), floodWithLava ? "flood_with_lava" : "flood");
        this.floodWithLava = floodWithLava;
        this.optionsPanel = floodWithLava ? new StandardOptionsPanel("Flood with Lava", "<ul><li>Left-click on dry land to flood with lava\n<li>Left-click on lava to raise it by one\n<li>Right-click on lava to lower it by one\n<li>Click on water to turn it to lava\n</ul>") : new StandardOptionsPanel("Flood with Water", "<ul><li>Left-click on dry land to flood with water\n<li>Left-click on water to raise it by one\n<li>Right-click on water to lower it by one\n<li>Click on lava to turn it to water\n</ul>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        final Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        if (this.alreadyFlooding) {
            logger.debug("Flood operation already in progress; ignoring repeated invocation");
            return;
        }
        this.alreadyFlooding = true;
        try {
            Dimension floodToHeight2;
            FloodFillMethod fillMethod;
            boolean fluidPresent;
            Rectangle dimensionBounds = new Rectangle(dimension.getLowestX() * 128, dimension.getLowestY() * 128, dimension.getWidth() * 128, dimension.getHeight() * 128);
            int terrainHeight = dimension.getIntHeightAt(centreX, centreY);
            if (terrainHeight == Integer.MIN_VALUE) {
                return;
            }
            int waterLevel = dimension.getWaterLevelAt(centreX, centreY);
            boolean bl = fluidPresent = waterLevel > terrainHeight;
            if (inverse && !fluidPresent) {
                return;
            }
            if (fluidPresent && this.floodWithLava != dimension.getBitLayerValueAt((Layer)FloodWithLava.INSTANCE, centreX, centreY)) {
                fillMethod = this.floodWithLava ? new FloodFillMethod("Changing water to lava", dimensionBounds){

                    @Override
                    public boolean isBoundary(int x, int y) {
                        int height = dimension.getIntHeightAt(x, y);
                        return height == Integer.MIN_VALUE || dimension.getWaterLevelAt(x, y) <= height || dimension.getBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y);
                    }

                    @Override
                    public void fill(int x, int y) {
                        dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y, true);
                    }
                } : new FloodFillMethod("Changing lava to water", dimensionBounds){

                    @Override
                    public boolean isBoundary(int x, int y) {
                        int height = dimension.getIntHeightAt(x, y);
                        return height == Integer.MIN_VALUE || dimension.getWaterLevelAt(x, y) <= height || !dimension.getBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y);
                    }

                    @Override
                    public void fill(int x, int y) {
                        dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y, false);
                    }
                };
            } else {
                int floodToHeight2;
                int height = Math.max(terrainHeight, waterLevel);
                if (inverse ? height <= dimension.getMinHeight() : height >= dimension.getMaxHeight() - 1) {
                    return;
                }
                int n = floodToHeight2 = inverse ? height - 1 : height + 1;
                fillMethod = inverse ? (this.floodWithLava ? new FloodFillMethod("Lowering lava level", dimensionBounds){

                    @Override
                    public boolean isBoundary(int x, int y) {
                        int height = dimension.getIntHeightAt(x, y);
                        return height == Integer.MIN_VALUE || dimension.getWaterLevelAt(x, y) <= height || dimension.getWaterLevelAt(x, y) <= floodToHeight2;
                    }

                    @Override
                    public void fill(int x, int y) {
                        dimension.setWaterLevelAt(x, y, floodToHeight2);
                        dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y, true);
                    }
                } : new FloodFillMethod("Lowering water level", dimensionBounds){

                    @Override
                    public boolean isBoundary(int x, int y) {
                        int height = dimension.getIntHeightAt(x, y);
                        return height == Integer.MIN_VALUE || dimension.getWaterLevelAt(x, y) <= height || dimension.getWaterLevelAt(x, y) <= floodToHeight2;
                    }

                    @Override
                    public void fill(int x, int y) {
                        dimension.setWaterLevelAt(x, y, floodToHeight2);
                        dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y, false);
                    }
                }) : (this.floodWithLava ? new FloodFillMethod(fluidPresent ? "Raising lava level" : "Flooding with lava", dimensionBounds){

                    @Override
                    public boolean isBoundary(int x, int y) {
                        int height = dimension.getIntHeightAt(x, y);
                        int waterLevel = dimension.getWaterLevelAt(x, y);
                        return height == Integer.MIN_VALUE || height >= floodToHeight2 || waterLevel >= floodToHeight2;
                    }

                    @Override
                    public void fill(int x, int y) {
                        dimension.setWaterLevelAt(x, y, floodToHeight2);
                        dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y, true);
                    }
                } : new FloodFillMethod(fluidPresent ? "Raising water level" : "Flooding with water", dimensionBounds){

                    @Override
                    public boolean isBoundary(int x, int y) {
                        int height = dimension.getIntHeightAt(x, y);
                        int waterLevel = dimension.getWaterLevelAt(x, y);
                        return height == Integer.MIN_VALUE || height >= floodToHeight2 || waterLevel >= floodToHeight2;
                    }

                    @Override
                    public void fill(int x, int y) {
                        dimension.setWaterLevelAt(x, y, floodToHeight2);
                        dimension.setBitLayerValueAt((Layer)FloodWithLava.INSTANCE, x, y, false);
                    }
                });
            }
            Dimension height = dimension;
            synchronized (height) {
                dimension.setEventsInhibited(true);
            }
            try {
                GeneralQueueLinearFloodFiller flooder;
                block45: {
                    height = dimension;
                    synchronized (height) {
                        dimension.rememberChanges();
                    }
                    flooder = new GeneralQueueLinearFloodFiller(fillMethod);
                    if (flooder.floodFill(centreX, centreY, SwingUtilities.getWindowAncestor((Component)this.getView()))) break block45;
                    floodToHeight2 = dimension;
                    synchronized (floodToHeight2) {
                        if (dimension.undoChanges()) {
                            dimension.clearRedo();
                            dimension.armSavePoint();
                        }
                    }
                    return;
                }
                try {
                    if (flooder.isBoundsHit()) {
                        MessageUtils.showWarning((Component)this.getView(), (String)"The area to be flooded was too large and may not have been completely flooded.", (String)"Area Too Large");
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    Dimension dimension2 = dimension;
                    synchronized (dimension2) {
                        if (dimension.undoChanges()) {
                            dimension.clearRedo();
                            dimension.armSavePoint();
                        }
                    }
                    JOptionPane.showMessageDialog((Component)this.getView(), "The area to be flooded is too large or complex; please retry with a smaller area", "Area Too Large", 0);
                }
            }
            finally {
                floodToHeight2 = dimension;
                synchronized (floodToHeight2) {
                    dimension.setEventsInhibited(false);
                }
            }
        }
        finally {
            this.alreadyFlooding = false;
        }
    }

    @Override
    public JPanel getOptionsPanel() {
        return this.optionsPanel;
    }

    static abstract class FloodFillMethod
    implements GeneralQueueLinearFloodFiller.FillMethod {
        private final String description;
        private final Rectangle bounds;

        protected FloodFillMethod(String description, Rectangle bounds) {
            this.description = description;
            this.bounds = bounds;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }
    }
}

