/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.util.Random;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MapDragControl;
import org.pepsoft.worldpainter.RadiusControl;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.WorldPainterView;
import org.pepsoft.worldpainter.operations.RadiusOperation;

public class Erode
extends RadiusOperation {
    private final int[][] heightBuffer = new int[3][3];
    private final Random random = new Random();
    private static final int ROUNDS = 1;
    private static final int ERODE_AMOUNT = 64;
    private static final float ROOT_OF_TWO = (float)Math.sqrt(2.0);

    public Erode(WorldPainter view, RadiusControl radiusControl, MapDragControl mapDragControl) {
        super("Erode", "Erode the terrain", (WorldPainterView)view, radiusControl, mapDragControl, 100, "operation.erode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        dimension.setEventsInhibited(true);
        try {
            int radius = this.getEffectiveRadius();
            for (int i = 0; i < 1; ++i) {
                for (int x = centreX - radius; x <= centreX + radius; ++x) {
                    for (int y = centreY - radius; y <= centreY + radius; ++y) {
                        int dy;
                        int dx;
                        float strength = this.getStrength(centreX, centreY, x, y);
                        if (strength != 1.0f && !(this.random.nextFloat() < strength)) continue;
                        for (int dx2 = -1; dx2 <= 1; ++dx2) {
                            for (int dy2 = -1; dy2 <= 1; ++dy2) {
                                this.heightBuffer[dx2 + 1][dy2 + 1] = dimension.getRawHeightAt(x + dx2, y + dy2);
                            }
                        }
                        int lowestDx = 0;
                        int lowestDy = 0;
                        int lowestRawHeight = Integer.MAX_VALUE;
                        boolean reverseX = this.random.nextBoolean();
                        boolean reverseY = this.random.nextBoolean();
                        if (reverseX) {
                            for (dx = 2; dx >= 0; --dx) {
                                if (reverseY) {
                                    for (dy = 2; dy >= 0; --dy) {
                                        if (this.heightBuffer[dx][dy] >= lowestRawHeight) continue;
                                        lowestRawHeight = this.heightBuffer[dx][dy];
                                        lowestDx = dx;
                                        lowestDy = dy;
                                    }
                                    continue;
                                }
                                for (dy = 0; dy < 3; ++dy) {
                                    if (this.heightBuffer[dx][dy] >= lowestRawHeight) continue;
                                    lowestRawHeight = this.heightBuffer[dx][dy];
                                    lowestDx = dx;
                                    lowestDy = dy;
                                }
                            }
                        } else {
                            for (dx = 0; dx < 3; ++dx) {
                                if (reverseY) {
                                    for (dy = 2; dy >= 0; --dy) {
                                        if (this.heightBuffer[dx][dy] >= lowestRawHeight) continue;
                                        lowestRawHeight = this.heightBuffer[dx][dy];
                                        lowestDx = dx;
                                        lowestDy = dy;
                                    }
                                    continue;
                                }
                                for (dy = 0; dy < 3; ++dy) {
                                    if (this.heightBuffer[dx][dy] >= lowestRawHeight) continue;
                                    lowestRawHeight = this.heightBuffer[dx][dy];
                                    lowestDx = dx;
                                    lowestDy = dy;
                                }
                            }
                        }
                        if (lowestDx == 1 && lowestDy == true) continue;
                        int difference = this.heightBuffer[1][1] - this.heightBuffer[lowestDx][lowestDy];
                        int amount = Math.min((int)((float)(difference / 2) / (lowestDx != 1 && lowestDy != 1 ? ROOT_OF_TWO : 1.0f)), 64);
                        if ((amount = (int)((float)amount / 64.0f * ((float)amount / 64.0f) * 64.0f)) <= 0) continue;
                        dimension.setRawHeightAt(x, y, this.heightBuffer[1][1] - amount);
                        dimension.setRawHeightAt(x + lowestDx - 1, y + lowestDy - 1, this.heightBuffer[lowestDx][lowestDy] + amount);
                    }
                }
            }
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }
}

