/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.operations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.pepsoft.util.BitField;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.operations.MouseOrTabletOperation;
import org.pepsoft.worldpainter.util.GeometryUtil;

public class CreateMountain
extends MouseOrTabletOperation {
    private static final NoiseHeightMap RANDOM_VARIATION = new NoiseHeightMap(20.0, 1.0, 3);

    public CreateMountain(WorldPainter view) {
        super("CreateMountain", "Instantly create a mountain", view, "operation.createMountain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tick(int centreX, int centreY, boolean inverse, boolean first, float dynamicLevel) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            return;
        }
        int maxY = dimension.getMaxHeight() - 1;
        float summit = Math.min(dimension.getHeightAt(centreX, centreY) + 128.0f, (float)(dimension.getMaxHeight() - 1));
        Random random = new Random();
        int noOfRidges = 3 + random.nextInt(2);
        float[] ridgeDirections = new float[noOfRidges];
        HashSet<Ridge> ridges = new HashSet<Ridge>();
        for (int i = 0; i < ridgeDirections.length; ++i) {
            ridgeDirections[i] = (float)(Math.PI * 2 * (double)i / (double)noOfRidges + random.nextDouble() / 2.0 - 0.25);
            ridges.add(new Ridge(centreX, centreY, summit, ridgeDirections[i], 5.0f, -5.0f));
        }
        BitField touchedBlocks = new BitField();
        dimension.setEventsInhibited(true);
        try {
            this.raiseCone(dimension, centreX, centreY, summit, touchedBlocks);
            HashSet<Ridge> addRidges = new HashSet<Ridge>();
            do {
                Iterator i = ridges.iterator();
                while (i.hasNext()) {
                    boolean isFalling;
                    Ridge ridge = (Ridge)i.next();
                    int intX = Math.round(ridge.x);
                    int intY = Math.round(ridge.y);
                    float newX = (float)((double)ridge.x + Math.sin(ridge.\u03b8) * (double)ridge.dXY);
                    float newY = (float)((double)ridge.y - Math.cos(ridge.\u03b8) * (double)ridge.dXY);
                    int intNewX = Math.round(newX);
                    int intNewY = Math.round(newY);
                    float newZ = ridge.z + ridge.dZ;
                    float dZ = (newZ - ridge.z) / MathUtils.getDistance((int)intX, (int)intY, (int)intNewX, (int)intNewY);
                    GeometryUtil.visitLine((int)intX, (int)intY, (int)intNewX, (int)intNewY, (x, y, d) -> {
                        if (d >= 1.0f) {
                            this.raiseCone(dimension, x, y, ridge.z + d * dZ, touchedBlocks);
                        }
                        return true;
                    });
                    float heightAtHead = dimension.getHeightAt(intNewX, intNewY);
                    if (heightAtHead == -3.4028235E38f || heightAtHead >= newZ) {
                        i.remove();
                        continue;
                    }
                    ridge.x = newX;
                    ridge.y = newY;
                    ridge.previousZ = ridge.z;
                    ridge.z = newZ;
                    if (random.nextInt(10) == 0) {
                        ridge.\u03b8 = (float)((double)ridge.\u03b8 + (random.nextDouble() - 0.5));
                    }
                    boolean wasRising = ridge.dZ > 0.0f;
                    ridge.dZ = (float)((double)ridge.dZ + (random.nextDouble() * 2.0 - 1.0));
                    if (ridge.z + ridge.dZ > (float)maxY) {
                        ridge.dZ = -ridge.dZ;
                    }
                    boolean bl = isFalling = ridge.dZ < 0.0f;
                    if ((!wasRising || !isFalling) && random.nextInt(10) != 0) continue;
                    addRidges.add(new Ridge(ridge.x, ridge.y, ridge.z, ridge.\u03b8 + (float)(random.nextBoolean() ? 1.5707963267948966 : -1.5707963267948966), 5.0f, ridge.start.dZ * 0.9f));
                }
                if (addRidges.isEmpty()) continue;
                ridges.addAll(addRidges);
                addRidges.clear();
            } while (!ridges.isEmpty());
            touchedBlocks.visitSetBits((x, y, b) -> {
                dimension.applyTheme(x, y);
                return true;
            });
        }
        finally {
            dimension.setEventsInhibited(false);
        }
    }

    private void raiseCone(Dimension dimension, int x, int y, float z, BitField touchedBlocks) {
        GeometryUtil.visitFilledCircle((int)((int)Math.ceil((double)z / 1.5)), (dx, dy, d) -> {
            int localX = x + dx;
            int localY = y + dy;
            float localZ = z - d * 2.0f + (float)dx / 1.5f - Math.min(d / 50.0f, 1.0f) * (float)RANDOM_VARIATION.getHeight(localX, localY);
            float existingHeight = dimension.getHeightAt(localX, localY);
            if (existingHeight != -3.4028235E38f && localZ >= existingHeight) {
                dimension.setHeightAt(localX, localY, localZ);
                touchedBlocks.set(localX, localY);
            }
            return true;
        });
    }

    static class Ridge
    implements Cloneable {
        float x;
        float y;
        float z;
        float previousZ;
        float \u03b8;
        float dXY;
        float dZ;
        Ridge start;

        public Ridge(float x, float y, float z, float \u03b8, float dXY, float dZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.\u03b8 = \u03b8;
            this.dXY = dXY;
            this.dZ = dZ;
            this.previousZ = z;
            this.start = this.clone();
        }

        public Ridge clone() {
            try {
                return (Ridge)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

