/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;

public class TunnelLayersTableModel
implements TableModel {
    private final List<Layer> layers = new ArrayList<Layer>();
    private final Map<Layer, TunnelLayer.LayerSettings> settings = new HashMap<Layer, TunnelLayer.LayerSettings>();
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private final int minHeight;
    private final int maxHeight;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_INTENSITY = 1;
    public static final int COLUMN_VARIATION = 2;
    public static final int COLUMN_MIN_LEVEL = 3;
    public static final int COLUMN_MAX_LEVEL = 4;
    private static final String[] COLUMN_NAMES = new String[]{"Layer", "Base intensity (%)", "Variation (%-points)", "Minimum level", "Maximum level"};
    private static final Class[] COLUMN_TYPES = new Class[]{JLabel.class, Integer.class, NoiseSettings.class, Integer.class, Integer.class};

    public TunnelLayersTableModel(List<TunnelLayer.LayerSettings> settings, int minHeight, int maxHeight) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        if (settings != null) {
            for (TunnelLayer.LayerSettings layerSettings : settings) {
                TunnelLayer.LayerSettings clonedSettings = layerSettings.clone();
                this.layers.add(clonedSettings.getLayer());
                this.settings.put(clonedSettings.getLayer(), clonedSettings);
            }
        }
    }

    public void addLayer(Layer layer) {
        if (!this.layers.contains(layer)) {
            this.layers.add(layer);
            TunnelLayer.LayerSettings layerSettings = new TunnelLayer.LayerSettings(this.minHeight, this.maxHeight - 1);
            layerSettings.setLayer(layer);
            this.settings.put(layer, layerSettings);
            int row = this.layers.size() - 1;
            TableModelEvent event = new TableModelEvent(this, row, row, -1, 1);
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(event);
            }
        }
    }

    public Layer getLayer(int row) {
        return this.layers.get(row);
    }

    public void removeLayer(int row) {
        Layer layer = this.layers.remove(row);
        this.settings.remove(layer);
        TableModelEvent event = new TableModelEvent(this, row, row, -1, -1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    public void layerChanged(int row) {
        TableModelEvent event = new TableModelEvent(this, row);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    public List<TunnelLayer.LayerSettings> getLayers() {
        ArrayList<TunnelLayer.LayerSettings> layerSettings = new ArrayList<TunnelLayer.LayerSettings>(this.layers.size());
        for (Layer layer : this.layers) {
            layerSettings.add(this.settings.get(layer));
        }
        return layerSettings;
    }

    @Override
    public int getRowCount() {
        return this.layers.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int index) {
        return COLUMN_NAMES[index];
    }

    @Override
    public Class<?> getColumnClass(int index) {
        return COLUMN_TYPES[index];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Layer layer = this.layers.get(row);
        switch (column) {
            case 0: {
                return layer;
            }
            case 1: {
                TunnelLayer.LayerSettings layerSettings = this.settings.get(layer);
                return layerSettings.getIntensity();
            }
            case 2: {
                TunnelLayer.LayerSettings layerSettings = this.settings.get(layer);
                return layerSettings.getVariation();
            }
            case 3: {
                TunnelLayer.LayerSettings layerSettings = this.settings.get(layer);
                return layerSettings.getMinLevel();
            }
            case 4: {
                TunnelLayer.LayerSettings layerSettings = this.settings.get(layer);
                return layerSettings.getMaxLevel();
            }
        }
        throw new IndexOutOfBoundsException("column: " + column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        Layer layer = this.layers.get(row);
        TunnelLayer.LayerSettings layerSettings = this.settings.get(layer);
        switch (column) {
            case 1: {
                layerSettings.setIntensity(MathUtils.clamp((int)0, (int)((Integer)value), (int)100));
                break;
            }
            case 2: {
                layerSettings.setVariation((NoiseSettings)value);
                break;
            }
            case 3: {
                layerSettings.setMinLevel(MathUtils.clamp((int)this.minHeight, (int)((Integer)value), (int)layerSettings.getMaxLevel()));
                break;
            }
            case 4: {
                layerSettings.setMaxLevel(MathUtils.clamp((int)layerSettings.getMinLevel(), (int)((Integer)value), (int)(this.maxHeight - 1)));
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("column: " + column);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(listener);
    }
}

