/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.importing;

import com.google.common.primitives.Bytes;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Collectors;
import org.pepsoft.util.MathUtils;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Layer;

abstract class Mapping {
    private final String aspect;
    private final String description;
    protected Tile tile;
    protected double threshold;
    protected double maskLowValue;
    protected double maskHighValue;
    protected double maskMaxValue;
    private static final int[][] ANNOTATIONS_PALETTE = new int[][]{{221, 221, 221}, {219, 125, 62}, {179, 80, 188}, {106, 138, 201}, {177, 166, 39}, {65, 174, 56}, {208, 132, 153}, {154, 161, 161}, {46, 110, 137}, {126, 61, 181}, {46, 56, 141}, {79, 50, 31}, {53, 70, 27}, {150, 52, 48}, {25, 22, 22}};
    private static final int[] COLOUR_ANNOTATION_MAPPING = new int[4096];

    Mapping(String aspect, String description) {
        this.aspect = aspect;
        this.description = description;
    }

    String getAspect() {
        return this.aspect;
    }

    String getDescription() {
        return this.description;
    }

    void setTile(Tile tile) {
        this.tile = tile;
    }

    void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    void setMaskLowValue(double maskLowValue) {
        this.maskLowValue = maskLowValue;
    }

    void setMaskHighValue(double maskHighValue) {
        this.maskHighValue = maskHighValue;
    }

    void setMaskMaxValue(double maskMaxValue) {
        this.maskMaxValue = maskMaxValue;
    }

    void applyGreyScale(int x, int y, double maskValue) {
        throw new UnsupportedOperationException();
    }

    void applyColour(int x, int y, int rgb) {
        throw new UnsupportedOperationException();
    }

    void applyDiscrete(int x, int y, int maskValue) {
        throw new UnsupportedOperationException();
    }

    boolean isRanged() {
        return false;
    }

    boolean isThreshold() {
        return false;
    }

    Mapping ditheredActualRange() {
        return new Mapping(this.aspect, this.description + " (dithered from actual mask range)"){
            private final Random random;
            {
                this.random = new Random(0L);
            }

            @Override
            void applyGreyScale(int x, int y, double maskValue) {
                if (maskValue >= this.maskHighValue || maskValue > this.maskLowValue && maskValue > this.random.nextDouble() * (this.maskHighValue - this.maskLowValue) + this.maskLowValue) {
                    Mapping.this.applyGreyScale(x, y, maskValue);
                }
            }

            @Override
            void applyDiscrete(int x, int y, int maskValue) {
                if ((double)maskValue >= this.maskHighValue || (double)maskValue > this.maskLowValue && (double)maskValue > this.random.nextDouble() * (this.maskHighValue - this.maskLowValue) + this.maskLowValue) {
                    Mapping.this.applyDiscrete(x, y, maskValue);
                }
            }

            @Override
            void setTile(Tile tile) {
                super.setTile(tile);
                Mapping.this.setTile(tile);
            }

            @Override
            void setThreshold(double threshold) {
                super.setThreshold(threshold);
                Mapping.this.setThreshold(threshold);
            }

            @Override
            void setMaskLowValue(double maskLowValue) {
                super.setMaskLowValue(maskLowValue);
                Mapping.this.setMaskLowValue(maskLowValue);
            }

            @Override
            void setMaskHighValue(double maskHighValue) {
                super.setMaskHighValue(maskHighValue);
                Mapping.this.setMaskHighValue(maskHighValue);
            }

            @Override
            void setMaskMaxValue(double maskMaxValue) {
                super.setMaskMaxValue(maskMaxValue);
                Mapping.this.setMaskMaxValue(maskMaxValue);
            }

            @Override
            boolean isRanged() {
                return Mapping.this.isRanged();
            }

            @Override
            boolean isThreshold() {
                return Mapping.this.isThreshold();
            }
        };
    }

    Mapping ditheredFullRange() {
        return new Mapping(this.aspect, this.description + " (dithered from full mask range)"){
            private final Random random;
            {
                this.random = new Random(0L);
            }

            @Override
            void applyGreyScale(int x, int y, double maskValue) {
                if (maskValue > 0.0 && maskValue > this.random.nextDouble() * this.maskMaxValue) {
                    Mapping.this.applyGreyScale(x, y, maskValue);
                }
            }

            @Override
            void applyDiscrete(int x, int y, int maskValue) {
                if ((double)maskValue > 0.0 && (double)maskValue > this.random.nextDouble() * this.maskMaxValue) {
                    Mapping.this.applyDiscrete(x, y, maskValue);
                }
            }

            @Override
            void setTile(Tile tile) {
                super.setTile(tile);
                Mapping.this.setTile(tile);
            }

            @Override
            void setThreshold(double threshold) {
                super.setThreshold(threshold);
                Mapping.this.setThreshold(threshold);
            }

            @Override
            void setMaskLowValue(double maskLowValue) {
                super.setMaskLowValue(maskLowValue);
                Mapping.this.setMaskLowValue(maskLowValue);
            }

            @Override
            void setMaskHighValue(double maskHighValue) {
                super.setMaskHighValue(maskHighValue);
                Mapping.this.setMaskHighValue(maskHighValue);
            }

            @Override
            void setMaskMaxValue(double maskMaxValue) {
                super.setMaskMaxValue(maskMaxValue);
                Mapping.this.setMaskMaxValue(maskMaxValue);
            }

            @Override
            boolean isRanged() {
                return Mapping.this.isRanged();
            }

            @Override
            boolean isThreshold() {
                return Mapping.this.isThreshold();
            }
        };
    }

    Mapping threshold() {
        return new Mapping(this.aspect, this.description + " where mask is at or above threshold"){

            @Override
            void applyGreyScale(int x, int y, double maskValue) {
                if (maskValue >= this.threshold) {
                    Mapping.this.applyGreyScale(x, y, maskValue);
                }
            }

            @Override
            void applyDiscrete(int x, int y, int maskValue) {
                if ((double)maskValue >= this.threshold) {
                    Mapping.this.applyDiscrete(x, y, maskValue);
                }
            }

            @Override
            void setTile(Tile tile) {
                super.setTile(tile);
                Mapping.this.setTile(tile);
            }

            @Override
            void setThreshold(double threshold) {
                super.setThreshold(threshold);
                Mapping.this.setThreshold(threshold);
            }

            @Override
            void setMaskLowValue(double maskLowValue) {
                super.setMaskLowValue(maskLowValue);
                Mapping.this.setMaskLowValue(maskLowValue);
            }

            @Override
            void setMaskHighValue(double maskHighValue) {
                super.setMaskHighValue(maskHighValue);
                Mapping.this.setMaskHighValue(maskHighValue);
            }

            @Override
            void setMaskMaxValue(double maskMaxValue) {
                super.setMaskMaxValue(maskMaxValue);
                Mapping.this.setMaskMaxValue(maskMaxValue);
            }

            @Override
            boolean isRanged() {
                return Mapping.this.isRanged();
            }

            @Override
            boolean isThreshold() {
                return true;
            }
        };
    }

    static Mapping setTerrainValue(final Terrain terrain) {
        return new Mapping("terrain " + terrain, "Set terrain type to " + terrain){

            @Override
            void applyGreyScale(int x, int y, double maskValue) {
                if (maskValue > 0.5) {
                    this.tile.setTerrain(x, y, terrain);
                }
            }
        };
    }

    static Mapping setLayerValue(final Layer layer, final int targetValue) {
        if (layer.dataSize.maxValue == 1) {
            return new Mapping("layer " + layer + " (value " + targetValue + ")", "Set layer " + layer + " to selected value"){

                @Override
                void applyGreyScale(int x, int y, double maskValue) {
                    if (targetValue != 0 && maskValue > 0.5) {
                        this.tile.setBitLayerValue(layer, x, y, true);
                    }
                }
            };
        }
        if (layer.discrete) {
            return new Mapping("layer " + layer + " (value " + targetValue + ")", "Set layer " + layer + " to selected value"){

                @Override
                void applyGreyScale(int x, int y, double maskValue) {
                    if (maskValue > 0.5) {
                        this.tile.setLayerValue(layer, x, y, targetValue);
                    }
                }
            };
        }
        return new Mapping("layer " + layer + " (value " + targetValue + ")", "Set layer " + layer + " to selected value"){

            @Override
            void applyGreyScale(int x, int y, double maskValue) {
                this.tile.setLayerValue(layer, x, y, Math.max(targetValue, this.tile.getLayerValue(layer, x, y)));
            }
        };
    }

    static Mapping mapToTerrain() {
        return new Mapping("terrain", "Set terrain type index to mask value"){

            @Override
            void applyDiscrete(int x, int y, int maskValue) {
                this.tile.setTerrain(x, y, Terrain.VALUES[maskValue]);
            }
        };
    }

    static Mapping mapToLayer(final Layer layer) {
        if (layer.discrete) {
            return new Mapping("layer " + layer, "Set layer " + layer + " to mask value"){

                @Override
                void applyDiscrete(int x, int y, int maskValue) {
                    if (maskValue != 0) {
                        this.tile.setLayerValue(layer, x, y, Math.max(maskValue, this.tile.getLayerValue(layer, x, y)));
                    }
                }
            };
        }
        if (layer.dataSize.maxValue == 1) {
            return new Mapping("layer " + layer, "Set layer " + layer + " to mask value"){

                @Override
                void applyGreyScale(int x, int y, double maskValue) {
                    if (maskValue > 0.5) {
                        this.tile.setBitLayerValue(layer, x, y, true);
                    }
                }
            };
        }
        return new Mapping("layer " + layer, "Set layer " + layer + " to mask value"){

            @Override
            void applyGreyScale(int x, int y, double maskValue) {
                if (maskValue > 0.0) {
                    this.tile.setLayerValue(layer, x, y, (int)Math.max(Math.round(maskValue), (long)this.tile.getLayerValue(layer, x, y)));
                }
            }
        };
    }

    static Mapping mapActualRangeToLayer(final Layer layer) {
        if (layer.dataSize.maxValue == 1) {
            throw new IllegalArgumentException("layer.dataSize " + layer.dataSize);
        }
        if (layer.discrete) {
            return new Mapping("layer " + layer, "Map layer " + layer + " to actual mask range"){

                @Override
                void applyGreyScale(int x, int y, double maskValue) {
                    if (maskValue > 0.0) {
                        this.tile.setLayerValue(layer, x, y, (int)Math.round((maskValue - this.maskLowValue) * (double)layer.dataSize.maxValue / (this.maskHighValue - this.maskLowValue)));
                    }
                }
            };
        }
        return new Mapping("layer " + layer, "Map layer " + layer + " to actual mask range"){

            @Override
            void applyGreyScale(int x, int y, double maskValue) {
                this.tile.setLayerValue(layer, x, y, Math.max((int)Math.round((maskValue - this.maskLowValue) * (double)layer.dataSize.maxValue / (this.maskHighValue - this.maskLowValue)), this.tile.getLayerValue(layer, x, y)));
            }

            @Override
            boolean isRanged() {
                return true;
            }
        };
    }

    static Mapping mapFullRangeToLayer(final Layer layer) {
        if (layer.dataSize.maxValue == 1) {
            throw new IllegalArgumentException("layer.dataSize " + layer.dataSize);
        }
        if (layer.discrete) {
            return new Mapping("layer " + layer, "Map layer " + layer + " to full mask range"){

                @Override
                void applyGreyScale(int x, int y, double maskValue) {
                    if (maskValue > 0.0) {
                        this.tile.setLayerValue(layer, x, y, (int)Math.round(maskValue * (double)layer.dataSize.maxValue / this.maskMaxValue));
                    }
                }
            };
        }
        return new Mapping("layer " + layer, "Map layer " + layer + " to full mask range"){

            @Override
            void applyGreyScale(int x, int y, double maskValue) {
                this.tile.setLayerValue(layer, x, y, Math.max((int)Math.round(maskValue * (double)layer.dataSize.maxValue / this.maskMaxValue), this.tile.getLayerValue(layer, x, y)));
            }

            @Override
            boolean isRanged() {
                return true;
            }
        };
    }

    static ColourToAnnotationsMapping colourToAnnotations() {
        return new ColourToAnnotationsMapping("annotations", "Map layer Annotations to mask colours"){

            @Override
            void applyColour(int x, int y, int rgb) {
                if ((rgb >> 24 & 0xFF) > 127) {
                    this.tile.setLayerValue((Layer)Annotations.INSTANCE, x, y, COLOUR_ANNOTATION_MAPPING[rgb >> 12 & 0xF00 | rgb >> 8 & 0xF0 | rgb >> 4 & 0xF]);
                }
            }

            @Override
            ColourToAnnotationsMapping ditheredActualRange() {
                return new ColourToAnnotationsMapping("annotations", "Map layer Annotations to mask colours (dithered)"){
                    {
                        super(aspect, description);
                        this.dithered = true;
                    }

                    @Override
                    void applyColour(int x, int y, int rgb) {
                        if ((rgb >> 24 & 0xFF) > 127) {
                            this.tile.setLayerValue((Layer)Annotations.INSTANCE, x, y, COLOUR_ANNOTATION_MAPPING[rgb >> 12 & 0xF00 | rgb >> 8 & 0xF0 | rgb >> 4 & 0xF]);
                        }
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage ditherMask(BufferedImage maskImage) {
        IndexColorModel colorModel = new IndexColorModel(4, 15, Bytes.toArray((Collection)Arrays.stream(ANNOTATIONS_PALETTE).map(row -> row[0]).collect(Collectors.toList())), Bytes.toArray((Collection)Arrays.stream(ANNOTATIONS_PALETTE).map(row -> row[1]).collect(Collectors.toList())), Bytes.toArray((Collection)Arrays.stream(ANNOTATIONS_PALETTE).map(row -> row[2]).collect(Collectors.toList())));
        BufferedImage ditheredImage = new BufferedImage(maskImage.getWidth(), maskImage.getHeight(), 13, colorModel);
        Graphics2D g2 = ditheredImage.createGraphics();
        try {
            g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
            g2.drawImage((Image)maskImage, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
        return ditheredImage;
    }

    private static int findNearestAnnotationValue(int colour) {
        int red = (colour & 0xFF0000) >> 16;
        int green = (colour & 0xFF00) >> 8;
        int blue = colour & 0xFF;
        float minDistance = Float.MAX_VALUE;
        int minDistanceIndex = -1;
        for (int i = 0; i < ANNOTATIONS_PALETTE.length; ++i) {
            float distance = MathUtils.getDistance((int)(red - ANNOTATIONS_PALETTE[i][0]), (int)(green - ANNOTATIONS_PALETTE[i][1]), (int)(blue - ANNOTATIONS_PALETTE[i][2]));
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minDistanceIndex = i;
        }
        return minDistanceIndex + 1;
    }

    static {
        for (int i = 0; i < 4096; ++i) {
            Mapping.COLOUR_ANNOTATION_MAPPING[i] = Mapping.findNearestAnnotationValue((i & 0xF00) << 12 | (i & 0xF0) << 8 | (i & 0xF) << 4);
        }
    }

    static abstract class ColourToAnnotationsMapping
    extends Mapping {
        boolean dithered;

        ColourToAnnotationsMapping(String aspect, String description) {
            super(aspect, description);
        }
    }
}

