/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Overlay;

public class OverlaysTableModel
implements TableModel {
    private final Dimension dimension;
    private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private static final int COLUMN_ENABLED = 0;
    private static final int COLUMN_IMAGE = 1;
    private static final String[] COLUMN_NAMES = new String[]{"Enabled", "Image"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{Boolean.class, String.class};

    public OverlaysTableModel(Dimension dimension) {
        this.dimension = dimension;
    }

    public int addOverlay(Overlay overlay) {
        int rowIndex = this.dimension.addOverlay(overlay);
        TableModelEvent event = new TableModelEvent(this, rowIndex, rowIndex, -1, 1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
        return rowIndex;
    }

    public Overlay getOverlay(int rowIndex) {
        return (Overlay)this.dimension.getOverlays().get(rowIndex);
    }

    public void removeOverlay(int rowIndex) {
        this.dimension.removeOverlay(rowIndex);
        TableModelEvent event = new TableModelEvent(this, rowIndex, rowIndex, -1, -1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    public void overlayChanged(int rowIndex) {
        TableModelEvent event = new TableModelEvent(this, rowIndex);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(event);
        }
    }

    @Override
    public int getRowCount() {
        return this.dimension.getOverlays().size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    @Nls
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Overlay overlay = (Overlay)this.dimension.getOverlays().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return overlay.isEnabled();
            }
            case 1: {
                return overlay.getFile().getName();
            }
        }
        throw new IndexOutOfBoundsException("columnIndex " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            throw new IllegalArgumentException("columnIndex " + columnIndex);
        }
        ((Overlay)this.dimension.getOverlays().get(rowIndex)).setEnabled(((Boolean)aValue).booleanValue());
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }
}

