/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.pepsoft.minecraft.Constants;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.IconUtils;
import org.pepsoft.worldpainter.BiomeScheme;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.biomeschemes.BiomeSchemeManager;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.util.BiomeUtils;

public class LayerValueListCellRenderer
extends DefaultListCellRenderer {
    private final String nullLabel;
    private final boolean showIcons;
    private final Map<Integer, Icon> icons = new HashMap<Integer, Icon>();
    private final Map<Integer, String> texts = new HashMap<Integer, String>();

    public LayerValueListCellRenderer(Layer layer, Platform platform, ColourScheme colourScheme, CustomBiomeManager customBiomeManager) {
        this(layer, platform, colourScheme, customBiomeManager, null);
    }

    public LayerValueListCellRenderer(Layer layer, Platform platform, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, String nullLabel) {
        this.nullLabel = nullLabel;
        if (layer instanceof Annotations) {
            for (int value = 1; value < 16; ++value) {
                this.icons.put(value, IconUtils.createScaledColourIcon((int)colourScheme.getColour(Material.WOOLS[value - 1])));
                this.texts.put(value, Constants.COLOUR_NAMES[value - 1]);
            }
            this.showIcons = true;
        } else if (layer instanceof Biome) {
            BiomeScheme biomeScheme = BiomeUtils.getBiomeScheme((Platform)platform);
            boolean addIds = !platform.capabilities.contains(Platform.Capability.NAMED_BIOMES);
            for (int value = 0; value < 256; ++value) {
                if (biomeScheme.isBiomePresent(value)) {
                    this.icons.put(value, new ImageIcon(IconUtils.scaleIcon((Image)BiomeSchemeManager.createImage((BiomeScheme)biomeScheme, (int)value, (ColourScheme)colourScheme), (int)16)));
                    this.texts.put(value, biomeScheme.getBiomeName(value) + (addIds ? " (" + value + ")" : ""));
                    continue;
                }
                int finalValue = value;
                customBiomeManager.getCustomBiomes().stream().filter(customBiome -> customBiome.getId() == finalValue).findAny().ifPresent(customBiome -> {
                    this.icons.put(finalValue, IconUtils.createScaledColourIcon((int)customBiome.getColour()));
                    this.texts.put(finalValue, customBiome.getName() + (addIds ? " (" + finalValue + ")" : ""));
                });
            }
            this.showIcons = true;
        } else {
            this.showIcons = false;
            Layer.DataSize dataSize = layer.getDataSize();
            if (dataSize != null) {
                for (int value = 0; value <= dataSize.maxValue; ++value) {
                    this.texts.put(value, dataSize.toString(value));
                }
            } else {
                throw new UnsupportedOperationException("Layer " + layer + " of type " + layer.getClass().getSimpleName() + " with data size " + dataSize + " not supported");
            }
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            if (this.showIcons) {
                this.setIcon(this.icons.get(value));
            }
            this.setText(this.texts.get(value));
        } else if (this.nullLabel != null) {
            this.setText(this.nullLabel);
        }
        return this;
    }
}

