/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.TileRenderer;
import org.pepsoft.worldpainter.TileSelector;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainterDialog;
import org.pepsoft.worldpainter.biomeschemes.CustomBiomeManager;
import org.pepsoft.worldpainter.layers.Layer;

public class ExportTileSelectionDialog
extends WorldPainterDialog
implements WindowListener {
    private JButton buttonClose;
    private JButton buttonSetSpawn;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private TileSelector tileSelector1;
    private final World2 world;
    private boolean programmaticChange;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportTileSelectionDialog(Window parent, World2 world, int selectedDimension, Set<Point> selectedTiles, ColourScheme colourScheme, CustomBiomeManager customBiomeManager, Set<Layer> hiddenLayers, boolean contourLines, int contourSeparation, TileRenderer.LightOrigin lightOrigin) {
        super(parent);
        this.world = world;
        this.initComponents();
        TreeSet<Integer> dimensions = new TreeSet<Integer>();
        for (Dimension dimension : world.getDimensions()) {
            dimensions.add(dimension.getAnchor().dim);
        }
        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(dimensions.toArray()));
        this.programmaticChange = true;
        try {
            this.jComboBox1.setSelectedItem(selectedDimension);
        }
        finally {
            this.programmaticChange = false;
        }
        this.jComboBox1.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    switch ((Integer)value) {
                        case 0: {
                            this.setText("Surface");
                            break;
                        }
                        case 1: {
                            this.setText("Nether");
                            break;
                        }
                        case 2: {
                            this.setText("End");
                        }
                    }
                }
                return this;
            }
        });
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("cancel", new AbstractAction("cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportTileSelectionDialog.this.dispose();
            }
        });
        this.tileSelector1.setColourScheme(colourScheme);
        this.tileSelector1.setHiddenLayers(hiddenLayers);
        this.tileSelector1.setContourLines(contourLines);
        this.tileSelector1.setContourSeparation(contourSeparation);
        this.tileSelector1.setLightOrigin(lightOrigin);
        this.tileSelector1.setDimension(world.getDimension(new Dimension.Anchor(selectedDimension, Dimension.Role.DETAIL, false, 0)));
        this.tileSelector1.setCustomBiomeManager(customBiomeManager);
        if (selectedTiles != null) {
            this.tileSelector1.setSelectedTiles(selectedTiles);
        }
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().setDefaultButton(this.buttonClose);
        this.scaleWindowToUI();
        this.setLocationRelativeTo(parent);
        this.addWindowListener(this);
    }

    public int getSelectedDimension() {
        return (Integer)this.jComboBox1.getSelectedItem();
    }

    public Set<Point> getSelectedTiles() {
        return this.tileSelector1.getSelectedTiles();
    }

    public void selectAll() {
        this.tileSelector1.selectAllTiles();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.tileSelector1.moveToCentre();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private void setSpawn() {
        this.world.setSpawnPoint(this.tileSelector1.getCurrentLocation());
        this.tileSelector1.refresh();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.buttonClose = new JButton();
        this.tileSelector1 = new TileSelector();
        this.buttonSetSpawn = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Tiles For Export");
        this.jLabel1.setText("Dimension to export:");
        this.jComboBox1.addActionListener(this::jComboBox1ActionPerformed);
        this.jLabel2.setText("WorldPainter works in tiles of 128 by 128 blocks. Select tiles to export:");
        this.buttonClose.setText("OK");
        this.buttonClose.addActionListener(this::buttonCloseActionPerformed);
        this.buttonSetSpawn.setText("Set Spawn");
        this.buttonSetSpawn.setToolTipText("Move the spawn point to the indicated location");
        this.buttonSetSpawn.addActionListener(this::buttonSetSpawnActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, -2, -1, -2)).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.buttonSetSpawn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonClose)).addComponent(this.tileSelector1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tileSelector1, -1, 364, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonClose).addComponent(this.buttonSetSpawn)).addContainerGap()));
        this.pack();
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        if (!this.programmaticChange) {
            int selectedDimension = this.getSelectedDimension();
            this.tileSelector1.setDimension(this.world.getDimension(new Dimension.Anchor(selectedDimension, Dimension.Role.DETAIL, false, 0)));
            this.tileSelector1.moveToCentre();
            this.tileSelector1.clearSelection();
            this.buttonSetSpawn.setEnabled(selectedDimension == 0);
        }
    }

    private void buttonCloseActionPerformed(ActionEvent evt) {
        this.ok();
    }

    private void buttonSetSpawnActionPerformed(ActionEvent evt) {
        this.setSpawn();
    }
}

