/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jnbt.Tag;
import org.pepsoft.minecraft.CustomGenerator;
import org.pepsoft.minecraft.MapGenerator;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SeededGenerator;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.AwtUtils;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.Version;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.worldpainter.ColourScheme;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.CustomLayersTableCellRenderer;
import org.pepsoft.worldpainter.CustomLayersTableModel;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Generator;
import org.pepsoft.worldpainter.HeightMapTileFactory;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.WPDialogWithPaintSelection;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.ExportSettingsEditor;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Caverns;
import org.pepsoft.worldpainter.layers.Caves;
import org.pepsoft.worldpainter.layers.Chasms;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.DeciduousForest;
import org.pepsoft.worldpainter.layers.Frost;
import org.pepsoft.worldpainter.layers.Jungle;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.PineForest;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.SwampLand;
import org.pepsoft.worldpainter.layers.TreeLayer;
import org.pepsoft.worldpainter.layers.exporters.AbstractCavesExporter;
import org.pepsoft.worldpainter.layers.exporters.AnnotationsExporter;
import org.pepsoft.worldpainter.layers.exporters.CavernsExporter;
import org.pepsoft.worldpainter.layers.exporters.CavesExporter;
import org.pepsoft.worldpainter.layers.exporters.ChasmsExporter;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.FrostExporter;
import org.pepsoft.worldpainter.layers.exporters.ResourcesExporter;
import org.pepsoft.worldpainter.layers.exporters.TreesExporter;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.PlatformProvider;
import org.pepsoft.worldpainter.superflat.EditSuperflatPresetDialog;
import org.pepsoft.worldpainter.themes.SimpleTheme;
import org.pepsoft.worldpainter.themes.TerrainListCellRenderer;
import org.pepsoft.worldpainter.themes.impl.simple.SimpleThemeEditor;
import org.pepsoft.worldpainter.tools.Eyedropper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionPropertiesEditor
extends JPanel {
    private JButton buttonCustomLayerBottom;
    private JButton buttonCustomLayerDown;
    private JButton buttonCustomLayerTop;
    private JButton buttonCustomLayerUp;
    private JButton buttonDisableLayers;
    private JButton buttonEnableLayers;
    private JButton buttonGeneratorOptions;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup5;
    private JButton buttonReset;
    private JButton buttonSelectPaint;
    private JCheckBox checkBoxBottomless;
    private JCheckBox checkBoxCavernsBreakSurface;
    private JCheckBox checkBoxCavernsEverywhere;
    private JCheckBox checkBoxCavernsFloodWithLava;
    private JCheckBox checkBoxCavernsRemoveWater;
    private JCheckBox checkBoxCavesBreakSurface;
    private JCheckBox checkBoxCavesEverywhere;
    private JCheckBox checkBoxChasmsBreakSurface;
    private JCheckBox checkBoxChasmsEverywhere;
    private JCheckBox checkBoxCoverSteepTerrain;
    private JCheckBox checkBoxDeciduousEverywhere;
    private JCheckBox checkBoxDecorateCaverns;
    private JCheckBox checkBoxDecorateCaves;
    private JCheckBox checkBoxDecorateChasms;
    private JCheckBox checkBoxDecorationBrownMushrooms;
    private JCheckBox checkBoxDecorationDripstoneCaves;
    private JCheckBox checkBoxDecorationGlowLichen;
    private JCheckBox checkBoxDecorationLushCaves;
    private JCheckBox checkBoxExportAnnotations;
    private JCheckBox checkBoxFloodCaverns;
    private JCheckBox checkBoxFrostEverywhere;
    private JCheckBox checkBoxJungleEverywhere;
    private JCheckBox checkBoxPineEverywhere;
    private JCheckBox checkBoxPopulate;
    private JCheckBox checkBoxRoof;
    private JCheckBox checkBoxSmoothSnow;
    private JCheckBox checkBoxSnowUnderTrees;
    private JCheckBox checkBoxSwamplandEverywhere;
    private JCheckBox checkBoxWall;
    private JComboBox<Generator> comboBoxGenerator;
    private JComboBox comboBoxSubsurfaceMaterial;
    private JComboBox<String> comboBoxSurfaceLayerAnchor;
    private JComboBox<String> comboBoxUndergroundLayerAnchor;
    private JCheckBox jCheckBox8;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel100;
    private JLabel jLabel101;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel29;
    private JLabel jLabel3;
    private JLabel jLabel30;
    private JLabel jLabel31;
    private JLabel jLabel32;
    private JLabel jLabel33;
    private JLabel jLabel34;
    private JLabel jLabel35;
    private JLabel jLabel36;
    private JLabel jLabel37;
    private JLabel jLabel38;
    private JLabel jLabel39;
    private JLabel jLabel4;
    private JLabel jLabel40;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel45;
    private JLabel jLabel46;
    private JLabel jLabel47;
    private JLabel jLabel48;
    private JLabel jLabel49;
    private JLabel jLabel5;
    private JLabel jLabel50;
    private JLabel jLabel51;
    private JLabel jLabel52;
    private JLabel jLabel53;
    private JLabel jLabel54;
    private JLabel jLabel55;
    private JLabel jLabel56;
    private JLabel jLabel57;
    private JLabel jLabel58;
    private JLabel jLabel59;
    private JLabel jLabel6;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;
    private JLabel jLabel63;
    private JLabel jLabel64;
    private JLabel jLabel65;
    private JLabel jLabel66;
    private JLabel jLabel67;
    private JLabel jLabel68;
    private JLabel jLabel69;
    private JLabel jLabel7;
    private JLabel jLabel70;
    private JLabel jLabel71;
    private JLabel jLabel72;
    private JLabel jLabel73;
    private JLabel jLabel74;
    private JLabel jLabel75;
    private JLabel jLabel76;
    private JLabel jLabel77;
    private JLabel jLabel78;
    private JLabel jLabel8;
    private JLabel jLabel82;
    private JLabel jLabel83;
    private JLabel jLabel84;
    private JLabel jLabel87;
    private JLabel jLabel88;
    private JLabel jLabel89;
    private JLabel jLabel9;
    private JLabel jLabel91;
    private JLabel jLabel92;
    private JLabel jLabel93;
    private JLabel jLabel94;
    private JLabel jLabel95;
    private JLabel jLabel96;
    private JLabel jLabel98;
    private JLabel jLabel99;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel18;
    private JPanel jPanel19;
    private JPanel jPanel2;
    private JPanel jPanel20;
    private JPanel jPanel21;
    private JPanel jPanel22;
    private JPanel jPanel23;
    private JPanel jPanel24;
    private JPanel jPanel25;
    private JPanel jPanel26;
    private JPanel jPanel27;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSlider jSlider4;
    private JSlider jSlider6;
    private JTabbedPane jTabbedPane1;
    private JPanel panelBorderWallRoof;
    private JPanel panelGeneral;
    private JPanel panelMinecraftSettings;
    private JRadioButton radioButtonBarrierBorder;
    private JRadioButton radioButtonBarrierRoof;
    private JRadioButton radioButtonBarrierWall;
    private JRadioButton radioButtonBedrockRoof;
    private JRadioButton radioButtonBedrockWall;
    private JRadioButton radioButtonEndlessBorder;
    private JRadioButton radioButtonFixedBorder;
    private JRadioButton radioButtonLavaBorder;
    private JRadioButton radioButtonNoBorder;
    private JRadioButton radioButtonVoidBorder;
    private JRadioButton radioButtonWaterBorder;
    private JSlider sliderCavernsEverywhereLevel;
    private JSlider sliderCavesEverywhereLevel;
    private JSlider sliderChasmsEverywhereLevel;
    private JSlider sliderDeciduousLevel;
    private JSlider sliderJungleLevel;
    private JSlider sliderPineLevel;
    private JSpinner spinnerAncientDebrisChance;
    private JSpinner spinnerAncientDebrisMaxLevel;
    private JSpinner spinnerAncientDebrisMinLevel;
    private JSpinner spinnerBorderLevel;
    private JSpinner spinnerBorderSize;
    private JSpinner spinnerCavernsFloodLevel;
    private JSpinner spinnerCavernsMaxLevel;
    private JSpinner spinnerCavernsMinLevel;
    private JSpinner spinnerCavesMaxLevel;
    private JSpinner spinnerCavesMinLevel;
    private JSpinner spinnerCeilingHeight;
    private JSpinner spinnerChasmsMaxLevel;
    private JSpinner spinnerChasmsMinLevel;
    private JSpinner spinnerCoalChance;
    private JSpinner spinnerCoalMaxLevel;
    private JSpinner spinnerCoalMinLevel;
    private JSpinner spinnerCopperChance;
    private JSpinner spinnerCopperMaxLevel;
    private JSpinner spinnerCopperMinLevel;
    private JSpinner spinnerDiamondChance;
    private JSpinner spinnerDiamondMaxLevel;
    private JSpinner spinnerDiamondMinLevel;
    private JSpinner spinnerDirtChance;
    private JSpinner spinnerDirtMaxLevel;
    private JSpinner spinnerDirtMinLevel;
    private JSpinner spinnerEmeraldChance;
    private JSpinner spinnerEmeraldMaxLevel;
    private JSpinner spinnerEmeraldMinLevel;
    private JSpinner spinnerGoldChance;
    private JSpinner spinnerGoldMaxLevel;
    private JSpinner spinnerGoldMinLevel;
    private JSpinner spinnerGravelChance;
    private JSpinner spinnerGravelMaxLevel;
    private JSpinner spinnerGravelMinLevel;
    private JSpinner spinnerIronChance;
    private JSpinner spinnerIronMaxLevel;
    private JSpinner spinnerIronMinLevel;
    private JSpinner spinnerLapisChance;
    private JSpinner spinnerLapisMaxLevel;
    private JSpinner spinnerLapisMinLevel;
    private JSpinner spinnerLavaChance;
    private JSpinner spinnerLavaMaxLevel;
    private JSpinner spinnerLavaMinLevel;
    private JSpinner spinnerMaxSurfaceDepth;
    private JSpinner spinnerMinSurfaceDepth;
    private JSpinner spinnerMinecraftSeed;
    private JSpinner spinnerQuartzChance;
    private JSpinner spinnerQuartzMaxLevel;
    private JSpinner spinnerQuartzMinLevel;
    private JSpinner spinnerRedstoneChance;
    private JSpinner spinnerRedstoneMaxLevel;
    private JSpinner spinnerRedstoneMinLevel;
    private JSpinner spinnerWaterChance;
    private JSpinner spinnerWaterMaxLevel;
    private JSpinner spinnerWaterMinLevel;
    private JTable tableCustomLayers;
    private SimpleThemeEditor themeEditor;
    private Dimension dimension;
    private Platform platform;
    private PlatformProvider platformProvider;
    private CustomLayersTableModel customLayersTableModel;
    private Mode mode;
    private Dimension.LayerAnchor subsurfaceLayerAnchor;
    private String generatorName;
    private SuperflatPreset superflatPreset;
    private boolean endlessBorder;
    private boolean programmaticChange;
    private boolean orderPristine = true;
    private Tag customGeneratorSettings;
    private Generator savedGeneratorType;
    private Eyedropper.SelectionListener selectionListener;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_THEME = 1;
    private static final int TAB_CAVES = 2;
    private static final int TAB_RESOURCES = 3;
    private static final int TAB_OTHER_LAYERS = 4;
    private static final int TAB_CUSTOM_LAYERS = 5;
    private static final Logger logger = LoggerFactory.getLogger(DimensionPropertiesEditor.class);
    private static final long serialVersionUID = 1L;

    public DimensionPropertiesEditor() {
        this.initComponents();
        if (Configuration.getInstance() != null && Configuration.getInstance().isEasyMode()) {
            this.jLabel4.setVisible(false);
            this.radioButtonNoBorder.setVisible(false);
            this.radioButtonVoidBorder.setVisible(false);
            this.radioButtonWaterBorder.setVisible(false);
            this.jLabel5.setVisible(false);
            this.spinnerBorderLevel.setVisible(false);
            this.jLabel44.setVisible(false);
            this.radioButtonLavaBorder.setVisible(false);
            this.jLabel8.setVisible(false);
            this.spinnerBorderSize.setVisible(false);
            this.jLabel9.setVisible(false);
            this.checkBoxWall.setVisible(false);
            this.jLabel7.setVisible(false);
            this.spinnerMinecraftSeed.setVisible(false);
            this.checkBoxPopulate.setVisible(false);
            this.jLabel47.setVisible(false);
        }
        this.configureSpinners(this.spinnerGoldChance, this.spinnerGoldMinLevel, this.spinnerGoldMaxLevel);
        this.configureSpinners(this.spinnerIronChance, this.spinnerIronMinLevel, this.spinnerIronMaxLevel);
        this.configureSpinners(this.spinnerCoalChance, this.spinnerCoalMinLevel, this.spinnerCoalMaxLevel);
        this.configureSpinners(this.spinnerLapisChance, this.spinnerLapisMinLevel, this.spinnerLapisMaxLevel);
        this.configureSpinners(this.spinnerDiamondChance, this.spinnerDiamondMinLevel, this.spinnerDiamondMaxLevel);
        this.configureSpinners(this.spinnerEmeraldChance, this.spinnerEmeraldMinLevel, this.spinnerEmeraldMaxLevel);
        this.configureSpinners(this.spinnerWaterChance, this.spinnerWaterMinLevel, this.spinnerWaterMaxLevel);
        this.configureSpinners(this.spinnerLavaChance, this.spinnerLavaMinLevel, this.spinnerLavaMaxLevel);
        this.configureSpinners(this.spinnerDirtChance, this.spinnerDirtMinLevel, this.spinnerDirtMaxLevel);
        this.configureSpinners(this.spinnerGravelChance, this.spinnerGravelMinLevel, this.spinnerGravelMaxLevel);
        this.configureSpinners(this.spinnerRedstoneChance, this.spinnerRedstoneMinLevel, this.spinnerRedstoneMaxLevel);
        this.configureSpinners(this.spinnerQuartzChance, this.spinnerQuartzMinLevel, this.spinnerQuartzMaxLevel);
        this.configureSpinners(this.spinnerCopperChance, this.spinnerCopperMinLevel, this.spinnerCopperMaxLevel);
        this.configureSpinners(this.spinnerAncientDebrisChance, this.spinnerAncientDebrisMinLevel, this.spinnerAncientDebrisMaxLevel);
        this.configureSpinners(null, this.spinnerCavesMinLevel, this.spinnerCavesMaxLevel);
        this.configureSpinners(null, this.spinnerCavernsMinLevel, this.spinnerCavernsMaxLevel);
        this.configureSpinners(null, this.spinnerChasmsMinLevel, this.spinnerChasmsMaxLevel);
        this.tableCustomLayers.setDefaultRenderer(CustomLayer.class, new CustomLayersTableCellRenderer());
        this.tableCustomLayers.getSelectionModel().addListSelectionListener(e -> {
            if (!this.programmaticChange) {
                this.setControlStates();
            }
        });
        this.comboBoxGenerator.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((Generator)value).getDisplayName());
                }
                return this;
            }
        });
        GUIUtils.scaleToUI((Container)this);
    }

    public void setColourScheme(ColourScheme colourScheme) {
        this.comboBoxSubsurfaceMaterial.setRenderer(new TerrainListCellRenderer(colourScheme));
        this.themeEditor.setColourScheme(colourScheme);
    }

    public ColourScheme getColourScheme() {
        return this.themeEditor.getColourScheme();
    }

    public void setMode(Mode mode) {
        Objects.requireNonNull(mode);
        if (this.mode != null) {
            throw new IllegalStateException("Mode already set");
        }
        if (this.dimension == null) {
            throw new IllegalStateException("Mode must be set after dimension");
        }
        this.mode = mode;
        Dimension.Anchor anchor = this.dimension.getAnchor();
        switch (mode) {
            case EXPORT: {
                if (anchor.role == Dimension.Role.MASTER) {
                    this.jTabbedPane1.remove(4);
                }
                if (anchor.role == Dimension.Role.CAVE_FLOOR || anchor.role == Dimension.Role.MASTER) {
                    this.jTabbedPane1.remove(3);
                    this.jTabbedPane1.remove(2);
                }
                this.jTabbedPane1.remove(1);
                if (anchor.role != Dimension.Role.DETAIL || anchor.invert) break;
                this.initialisePostProcessingTab();
                break;
            }
            case DEFAULT_SETTINGS: {
                this.spinnerMinecraftSeed.setEnabled(false);
                this.jTabbedPane1.remove(5);
                this.jTabbedPane1.remove(3);
                this.themeEditor.setAllowCustomItems(false);
                break;
            }
            case EDITOR: {
                this.jTabbedPane1.remove(5);
                if (anchor.role == Dimension.Role.MASTER) {
                    this.jTabbedPane1.remove(4);
                }
                if (anchor.role != Dimension.Role.CAVE_FLOOR && anchor.role != Dimension.Role.MASTER) break;
                this.jTabbedPane1.remove(3);
                this.jTabbedPane1.remove(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode " + (Object)((Object)mode));
            }
        }
        this.loadSettings();
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        Objects.requireNonNull(dimension);
        if (this.dimension != null) {
            throw new IllegalStateException("Dimension already set");
        }
        this.dimension = dimension;
        Dimension.Anchor anchor = dimension.getAnchor();
        if (anchor.role != Dimension.Role.DETAIL || anchor.invert) {
            AwtUtils.doLaterOnEventThread(() -> {
                this.panelGeneral.remove(this.panelMinecraftSettings);
                this.panelGeneral.remove(this.panelBorderWallRoof);
            });
        }
        this.setPlatform(dimension.getWorld().getPlatform());
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        Objects.requireNonNull(platform);
        if (platform != this.platform) {
            this.platform = platform;
            this.platformProvider = PlatformManager.getInstance().getPlatformProvider(platform);
            if (platform.capabilities.contains(Platform.Capability.POPULATE)) {
                this.checkBoxPopulate.setSelected(this.dimension.isPopulate());
                this.checkBoxPopulate.setToolTipText(null);
            } else {
                this.checkBoxPopulate.setSelected(false);
                this.checkBoxPopulate.setToolTipText("Automatic population not support by format " + platform);
            }
            Generator generator = (Generator)this.comboBoxGenerator.getSelectedItem();
            this.comboBoxGenerator.setModel(new DefaultComboBoxModel<Generator>(platform.supportedGenerators.toArray(new Generator[platform.supportedGenerators.size()])));
            if (platform.supportedGenerators.contains(generator)) {
                this.comboBoxGenerator.setSelectedItem(generator);
            } else {
                this.comboBoxGenerator.setSelectedItem(platform.supportedGenerators.get(0));
            }
            this.comboBoxGenerator.setEnabled(platform.supportedGenerators.size() > 1);
            this.setControlStates();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBoxSubsurfaceMaterial.setEnabled(enabled);
        this.checkBoxCavernsEverywhere.setEnabled(enabled);
        this.checkBoxChasmsEverywhere.setEnabled(enabled);
        this.checkBoxDeciduousEverywhere.setEnabled(enabled);
        this.checkBoxFrostEverywhere.setEnabled(enabled);
        this.checkBoxFloodCaverns.setEnabled(enabled);
        this.checkBoxCavernsBreakSurface.setEnabled(enabled);
        this.checkBoxChasmsBreakSurface.setEnabled(enabled);
        this.checkBoxPineEverywhere.setEnabled(enabled);
        this.checkBoxJungleEverywhere.setEnabled(enabled);
        this.checkBoxSwamplandEverywhere.setEnabled(enabled);
        this.jCheckBox8.setEnabled(enabled);
        this.checkBoxSmoothSnow.setEnabled(enabled);
        this.jTabbedPane1.setEnabled(enabled);
        this.spinnerQuartzChance.setEnabled(enabled);
        this.spinnerGoldChance.setEnabled(enabled);
        this.spinnerGoldMaxLevel.setEnabled(enabled);
        this.spinnerIronChance.setEnabled(enabled);
        this.spinnerIronMaxLevel.setEnabled(enabled);
        this.spinnerCoalChance.setEnabled(enabled);
        this.spinnerCoalMaxLevel.setEnabled(enabled);
        this.spinnerLapisChance.setEnabled(enabled);
        this.spinnerLapisMaxLevel.setEnabled(enabled);
        this.spinnerDiamondChance.setEnabled(enabled);
        this.spinnerDiamondMaxLevel.setEnabled(enabled);
        this.spinnerRedstoneChance.setEnabled(enabled);
        this.spinnerRedstoneMaxLevel.setEnabled(enabled);
        this.spinnerWaterChance.setEnabled(enabled);
        this.spinnerWaterMaxLevel.setEnabled(enabled);
        this.spinnerLavaChance.setEnabled(enabled);
        this.spinnerDirtChance.setEnabled(enabled);
        this.spinnerLavaMaxLevel.setEnabled(enabled);
        this.spinnerDirtMaxLevel.setEnabled(enabled);
        this.spinnerGravelChance.setEnabled(enabled);
        this.spinnerGravelMaxLevel.setEnabled(enabled);
        this.spinnerEmeraldChance.setEnabled(enabled);
        this.spinnerEmeraldMaxLevel.setEnabled(enabled);
        this.spinnerGoldMinLevel.setEnabled(enabled);
        this.spinnerIronMinLevel.setEnabled(enabled);
        this.spinnerCoalMinLevel.setEnabled(enabled);
        this.spinnerLapisMinLevel.setEnabled(enabled);
        this.spinnerDiamondMinLevel.setEnabled(enabled);
        this.spinnerEmeraldMinLevel.setEnabled(enabled);
        this.spinnerWaterMinLevel.setEnabled(enabled);
        this.spinnerLavaMinLevel.setEnabled(enabled);
        this.spinnerDirtMinLevel.setEnabled(enabled);
        this.spinnerGravelMinLevel.setEnabled(enabled);
        this.spinnerRedstoneMinLevel.setEnabled(enabled);
        this.spinnerQuartzMinLevel.setEnabled(enabled);
        this.spinnerQuartzMaxLevel.setEnabled(enabled);
        this.themeEditor.setEnabled(enabled);
        this.spinnerMinSurfaceDepth.setEnabled(enabled);
        this.spinnerMaxSurfaceDepth.setEnabled(enabled);
        this.checkBoxBottomless.setEnabled(enabled);
        this.spinnerCavernsMinLevel.setEnabled(enabled);
        this.spinnerCavernsMaxLevel.setEnabled(enabled);
        this.spinnerChasmsMinLevel.setEnabled(enabled);
        this.spinnerChasmsMaxLevel.setEnabled(enabled);
        this.checkBoxCoverSteepTerrain.setEnabled(enabled);
        this.checkBoxExportAnnotations.setEnabled(enabled);
        this.checkBoxSnowUnderTrees.setEnabled(enabled);
        this.comboBoxSurfaceLayerAnchor.setEnabled(enabled);
        this.setControlStates();
    }

    public boolean saveSettings() {
        Generator generatorType;
        AnnotationsExporter.AnnotationsSettings annotationsSettings;
        int minHeight = this.dimension.getMinHeight();
        int maxHeight = this.dimension.getMaxHeight() - 1;
        if (this.comboBoxGenerator.getSelectedItem() == Generator.CUSTOM && (this.generatorName == null || this.generatorName.trim().isEmpty())) {
            this.buttonGeneratorOptions.requestFocusInWindow();
            MessageUtils.beepAndShowError((Component)this, (String)"The custom world generator name has not been set.\nUse the [...] button to set it.", (String)"Error");
            return false;
        }
        if (this.mode != Mode.EXPORT && !this.themeEditor.save()) {
            this.jTabbedPane1.setSelectedIndex(1);
            return false;
        }
        int topLayerMinDepth = (Integer)this.spinnerMinSurfaceDepth.getValue();
        this.dimension.setTopLayerMinDepth(topLayerMinDepth);
        this.dimension.setTopLayerVariation((Integer)this.spinnerMaxSurfaceDepth.getValue() - topLayerMinDepth);
        this.dimension.setTopLayerAnchor(Dimension.LayerAnchor.values()[this.comboBoxSurfaceLayerAnchor.getSelectedIndex()]);
        this.dimension.setSubsurfaceMaterial((Terrain)this.comboBoxSubsurfaceMaterial.getSelectedItem());
        this.dimension.setSubsurfaceLayerAnchor(this.subsurfaceLayerAnchor);
        this.dimension.setBorder(this.getSelectedBorder());
        this.dimension.setBorderLevel(((Integer)this.spinnerBorderLevel.getValue()).intValue());
        this.dimension.setBorderSize((Integer)this.spinnerBorderSize.getValue() / 128);
        this.dimension.setWallType(this.checkBoxWall.isSelected() && !this.endlessBorder ? (this.radioButtonBedrockWall.isSelected() ? Dimension.WallType.BEDROCK : Dimension.WallType.BARIER) : null);
        this.dimension.setRoofType(this.checkBoxRoof.isSelected() ? (this.radioButtonBedrockRoof.isSelected() ? Dimension.WallType.BEDROCK : Dimension.WallType.BARIER) : null);
        long previousSeed = this.dimension.getMinecraftSeed();
        long newSeed = ((Number)this.spinnerMinecraftSeed.getValue()).longValue();
        if (newSeed != previousSeed) {
            this.dimension.setMinecraftSeed(newSeed);
            if (this.dimension.getGenerator() instanceof SeededGenerator) {
                ((SeededGenerator)this.dimension.getGenerator()).setSeed(newSeed);
            }
        }
        this.dimension.setBottomless(this.checkBoxBottomless.isSelected());
        this.dimension.setCoverSteepTerrain(this.checkBoxCoverSteepTerrain.isSelected());
        this.dimension.setCeilingHeight(((Integer)this.spinnerCeilingHeight.getValue()).intValue());
        CavesExporter.CavesSettings cavesSettings = (CavesExporter.CavesSettings)this.dimension.getLayerSettings((Layer)Caves.INSTANCE);
        if (cavesSettings == null) {
            cavesSettings = new CavesExporter.CavesSettings();
        }
        if (this.checkBoxCavesEverywhere.isSelected()) {
            int cavesEverywhereLevel = this.sliderCavesEverywhereLevel.getValue();
            cavesSettings.setCavesEverywhereLevel(cavesEverywhereLevel);
        } else {
            cavesSettings.setCavesEverywhereLevel(0);
        }
        cavesSettings.setSurfaceBreaking(this.checkBoxCavesBreakSurface.isSelected());
        cavesSettings.setMinimumLevel(((Integer)this.spinnerCavesMinLevel.getValue()).intValue());
        cavesSettings.setMaximumLevel(((Integer)this.spinnerCavesMaxLevel.getValue()).intValue());
        if (this.checkBoxFloodCaverns.isSelected()) {
            cavesSettings.setWaterLevel(((Integer)this.spinnerCavernsFloodLevel.getValue()).intValue());
        } else {
            cavesSettings.setWaterLevel(Integer.MIN_VALUE);
        }
        cavesSettings.setFloodWithLava(this.checkBoxCavernsFloodWithLava.isSelected());
        cavesSettings.setLeaveWater(!this.checkBoxCavernsRemoveWater.isSelected());
        boolean anyDecorationsSelected = this.checkBoxDecorationBrownMushrooms.isSelected() || this.checkBoxDecorationGlowLichen.isSelected() || this.checkBoxDecorationLushCaves.isSelected() || this.checkBoxDecorationDripstoneCaves.isSelected();
        AbstractCavesExporter.CaveDecorationSettings decorationSettings = anyDecorationsSelected ? new AbstractCavesExporter.CaveDecorationSettings(this.checkBoxDecorationBrownMushrooms.isSelected(), this.checkBoxDecorationGlowLichen.isSelected(), this.checkBoxDecorationLushCaves.isSelected(), this.checkBoxDecorationDripstoneCaves.isSelected()) : null;
        cavesSettings.setCaveDecorationSettings((AbstractCavesExporter.CaveDecorationSettings)(this.checkBoxDecorateCaves.isSelected() ? decorationSettings : null));
        this.dimension.setLayerSettings((Layer)Caves.INSTANCE, (ExporterSettings)cavesSettings);
        CavernsExporter.CavernsSettings cavernsSettings = (CavernsExporter.CavernsSettings)this.dimension.getLayerSettings((Layer)Caverns.INSTANCE);
        if (cavernsSettings == null) {
            cavernsSettings = new CavernsExporter.CavernsSettings();
        }
        if (this.checkBoxCavernsEverywhere.isSelected()) {
            int cavernsEverywhereLevel = this.sliderCavernsEverywhereLevel.getValue();
            cavernsSettings.setCavernsEverywhereLevel(cavernsEverywhereLevel);
        } else {
            cavernsSettings.setCavernsEverywhereLevel(0);
        }
        if (this.checkBoxFloodCaverns.isSelected()) {
            cavernsSettings.setWaterLevel(((Integer)this.spinnerCavernsFloodLevel.getValue()).intValue());
        } else {
            cavernsSettings.setWaterLevel(Integer.MIN_VALUE);
        }
        cavernsSettings.setFloodWithLava(this.checkBoxCavernsFloodWithLava.isSelected());
        cavernsSettings.setSurfaceBreaking(this.checkBoxCavernsBreakSurface.isSelected());
        cavernsSettings.setLeaveWater(!this.checkBoxCavernsRemoveWater.isSelected());
        cavernsSettings.setMinimumLevel(((Integer)this.spinnerCavernsMinLevel.getValue()).intValue());
        int cavernsMaxLevel = (Integer)this.spinnerCavernsMaxLevel.getValue();
        cavernsSettings.setMaximumLevel(cavernsMaxLevel >= maxHeight ? Integer.MAX_VALUE : cavernsMaxLevel);
        cavernsSettings.setCaveDecorationSettings((AbstractCavesExporter.CaveDecorationSettings)(this.checkBoxDecorateCaverns.isSelected() ? decorationSettings : null));
        this.dimension.setLayerSettings((Layer)Caverns.INSTANCE, (ExporterSettings)cavernsSettings);
        ChasmsExporter.ChasmsSettings chasmsSettings = (ChasmsExporter.ChasmsSettings)this.dimension.getLayerSettings((Layer)Chasms.INSTANCE);
        if (chasmsSettings == null) {
            chasmsSettings = new ChasmsExporter.ChasmsSettings();
        }
        if (this.checkBoxChasmsEverywhere.isSelected()) {
            int chasmsEverywhereLevel = this.sliderChasmsEverywhereLevel.getValue();
            chasmsSettings.setChasmsEverywhereLevel(chasmsEverywhereLevel);
        } else {
            chasmsSettings.setChasmsEverywhereLevel(0);
        }
        chasmsSettings.setSurfaceBreaking(this.checkBoxChasmsBreakSurface.isSelected());
        chasmsSettings.setMinimumLevel(((Integer)this.spinnerChasmsMinLevel.getValue()).intValue());
        chasmsSettings.setMaximumLevel(((Integer)this.spinnerChasmsMaxLevel.getValue()).intValue());
        if (this.checkBoxFloodCaverns.isSelected()) {
            chasmsSettings.setWaterLevel(((Integer)this.spinnerCavernsFloodLevel.getValue()).intValue());
        } else {
            chasmsSettings.setWaterLevel(Integer.MIN_VALUE);
        }
        chasmsSettings.setFloodWithLava(this.checkBoxCavernsFloodWithLava.isSelected());
        chasmsSettings.setLeaveWater(!this.checkBoxCavernsRemoveWater.isSelected());
        chasmsSettings.setCaveDecorationSettings((AbstractCavesExporter.CaveDecorationSettings)(this.checkBoxDecorateChasms.isSelected() ? decorationSettings : null));
        this.dimension.setLayerSettings((Layer)Chasms.INSTANCE, (ExporterSettings)chasmsSettings);
        this.dimension.setPopulate(this.checkBoxPopulate.isSelected());
        TreesExporter.TreeLayerSettings deciduousSettings = (TreesExporter.TreeLayerSettings)this.dimension.getLayerSettings((Layer)DeciduousForest.INSTANCE);
        if (deciduousSettings == null) {
            deciduousSettings = new TreesExporter.TreeLayerSettings((TreeLayer)DeciduousForest.INSTANCE);
        }
        if (this.checkBoxDeciduousEverywhere.isSelected()) {
            int minimumLevel = this.sliderDeciduousLevel.getValue();
            deciduousSettings.setMinimumLevel(minimumLevel);
        } else {
            deciduousSettings.setMinimumLevel(0);
        }
        this.dimension.setLayerSettings((Layer)DeciduousForest.INSTANCE, (ExporterSettings)deciduousSettings);
        TreesExporter.TreeLayerSettings pineSettings = (TreesExporter.TreeLayerSettings)this.dimension.getLayerSettings((Layer)PineForest.INSTANCE);
        if (pineSettings == null) {
            pineSettings = new TreesExporter.TreeLayerSettings((TreeLayer)PineForest.INSTANCE);
        }
        if (this.checkBoxPineEverywhere.isSelected()) {
            int minimumLevel = this.sliderPineLevel.getValue();
            pineSettings.setMinimumLevel(minimumLevel);
        } else {
            pineSettings.setMinimumLevel(0);
        }
        this.dimension.setLayerSettings((Layer)PineForest.INSTANCE, (ExporterSettings)pineSettings);
        TreesExporter.TreeLayerSettings jungleSettings = (TreesExporter.TreeLayerSettings)this.dimension.getLayerSettings((Layer)Jungle.INSTANCE);
        if (jungleSettings == null) {
            jungleSettings = new TreesExporter.TreeLayerSettings((TreeLayer)Jungle.INSTANCE);
        }
        if (this.checkBoxJungleEverywhere.isSelected()) {
            int minimumLevel = this.sliderJungleLevel.getValue();
            jungleSettings.setMinimumLevel(minimumLevel);
        } else {
            jungleSettings.setMinimumLevel(0);
        }
        this.dimension.setLayerSettings((Layer)Jungle.INSTANCE, (ExporterSettings)jungleSettings);
        TreesExporter.TreeLayerSettings swampLandSettings = (TreesExporter.TreeLayerSettings)this.dimension.getLayerSettings((Layer)SwampLand.INSTANCE);
        if (swampLandSettings == null) {
            swampLandSettings = new TreesExporter.TreeLayerSettings((TreeLayer)SwampLand.INSTANCE);
        }
        if (this.checkBoxSwamplandEverywhere.isSelected()) {
            int minimumLevel = this.jSlider6.getValue();
            swampLandSettings.setMinimumLevel(minimumLevel);
        } else {
            swampLandSettings.setMinimumLevel(0);
        }
        this.dimension.setLayerSettings((Layer)SwampLand.INSTANCE, (ExporterSettings)swampLandSettings);
        FrostExporter.FrostSettings frostSettings = (FrostExporter.FrostSettings)this.dimension.getLayerSettings((Layer)Frost.INSTANCE);
        if (frostSettings == null) {
            frostSettings = new FrostExporter.FrostSettings();
        }
        frostSettings.setFrostEverywhere(this.checkBoxFrostEverywhere.isSelected());
        if (!this.checkBoxSmoothSnow.isSelected() || frostSettings.getMode() != 3) {
            frostSettings.setMode(this.checkBoxSmoothSnow.isSelected() ? 2 : 0);
        }
        frostSettings.setSnowUnderTrees(this.checkBoxSnowUnderTrees.isSelected());
        this.dimension.setLayerSettings((Layer)Frost.INSTANCE, (ExporterSettings)frostSettings);
        if (this.mode != Mode.DEFAULT_SETTINGS) {
            ResourcesExporter.ResourcesExporterSettings resourcesSettings = (ResourcesExporter.ResourcesExporterSettings)this.dimension.getLayerSettings((Layer)Resources.INSTANCE);
            if (resourcesSettings == null) {
                resourcesSettings = ResourcesExporter.ResourcesExporterSettings.defaultSettings((Platform)this.platform, (Dimension.Anchor)this.dimension.getAnchor(), (int)this.dimension.getMinHeight(), (int)this.dimension.getMaxHeight());
            }
            if (this.jCheckBox8.isSelected()) {
                int minimumLevel = this.jSlider4.getValue();
                resourcesSettings.setMinimumLevel(minimumLevel);
            } else {
                resourcesSettings.setMinimumLevel(0);
            }
            resourcesSettings.setChance(Material.GOLD_ORE, ((Integer)this.spinnerGoldChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.GOLD_ORE, ((Integer)this.spinnerGoldMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.GOLD_ORE, ((Integer)this.spinnerGoldMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.IRON_ORE, ((Integer)this.spinnerIronChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.IRON_ORE, ((Integer)this.spinnerIronMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.IRON_ORE, ((Integer)this.spinnerIronMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.COAL, ((Integer)this.spinnerCoalChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.COAL, ((Integer)this.spinnerCoalMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.COAL, ((Integer)this.spinnerCoalMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.LAPIS_LAZULI_ORE, ((Integer)this.spinnerLapisChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.LAPIS_LAZULI_ORE, ((Integer)this.spinnerLapisMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.LAPIS_LAZULI_ORE, ((Integer)this.spinnerLapisMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.DIAMOND_ORE, ((Integer)this.spinnerDiamondChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.DIAMOND_ORE, ((Integer)this.spinnerDiamondMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.DIAMOND_ORE, ((Integer)this.spinnerDiamondMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.REDSTONE_ORE, ((Integer)this.spinnerRedstoneChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.REDSTONE_ORE, ((Integer)this.spinnerRedstoneMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.REDSTONE_ORE, ((Integer)this.spinnerRedstoneMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.STATIONARY_WATER, ((Integer)this.spinnerWaterChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.STATIONARY_WATER, ((Integer)this.spinnerWaterMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.STATIONARY_WATER, ((Integer)this.spinnerWaterMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.STATIONARY_LAVA, ((Integer)this.spinnerLavaChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.STATIONARY_LAVA, ((Integer)this.spinnerLavaMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.STATIONARY_LAVA, ((Integer)this.spinnerLavaMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.DIRT, ((Integer)this.spinnerDirtChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.DIRT, ((Integer)this.spinnerDirtMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.DIRT, ((Integer)this.spinnerDirtMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.GRAVEL, ((Integer)this.spinnerGravelChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.GRAVEL, ((Integer)this.spinnerGravelMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.GRAVEL, ((Integer)this.spinnerGravelMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.EMERALD_ORE, ((Integer)this.spinnerEmeraldChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.EMERALD_ORE, ((Integer)this.spinnerEmeraldMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.EMERALD_ORE, ((Integer)this.spinnerEmeraldMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.QUARTZ_ORE, ((Integer)this.spinnerQuartzChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.QUARTZ_ORE, ((Integer)this.spinnerQuartzMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.QUARTZ_ORE, ((Integer)this.spinnerQuartzMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.COPPER_ORE, ((Integer)this.spinnerCopperChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.COPPER_ORE, ((Integer)this.spinnerCopperMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.COPPER_ORE, ((Integer)this.spinnerCopperMaxLevel.getValue()).intValue());
            resourcesSettings.setChance(Material.ANCIENT_DEBRIS, ((Integer)this.spinnerAncientDebrisChance.getValue()).intValue());
            resourcesSettings.setMinLevel(Material.ANCIENT_DEBRIS, ((Integer)this.spinnerAncientDebrisMinLevel.getValue()).intValue());
            resourcesSettings.setMaxLevel(Material.ANCIENT_DEBRIS, ((Integer)this.spinnerAncientDebrisMaxLevel.getValue()).intValue());
            this.dimension.setLayerSettings((Layer)Resources.INSTANCE, (ExporterSettings)resourcesSettings);
        }
        if ((annotationsSettings = (AnnotationsExporter.AnnotationsSettings)this.dimension.getLayerSettings((Layer)Annotations.INSTANCE)) == null) {
            annotationsSettings = new AnnotationsExporter.AnnotationsSettings();
        }
        annotationsSettings.setExport(this.checkBoxExportAnnotations.isSelected());
        this.dimension.setLayerSettings((Layer)Annotations.INSTANCE, (ExporterSettings)annotationsSettings);
        if (this.mode == Mode.EXPORT && this.customLayersTableModel != null && !this.customLayersTableModel.isPristine()) {
            this.customLayersTableModel.save();
            this.dimension.changed();
        }
        for (Component component : this.jTabbedPane1.getComponents()) {
            if (!(component instanceof ExportSettingsEditor)) continue;
            ExportSettingsEditor editor = (ExportSettingsEditor)component;
            this.dimension.setExportSettings(editor.getExportSettings());
        }
        if (!this.endlessBorder && (generatorType = (Generator)this.comboBoxGenerator.getSelectedItem()) != null) {
            switch (generatorType) {
                case FLAT: {
                    this.dimension.setGenerator((MapGenerator)new SuperflatGenerator(this.superflatPreset));
                    break;
                }
                case DEFAULT: 
                case LARGE_BIOMES: 
                case BUFFET: 
                case CUSTOMIZED: 
                case NETHER: 
                case END: 
                case AMPLIFIED: {
                    this.dimension.setGenerator((MapGenerator)new SeededGenerator(generatorType, this.dimension.getMinecraftSeed()));
                    break;
                }
                case CUSTOM: {
                    this.dimension.setGenerator((MapGenerator)new CustomGenerator(this.generatorName.trim(), this.customGeneratorSettings));
                    break;
                }
            }
        }
        return true;
    }

    public boolean isPopulateSelected() {
        return this.checkBoxPopulate.isSelected();
    }

    Generator getSelectedGeneratorType() {
        return (Generator)this.comboBoxGenerator.getSelectedItem();
    }

    void setSelectedGeneratorType(Generator generatorType) {
        this.comboBoxGenerator.setSelectedItem(generatorType);
    }

    private void initialisePostProcessingTab() {
        if (this.mode == Mode.EXPORT) {
            ExportSettings exportSettings = this.dimension.getExportSettings();
            if (exportSettings == null && this.platformProvider != null) {
                exportSettings = this.platformProvider.getDefaultExportSettings(this.platform);
            }
            if (exportSettings != null) {
                try {
                    ExportSettingsEditor editor = this.platformProvider.getExportSettingsEditor(this.platform);
                    editor.setExportSettings(exportSettings);
                    this.jTabbedPane1.addTab("Post Processing", (Component)editor);
                }
                catch (RuntimeException e) {
                    logger.warn("Could not initialise post processing tab", (Throwable)e);
                }
            }
        }
    }

    private Dimension.Border getSelectedBorder() {
        if (this.radioButtonLavaBorder.isSelected()) {
            return this.radioButtonEndlessBorder.isSelected() ? Dimension.Border.ENDLESS_LAVA : Dimension.Border.LAVA;
        }
        if (this.radioButtonNoBorder.isSelected()) {
            return null;
        }
        if (this.radioButtonVoidBorder.isSelected()) {
            return this.radioButtonEndlessBorder.isSelected() ? Dimension.Border.ENDLESS_VOID : Dimension.Border.VOID;
        }
        if (this.radioButtonWaterBorder.isSelected()) {
            return this.radioButtonEndlessBorder.isSelected() ? Dimension.Border.ENDLESS_WATER : Dimension.Border.WATER;
        }
        return this.radioButtonEndlessBorder.isSelected() ? Dimension.Border.ENDLESS_BARRIER : Dimension.Border.BARRIER;
    }

    private void loadSettings() {
        List customLayers;
        AnnotationsExporter.AnnotationsSettings annotationsSettings;
        ChasmsExporter.ChasmsSettings chasmsSettings;
        int maxHeight;
        int minHeight;
        block53: {
            block52: {
                minHeight = this.dimension.getMinHeight();
                maxHeight = this.dimension.getMaxHeight() - 1;
                ((SpinnerNumberModel)this.spinnerMinSurfaceDepth.getModel()).setMaximum(Integer.valueOf(maxHeight));
                this.spinnerMinSurfaceDepth.setValue(this.dimension.getTopLayerMinDepth());
                ((SpinnerNumberModel)this.spinnerMaxSurfaceDepth.getModel()).setMaximum(Integer.valueOf(maxHeight));
                this.spinnerMaxSurfaceDepth.setValue(this.dimension.getTopLayerMinDepth() + this.dimension.getTopLayerVariation());
                this.comboBoxSurfaceLayerAnchor.setSelectedIndex(this.dimension.getTopLayerAnchor().ordinal());
                Terrain subsurfaceTerrain = this.dimension.getSubsurfaceMaterial();
                this.subsurfaceLayerAnchor = this.dimension.getSubsurfaceLayerAnchor();
                if (subsurfaceTerrain != null && subsurfaceTerrain.isCustom()) {
                    MixedMaterial material = Terrain.getCustomMaterial((int)subsurfaceTerrain.getCustomTerrainIndex());
                    if (material.getMode() == MixedMaterial.Mode.LAYERED) {
                        this.comboBoxUndergroundLayerAnchor.setSelectedIndex(this.subsurfaceLayerAnchor.ordinal());
                    } else {
                        this.comboBoxUndergroundLayerAnchor.setSelectedItem(null);
                    }
                } else {
                    this.comboBoxUndergroundLayerAnchor.setSelectedItem(null);
                }
                if (this.dimension.getBorder() == null) break block52;
                switch (this.dimension.getBorder()) {
                    case LAVA: {
                        this.radioButtonLavaBorder.setSelected(true);
                        this.radioButtonFixedBorder.setSelected(true);
                        break block53;
                    }
                    case WATER: {
                        this.radioButtonWaterBorder.setSelected(true);
                        this.radioButtonFixedBorder.setSelected(true);
                        break block53;
                    }
                    case VOID: {
                        this.radioButtonVoidBorder.setSelected(true);
                        this.radioButtonFixedBorder.setSelected(true);
                        break block53;
                    }
                    case BARRIER: {
                        this.radioButtonBarrierBorder.setSelected(true);
                        this.radioButtonFixedBorder.setSelected(true);
                        break block53;
                    }
                    case ENDLESS_LAVA: {
                        this.radioButtonLavaBorder.setSelected(true);
                        this.radioButtonEndlessBorder.setSelected(true);
                        break block53;
                    }
                    case ENDLESS_WATER: {
                        this.radioButtonWaterBorder.setSelected(true);
                        this.radioButtonEndlessBorder.setSelected(true);
                        break block53;
                    }
                    case ENDLESS_VOID: {
                        this.radioButtonVoidBorder.setSelected(true);
                        this.radioButtonEndlessBorder.setSelected(true);
                        break block53;
                    }
                    case ENDLESS_BARRIER: {
                        this.radioButtonBarrierBorder.setSelected(true);
                        this.radioButtonEndlessBorder.setSelected(true);
                        break block53;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            this.radioButtonNoBorder.setSelected(true);
        }
        ((SpinnerNumberModel)this.spinnerBorderLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerBorderLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
        this.spinnerBorderLevel.setValue(this.dimension.getBorderLevel());
        this.spinnerBorderSize.setValue(this.dimension.getBorderSize() * 128);
        this.checkBoxWall.setSelected(this.dimension.getWallType() != null);
        this.radioButtonBedrockWall.setSelected(this.dimension.getWallType() == Dimension.WallType.BEDROCK);
        this.radioButtonBarrierWall.setSelected(this.dimension.getWallType() == Dimension.WallType.BARIER);
        this.checkBoxRoof.setSelected(this.dimension.getRoofType() != null);
        this.radioButtonBedrockRoof.setSelected(this.dimension.getRoofType() == Dimension.WallType.BEDROCK);
        this.radioButtonBarrierRoof.setSelected(this.dimension.getRoofType() == Dimension.WallType.BARIER);
        this.spinnerMinecraftSeed.setValue(this.dimension.getMinecraftSeed());
        this.checkBoxBottomless.setSelected(this.dimension.isBottomless());
        this.checkBoxCoverSteepTerrain.setSelected(this.dimension.isCoverSteepTerrain());
        ((SpinnerNumberModel)this.spinnerCeilingHeight.getModel()).setMinimum(Integer.valueOf(minHeight + 1));
        ((SpinnerNumberModel)this.spinnerCeilingHeight.getModel()).setMaximum(Integer.valueOf(maxHeight + 1));
        this.spinnerCeilingHeight.setValue(this.dimension.getCeilingHeight());
        ArrayList<Terrain> materialList = new ArrayList<Terrain>(Arrays.asList(Terrain.VALUES));
        Iterator i = materialList.iterator();
        while (i.hasNext()) {
            Terrain terrain = (Terrain)i.next();
            if ((!terrain.isCustom() || terrain.isConfigured()) && terrain != Terrain.GRASS && terrain != Terrain.DESERT && terrain != Terrain.RED_DESERT) continue;
            i.remove();
        }
        this.comboBoxSubsurfaceMaterial.setModel(new DefaultComboBoxModel<Object>(materialList.toArray()));
        this.comboBoxSubsurfaceMaterial.setSelectedItem(this.dimension.getSubsurfaceMaterial());
        CavesExporter.CavesSettings cavesSettings = (CavesExporter.CavesSettings)this.dimension.getLayerSettings((Layer)Caves.INSTANCE);
        if (cavesSettings == null) {
            cavesSettings = new CavesExporter.CavesSettings();
        }
        if (cavesSettings.getCavesEverywhereLevel() > 0) {
            this.checkBoxCavesEverywhere.setSelected(true);
            this.sliderCavesEverywhereLevel.setValue(cavesSettings.getCavesEverywhereLevel());
        } else {
            this.checkBoxCavesEverywhere.setSelected(false);
            this.sliderCavesEverywhereLevel.setValue(8);
        }
        this.checkBoxCavesBreakSurface.setSelected(cavesSettings.isSurfaceBreaking());
        ((SpinnerNumberModel)this.spinnerCavesMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerCavesMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
        this.spinnerCavesMinLevel.setValue(cavesSettings.getMinimumLevel() == Integer.MIN_VALUE ? minHeight + 8 : Math.max(cavesSettings.getMinimumLevel(), minHeight));
        ((SpinnerNumberModel)this.spinnerCavesMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerCavesMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
        this.spinnerCavesMaxLevel.setValue(Math.min(cavesSettings.getMaximumLevel(), maxHeight));
        AbstractCavesExporter.CaveDecorationSettings decorationSettings = cavesSettings.getCaveDecorationSettings();
        this.checkBoxDecorateCaves.setSelected(decorationSettings != null);
        CavernsExporter.CavernsSettings cavernsSettings = (CavernsExporter.CavernsSettings)this.dimension.getLayerSettings((Layer)Caverns.INSTANCE);
        if (cavernsSettings == null) {
            cavernsSettings = new CavernsExporter.CavernsSettings();
        }
        if (cavernsSettings.getCavernsEverywhereLevel() > 0) {
            this.checkBoxCavernsEverywhere.setSelected(true);
            this.sliderCavernsEverywhereLevel.setValue(cavernsSettings.getCavernsEverywhereLevel());
        } else {
            this.checkBoxCavernsEverywhere.setSelected(false);
            this.sliderCavernsEverywhereLevel.setValue(8);
        }
        ((SpinnerNumberModel)this.spinnerCavernsFloodLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerCavernsFloodLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
        if (cavernsSettings.getWaterLevel() >= minHeight) {
            this.checkBoxFloodCaverns.setSelected(true);
            this.spinnerCavernsFloodLevel.setValue(cavernsSettings.getWaterLevel());
        } else {
            this.checkBoxFloodCaverns.setSelected(false);
            this.spinnerCavernsFloodLevel.setValue(minHeight + 8);
        }
        this.checkBoxCavernsFloodWithLava.setSelected(cavernsSettings.isFloodWithLava());
        this.checkBoxCavernsBreakSurface.setSelected(cavernsSettings.isSurfaceBreaking());
        this.checkBoxCavernsRemoveWater.setSelected(!cavernsSettings.isLeaveWater());
        ((SpinnerNumberModel)this.spinnerCavernsMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerCavernsMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
        this.spinnerCavernsMinLevel.setValue(Math.max(cavernsSettings.getMinimumLevel(), minHeight));
        ((SpinnerNumberModel)this.spinnerCavernsMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerCavernsMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
        this.spinnerCavernsMaxLevel.setValue(Math.min(cavernsSettings.getMaximumLevel(), maxHeight));
        AbstractCavesExporter.CaveDecorationSettings cavernDecorationSettings = cavernsSettings.getCaveDecorationSettings();
        if (this.checkBoxDecorateCaverns.isEnabled()) {
            this.checkBoxDecorateCaverns.setSelected(cavernDecorationSettings != null);
        }
        if (decorationSettings == null) {
            decorationSettings = cavernDecorationSettings;
        }
        if ((chasmsSettings = (ChasmsExporter.ChasmsSettings)this.dimension.getLayerSettings((Layer)Chasms.INSTANCE)) == null) {
            chasmsSettings = new ChasmsExporter.ChasmsSettings();
        }
        if (chasmsSettings.getChasmsEverywhereLevel() > 0) {
            this.checkBoxChasmsEverywhere.setSelected(true);
            this.sliderChasmsEverywhereLevel.setValue(chasmsSettings.getChasmsEverywhereLevel());
        } else {
            this.checkBoxChasmsEverywhere.setSelected(false);
            this.sliderChasmsEverywhereLevel.setValue(8);
        }
        this.checkBoxChasmsBreakSurface.setSelected(chasmsSettings.isSurfaceBreaking());
        ((SpinnerNumberModel)this.spinnerChasmsMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerChasmsMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
        this.spinnerChasmsMinLevel.setValue(Math.max(chasmsSettings.getMinimumLevel(), minHeight));
        ((SpinnerNumberModel)this.spinnerChasmsMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
        ((SpinnerNumberModel)this.spinnerChasmsMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
        this.spinnerChasmsMaxLevel.setValue(Math.min(chasmsSettings.getMaximumLevel(), maxHeight));
        AbstractCavesExporter.CaveDecorationSettings chasmDecorationSettings = chasmsSettings.getCaveDecorationSettings();
        if (this.checkBoxDecorateChasms.isEnabled()) {
            this.checkBoxDecorateChasms.setSelected(chasmDecorationSettings != null);
        }
        if (decorationSettings == null) {
            decorationSettings = chasmDecorationSettings;
        }
        if (decorationSettings == null) {
            decorationSettings = new AbstractCavesExporter.CaveDecorationSettings();
        }
        this.checkBoxDecorationBrownMushrooms.setSelected(decorationSettings.isEnabled(AbstractCavesExporter.CaveDecorationSettings.Decoration.BROWN_MUSHROOM));
        this.checkBoxDecorationGlowLichen.setSelected(decorationSettings.isEnabled(AbstractCavesExporter.CaveDecorationSettings.Decoration.GLOW_LICHEN));
        this.checkBoxDecorationLushCaves.setSelected(decorationSettings.isEnabled(AbstractCavesExporter.CaveDecorationSettings.Decoration.LUSH_CAVE_PATCHES));
        this.checkBoxDecorationDripstoneCaves.setSelected(decorationSettings.isEnabled(AbstractCavesExporter.CaveDecorationSettings.Decoration.DRIPSTONE_CAVE_PATCHES));
        this.checkBoxPopulate.setSelected(this.dimension.isPopulate());
        TreesExporter.TreeLayerSettings deciduousSettings = (TreesExporter.TreeLayerSettings)this.dimension.getLayerSettings((Layer)DeciduousForest.INSTANCE);
        if (deciduousSettings == null) {
            deciduousSettings = new TreesExporter.TreeLayerSettings((TreeLayer)DeciduousForest.INSTANCE);
        }
        if (deciduousSettings.getMinimumLevel() > 0) {
            this.checkBoxDeciduousEverywhere.setSelected(true);
            this.sliderDeciduousLevel.setValue(deciduousSettings.getMinimumLevel());
        } else {
            this.checkBoxDeciduousEverywhere.setSelected(false);
            this.sliderDeciduousLevel.setValue(8);
        }
        TreesExporter.TreeLayerSettings pineSettings = (TreesExporter.TreeLayerSettings)this.dimension.getLayerSettings((Layer)PineForest.INSTANCE);
        if (pineSettings == null) {
            pineSettings = new TreesExporter.TreeLayerSettings((TreeLayer)PineForest.INSTANCE);
        }
        if (pineSettings.getMinimumLevel() > 0) {
            this.checkBoxPineEverywhere.setSelected(true);
            this.sliderPineLevel.setValue(pineSettings.getMinimumLevel());
        } else {
            this.checkBoxPineEverywhere.setSelected(false);
            this.sliderPineLevel.setValue(8);
        }
        TreesExporter.TreeLayerSettings jungleSettings = (TreesExporter.TreeLayerSettings)this.dimension.getLayerSettings((Layer)Jungle.INSTANCE);
        if (jungleSettings == null) {
            jungleSettings = new TreesExporter.TreeLayerSettings((TreeLayer)Jungle.INSTANCE);
        }
        if (jungleSettings.getMinimumLevel() > 0) {
            this.checkBoxJungleEverywhere.setSelected(true);
            this.sliderJungleLevel.setValue(jungleSettings.getMinimumLevel());
        } else {
            this.checkBoxJungleEverywhere.setSelected(false);
            this.sliderJungleLevel.setValue(8);
        }
        TreesExporter.TreeLayerSettings swampLandSettings = (TreesExporter.TreeLayerSettings)this.dimension.getLayerSettings((Layer)SwampLand.INSTANCE);
        if (swampLandSettings == null) {
            swampLandSettings = new TreesExporter.TreeLayerSettings((TreeLayer)SwampLand.INSTANCE);
        }
        if (swampLandSettings.getMinimumLevel() > 0) {
            this.checkBoxSwamplandEverywhere.setSelected(true);
            this.jSlider6.setValue(swampLandSettings.getMinimumLevel());
        } else {
            this.checkBoxSwamplandEverywhere.setSelected(false);
            this.jSlider6.setValue(8);
        }
        FrostExporter.FrostSettings frostSettings = (FrostExporter.FrostSettings)this.dimension.getLayerSettings((Layer)Frost.INSTANCE);
        if (frostSettings == null) {
            frostSettings = new FrostExporter.FrostSettings();
        }
        this.checkBoxFrostEverywhere.setSelected(frostSettings.isFrostEverywhere());
        this.checkBoxSmoothSnow.setSelected(frostSettings.getMode() == 2 || frostSettings.getMode() == 3);
        this.checkBoxSnowUnderTrees.setSelected(frostSettings.isSnowUnderTrees());
        if (this.mode != Mode.DEFAULT_SETTINGS) {
            ResourcesExporter.ResourcesExporterSettings resourcesSettings = (ResourcesExporter.ResourcesExporterSettings)this.dimension.getLayerSettings((Layer)Resources.INSTANCE);
            if (resourcesSettings == null) {
                resourcesSettings = ResourcesExporter.ResourcesExporterSettings.defaultSettings((Platform)this.platform, (Dimension.Anchor)this.dimension.getAnchor(), (int)this.dimension.getMinHeight(), (int)this.dimension.getMaxHeight());
                resourcesSettings.setMinimumLevel(0);
            }
            this.jCheckBox8.setSelected(resourcesSettings.isApplyEverywhere());
            if (resourcesSettings.isApplyEverywhere()) {
                this.jSlider4.setValue(resourcesSettings.getMinimumLevel());
            } else {
                this.jSlider4.setValue(8);
            }
            this.spinnerGoldChance.setValue(resourcesSettings.getChance(Material.GOLD_ORE));
            ((SpinnerNumberModel)this.spinnerGoldMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerGoldMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerGoldMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.GOLD_ORE), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerGoldMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerGoldMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerGoldMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.GOLD_ORE), (int)maxHeight));
            this.spinnerIronChance.setValue(resourcesSettings.getChance(Material.IRON_ORE));
            ((SpinnerNumberModel)this.spinnerIronMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerIronMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerIronMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.IRON_ORE), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerIronMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerIronMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerIronMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.IRON_ORE), (int)maxHeight));
            this.spinnerCoalChance.setValue(resourcesSettings.getChance(Material.COAL));
            ((SpinnerNumberModel)this.spinnerCoalMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerCoalMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerCoalMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.COAL), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerCoalMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerCoalMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerCoalMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.COAL), (int)maxHeight));
            this.spinnerLapisChance.setValue(resourcesSettings.getChance(Material.LAPIS_LAZULI_ORE));
            ((SpinnerNumberModel)this.spinnerLapisMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerLapisMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerLapisMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.LAPIS_LAZULI_ORE), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerLapisMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerLapisMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerLapisMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.LAPIS_LAZULI_ORE), (int)maxHeight));
            this.spinnerDiamondChance.setValue(resourcesSettings.getChance(Material.DIAMOND_ORE));
            ((SpinnerNumberModel)this.spinnerDiamondMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerDiamondMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerDiamondMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.DIAMOND_ORE), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerDiamondMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerDiamondMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerDiamondMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.DIAMOND_ORE), (int)maxHeight));
            this.spinnerRedstoneChance.setValue(resourcesSettings.getChance(Material.REDSTONE_ORE));
            ((SpinnerNumberModel)this.spinnerRedstoneMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerRedstoneMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerRedstoneMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.REDSTONE_ORE), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerRedstoneMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerRedstoneMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerRedstoneMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.REDSTONE_ORE), (int)maxHeight));
            this.spinnerWaterChance.setValue(resourcesSettings.getChance(Material.STATIONARY_WATER));
            ((SpinnerNumberModel)this.spinnerWaterMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerWaterMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerWaterMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.STATIONARY_WATER), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerWaterMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerWaterMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerWaterMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.STATIONARY_WATER), (int)maxHeight));
            this.spinnerLavaChance.setValue(resourcesSettings.getChance(Material.STATIONARY_LAVA));
            ((SpinnerNumberModel)this.spinnerLavaMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerLavaMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerLavaMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.STATIONARY_LAVA), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerLavaMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerLavaMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerLavaMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.STATIONARY_LAVA), (int)maxHeight));
            this.spinnerDirtChance.setValue(resourcesSettings.getChance(Material.DIRT));
            ((SpinnerNumberModel)this.spinnerDirtMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerDirtMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerDirtMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.DIRT), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerDirtMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerDirtMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerDirtMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.DIRT), (int)maxHeight));
            this.spinnerGravelChance.setValue(resourcesSettings.getChance(Material.GRAVEL));
            ((SpinnerNumberModel)this.spinnerGravelMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerGravelMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerGravelMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.GRAVEL), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerGravelMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerGravelMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerGravelMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.GRAVEL), (int)maxHeight));
            this.spinnerEmeraldChance.setValue(resourcesSettings.getChance(Material.EMERALD_ORE));
            ((SpinnerNumberModel)this.spinnerEmeraldMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerEmeraldMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerEmeraldMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.EMERALD_ORE), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerEmeraldMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerEmeraldMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerEmeraldMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.EMERALD_ORE), (int)maxHeight));
            this.spinnerQuartzChance.setValue(resourcesSettings.getChance(Material.QUARTZ_ORE));
            ((SpinnerNumberModel)this.spinnerQuartzMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerQuartzMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerQuartzMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.QUARTZ_ORE), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerQuartzMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerQuartzMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerQuartzMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.QUARTZ_ORE), (int)maxHeight));
            this.spinnerCopperChance.setValue(resourcesSettings.getChance(Material.COPPER_ORE));
            ((SpinnerNumberModel)this.spinnerCopperMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerCopperMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerCopperMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.COPPER_ORE), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerCopperMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerCopperMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerCopperMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.COPPER_ORE), (int)maxHeight));
            this.spinnerAncientDebrisChance.setValue(resourcesSettings.getChance(Material.ANCIENT_DEBRIS));
            ((SpinnerNumberModel)this.spinnerAncientDebrisMinLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerAncientDebrisMinLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerAncientDebrisMinLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMinLevel(Material.ANCIENT_DEBRIS), (int)maxHeight));
            ((SpinnerNumberModel)this.spinnerAncientDebrisMaxLevel.getModel()).setMinimum(Integer.valueOf(minHeight));
            ((SpinnerNumberModel)this.spinnerAncientDebrisMaxLevel.getModel()).setMaximum(Integer.valueOf(maxHeight));
            this.spinnerAncientDebrisMaxLevel.setValue(MathUtils.clamp((int)minHeight, (int)resourcesSettings.getMaxLevel(Material.ANCIENT_DEBRIS), (int)maxHeight));
        }
        if (this.mode != Mode.EXPORT && this.dimension.getTileFactory() instanceof HeightMapTileFactory && ((HeightMapTileFactory)this.dimension.getTileFactory()).getTheme() instanceof SimpleTheme && ((SimpleTheme)((HeightMapTileFactory)this.dimension.getTileFactory()).getTheme()).getTerrainRanges() != null) {
            this.themeEditor.setTheme((SimpleTheme)((HeightMapTileFactory)this.dimension.getTileFactory()).getTheme());
        }
        if ((annotationsSettings = (AnnotationsExporter.AnnotationsSettings)this.dimension.getLayerSettings((Layer)Annotations.INSTANCE)) == null) {
            annotationsSettings = new AnnotationsExporter.AnnotationsSettings();
        }
        this.checkBoxExportAnnotations.setSelected(annotationsSettings.isExport());
        if (this.mode == Mode.EXPORT && !(customLayers = this.dimension.getCustomLayers(true)).isEmpty()) {
            this.customLayersTableModel = new CustomLayersTableModel(customLayers);
            this.tableCustomLayers.setModel(this.customLayersTableModel);
            this.orderPristine = customLayers.stream().noneMatch(layer -> layer.getIndex() != null);
        }
        this.endlessBorder = this.dimension.getBorder() != null && this.dimension.getBorder().isEndless();
        MapGenerator generator = this.dimension.getGenerator();
        this.comboBoxGenerator.setSelectedItem(this.endlessBorder ? Generator.FLAT : (generator != null ? generator.getType() : null));
        if (generator != null) {
            this.savedGeneratorType = generator.getType();
            this.generatorName = generator instanceof CustomGenerator ? ((CustomGenerator)generator).getName() : null;
            this.customGeneratorSettings = generator instanceof CustomGenerator ? ((CustomGenerator)generator).getSettings() : null;
            this.superflatPreset = generator instanceof SuperflatGenerator ? ((SuperflatGenerator)generator).getSettings() : null;
        }
        this.setControlStates();
    }

    private void setControlStates() {
        boolean enabled = this.isEnabled();
        Dimension.Anchor anchor = this.dimension != null ? this.dimension.getAnchor() : null;
        boolean dim0 = anchor != null && anchor.dim == 0 && anchor.role == Dimension.Role.DETAIL && !anchor.invert;
        boolean ceiling = anchor != null && anchor.invert;
        boolean caveFloor = anchor != null && anchor.role == Dimension.Role.CAVE_FLOOR;
        boolean master = anchor != null && anchor.role == Dimension.Role.MASTER;
        boolean decorations = this.checkBoxDecorateCaverns.isSelected() || this.checkBoxDecorateCaves.isSelected() || this.checkBoxDecorateChasms.isSelected();
        this.setEnabled(this.radioButtonLavaBorder, enabled && !ceiling && !caveFloor && !master);
        this.setEnabled(this.radioButtonNoBorder, enabled && !ceiling && !caveFloor && !master);
        this.setEnabled(this.radioButtonVoidBorder, enabled && !ceiling && !caveFloor && !master);
        this.setEnabled(this.radioButtonWaterBorder, enabled && !ceiling && !caveFloor && !master);
        this.setEnabled(this.radioButtonBarrierBorder, enabled && !ceiling && !caveFloor && !master);
        this.setEnabled(this.spinnerBorderLevel, enabled && !ceiling && !caveFloor && !master && (this.radioButtonLavaBorder.isSelected() || this.radioButtonWaterBorder.isSelected()));
        this.setEnabled(this.radioButtonFixedBorder, enabled && !ceiling && !caveFloor && !master && !this.radioButtonNoBorder.isSelected());
        this.setEnabled(this.radioButtonEndlessBorder, enabled && (this.platform.capabilities.contains(Platform.Capability.GENERATOR_PER_DIMENSION) || dim0) && !ceiling && !caveFloor && !master && !this.radioButtonNoBorder.isSelected());
        this.setEnabled(this.spinnerBorderSize, enabled && !ceiling && !caveFloor && !master && !this.radioButtonNoBorder.isSelected() && this.radioButtonFixedBorder.isSelected());
        this.setEnabled(this.sliderCavesEverywhereLevel, enabled && this.checkBoxCavesEverywhere.isSelected());
        this.setEnabled(this.sliderCavernsEverywhereLevel, enabled && this.checkBoxCavernsEverywhere.isSelected());
        this.setEnabled(this.sliderChasmsEverywhereLevel, enabled && this.checkBoxChasmsEverywhere.isSelected());
        this.setEnabled(this.spinnerCavernsFloodLevel, enabled && this.checkBoxFloodCaverns.isSelected());
        this.setEnabled(this.checkBoxCavernsFloodWithLava, enabled && this.checkBoxFloodCaverns.isSelected());
        this.setEnabled(this.sliderDeciduousLevel, enabled && this.checkBoxDeciduousEverywhere.isSelected());
        this.setEnabled(this.sliderPineLevel, enabled && this.checkBoxPineEverywhere.isSelected());
        this.setEnabled(this.sliderJungleLevel, enabled && this.checkBoxJungleEverywhere.isSelected());
        this.setEnabled(this.jSlider6, enabled && this.checkBoxSwamplandEverywhere.isSelected());
        this.setEnabled(this.jSlider4, enabled && this.jCheckBox8.isSelected());
        this.setEnabled(this.spinnerMinecraftSeed, this.mode != Mode.DEFAULT_SETTINGS && enabled && dim0);
        this.setEnabled(this.checkBoxPopulate, (this.platform == null || this.platform.capabilities.contains(Platform.Capability.POPULATE)) && enabled && dim0);
        this.setEnabled(this.checkBoxCavernsRemoveWater, enabled && (this.checkBoxCavesBreakSurface.isSelected() || this.checkBoxCavernsBreakSurface.isSelected() || this.checkBoxChasmsBreakSurface.isSelected()));
        this.setEnabled(this.spinnerCeilingHeight, enabled && ceiling);
        int[] selectedRows = this.tableCustomLayers.getSelectedRows();
        boolean headerIncluded = false;
        boolean disabledLayersFound = false;
        boolean enabledLayersFound = false;
        if (selectedRows.length > 0) {
            for (int row = selectedRows[0]; row <= selectedRows[selectedRows.length - 1]; ++row) {
                if (this.customLayersTableModel.isHeaderRow(row)) {
                    headerIncluded = true;
                    continue;
                }
                if (((Boolean)this.customLayersTableModel.getValueAt(row, 3)).booleanValue()) {
                    enabledLayersFound = true;
                    continue;
                }
                disabledLayersFound = true;
            }
        }
        this.setEnabled(this.buttonSelectPaint, enabled && this.customLayersTableModel != null);
        this.setEnabled(this.buttonCustomLayerUp, enabled && selectedRows.length > 0 && !headerIncluded && !this.customLayersTableModel.isHeaderRow(selectedRows[0]) && selectedRows[0] > 0 && !this.customLayersTableModel.isHeaderRow(selectedRows[0] - 1));
        this.setEnabled(this.buttonCustomLayerTop, this.buttonCustomLayerUp.isEnabled());
        this.setEnabled(this.buttonCustomLayerDown, enabled && selectedRows.length > 0 && !headerIncluded && !this.customLayersTableModel.isHeaderRow(selectedRows[selectedRows.length - 1]) && selectedRows[selectedRows.length - 1] < this.tableCustomLayers.getRowCount() - 1 && !this.customLayersTableModel.isHeaderRow(selectedRows[selectedRows.length - 1] + 1));
        this.setEnabled(this.buttonCustomLayerBottom, this.buttonCustomLayerDown.isEnabled());
        this.setEnabled(this.buttonDisableLayers, enabled && enabledLayersFound);
        this.setEnabled(this.buttonEnableLayers, enabled && disabledLayersFound);
        this.setEnabled(this.buttonReset, enabled && !this.orderPristine);
        if (!enabled) {
            this.setEnabled(this.comboBoxUndergroundLayerAnchor, false);
        } else {
            Terrain subsurfaceTerrain = (Terrain)this.comboBoxSubsurfaceMaterial.getSelectedItem();
            if (subsurfaceTerrain != null && subsurfaceTerrain.isCustom()) {
                MixedMaterial material = Terrain.getCustomMaterial((int)subsurfaceTerrain.getCustomTerrainIndex());
                this.setEnabled(this.comboBoxUndergroundLayerAnchor, material.getMode() == MixedMaterial.Mode.LAYERED);
            } else {
                this.setEnabled(this.comboBoxUndergroundLayerAnchor, false);
            }
        }
        this.setEnabled(this.comboBoxGenerator, enabled && !this.endlessBorder && !ceiling && !caveFloor && !master);
        this.setEnabled(this.buttonGeneratorOptions, enabled && !this.endlessBorder && !ceiling && !caveFloor && !master && (this.comboBoxGenerator.getSelectedItem() == Generator.FLAT || this.comboBoxGenerator.getSelectedItem() == Generator.CUSTOM && this.customGeneratorSettings == null));
        this.setEnabled(this.checkBoxWall, enabled && !this.endlessBorder && !ceiling && !caveFloor && !master);
        this.setEnabled(this.radioButtonBedrockWall, enabled && !this.endlessBorder && this.checkBoxWall.isSelected());
        this.setEnabled(this.radioButtonBarrierWall, enabled && !this.endlessBorder && this.checkBoxWall.isSelected());
        this.setEnabled(this.checkBoxRoof, enabled && !ceiling && !caveFloor && !master);
        this.setEnabled(this.radioButtonBedrockRoof, enabled && this.checkBoxRoof.isSelected());
        this.setEnabled(this.radioButtonBarrierRoof, enabled && this.checkBoxRoof.isSelected());
        this.setEnabled(this.checkBoxDecorateCaverns, enabled);
        this.setEnabled(this.checkBoxDecorateCaves, enabled);
        this.setEnabled(this.checkBoxDecorateChasms, enabled);
        this.setEnabled(this.checkBoxDecorationBrownMushrooms, enabled && decorations);
        boolean mcVersionAtLeast1_17 = ((Version)this.platform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION)).isAtLeast(Constants.V_1_17);
        this.setEnabled(this.checkBoxDecorationGlowLichen, enabled && decorations && mcVersionAtLeast1_17);
        this.setEnabled(this.checkBoxDecorationLushCaves, enabled && decorations && mcVersionAtLeast1_17);
        this.setEnabled(this.checkBoxDecorationDripstoneCaves, enabled && decorations && mcVersionAtLeast1_17);
        this.setEnabled(this.checkBoxCoverSteepTerrain, enabled && !caveFloor && !master);
        this.setEnabled(this.comboBoxSurfaceLayerAnchor, enabled);
        this.setEnabled(this.comboBoxSubsurfaceMaterial, enabled && !caveFloor && !master);
        this.setEnabled(this.comboBoxUndergroundLayerAnchor, enabled && !caveFloor && !master);
        this.setEnabled(this.checkBoxBottomless, enabled && !caveFloor && !master);
    }

    private void setEnabled(Component component, boolean enabled) {
        if (component.isEnabled() != enabled) {
            component.setEnabled(enabled);
        }
    }

    private void configureSpinners(JSpinner chanceSpinner, JSpinner minSpinner, JSpinner maxSpinner) {
        if (chanceSpinner != null) {
            chanceSpinner.setEditor(new JSpinner.NumberEditor(chanceSpinner, "0"));
            minSpinner.setEnabled((Integer)chanceSpinner.getValue() != 0);
            maxSpinner.setEnabled((Integer)chanceSpinner.getValue() != 0);
            chanceSpinner.addChangeListener(e -> {
                minSpinner.setEnabled((Integer)chanceSpinner.getValue() != 0);
                maxSpinner.setEnabled((Integer)chanceSpinner.getValue() != 0);
            });
        }
        minSpinner.setEditor(new JSpinner.NumberEditor(minSpinner, "0"));
        minSpinner.addChangeListener(e -> {
            int currentMaxValue;
            int newMinValue = (Integer)minSpinner.getValue();
            if (newMinValue > (currentMaxValue = ((Integer)maxSpinner.getValue()).intValue())) {
                maxSpinner.setValue(newMinValue);
            }
        });
        maxSpinner.setEditor(new JSpinner.NumberEditor(maxSpinner, "0"));
        maxSpinner.addChangeListener(e -> {
            int currentMinValue;
            int newMaxValue = (Integer)maxSpinner.getValue();
            if (newMaxValue < (currentMinValue = ((Integer)minSpinner.getValue()).intValue())) {
                minSpinner.setValue(newMaxValue);
            }
        });
    }

    private void borderChanged() {
        boolean previousEndlessBorder = this.endlessBorder;
        Dimension.Border border = this.getSelectedBorder();
        boolean bl = this.endlessBorder = border != null && border.isEndless();
        if (this.endlessBorder != previousEndlessBorder) {
            this.programmaticChange = true;
            try {
                if (this.endlessBorder) {
                    this.savedGeneratorType = (Generator)this.comboBoxGenerator.getSelectedItem();
                    this.comboBoxGenerator.setSelectedItem(Generator.FLAT);
                } else {
                    this.comboBoxGenerator.setSelectedItem(this.savedGeneratorType);
                }
            }
            finally {
                this.programmaticChange = false;
            }
        }
    }

    private void updateGeneratorButtonTooltip() {
        if (this.comboBoxGenerator.getSelectedItem() != null) {
            switch ((Generator)this.comboBoxGenerator.getSelectedItem()) {
                case FLAT: {
                    this.buttonGeneratorOptions.setToolTipText("Edit the Superflat mode preset");
                    break;
                }
                case CUSTOM: {
                    this.buttonGeneratorOptions.setToolTipText("Set the custom world generator name");
                    break;
                }
                default: {
                    this.buttonGeneratorOptions.setToolTipText(null);
                    break;
                }
            }
        } else {
            this.buttonGeneratorOptions.setToolTipText(null);
        }
    }

    private void disableSelectedLayers() {
        for (int row : this.tableCustomLayers.getSelectedRows()) {
            if (this.customLayersTableModel.isHeaderRow(row)) continue;
            this.customLayersTableModel.setExport(row, false);
        }
        this.setControlStates();
    }

    private void enableSelectedLayers() {
        for (int row : this.tableCustomLayers.getSelectedRows()) {
            if (this.customLayersTableModel.isHeaderRow(row)) continue;
            this.customLayersTableModel.setExport(row, true);
        }
        this.setControlStates();
    }

    private void selectPaintOnMap() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof WPDialogWithPaintSelection); parent = parent.getParent()) {
        }
        if (parent != null) {
            ((WPDialogWithPaintSelection)parent).selectFromMap(Collections.singleton(Eyedropper.PaintType.LAYER), new Eyedropper.SelectionListener(){

                @Override
                public void layerSelected(Layer layer, int value) {
                    if (layer instanceof CustomLayer) {
                        int index = DimensionPropertiesEditor.this.customLayersTableModel.getLayerIndex((CustomLayer)layer);
                        if (index != -1) {
                            DimensionPropertiesEditor.this.tableCustomLayers.getSelectionModel().setSelectionInterval(index, index);
                            DimensionPropertiesEditor.this.tableCustomLayers.scrollRectToVisible(DimensionPropertiesEditor.this.tableCustomLayers.getCellRect(index, 0, true));
                        } else {
                            MessageUtils.beepAndShowError((Component)DimensionPropertiesEditor.this, (String)("Layer " + layer.getName() + " not in list"), (String)"Not In List");
                        }
                    } else {
                        MessageUtils.beepAndShowError((Component)DimensionPropertiesEditor.this, (String)("Layer " + layer.getName() + " is not a Custom Layer"), (String)"Not A Custom Layer");
                    }
                }

                @Override
                public void terrainSelected(Terrain terrain) {
                }

                @Override
                public void selectionCancelled(boolean byUser) {
                }
            });
        } else {
            DesktopUtils.beep();
        }
    }

    private void resetOrder() {
        if (JOptionPane.showConfirmDialog(this, "Do you want to reset the order of all custom layers to the default?\nThis cannot be undone!", "Confirm Order Reset", 0) != 0) {
            return;
        }
        List customLayers = this.dimension.getCustomLayers(true);
        customLayers.forEach(layer -> layer.setIndex(null));
        this.customLayersTableModel = new CustomLayersTableModel(customLayers);
        this.tableCustomLayers.setModel(this.customLayersTableModel);
        this.orderPristine = true;
        this.setControlStates();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup5 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.panelGeneral = new JPanel();
        this.jLabel6 = new JLabel();
        this.comboBoxSubsurfaceMaterial = new JComboBox();
        this.jLabel65 = new JLabel();
        this.spinnerMinSurfaceDepth = new JSpinner();
        this.jLabel66 = new JLabel();
        this.spinnerMaxSurfaceDepth = new JSpinner();
        this.checkBoxBottomless = new JCheckBox();
        this.jLabel67 = new JLabel();
        this.checkBoxCoverSteepTerrain = new JCheckBox();
        this.jLabel78 = new JLabel();
        this.spinnerCeilingHeight = new JSpinner();
        this.comboBoxSurfaceLayerAnchor = new JComboBox();
        this.jLabel83 = new JLabel();
        this.jLabel84 = new JLabel();
        this.comboBoxUndergroundLayerAnchor = new JComboBox();
        this.panelBorderWallRoof = new JPanel();
        this.jLabel4 = new JLabel();
        this.checkBoxWall = new JCheckBox();
        this.spinnerBorderLevel = new JSpinner();
        this.radioButtonWaterBorder = new JRadioButton();
        this.radioButtonEndlessBorder = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.spinnerBorderSize = new JSpinner();
        this.radioButtonBedrockRoof = new JRadioButton();
        this.radioButtonLavaBorder = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.radioButtonNoBorder = new JRadioButton();
        this.radioButtonBarrierRoof = new JRadioButton();
        this.checkBoxRoof = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.radioButtonFixedBorder = new JRadioButton();
        this.radioButtonBedrockWall = new JRadioButton();
        this.jLabel44 = new JLabel();
        this.radioButtonVoidBorder = new JRadioButton();
        this.radioButtonBarrierWall = new JRadioButton();
        this.radioButtonBarrierBorder = new JRadioButton();
        this.panelMinecraftSettings = new JPanel();
        this.buttonGeneratorOptions = new JButton();
        this.jLabel95 = new JLabel();
        this.jLabel94 = new JLabel();
        this.spinnerMinecraftSeed = new JSpinner();
        this.jLabel7 = new JLabel();
        this.comboBoxGenerator = new JComboBox();
        this.jPanel5 = new JPanel();
        this.themeEditor = new SimpleThemeEditor();
        this.jLabel45 = new JLabel();
        this.jLabel46 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jPanel9 = new JPanel();
        this.checkBoxCavesEverywhere = new JCheckBox();
        this.sliderCavesEverywhereLevel = new JSlider();
        this.jPanel10 = new JPanel();
        this.checkBoxCavernsEverywhere = new JCheckBox();
        this.sliderCavernsEverywhereLevel = new JSlider();
        this.jPanel11 = new JPanel();
        this.checkBoxChasmsEverywhere = new JCheckBox();
        this.sliderChasmsEverywhereLevel = new JSlider();
        this.jPanel16 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel13 = new JPanel();
        this.jLabel87 = new JLabel();
        this.spinnerCavesMinLevel = new JSpinner();
        this.jLabel88 = new JLabel();
        this.spinnerCavesMaxLevel = new JSpinner();
        this.jPanel12 = new JPanel();
        this.jLabel70 = new JLabel();
        this.spinnerCavernsMinLevel = new JSpinner();
        this.jLabel71 = new JLabel();
        this.spinnerCavernsMaxLevel = new JSpinner();
        this.jPanel14 = new JPanel();
        this.jLabel73 = new JLabel();
        this.spinnerChasmsMinLevel = new JSpinner();
        this.jLabel72 = new JLabel();
        this.spinnerChasmsMaxLevel = new JSpinner();
        this.jPanel8 = new JPanel();
        this.checkBoxFloodCaverns = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.spinnerCavernsFloodLevel = new JSpinner();
        this.checkBoxCavernsFloodWithLava = new JCheckBox();
        this.jPanel17 = new JPanel();
        this.checkBoxCavesBreakSurface = new JCheckBox();
        this.jPanel18 = new JPanel();
        this.checkBoxCavernsBreakSurface = new JCheckBox();
        this.jPanel19 = new JPanel();
        this.checkBoxChasmsBreakSurface = new JCheckBox();
        this.checkBoxCavernsRemoveWater = new JCheckBox();
        this.jPanel15 = new JPanel();
        this.jPanel23 = new JPanel();
        this.jSeparator5 = new JSeparator();
        this.jPanel24 = new JPanel();
        this.jLabel96 = new JLabel();
        this.checkBoxDecorationBrownMushrooms = new JCheckBox();
        this.checkBoxDecorationGlowLichen = new JCheckBox();
        this.checkBoxDecorationLushCaves = new JCheckBox();
        this.checkBoxDecorationDripstoneCaves = new JCheckBox();
        this.jPanel25 = new JPanel();
        this.checkBoxDecorateCaves = new JCheckBox();
        this.jPanel26 = new JPanel();
        this.checkBoxDecorateCaverns = new JCheckBox();
        this.jPanel27 = new JPanel();
        this.checkBoxDecorateChasms = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jCheckBox8 = new JCheckBox();
        this.jSlider4 = new JSlider();
        this.jSeparator2 = new JSeparator();
        this.jLabel10 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jPanel20 = new JPanel();
        this.spinnerIronMaxLevel = new JSpinner();
        this.jLabel35 = new JLabel();
        this.spinnerWaterChance = new JSpinner();
        this.jLabel29 = new JLabel();
        this.spinnerWaterMinLevel = new JSpinner();
        this.jLabel14 = new JLabel();
        this.spinnerEmeraldMinLevel = new JSpinner();
        this.jLabel54 = new JLabel();
        this.spinnerCoalChance = new JSpinner();
        this.jLabel20 = new JLabel();
        this.jLabel53 = new JLabel();
        this.spinnerCoalMaxLevel = new JSpinner();
        this.spinnerCoalMinLevel = new JSpinner();
        this.jLabel13 = new JLabel();
        this.jLabel34 = new JLabel();
        this.jLabel55 = new JLabel();
        this.jLabel37 = new JLabel();
        this.spinnerEmeraldMaxLevel = new JSpinner();
        this.spinnerLapisChance = new JSpinner();
        this.jLabel25 = new JLabel();
        this.spinnerIronChance = new JSpinner();
        this.jLabel51 = new JLabel();
        this.jLabel22 = new JLabel();
        this.spinnerGoldChance = new JSpinner();
        this.spinnerLapisMinLevel = new JSpinner();
        this.spinnerGoldMaxLevel = new JSpinner();
        this.spinnerDiamondMinLevel = new JSpinner();
        this.jLabel56 = new JLabel();
        this.spinnerWaterMaxLevel = new JSpinner();
        this.jLabel26 = new JLabel();
        this.jLabel59 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel17 = new JLabel();
        this.spinnerLapisMaxLevel = new JSpinner();
        this.jLabel40 = new JLabel();
        this.jLabel18 = new JLabel();
        this.spinnerDiamondMaxLevel = new JSpinner();
        this.jLabel21 = new JLabel();
        this.jLabel36 = new JLabel();
        this.spinnerLavaMinLevel = new JSpinner();
        this.jLabel23 = new JLabel();
        this.jLabel60 = new JLabel();
        this.spinnerLavaMaxLevel = new JSpinner();
        this.jLabel24 = new JLabel();
        this.jLabel61 = new JLabel();
        this.jLabel52 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jLabel57 = new JLabel();
        this.jLabel58 = new JLabel();
        this.spinnerIronMinLevel = new JSpinner();
        this.spinnerGoldMinLevel = new JSpinner();
        this.jLabel38 = new JLabel();
        this.spinnerLavaChance = new JSpinner();
        this.jLabel41 = new JLabel();
        this.spinnerEmeraldChance = new JSpinner();
        this.jLabel12 = new JLabel();
        this.spinnerDiamondChance = new JSpinner();
        this.jPanel21 = new JPanel();
        this.jLabel63 = new JLabel();
        this.jLabel92 = new JLabel();
        this.jLabel3 = new JLabel();
        this.spinnerCopperMinLevel = new JSpinner();
        this.spinnerGravelChance = new JSpinner();
        this.spinnerRedstoneMinLevel = new JSpinner();
        this.jLabel62 = new JLabel();
        this.jLabel39 = new JLabel();
        this.jLabel64 = new JLabel();
        this.jLabel43 = new JLabel();
        this.spinnerCopperChance = new JSpinner();
        this.spinnerDirtChance = new JSpinner();
        this.jLabel32 = new JLabel();
        this.jLabel93 = new JLabel();
        this.jLabel30 = new JLabel();
        this.jLabel33 = new JLabel();
        this.spinnerRedstoneChance = new JSpinner();
        this.jLabel19 = new JLabel();
        this.spinnerGravelMaxLevel = new JSpinner();
        this.spinnerCopperMaxLevel = new JSpinner();
        this.jLabel27 = new JLabel();
        this.spinnerGravelMinLevel = new JSpinner();
        this.jLabel31 = new JLabel();
        this.spinnerDirtMinLevel = new JSpinner();
        this.spinnerDirtMaxLevel = new JSpinner();
        this.jLabel11 = new JLabel();
        this.jLabel91 = new JLabel();
        this.jLabel42 = new JLabel();
        this.jLabel89 = new JLabel();
        this.spinnerRedstoneMaxLevel = new JSpinner();
        this.jPanel22 = new JPanel();
        this.jLabel101 = new JLabel();
        this.jLabel100 = new JLabel();
        this.spinnerQuartzChance = new JSpinner();
        this.jLabel74 = new JLabel();
        this.jLabel76 = new JLabel();
        this.jLabel98 = new JLabel();
        this.spinnerQuartzMaxLevel = new JSpinner();
        this.spinnerAncientDebrisMaxLevel = new JSpinner();
        this.spinnerAncientDebrisMinLevel = new JSpinner();
        this.jLabel75 = new JLabel();
        this.jLabel99 = new JLabel();
        this.spinnerAncientDebrisChance = new JSpinner();
        this.spinnerQuartzMinLevel = new JSpinner();
        this.jLabel77 = new JLabel();
        this.jPanel2 = new JPanel();
        this.checkBoxPopulate = new JCheckBox();
        this.checkBoxDeciduousEverywhere = new JCheckBox();
        this.sliderDeciduousLevel = new JSlider();
        this.checkBoxFrostEverywhere = new JCheckBox();
        this.checkBoxPineEverywhere = new JCheckBox();
        this.sliderPineLevel = new JSlider();
        this.checkBoxSmoothSnow = new JCheckBox();
        this.jLabel47 = new JLabel();
        this.jLabel48 = new JLabel();
        this.jLabel49 = new JLabel();
        this.jLabel50 = new JLabel();
        this.checkBoxJungleEverywhere = new JCheckBox();
        this.jLabel68 = new JLabel();
        this.sliderJungleLevel = new JSlider();
        this.checkBoxSwamplandEverywhere = new JCheckBox();
        this.jLabel69 = new JLabel();
        this.jSlider6 = new JSlider();
        this.checkBoxSnowUnderTrees = new JCheckBox();
        this.checkBoxExportAnnotations = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.jLabel82 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableCustomLayers = new JTable();
        this.buttonCustomLayerUp = new JButton();
        this.buttonCustomLayerDown = new JButton();
        this.buttonCustomLayerTop = new JButton();
        this.buttonCustomLayerBottom = new JButton();
        this.buttonDisableLayers = new JButton();
        this.buttonEnableLayers = new JButton();
        this.buttonSelectPaint = new JButton();
        this.buttonReset = new JButton();
        this.jLabel6.setText("Underground material:");
        this.comboBoxSubsurfaceMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.comboBoxSubsurfaceMaterialActionPerformed(evt);
            }
        });
        this.jLabel65.setText("Top layer minimum depth:");
        this.spinnerMinSurfaceDepth.setModel(new SpinnerNumberModel(3, 1, 255, 1));
        this.spinnerMinSurfaceDepth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DimensionPropertiesEditor.this.spinnerMinSurfaceDepthStateChanged(evt);
            }
        });
        this.jLabel66.setText(", maximum depth:");
        this.spinnerMaxSurfaceDepth.setModel(new SpinnerNumberModel(7, 1, 255, 1));
        this.spinnerMaxSurfaceDepth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DimensionPropertiesEditor.this.spinnerMaxSurfaceDepthStateChanged(evt);
            }
        });
        this.checkBoxBottomless.setText("Bottomless world");
        this.checkBoxBottomless.setToolTipText("<html>Generate a bottomless map:\n<ul><li>No bedrock at the bottom of the map\n<li>Caverns and chasms are open to the void</html>");
        this.jLabel67.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/information.png")));
        this.jLabel67.setText(" ");
        this.jLabel67.setToolTipText("<html>Generate a bottomless map:\n<ul><li>No bedrock at the bottom of the map\n<li>Caverns and chasms are open to the void</html>");
        this.checkBoxCoverSteepTerrain.setText("keep steep terrain covered");
        this.checkBoxCoverSteepTerrain.setToolTipText("<html>Enable this to extend the top layer<br>\ndownwards on steep terrain such as cliffs <br>\nso that the underground material is never exposed.</html>");
        this.jLabel78.setText("Ceiling dimension height:");
        this.spinnerCeilingHeight.setModel(new SpinnerNumberModel(256, 1, 256, 1));
        this.comboBoxSurfaceLayerAnchor.setModel(new DefaultComboBoxModel<String>(new String[]{"Bedrock", "Terrain"}));
        this.jLabel83.setText("Layered materials relative to:");
        this.jLabel84.setText("Layered material relative to:");
        this.comboBoxUndergroundLayerAnchor.setModel(new DefaultComboBoxModel<String>(new String[]{"Bedrock", "Terrain"}));
        this.comboBoxUndergroundLayerAnchor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.comboBoxUndergroundLayerAnchorActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Border:");
        this.checkBoxWall.setText("Wall:");
        this.checkBoxWall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxWallActionPerformed(evt);
            }
        });
        this.spinnerBorderLevel.setModel(new SpinnerNumberModel(62, 0, 127, 1));
        this.spinnerBorderLevel.setEnabled(false);
        this.buttonGroup1.add(this.radioButtonWaterBorder);
        this.radioButtonWaterBorder.setText("Water");
        this.radioButtonWaterBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonWaterBorderActionPerformed(evt);
            }
        });
        this.buttonGroup3.add(this.radioButtonEndlessBorder);
        this.radioButtonEndlessBorder.setText("endless");
        this.radioButtonEndlessBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonEndlessBorderActionPerformed(evt);
            }
        });
        this.jLabel8.setLabelFor(this.spinnerBorderSize);
        this.jLabel8.setText("Border size:");
        this.spinnerBorderSize.setModel(new SpinnerNumberModel((Number)256, Integer.valueOf(128), null, (Number)128));
        this.spinnerBorderSize.setEnabled(false);
        this.spinnerBorderSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DimensionPropertiesEditor.this.spinnerBorderSizeStateChanged(evt);
            }
        });
        this.buttonGroup5.add(this.radioButtonBedrockRoof);
        this.radioButtonBedrockRoof.setSelected(true);
        this.radioButtonBedrockRoof.setText("bedrock");
        this.radioButtonBedrockRoof.setEnabled(false);
        this.radioButtonBedrockRoof.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonBedrockRoofActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonLavaBorder);
        this.radioButtonLavaBorder.setText("Lava");
        this.radioButtonLavaBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonLavaBorderActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Water or lava level:");
        this.buttonGroup1.add(this.radioButtonNoBorder);
        this.radioButtonNoBorder.setText("No border");
        this.radioButtonNoBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonNoBorderActionPerformed(evt);
            }
        });
        this.buttonGroup5.add(this.radioButtonBarrierRoof);
        this.radioButtonBarrierRoof.setText("barrier");
        this.radioButtonBarrierRoof.setEnabled(false);
        this.radioButtonBarrierRoof.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonBarrierRoofActionPerformed(evt);
            }
        });
        this.checkBoxRoof.setText("Roof:");
        this.checkBoxRoof.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxRoofActionPerformed(evt);
            }
        });
        this.jLabel9.setText("blocks (in multiples of 128)");
        this.buttonGroup3.add(this.radioButtonFixedBorder);
        this.radioButtonFixedBorder.setSelected(true);
        this.radioButtonFixedBorder.setText("fixed:");
        this.radioButtonFixedBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonFixedBorderActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.radioButtonBedrockWall);
        this.radioButtonBedrockWall.setSelected(true);
        this.radioButtonBedrockWall.setText("bedrock");
        this.radioButtonBedrockWall.setEnabled(false);
        this.radioButtonBedrockWall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonBedrockWallActionPerformed(evt);
            }
        });
        this.jLabel44.setText("(Minecraft default: 62)");
        this.buttonGroup1.add(this.radioButtonVoidBorder);
        this.radioButtonVoidBorder.setText("Void");
        this.radioButtonVoidBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonVoidBorderActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.radioButtonBarrierWall);
        this.radioButtonBarrierWall.setText("barrier");
        this.radioButtonBarrierWall.setEnabled(false);
        this.radioButtonBarrierWall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonBarrierWallActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.radioButtonBarrierBorder);
        this.radioButtonBarrierBorder.setText("Barrier");
        this.radioButtonBarrierBorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.radioButtonBarrierBorderActionPerformed(evt);
            }
        });
        GroupLayout panelBorderWallRoofLayout = new GroupLayout(this.panelBorderWallRoof);
        this.panelBorderWallRoof.setLayout(panelBorderWallRoofLayout);
        panelBorderWallRoofLayout.setHorizontalGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelBorderWallRoofLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.radioButtonNoBorder).addComponent(this.radioButtonVoidBorder).addComponent(this.radioButtonLavaBorder).addGroup(panelBorderWallRoofLayout.createSequentialGroup().addGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonWaterBorder).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioButtonEndlessBorder).addGroup(panelBorderWallRoofLayout.createSequentialGroup().addComponent(this.radioButtonFixedBorder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelBorderWallRoofLayout.createSequentialGroup().addComponent(this.spinnerBorderSize, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel9)).addGroup(panelBorderWallRoofLayout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerBorderLevel, -2, -1, -2)).addComponent(this.jLabel44))))).addComponent(this.radioButtonBarrierBorder).addGroup(panelBorderWallRoofLayout.createSequentialGroup().addComponent(this.checkBoxWall).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonBedrockWall).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonBarrierWall).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxRoof).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonBedrockRoof).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonBarrierRoof))).addGap(0, 0, 0)));
        panelBorderWallRoofLayout.setVerticalGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelBorderWallRoofLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonNoBorder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonVoidBorder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonWaterBorder).addComponent(this.jLabel5).addComponent(this.spinnerBorderLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonLavaBorder).addComponent(this.jLabel44)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonBarrierBorder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.spinnerBorderSize, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.radioButtonFixedBorder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonEndlessBorder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelBorderWallRoofLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxWall).addComponent(this.checkBoxRoof).addComponent(this.radioButtonBedrockRoof).addComponent(this.radioButtonBarrierRoof).addComponent(this.radioButtonBarrierWall).addComponent(this.radioButtonBedrockWall)).addGap(0, 0, 0)));
        this.buttonGeneratorOptions.setText("...");
        this.buttonGeneratorOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonGeneratorOptionsActionPerformed(evt);
            }
        });
        this.jLabel95.setText("seed:");
        this.jLabel94.setText("world type:");
        this.spinnerMinecraftSeed.setModel(new SpinnerNumberModel((Number)Long.MIN_VALUE, null, null, (Number)1L));
        this.spinnerMinecraftSeed.setEditor(new JSpinner.NumberEditor(this.spinnerMinecraftSeed, "0"));
        this.jLabel7.setText("Minecraft settings:");
        this.comboBoxGenerator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.comboBoxGeneratorActionPerformed(evt);
            }
        });
        GroupLayout panelMinecraftSettingsLayout = new GroupLayout(this.panelMinecraftSettings);
        this.panelMinecraftSettings.setLayout(panelMinecraftSettingsLayout);
        panelMinecraftSettingsLayout.setHorizontalGroup(panelMinecraftSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMinecraftSettingsLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel94).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxGenerator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonGeneratorOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel95).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerMinecraftSeed, -2, -1, -2).addGap(0, 0, 0)));
        panelMinecraftSettingsLayout.setVerticalGroup(panelMinecraftSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelMinecraftSettingsLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelMinecraftSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.spinnerMinecraftSeed, -2, -1, -2).addComponent(this.comboBoxGenerator, -2, -1, -2).addComponent(this.jLabel94).addComponent(this.jLabel95).addComponent(this.buttonGeneratorOptions)).addGap(0, 0, 0)));
        GroupLayout panelGeneralLayout = new GroupLayout(this.panelGeneral);
        this.panelGeneral.setLayout(panelGeneralLayout);
        panelGeneralLayout.setHorizontalGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGeneralLayout.createSequentialGroup().addContainerGap().addGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelBorderWallRoof, -2, -1, -2).addGroup(panelGeneralLayout.createSequentialGroup().addComponent(this.jLabel65).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerMinSurfaceDepth, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel66).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerMaxSurfaceDepth, -2, -1, -2).addGap(18, 18, 18).addComponent(this.checkBoxCoverSteepTerrain).addGap(18, 18, 18).addComponent(this.jLabel83).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxSurfaceLayerAnchor, -2, -1, -2)).addGroup(panelGeneralLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxSubsurfaceMaterial, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel84).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxUndergroundLayerAnchor, -2, -1, -2)).addGroup(panelGeneralLayout.createSequentialGroup().addComponent(this.checkBoxBottomless).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel67).addGap(18, 18, 18).addComponent(this.jLabel78).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCeilingHeight, -2, -1, -2)).addComponent(this.panelMinecraftSettings, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        panelGeneralLayout.setVerticalGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelGeneralLayout.createSequentialGroup().addContainerGap().addGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel65).addComponent(this.spinnerMinSurfaceDepth, -2, -1, -2).addComponent(this.jLabel66).addComponent(this.spinnerMaxSurfaceDepth, -2, -1, -2).addComponent(this.checkBoxCoverSteepTerrain).addComponent(this.comboBoxSurfaceLayerAnchor, -2, -1, -2).addComponent(this.jLabel83)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.comboBoxSubsurfaceMaterial, -2, -1, -2).addComponent(this.jLabel84).addComponent(this.comboBoxUndergroundLayerAnchor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelGeneralLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxBottomless).addComponent(this.jLabel67, -2, 24, -2).addComponent(this.jLabel78).addComponent(this.spinnerCeilingHeight, -2, -1, -2)).addGap(19, 19, 19).addComponent(this.panelBorderWallRoof, -2, -1, -2).addGap(18, 18, 18).addComponent(this.panelMinecraftSettings, -2, -1, -2).addContainerGap(67, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("General", this.panelGeneral);
        this.jLabel45.setText("These are the default terrain types and layers used by the Mountain tool, and when resetting the");
        this.jLabel46.setText("terrain to the default by right-clicking with a terrain type selected:");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.themeEditor, -1, -1, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel46, GroupLayout.Alignment.LEADING).addComponent(this.jLabel45, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel45).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel46).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.themeEditor, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("Theme", this.jPanel5);
        this.jPanel3.setLayout(new GridBagLayout());
        this.checkBoxCavesEverywhere.setText("Caves everywhere");
        this.checkBoxCavesEverywhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxCavesEverywhereActionPerformed(evt);
            }
        });
        this.sliderCavesEverywhereLevel.setMajorTickSpacing(1);
        this.sliderCavesEverywhereLevel.setMaximum(15);
        this.sliderCavesEverywhereLevel.setMinimum(1);
        this.sliderCavesEverywhereLevel.setPaintTicks(true);
        this.sliderCavesEverywhereLevel.setSnapToTicks(true);
        this.sliderCavesEverywhereLevel.setValue(8);
        GroupLayout jPanel9Layout = new GroupLayout(this.jPanel9);
        this.jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.sliderCavesEverywhereLevel, -2, -1, -2)).addComponent(this.checkBoxCavesEverywhere)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel9Layout.setVerticalGroup(jPanel9Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel9Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxCavesEverywhere).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderCavesEverywhereLevel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel9, gridBagConstraints);
        this.checkBoxCavernsEverywhere.setText("Caverns everywhere");
        this.checkBoxCavernsEverywhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxCavernsEverywhereActionPerformed(evt);
            }
        });
        this.sliderCavernsEverywhereLevel.setMajorTickSpacing(1);
        this.sliderCavernsEverywhereLevel.setMaximum(15);
        this.sliderCavernsEverywhereLevel.setMinimum(1);
        this.sliderCavernsEverywhereLevel.setPaintTicks(true);
        this.sliderCavernsEverywhereLevel.setSnapToTicks(true);
        this.sliderCavernsEverywhereLevel.setValue(8);
        GroupLayout jPanel10Layout = new GroupLayout(this.jPanel10);
        this.jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.sliderCavernsEverywhereLevel, -2, -1, -2)).addComponent(this.checkBoxCavernsEverywhere)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup(jPanel10Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel10Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxCavernsEverywhere).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderCavernsEverywhereLevel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel10, gridBagConstraints);
        this.checkBoxChasmsEverywhere.setText("Chasms everywhere");
        this.checkBoxChasmsEverywhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxChasmsEverywhereActionPerformed(evt);
            }
        });
        this.sliderChasmsEverywhereLevel.setMajorTickSpacing(1);
        this.sliderChasmsEverywhereLevel.setMaximum(15);
        this.sliderChasmsEverywhereLevel.setMinimum(1);
        this.sliderChasmsEverywhereLevel.setPaintTicks(true);
        this.sliderChasmsEverywhereLevel.setSnapToTicks(true);
        this.sliderChasmsEverywhereLevel.setValue(8);
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addContainerGap().addGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel11Layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.sliderChasmsEverywhereLevel, -2, -1, -2)).addComponent(this.checkBoxChasmsEverywhere)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel11Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxChasmsEverywhere).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderChasmsEverywhereLevel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel11, gridBagConstraints);
        this.jLabel2.setText("Settings for the Caves, Caverns and Chasms layers. These apply also to hand-painted Caves, Caverns and Chasms:");
        GroupLayout jPanel16Layout = new GroupLayout(this.jPanel16);
        this.jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel16Layout.setVerticalGroup(jPanel16Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel16Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addContainerGap()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel16, gridBagConstraints);
        this.jLabel87.setText("Caves min. level:");
        this.spinnerCavesMinLevel.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jLabel88.setText("Caves max. level:");
        this.spinnerCavesMaxLevel.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel87).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCavesMinLevel, -2, -1, -2)).addGroup(jPanel13Layout.createSequentialGroup().addComponent(this.jLabel88).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCavesMaxLevel, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel13Layout.createSequentialGroup().addContainerGap().addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel87).addComponent(this.spinnerCavesMinLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel13Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel88).addComponent(this.spinnerCavesMaxLevel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel3.add((Component)this.jPanel13, gridBagConstraints);
        this.jLabel70.setText("Caverns min. level:");
        this.spinnerCavernsMinLevel.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jLabel71.setText("Caverns max. level:");
        this.spinnerCavernsMaxLevel.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addComponent(this.jLabel70).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCavernsMinLevel, -2, -1, -2)).addGroup(jPanel12Layout.createSequentialGroup().addComponent(this.jLabel71).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCavernsMaxLevel, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel12Layout.createSequentialGroup().addContainerGap().addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel70).addComponent(this.spinnerCavernsMinLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel71).addComponent(this.spinnerCavernsMaxLevel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel3.add((Component)this.jPanel12, gridBagConstraints);
        this.jLabel73.setText("Chasms min. level:");
        this.spinnerChasmsMinLevel.setModel(new SpinnerNumberModel(0, 0, 255, 1));
        this.jLabel72.setText("Chasms max. level:");
        this.spinnerChasmsMaxLevel.setModel(new SpinnerNumberModel(255, 0, 255, 1));
        GroupLayout jPanel14Layout = new GroupLayout(this.jPanel14);
        this.jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addComponent(this.jLabel73).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerChasmsMinLevel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel14Layout.createSequentialGroup().addComponent(this.jLabel72).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerChasmsMaxLevel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanel14Layout.setVerticalGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel14Layout.createSequentialGroup().addContainerGap().addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel73).addComponent(this.spinnerChasmsMinLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel14Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel72).addComponent(this.spinnerChasmsMaxLevel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.jPanel3.add((Component)this.jPanel14, gridBagConstraints);
        this.checkBoxFloodCaverns.setText("Flood the caves, caverns and chasms");
        this.checkBoxFloodCaverns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxFloodCavernsActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Level:");
        this.spinnerCavernsFloodLevel.setModel(new SpinnerNumberModel(16, 1, 127, 1));
        this.checkBoxCavernsFloodWithLava.setText("Lava instead of water:");
        this.checkBoxCavernsFloodWithLava.setHorizontalTextPosition(10);
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxFloodCaverns).addGroup(jPanel8Layout.createSequentialGroup().addGap(19, 19, 19).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxCavernsFloodWithLava).addGroup(jPanel8Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spinnerCavernsFloodLevel, -2, -1, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxFloodCaverns).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.spinnerCavernsFloodLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxCavernsFloodWithLava).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel8, gridBagConstraints);
        this.checkBoxCavesBreakSurface.setText("Caves break the surface");
        this.checkBoxCavesBreakSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxCavesBreakSurfaceActionPerformed(evt);
            }
        });
        GroupLayout jPanel17Layout = new GroupLayout(this.jPanel17);
        this.jPanel17.setLayout(jPanel17Layout);
        jPanel17Layout.setHorizontalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxCavesBreakSurface).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel17Layout.setVerticalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxCavesBreakSurface).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel17, gridBagConstraints);
        this.checkBoxCavernsBreakSurface.setText("Caverns break the surface");
        this.checkBoxCavernsBreakSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxCavernsBreakSurfaceActionPerformed(evt);
            }
        });
        GroupLayout jPanel18Layout = new GroupLayout(this.jPanel18);
        this.jPanel18.setLayout(jPanel18Layout);
        jPanel18Layout.setHorizontalGroup(jPanel18Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel18Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxCavernsBreakSurface).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel18Layout.setVerticalGroup(jPanel18Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel18Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxCavernsBreakSurface).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel18, gridBagConstraints);
        this.checkBoxChasmsBreakSurface.setText("Chasms break the surface");
        this.checkBoxChasmsBreakSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxChasmsBreakSurfaceActionPerformed(evt);
            }
        });
        GroupLayout jPanel19Layout = new GroupLayout(this.jPanel19);
        this.jPanel19.setLayout(jPanel19Layout);
        jPanel19Layout.setHorizontalGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel19Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxChasmsBreakSurface).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel19Layout.setVerticalGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel19Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxChasmsBreakSurface).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel19, gridBagConstraints);
        this.checkBoxCavernsRemoveWater.setSelected(true);
        this.checkBoxCavernsRemoveWater.setText("Remove water and lava above openings");
        this.checkBoxCavernsRemoveWater.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 19, 0, 0);
        this.jPanel3.add((Component)this.checkBoxCavernsRemoveWater, gridBagConstraints);
        GroupLayout jPanel15Layout = new GroupLayout(this.jPanel15);
        this.jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel15Layout.setVerticalGroup(jPanel15Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jPanel15, gridBagConstraints);
        GroupLayout jPanel23Layout = new GroupLayout(this.jPanel23);
        this.jPanel23.setLayout(jPanel23Layout);
        jPanel23Layout.setHorizontalGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel23Layout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator5, -1, 789, Short.MAX_VALUE).addContainerGap()));
        jPanel23Layout.setVerticalGroup(jPanel23Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel23Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jSeparator5, -2, 10, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.jPanel23, gridBagConstraints);
        this.jLabel96.setText("Decorations:");
        this.checkBoxDecorationBrownMushrooms.setText("brown mushrooms");
        this.checkBoxDecorationGlowLichen.setText("glow lichen");
        this.checkBoxDecorationLushCaves.setText("patches of lush cave");
        this.checkBoxDecorationDripstoneCaves.setText("patches of dripstone cave");
        GroupLayout jPanel24Layout = new GroupLayout(this.jPanel24);
        this.jPanel24.setLayout(jPanel24Layout);
        jPanel24Layout.setHorizontalGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel24Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel96).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxDecorationDripstoneCaves).addComponent(this.checkBoxDecorationLushCaves).addComponent(this.checkBoxDecorationGlowLichen).addComponent(this.checkBoxDecorationBrownMushrooms)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel24Layout.setVerticalGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel24Layout.createSequentialGroup().addContainerGap().addGroup(jPanel24Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel96).addComponent(this.checkBoxDecorationBrownMushrooms)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxDecorationGlowLichen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxDecorationLushCaves).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxDecorationDripstoneCaves).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel24, gridBagConstraints);
        this.checkBoxDecorateCaves.setText("Decorate");
        this.checkBoxDecorateCaves.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxDecorateCavesActionPerformed(evt);
            }
        });
        GroupLayout jPanel25Layout = new GroupLayout(this.jPanel25);
        this.jPanel25.setLayout(jPanel25Layout);
        jPanel25Layout.setHorizontalGroup(jPanel25Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel25Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxDecorateCaves).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel25Layout.setVerticalGroup(jPanel25Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel25Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxDecorateCaves).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel25, gridBagConstraints);
        this.checkBoxDecorateCaverns.setText("Decorate");
        this.checkBoxDecorateCaverns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxDecorateCavernsActionPerformed(evt);
            }
        });
        GroupLayout jPanel26Layout = new GroupLayout(this.jPanel26);
        this.jPanel26.setLayout(jPanel26Layout);
        jPanel26Layout.setHorizontalGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxDecorateCaverns).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel26Layout.setVerticalGroup(jPanel26Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel26Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxDecorateCaverns).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel26, gridBagConstraints);
        this.checkBoxDecorateChasms.setText("Decorate");
        this.checkBoxDecorateChasms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxDecorateChasmsActionPerformed(evt);
            }
        });
        GroupLayout jPanel27Layout = new GroupLayout(this.jPanel27);
        this.jPanel27.setLayout(jPanel27Layout);
        jPanel27Layout.setHorizontalGroup(jPanel27Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel27Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxDecorateChasms).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel27Layout.setVerticalGroup(jPanel27Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel27Layout.createSequentialGroup().addContainerGap().addComponent(this.checkBoxDecorateChasms).addContainerGap(-1, Short.MAX_VALUE)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        this.jPanel3.add((Component)this.jPanel27, gridBagConstraints);
        this.jTabbedPane1.addTab("Caves, Caverns and Chasms", new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/caverns.png")), this.jPanel3);
        this.jCheckBox8.setText("Resources everywhere");
        this.jCheckBox8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.jCheckBox8ActionPerformed(evt);
            }
        });
        this.jSlider4.setMajorTickSpacing(1);
        this.jSlider4.setMaximum(15);
        this.jSlider4.setMinimum(1);
        this.jSlider4.setPaintTicks(true);
        this.jSlider4.setSnapToTicks(true);
        this.jSlider4.setValue(8);
        this.jLabel10.setText("Settings for the Resources layer at 50% intensity. These also apply to hand-painted Resources:");
        this.jSeparator3.setOrientation(1);
        this.jPanel20.setLayout(new GridBagLayout());
        this.spinnerIronMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerIronMaxLevel, gridBagConstraints);
        this.jLabel35.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel35, gridBagConstraints);
        this.spinnerWaterChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerWaterChance, gridBagConstraints);
        this.jLabel29.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel29, gridBagConstraints);
        this.spinnerWaterMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerWaterMinLevel, gridBagConstraints);
        this.jLabel14.setText("Levels:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel14, gridBagConstraints);
        this.spinnerEmeraldMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerEmeraldMinLevel, gridBagConstraints);
        this.jLabel54.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel54, gridBagConstraints);
        this.spinnerCoalChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerCoalChance, gridBagConstraints);
        this.jLabel20.setText("Water:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel20, gridBagConstraints);
        this.jLabel53.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel53, gridBagConstraints);
        this.spinnerCoalMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerCoalMaxLevel, gridBagConstraints);
        this.spinnerCoalMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerCoalMinLevel, gridBagConstraints);
        this.jLabel13.setText("Occurrence:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel34.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel34, gridBagConstraints);
        this.jLabel55.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel55, gridBagConstraints);
        this.jLabel37.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel37, gridBagConstraints);
        this.spinnerEmeraldMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerEmeraldMaxLevel, gridBagConstraints);
        this.spinnerLapisChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerLapisChance, gridBagConstraints);
        this.jLabel25.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel25, gridBagConstraints);
        this.spinnerIronChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerIronChance, gridBagConstraints);
        this.jLabel51.setText("Emerald:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel51, gridBagConstraints);
        this.jLabel22.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel22, gridBagConstraints);
        this.spinnerGoldChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerGoldChance, gridBagConstraints);
        this.spinnerLapisMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerLapisMinLevel, gridBagConstraints);
        this.spinnerGoldMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerGoldMaxLevel, gridBagConstraints);
        this.spinnerDiamondMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerDiamondMinLevel, gridBagConstraints);
        this.jLabel56.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel56, gridBagConstraints);
        this.spinnerWaterMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerWaterMaxLevel, gridBagConstraints);
        this.jLabel26.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel59.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel59, gridBagConstraints);
        this.jLabel16.setText("Coal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel15.setText("Iron:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel17.setText("Lapis Lazuli:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel17, gridBagConstraints);
        this.spinnerLapisMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerLapisMaxLevel, gridBagConstraints);
        this.jLabel40.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel40, gridBagConstraints);
        this.jLabel18.setText("Diamond:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel18, gridBagConstraints);
        this.spinnerDiamondMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerDiamondMaxLevel, gridBagConstraints);
        this.jLabel21.setText("Lava:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel21, gridBagConstraints);
        this.jLabel36.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel36, gridBagConstraints);
        this.spinnerLavaMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerLavaMinLevel, gridBagConstraints);
        this.jLabel23.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel23, gridBagConstraints);
        this.jLabel60.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel60, gridBagConstraints);
        this.spinnerLavaMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerLavaMaxLevel, gridBagConstraints);
        this.jLabel24.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel24, gridBagConstraints);
        this.jLabel61.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel61, gridBagConstraints);
        this.jLabel52.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel52, gridBagConstraints);
        this.jLabel28.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel28, gridBagConstraints);
        this.jLabel57.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel57, gridBagConstraints);
        this.jLabel58.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel58, gridBagConstraints);
        this.spinnerIronMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerIronMinLevel, gridBagConstraints);
        this.spinnerGoldMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerGoldMinLevel, gridBagConstraints);
        this.jLabel38.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel38, gridBagConstraints);
        this.spinnerLavaChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerLavaChance, gridBagConstraints);
        this.jLabel41.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel41, gridBagConstraints);
        this.spinnerEmeraldChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerEmeraldChance, gridBagConstraints);
        this.jLabel12.setText("Gold:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.jLabel12, gridBagConstraints);
        this.spinnerDiamondChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel20.add((Component)this.spinnerDiamondChance, gridBagConstraints);
        this.jPanel21.setLayout(new GridBagLayout());
        this.jLabel63.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel63, gridBagConstraints);
        this.jLabel92.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel92, gridBagConstraints);
        this.jLabel3.setText("Occurrence:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel3, gridBagConstraints);
        this.spinnerCopperMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerCopperMinLevel, gridBagConstraints);
        this.spinnerGravelChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerGravelChance, gridBagConstraints);
        this.spinnerRedstoneMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerRedstoneMinLevel, gridBagConstraints);
        this.jLabel62.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel62, gridBagConstraints);
        this.jLabel39.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel39, gridBagConstraints);
        this.jLabel64.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel64, gridBagConstraints);
        this.jLabel43.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel43, gridBagConstraints);
        this.spinnerCopperChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerCopperChance, gridBagConstraints);
        this.spinnerDirtChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerDirtChance, gridBagConstraints);
        this.jLabel32.setText("Gravel:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel32, gridBagConstraints);
        this.jLabel93.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel93, gridBagConstraints);
        this.jLabel30.setText("Dirt:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel30, gridBagConstraints);
        this.jLabel33.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel33, gridBagConstraints);
        this.spinnerRedstoneChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerRedstoneChance, gridBagConstraints);
        this.jLabel19.setText("Redstone:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel19, gridBagConstraints);
        this.spinnerGravelMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerGravelMaxLevel, gridBagConstraints);
        this.spinnerCopperMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerCopperMaxLevel, gridBagConstraints);
        this.jLabel27.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel27, gridBagConstraints);
        this.spinnerGravelMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerGravelMinLevel, gridBagConstraints);
        this.jLabel31.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel31, gridBagConstraints);
        this.spinnerDirtMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerDirtMinLevel, gridBagConstraints);
        this.spinnerDirtMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerDirtMaxLevel, gridBagConstraints);
        this.jLabel11.setText("Levels:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel91.setText("Copper:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel91, gridBagConstraints);
        this.jLabel42.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel42, gridBagConstraints);
        this.jLabel89.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.jLabel89, gridBagConstraints);
        this.spinnerRedstoneMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel21.add((Component)this.spinnerRedstoneMaxLevel, gridBagConstraints);
        this.jPanel22.setLayout(new GridBagLayout());
        this.jLabel101.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.jLabel101, gridBagConstraints);
        this.jLabel100.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.jLabel100, gridBagConstraints);
        this.spinnerQuartzChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.spinnerQuartzChance, gridBagConstraints);
        this.jLabel74.setText("Nether Quartz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.jLabel74, gridBagConstraints);
        this.jLabel76.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.jLabel76, gridBagConstraints);
        this.jLabel98.setText("blocks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.jLabel98, gridBagConstraints);
        this.spinnerQuartzMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.spinnerQuartzMaxLevel, gridBagConstraints);
        this.spinnerAncientDebrisMaxLevel.setModel(new SpinnerNumberModel(1, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.spinnerAncientDebrisMaxLevel, gridBagConstraints);
        this.spinnerAncientDebrisMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.spinnerAncientDebrisMinLevel, gridBagConstraints);
        this.jLabel75.setText("\u2030");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.jLabel75, gridBagConstraints);
        this.jLabel99.setText("Ancient Debris:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.jLabel99, gridBagConstraints);
        this.spinnerAncientDebrisChance.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.spinnerAncientDebrisChance, gridBagConstraints);
        this.spinnerQuartzMinLevel.setModel(new SpinnerNumberModel(0, 0, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.spinnerQuartzMinLevel, gridBagConstraints);
        this.jLabel77.setText("-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel22.add((Component)this.jLabel77, gridBagConstraints);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel4Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jSlider4, -2, -1, -2)).addComponent(this.jCheckBox8).addComponent(this.jLabel10).addComponent(this.jSeparator2).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel20, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jSeparator3, -2, 2, -2).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator4, -2, 333, -2).addComponent(this.jPanel21, -2, -1, -2).addComponent(this.jPanel22, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider4, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jSeparator3).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jPanel21, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jSeparator4, -2, 11, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel22, -2, -1, -2)).addComponent(this.jPanel20, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Resources", new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/resources.png")), this.jPanel4);
        this.checkBoxPopulate.setText("Allow Minecraft to populate the entire terrain");
        this.checkBoxPopulate.setToolTipText("<html>This will mark the entire terrain as unpopulated, causing Minecraft to generate trees,<br/>\nwater and lava pools, pockets of dirt, gravel, coal, ore, etc. (but not caverns) as the<br/>\nchunks are loaded. This will slow down the initial loading of each chunk, and you have<br/>\nno control over where trees, snow, etc. appear.</html>");
        this.checkBoxPopulate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxPopulateActionPerformed(evt);
            }
        });
        this.checkBoxDeciduousEverywhere.setText("Deciduous forest everywhere");
        this.checkBoxDeciduousEverywhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxDeciduousEverywhereActionPerformed(evt);
            }
        });
        this.sliderDeciduousLevel.setMajorTickSpacing(1);
        this.sliderDeciduousLevel.setMaximum(15);
        this.sliderDeciduousLevel.setMinimum(1);
        this.sliderDeciduousLevel.setPaintTicks(true);
        this.sliderDeciduousLevel.setSnapToTicks(true);
        this.sliderDeciduousLevel.setValue(8);
        this.checkBoxFrostEverywhere.setText("Frost everywhere");
        this.checkBoxPineEverywhere.setText("Pine forest everywhere");
        this.checkBoxPineEverywhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxPineEverywhereActionPerformed(evt);
            }
        });
        this.sliderPineLevel.setMajorTickSpacing(1);
        this.sliderPineLevel.setMaximum(15);
        this.sliderPineLevel.setMinimum(1);
        this.sliderPineLevel.setPaintTicks(true);
        this.sliderPineLevel.setSnapToTicks(true);
        this.sliderPineLevel.setValue(8);
        this.checkBoxSmoothSnow.setText("Smooth snow (also applies to hand-painted Frost layer)");
        this.jLabel47.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/populate.png")));
        this.jLabel48.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/deciduousforest.png")));
        this.jLabel49.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/pineforest.png")));
        this.jLabel50.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/frost.png")));
        this.checkBoxJungleEverywhere.setText("Jungle everywhere");
        this.checkBoxJungleEverywhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxJungleEverywhereActionPerformed(evt);
            }
        });
        this.jLabel68.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/jungle.png")));
        this.sliderJungleLevel.setMajorTickSpacing(1);
        this.sliderJungleLevel.setMaximum(15);
        this.sliderJungleLevel.setMinimum(1);
        this.sliderJungleLevel.setPaintTicks(true);
        this.sliderJungleLevel.setSnapToTicks(true);
        this.sliderJungleLevel.setValue(8);
        this.checkBoxSwamplandEverywhere.setText("Swampland everywhere");
        this.checkBoxSwamplandEverywhere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxSwamplandEverywhereActionPerformed(evt);
            }
        });
        this.jLabel69.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/swampland.png")));
        this.jSlider6.setMajorTickSpacing(1);
        this.jSlider6.setMaximum(15);
        this.jSlider6.setMinimum(1);
        this.jSlider6.setPaintTicks(true);
        this.jSlider6.setSnapToTicks(true);
        this.jSlider6.setValue(8);
        this.checkBoxSnowUnderTrees.setText("Frost under trees (also applies to hand-painted Frost layer)");
        this.checkBoxExportAnnotations.setText("Export the annotations (as coloured wool)");
        this.checkBoxExportAnnotations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.checkBoxExportAnnotationsActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.checkBoxPopulate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel47)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.checkBoxFrostEverywhere).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel50)).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxSmoothSnow).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sliderDeciduousLevel, -2, -1, -2).addComponent(this.sliderPineLevel, -2, -1, -2)).addGap(67, 67, 67).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.checkBoxJungleEverywhere).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel68)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.checkBoxSwamplandEverywhere).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel69)).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider6, -2, -1, -2).addComponent(this.sliderJungleLevel, -2, -1, -2))))).addComponent(this.checkBoxSnowUnderTrees))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxDeciduousEverywhere).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.checkBoxPineEverywhere).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel49))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel48)).addComponent(this.checkBoxExportAnnotations)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxPopulate).addComponent(this.jLabel47)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxDeciduousEverywhere).addComponent(this.jLabel48)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderDeciduousLevel, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxJungleEverywhere).addComponent(this.jLabel68)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sliderJungleLevel, -2, -1, -2))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxPineEverywhere).addComponent(this.jLabel49))).addGroup(jPanel2Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jLabel69)))).addComponent(this.checkBoxSwamplandEverywhere, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sliderPineLevel, -2, -1, -2).addComponent(this.jSlider6, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxFrostEverywhere).addComponent(this.jLabel50)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxSmoothSnow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxSnowUnderTrees).addGap(18, 18, 18).addComponent(this.checkBoxExportAnnotations).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Other Layers", this.jPanel2);
        this.jLabel82.setText("<html>On this page you can configure the export order of your custom layers, as well as prevent certain layers from being exported.<br>\nHigher layers in the list are exported <em>before</em> lower layers. Layers cannot be moved between first or second pass.<br>\n<strong>Note:</strong> once you customise the order on this screen, new layers will be added to the end of the list.</html>");
        this.tableCustomLayers.setSelectionMode(2);
        this.jScrollPane1.setViewportView(this.tableCustomLayers);
        this.buttonCustomLayerUp.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/up.png")));
        this.buttonCustomLayerUp.setText("Up");
        this.buttonCustomLayerUp.setToolTipText("Move the selected layer(s) up");
        this.buttonCustomLayerUp.setHorizontalAlignment(10);
        this.buttonCustomLayerUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonCustomLayerUpActionPerformed(evt);
            }
        });
        this.buttonCustomLayerDown.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/down.png")));
        this.buttonCustomLayerDown.setText("Down");
        this.buttonCustomLayerDown.setToolTipText("Move the selected layer(s) down");
        this.buttonCustomLayerDown.setHorizontalAlignment(10);
        this.buttonCustomLayerDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonCustomLayerDownActionPerformed(evt);
            }
        });
        this.buttonCustomLayerTop.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/top.png")));
        this.buttonCustomLayerTop.setText("To Top");
        this.buttonCustomLayerTop.setToolTipText("Move the selected layer(s) to the start of their pass");
        this.buttonCustomLayerTop.setHorizontalAlignment(10);
        this.buttonCustomLayerTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonCustomLayerTopActionPerformed(evt);
            }
        });
        this.buttonCustomLayerBottom.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/bottom.png")));
        this.buttonCustomLayerBottom.setText("To Bottom");
        this.buttonCustomLayerBottom.setToolTipText("Move the selected layer(s) to the end of their pass");
        this.buttonCustomLayerBottom.setHorizontalAlignment(10);
        this.buttonCustomLayerBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonCustomLayerBottomActionPerformed(evt);
            }
        });
        this.buttonDisableLayers.setText("Disable");
        this.buttonDisableLayers.setToolTipText("Disable the selected layer(s)");
        this.buttonDisableLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonDisableLayersActionPerformed(evt);
            }
        });
        this.buttonEnableLayers.setText("Enable");
        this.buttonEnableLayers.setToolTipText("Enable the selected layer(s)");
        this.buttonEnableLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonEnableLayersActionPerformed(evt);
            }
        });
        this.buttonSelectPaint.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/icons/eyedropper.png")));
        this.buttonSelectPaint.setText("Select");
        this.buttonSelectPaint.setHorizontalAlignment(10);
        this.buttonSelectPaint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonSelectPaintActionPerformed(evt);
            }
        });
        this.buttonReset.setText("Reset Order");
        this.buttonReset.setToolTipText("Enable the selected layer(s)");
        this.buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimensionPropertiesEditor.this.buttonResetActionPerformed(evt);
            }
        });
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel82, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buttonCustomLayerBottom, -1, -1, Short.MAX_VALUE).addComponent(this.buttonCustomLayerDown, -1, -1, Short.MAX_VALUE).addComponent(this.buttonCustomLayerUp, -1, -1, Short.MAX_VALUE).addComponent(this.buttonDisableLayers, -1, -1, Short.MAX_VALUE).addComponent(this.buttonEnableLayers, -1, -1, Short.MAX_VALUE).addComponent(this.buttonCustomLayerTop, -1, -1, Short.MAX_VALUE).addComponent(this.buttonSelectPaint, -1, -1, Short.MAX_VALUE).addComponent(this.buttonReset, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel82, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 371, Short.MAX_VALUE).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.buttonSelectPaint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCustomLayerTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCustomLayerUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCustomLayerDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCustomLayerBottom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonDisableLayers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonEnableLayers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonReset).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jTabbedPane1.addTab("Custom Layers", this.jPanel7);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jTabbedPane1)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1));
    }

    private void radioButtonWaterBorderActionPerformed(ActionEvent evt) {
        this.borderChanged();
        this.setControlStates();
        if ((Integer)this.spinnerBorderLevel.getValue() == this.dimension.getMaxHeight() - 1) {
            this.spinnerBorderLevel.setValue(this.dimension.getBorderLevel());
        }
    }

    private void radioButtonNoBorderActionPerformed(ActionEvent evt) {
        this.borderChanged();
        this.setControlStates();
    }

    private void checkBoxPopulateActionPerformed(ActionEvent evt) {
        if (this.checkBoxPopulate.isSelected() && this.jCheckBox8.isSelected() && !this.endlessBorder) {
            this.jCheckBox8.setSelected(false);
            this.setControlStates();
            MessageUtils.showInfo((Component)this, (String)"\"Resources everywhere\" disabled on the Resources tab,\nto avoid duplicate resources. You may enable it again manually.", (String)"Resources Everywhere Disabled");
        }
    }

    private void radioButtonVoidBorderActionPerformed(ActionEvent evt) {
        this.borderChanged();
        this.setControlStates();
    }

    private void radioButtonLavaBorderActionPerformed(ActionEvent evt) {
        this.borderChanged();
        this.setControlStates();
        if ((Integer)this.spinnerBorderLevel.getValue() == this.dimension.getMaxHeight() - 1) {
            this.spinnerBorderLevel.setValue(this.dimension.getBorderLevel());
        }
    }

    private void comboBoxSubsurfaceMaterialActionPerformed(ActionEvent evt) {
        Terrain terrain = (Terrain)this.comboBoxSubsurfaceMaterial.getSelectedItem();
        if (terrain != null && terrain.isCustom()) {
            MixedMaterial material = Terrain.getCustomMaterial((int)terrain.getCustomTerrainIndex());
            if (material.getMode() == MixedMaterial.Mode.LAYERED) {
                this.comboBoxUndergroundLayerAnchor.setSelectedIndex(this.subsurfaceLayerAnchor.ordinal());
            } else {
                this.comboBoxUndergroundLayerAnchor.setSelectedItem(null);
            }
        } else {
            this.comboBoxUndergroundLayerAnchor.setSelectedItem(null);
        }
        this.setControlStates();
    }

    private void checkBoxDeciduousEverywhereActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxPineEverywhereActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void spinnerBorderSizeStateChanged(ChangeEvent evt) {
        int value = (Integer)this.spinnerBorderSize.getValue();
        if ((value = Math.round((float)value / 128.0f) * 128) < 128) {
            value = 128;
        }
        this.spinnerBorderSize.setValue(value);
    }

    private void jCheckBox8ActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void spinnerMinSurfaceDepthStateChanged(ChangeEvent evt) {
        int topLevelMaxDepth;
        int topLevelMinDepth = (Integer)this.spinnerMinSurfaceDepth.getValue();
        if (topLevelMinDepth > (topLevelMaxDepth = ((Integer)this.spinnerMaxSurfaceDepth.getValue()).intValue())) {
            this.spinnerMaxSurfaceDepth.setValue(topLevelMinDepth);
        }
    }

    private void spinnerMaxSurfaceDepthStateChanged(ChangeEvent evt) {
        int topLevelMinDepth = (Integer)this.spinnerMinSurfaceDepth.getValue();
        int topLevelMaxDepth = (Integer)this.spinnerMaxSurfaceDepth.getValue();
        if (topLevelMaxDepth < topLevelMinDepth) {
            this.spinnerMinSurfaceDepth.setValue(topLevelMaxDepth);
        }
    }

    private void checkBoxJungleEverywhereActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxSwamplandEverywhereActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxExportAnnotationsActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void buttonCustomLayerUpActionPerformed(ActionEvent evt) {
        this.moveSelectedRowsUp(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedRowsUp(int noOfRows) {
        this.programmaticChange = true;
        try {
            for (int i = 0; i < noOfRows; ++i) {
                int[] rowIndices = this.tableCustomLayers.getSelectedRows();
                this.tableCustomLayers.clearSelection();
                for (int rowIndex : rowIndices) {
                    this.customLayersTableModel.swap(rowIndex - 1, rowIndex);
                    this.tableCustomLayers.getSelectionModel().addSelectionInterval(rowIndex - 1, rowIndex - 1);
                }
            }
        }
        finally {
            this.programmaticChange = false;
        }
        this.tableCustomLayers.scrollRectToVisible(this.tableCustomLayers.getCellRect(this.tableCustomLayers.getSelectedRows()[0], 0, true));
        this.orderPristine = false;
        this.setControlStates();
    }

    private void buttonCustomLayerDownActionPerformed(ActionEvent evt) {
        this.moveSelectedRowsDown(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveSelectedRowsDown(int noOfRows) {
        this.programmaticChange = true;
        try {
            for (int i = 0; i < noOfRows; ++i) {
                int[] rowIndices = this.tableCustomLayers.getSelectedRows();
                this.tableCustomLayers.clearSelection();
                for (int j = rowIndices.length - 1; j >= 0; --j) {
                    this.customLayersTableModel.swap(rowIndices[j] + 1, rowIndices[j]);
                    this.tableCustomLayers.getSelectionModel().addSelectionInterval(rowIndices[j] + 1, rowIndices[j] + 1);
                }
            }
        }
        finally {
            this.programmaticChange = false;
        }
        this.tableCustomLayers.scrollRectToVisible(this.tableCustomLayers.getCellRect(this.tableCustomLayers.getSelectedRows()[this.tableCustomLayers.getSelectedRowCount() - 1], 0, true));
        this.orderPristine = false;
        this.setControlStates();
    }

    private void radioButtonFixedBorderActionPerformed(ActionEvent evt) {
        this.borderChanged();
        this.setControlStates();
    }

    private void radioButtonEndlessBorderActionPerformed(ActionEvent evt) {
        this.borderChanged();
        this.setControlStates();
    }

    private void comboBoxUndergroundLayerAnchorActionPerformed(ActionEvent evt) {
        int selectedIndex = this.comboBoxUndergroundLayerAnchor.getSelectedIndex();
        if (selectedIndex >= 0) {
            this.subsurfaceLayerAnchor = Dimension.LayerAnchor.values()[selectedIndex];
        }
    }

    private void checkBoxCavernsEverywhereActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxCavernsBreakSurfaceActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxChasmsBreakSurfaceActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxFloodCavernsActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxChasmsEverywhereActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxCavesEverywhereActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxCavesBreakSurfaceActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void buttonGeneratorOptionsActionPerformed(ActionEvent evt) {
        if (this.comboBoxGenerator.getSelectedItem() == Generator.CUSTOM) {
            String editedGeneratorOptions = JOptionPane.showInputDialog(this, "Edit the custom world generator name:", this.generatorName);
            if (editedGeneratorOptions != null) {
                this.generatorName = editedGeneratorOptions;
            }
        } else if (this.generatorName != null) {
            String editedGeneratorOptions = JOptionPane.showInputDialog(this, "Edit the Superflat mode preset:", this.generatorName);
            if (editedGeneratorOptions != null) {
                this.generatorName = editedGeneratorOptions;
            }
        } else {
            SuperflatPreset mySuperflatPreset = this.superflatPreset != null ? this.superflatPreset : SuperflatPreset.defaultPreset((Platform)this.platform);
            EditSuperflatPresetDialog dialog = new EditSuperflatPresetDialog(SwingUtilities.windowForComponent(this), this.platform, mySuperflatPreset);
            dialog.setVisible(true);
            if (!dialog.isCancelled()) {
                this.superflatPreset = mySuperflatPreset;
            }
        }
    }

    private void comboBoxGeneratorActionPerformed(ActionEvent evt) {
        this.updateGeneratorButtonTooltip();
        this.setControlStates();
    }

    private void buttonCustomLayerTopActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.tableCustomLayers.getSelectedRows();
        int topSelectedRow = selectedRows[0];
        int headerRow = -1;
        for (int row = topSelectedRow - 1; row >= 0; --row) {
            if (!this.customLayersTableModel.isHeaderRow(row)) continue;
            headerRow = row;
            break;
        }
        if (headerRow == -1) {
            throw new IllegalStateException("No header row found above selected rows");
        }
        this.moveSelectedRowsUp(topSelectedRow - headerRow - 1);
    }

    private void buttonCustomLayerBottomActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.tableCustomLayers.getSelectedRows();
        int bottomSelectedRow = selectedRows[selectedRows.length - 1];
        int rowCount = this.tableCustomLayers.getRowCount();
        int headerRow = -1;
        for (int row = bottomSelectedRow + 1; row < rowCount; ++row) {
            if (!this.customLayersTableModel.isHeaderRow(row)) continue;
            headerRow = row;
            break;
        }
        if (headerRow == -1) {
            headerRow = rowCount;
        }
        this.moveSelectedRowsDown(headerRow - bottomSelectedRow - 1);
    }

    private void checkBoxRoofActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxWallActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonBedrockRoofActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonBarrierRoofActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonBarrierBorderActionPerformed(ActionEvent evt) {
        this.borderChanged();
        this.setControlStates();
    }

    private void radioButtonBedrockWallActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void radioButtonBarrierWallActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxDecorateCavesActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxDecorateCavernsActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void checkBoxDecorateChasmsActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }

    private void buttonDisableLayersActionPerformed(ActionEvent evt) {
        this.disableSelectedLayers();
    }

    private void buttonEnableLayersActionPerformed(ActionEvent evt) {
        this.enableSelectedLayers();
    }

    private void buttonSelectPaintActionPerformed(ActionEvent evt) {
        this.selectPaintOnMap();
    }

    private void buttonResetActionPerformed(ActionEvent evt) {
        this.resetOrder();
    }

    public static enum Mode {
        EXPORT,
        DEFAULT_SETTINGS,
        EDITOR;

    }
}

