/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import org.pepsoft.util.DesktopUtils;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.GUIUtils;
import org.pepsoft.util.swing.MessageUtils;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.Scroller;
import org.pepsoft.worldpainter.Version;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.WorldPainter;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.util.MinecraftUtil;
import org.pepsoft.worldpainter.vo.EventVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialog
extends JDialog
implements WindowListener {
    private JButton buttonClose;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JTextPane jTextPane1;
    private JTextPane jTextPane2;
    private JTextPane jTextPane3;
    private Scroller scroller;
    private static final int BUFFER_SIZE = 32768;
    private static final ResourceBundle strings = ResourceBundle.getBundle("org.pepsoft.worldpainter.resources.strings");
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AboutDialog.class);

    public AboutDialog(Window parent, World2 world, WorldPainter view, UndoManager undoManager) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.jTextPane2.setText(this.loadChangelog());
        this.jTextPane1.setText(this.loadCredits());
        this.jTextPane3.setText(this.loadTechInfo(world, view, undoManager));
        ActionMap actionMap = this.rootPane.getActionMap();
        actionMap.put("close", new AbstractAction("close"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.close();
            }
        });
        InputMap inputMap = this.rootPane.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
        this.rootPane.setDefaultButton(this.buttonClose);
        GUIUtils.scaleToUI((Container)this);
        this.jLabel1.setIcon(new ImageIcon(GUIUtils.scaleToUI((Image)((ImageIcon)this.jLabel1.getIcon()).getImage(), (boolean)true)));
        GUIUtils.scaleWindow((Window)this);
        this.setLocationRelativeTo(parent);
        this.addWindowListener(this);
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.jScrollPane1.getVerticalScrollBar().setValue(0);
        this.scroller = new Scroller();
        this.scroller.attach(this.jScrollPane1.getVerticalScrollBar());
        this.jScrollPane2.getVerticalScrollBar().setValue(0);
        this.jScrollPane3.getVerticalScrollBar().setValue(0);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.scroller != null) {
            this.scroller.detach();
            this.scroller = null;
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadCredits() {
        Font defaultTextPaneFont = this.jTextPane2.getFont();
        Color textColour = this.jTextPane2.getForeground();
        Color linkColour = textColour.getRed() + textColour.getGreen() + textColour.getBlue() > 384 ? Color.CYAN : Color.BLUE;
        String style = String.format("body {font-family: %s; font-size: %dpt; color: #%06x; background-color: #%06x;} a {color: #%06x;}", defaultTextPaneFont.getFamily(), defaultTextPaneFont.getSize(), textColour.getRGB() & 0xFFFFFF, this.jTextPane2.getBackground().getRGB() & 0xFFFFFF, linkColour.getRGB() & 0xFFFFFF);
        try (InputStreamReader in = new InputStreamReader(AboutDialog.class.getResourceAsStream("resources/credits.html"), StandardCharsets.UTF_8);){
            int read;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[32768];
            while ((read = in.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
            }
            String template = sb.toString();
            MessageFormat formatter = new MessageFormat(template);
            Configuration.DonationStatus donationStatus = Configuration.getInstance().getDonationStatus();
            String string = formatter.format(new Object[]{Version.VERSION, donationStatus != null ? donationStatus.ordinal() : Configuration.DonationStatus.NO_THANK_YOU.ordinal(), style});
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error reading resource", e);
        }
    }

    private String loadChangelog() {
        try {
            return FileUtils.load((InputStream)ClassLoader.getSystemResourceAsStream("CHANGELOG"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error while loading change log from classpath", e);
        }
    }

    private void close() {
        this.dispose();
    }

    private void donate() {
        try {
            DesktopUtils.open((URL)new URL("https://www.worldpainter.net/donate/paypal"));
            Configuration config = Configuration.getInstance();
            config.setDonationStatus(Configuration.DonationStatus.DONATED);
            MessageUtils.showInfo((Component)this, (String)strings.getString("the.donation.paypal.page.has.been.opened"), (String)strings.getString("thank.you"));
            config.logEvent(new EventVO("donation.donate").addTimestamp());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String loadTechInfo(World2 world, WorldPainter view, UndoManager undoManager) {
        File installDir = null;
        ClassLoader classLoader = AboutDialog.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                if (!url.getPath().endsWith("WorldPainter.jar")) continue;
                try {
                    installDir = new File(url.toURI()).getParentFile();
                    if (!installDir.getName().equals("app")) break;
                    installDir = installDir.getParentFile().getParentFile().getParentFile();
                }
                catch (URISyntaxException e) {
                    logger.error("URI syntax exception while trying to find install dir", (Throwable)e);
                }
                break;
            }
        }
        File minecraftDir = MinecraftUtil.findMinecraftDir();
        File configDir = Configuration.getConfigDir();
        StringBuilder message = new StringBuilder();
        if (Configuration.getInstance().isSafeMode()) {
            message.append("WorldPainter is running in safe mode\n");
        }
        message.append(MessageFormat.format(strings.getString("worldpainter.version.0.njava.version.1.noperating.system.2.3.version.4.n"), Version.VERSION, Version.BUILD, System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version")));
        if (installDir != null) {
            message.append(MessageFormat.format(strings.getString("installation.directory.0.n"), installDir));
        }
        message.append(MessageFormat.format(strings.getString("worldpainter.config.directory.0.ninstallation.id.1.n"), configDir, Configuration.getInstance().getUuid()));
        List plugins = WPPluginManager.getInstance().getAllPlugins();
        plugins.stream().filter(plugin -> !plugin.getClass().getName().startsWith("org.pepsoft.worldpainter")).forEach(plugin -> message.append(MessageFormat.format(strings.getString("0.plugin.version.1.n"), plugin.getName(), plugin.getVersion())));
        if (minecraftDir != null) {
            message.append(MessageFormat.format(strings.getString("minecraft.data.directory.0.n"), minecraftDir));
        }
        Runtime runtime = Runtime.getRuntime();
        long dataSize = world != null ? world.measureSize() : 0L;
        long undoDataSize = undoManager != null ? undoManager.getDataSize() : 0L;
        long overlayImageSize = view.getOverlayImageSize();
        message.append(MessageFormat.format(strings.getString("available.cpu.cores.0.nmaximum.configured.memory.1.mb.ncurrently.allocated.memory.2.mb.n"), runtime.availableProcessors(), runtime.maxMemory() / 1024L / 1024L, runtime.totalMemory() / 1024L / 1024L));
        if (dataSize > 0L) {
            message.append(MessageFormat.format(strings.getString("world.data.size.0.kb.n"), dataSize / 1024L));
        }
        if (undoDataSize - dataSize > 0L) {
            message.append(MessageFormat.format(strings.getString("additional.undo.data.size.0.kb.n"), (undoDataSize - dataSize) / 1024L));
        }
        if (overlayImageSize > 0L) {
            message.append(MessageFormat.format(strings.getString("overlay.image.data.size.0.kb.n"), overlayImageSize / 1024L));
        }
        return message.toString();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.buttonClose = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTextPane2 = new JTextPane();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane3 = new JTextPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("About WorldPainter");
        this.setResizable(false);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/org/pepsoft/worldpainter/resources/banner.png")));
        this.jLabel1.setBorder(BorderFactory.createBevelBorder(1));
        this.buttonClose.setText("Close");
        this.buttonClose.addActionListener(this::buttonCloseActionPerformed);
        this.jScrollPane1.setBorder(null);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.setText("<html>\n  <head>\n  </head>\n  <body>\n    <p style=\"margin-top: 0\">\nEen paar regels<br>\nom te laten zien<br>\nhoe het er in het echt<br>\nuit zal zien.      \n    </p>\n  </body>\n</html>");
        this.jTextPane1.addHyperlinkListener(this::jTextPane1HyperlinkUpdate);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jTabbedPane1.addTab("Credits", this.jScrollPane1);
        this.jScrollPane2.setBorder(null);
        this.jTextPane2.setEditable(false);
        this.jTextPane2.setText("Een paar regels\nom te laten zien\nhoe het er in het echt\nuit zal zien.");
        this.jScrollPane2.setViewportView(this.jTextPane2);
        this.jTabbedPane1.addTab("Change log", this.jScrollPane2);
        this.jScrollPane3.setBorder(null);
        this.jTextPane3.setEditable(false);
        this.jTextPane3.setText("Een paar regels\nom te laten zien\nhoe het er in het echt\nuit zal zien.");
        this.jScrollPane3.setViewportView(this.jTextPane3);
        this.jTabbedPane1.addTab("Tech Info", this.jScrollPane3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.buttonClose, GroupLayout.Alignment.TRAILING)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jTabbedPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, 213, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClose).addContainerGap()));
        this.pack();
    }

    private void jTextPane1HyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = evt.getURL();
            if (url.getProtocol().equals("action")) {
                String action = url.getPath().toLowerCase().trim();
                if (action.equals("/donate")) {
                    this.donate();
                }
            } else {
                DesktopUtils.open((URL)url);
            }
        }
    }

    private void buttonCloseActionPerformed(ActionEvent evt) {
        this.close();
    }
}

