/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.util.ArrayList;
import java.util.Set;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.ProgressReceiver;
import org.pepsoft.util.SubProgressReceiver;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightTransform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.layers.CustomLayer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public final class WorldUtils {
    private WorldUtils() {
    }

    public static void resizeWorld(World2 world, HeightTransform transform, int newMinHeight, int newMaxHeight, boolean transformLayers, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        world.setMinHeight(newMinHeight);
        world.setMaxHeight(newMaxHeight);
        Set<Dimension> dimensions = world.getDimensions();
        int total = dimensions.size();
        int count = 0;
        for (Dimension dimension : dimensions) {
            SubProgressReceiver subProgressReceiver;
            if (progressReceiver != null) {
                ++count;
                subProgressReceiver = new SubProgressReceiver(progressReceiver, (float)count / (float)total, 1.0f / (float)total);
            } else {
                subProgressReceiver = null;
            }
            WorldUtils.resizeDimension(dimension, newMinHeight, newMaxHeight, transform, transformLayers, (ProgressReceiver)subProgressReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resizeDimension(Dimension dim, int newMinHeight, int newMaxHeight, HeightTransform transform, boolean transformLayers, ProgressReceiver progressReceiver) throws ProgressReceiver.OperationCancelled {
        int dimNewMaxHeight;
        int dimNewMinHeight;
        int oldMinHeight = dim.getMinHeight();
        int oldMaxHeight = dim.getMaxHeight();
        switch (dim.getAnchor().dim) {
            case 1: {
                dimNewMinHeight = Math.max(newMinHeight, 0);
                dimNewMaxHeight = Math.min(newMaxHeight, 256);
                break;
            }
            case 2: {
                dimNewMinHeight = Math.max(newMinHeight, 0);
                dimNewMaxHeight = Math.min(newMaxHeight, 256);
                break;
            }
            default: {
                dimNewMinHeight = newMinHeight;
                dimNewMaxHeight = newMaxHeight;
            }
        }
        if (dimNewMinHeight == oldMinHeight && dimNewMaxHeight == oldMaxHeight && transform.isIdentity()) {
            return;
        }
        dim.clearUndo();
        dim.getTiles().forEach(Tile::inhibitEvents);
        try {
            int tileCount = dim.getTileCount();
            int tileNo = 0;
            for (Tile tile : dim.getTiles()) {
                tile.setMinMaxHeight(dimNewMinHeight, dimNewMaxHeight, transform);
                ++tileNo;
                if (progressReceiver == null) continue;
                progressReceiver.setProgress((float)tileNo / (float)tileCount);
            }
            dim.setMinHeight(dimNewMinHeight);
            dim.setMaxHeight(dimNewMaxHeight);
            dim.getTileFactory().setMinMaxHeight(dimNewMinHeight, dimNewMaxHeight, transform);
            if (dim.getAnchor().invert) {
                int minHeightDelta = dimNewMinHeight - oldMinHeight;
                dim.setCeilingHeight(dim.getCeilingHeight() - minHeightDelta);
            } else {
                dim.setCeilingHeight(dimNewMaxHeight);
            }
            if (transformLayers) {
                for (ExporterSettings exporterSettings : dim.getAllLayerSettings().values()) {
                    exporterSettings.setMinMaxHeight(oldMinHeight, dimNewMinHeight, oldMaxHeight, dimNewMaxHeight, transform);
                }
                for (CustomLayer customLayer : dim.getCustomLayers()) {
                    customLayer.setMinMaxHeight(oldMinHeight, dimNewMinHeight, oldMaxHeight, dimNewMaxHeight, transform);
                }
                if (dim.getGenerator() instanceof SuperflatGenerator && dimNewMinHeight != oldMinHeight) {
                    int raiseBy = oldMinHeight - dimNewMinHeight;
                    SuperflatPreset superflatPreset = ((SuperflatGenerator)dim.getGenerator()).getSettings();
                    if (superflatPreset != null) {
                        ArrayList<SuperflatPreset.Layer> layers = new ArrayList<SuperflatPreset.Layer>(superflatPreset.getLayers());
                        if (raiseBy > 0) {
                            if (((SuperflatPreset.Layer)layers.get(0)).getMaterialName().equals("minecraft:bedrock")) {
                                if (((SuperflatPreset.Layer)layers.get(1)).getMaterialName().equals("minecraft:deepslate")) {
                                    ((SuperflatPreset.Layer)layers.get(1)).setThickness(((SuperflatPreset.Layer)layers.get(1)).getThickness() + raiseBy);
                                } else {
                                    layers.add(1, new SuperflatPreset.Layer("minecraft:deepslate", raiseBy));
                                }
                            } else if (((SuperflatPreset.Layer)layers.get(0)).getMaterialName().equals("minecraft:deepslate")) {
                                ((SuperflatPreset.Layer)layers.get(0)).setThickness(((SuperflatPreset.Layer)layers.get(0)).getThickness() + raiseBy);
                            } else {
                                layers.add(0, new SuperflatPreset.Layer("minecraft:deepslate", raiseBy));
                            }
                        } else {
                            int lowerBy = -raiseBy;
                            for (SuperflatPreset.Layer layer : layers) {
                                int amount = Math.min(lowerBy, layer.getThickness() - 1);
                                if (amount <= 0) continue;
                                layer.setThickness(layer.getThickness() - amount);
                                if ((lowerBy -= amount) != 0) continue;
                                break;
                            }
                        }
                        superflatPreset.setLayers(layers);
                    }
                }
            }
            dim.clearUndo();
            dim.armSavePoint();
            if (progressReceiver != null) {
                progressReceiver.setProgress(1.0f);
            }
        }
        finally {
            dim.getTiles().forEach(Tile::releaseEvents);
        }
    }
}

