/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import com.google.common.collect.ImmutableSet;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;

public class MinecraftWorldUtils {
    private static final Set<String> IGNORED_PROPERTIES = ImmutableSet.of((Object)"waterlogged", (Object)"facing", (Object)"snowy", (Object)"distance", (Object)"down");

    public static void assertEquals(String role1, MinecraftWorld world1, String role2, MinecraftWorld world2, Rectangle area) {
        for (int x = area.x; x < area.x + area.width; ++x) {
            for (int z = area.y; z < area.y + area.height; ++z) {
                Chunk chunk1 = world1.getChunk(x, z);
                Chunk chunk2 = world2.getChunk(x, z);
                if (chunk1 != null) {
                    if (chunk2 != null) {
                        MinecraftWorldUtils.assertEquals(role1, chunk1, role2, chunk2);
                        continue;
                    }
                    throw new AssertionError((Object)("Chunk " + x + "," + z + " exists in " + role1 + " but not in " + role2));
                }
                if (chunk2 != null) {
                    throw new AssertionError((Object)("Chunk " + x + "," + z + " exists in " + role2 + " but not in " + role1));
                }
            }
        }
    }

    public static void assertEquals(String role1, Chunk chunk1, String role2, Chunk chunk2) {
        int offsetX = chunk1.getxPos() << 4;
        int offsetZ = chunk1.getzPos() << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int maxY = Math.max(chunk1.getHighestNonAirBlock(x, z), chunk2.getHighestNonAirBlock(x, z));
                for (int y = 0; y <= maxY; ++y) {
                    Material material1 = chunk1.getMaterial(x, y, z);
                    Material material2 = chunk2.getMaterial(x, y, z);
                    if (material1.name.equals("legacy:block_175") && material1.getProperty("data_value").equals("8") && material2.isNamedOneOf("minecraft:peony", "minecraft:sunflower", "minecraft:lilac", "minecraft:tall_grass", "minecraft:large_fern", "minecraft:rose_bush") && material2.getProperty("half").equals("upper")) continue;
                    if (y <= 62) {
                        if (material1.blockType == 9) {
                            if (material2.isNotNamed("minecraft:water") && !material2.watery && !material2.is(Material.WATERLOGGED)) {
                                throw new AssertionError((Object)(role2 + " material " + material2 + " != " + material1 + " at " + x + "," + y + "," + z));
                            }
                            continue;
                        }
                        MinecraftWorldUtils.assertEquals(material1, role2, material2, "material", offsetX + x, y, offsetZ + z);
                    } else {
                        if (material1.isNamedOneOf("minecraft:air", "minecraft:vine", "minecraft:oak_leaves", "minecraft:lily_pad", "minecraft:dead_bush") && material2.isNamedOneOf("minecraft:air", "minecraft:vine", "minecraft:oak_leaves", "minecraft:lily_pad", "minecraft:dead_bush")) continue;
                        MinecraftWorldUtils.assertEquals(material1, role2, material2, "material", offsetX + x, y, offsetZ + z);
                    }
                    if (!material1.isNotNamed("minecraft:water")) continue;
                    MinecraftWorldUtils.assertEquals(chunk1.getSkyLightLevel(x, y, z), role2, chunk1.getSkyLightLevel(x, y, z), "sky light", offsetX + x, y, offsetZ + z);
                    MinecraftWorldUtils.assertEquals(chunk1.getBlockLightLevel(x, y, z), role2, chunk2.getBlockLightLevel(x, y, z), "block light", offsetX + x, y, offsetZ + z);
                }
            }
        }
    }

    public static void assertEquals(Material material1, String role2, Material material2, String type, int x, int y, int z) {
        if (material1.name == material2.name) {
            Map<String, String> properties1 = material1.getProperties();
            Map<String, String> properties2 = material2.getProperties();
            if (properties1 != null && (properties1 = properties1.entrySet().stream().filter(entry -> !IGNORED_PROPERTIES.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
                properties1 = null;
            }
            if (properties2 != null && (properties2 = properties2.entrySet().stream().filter(entry -> !IGNORED_PROPERTIES.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
                properties2 = null;
            }
            if (Objects.equals(properties1, properties2)) {
                return;
            }
        }
        throw new AssertionError((Object)(role2 + " " + type + " " + material2 + " != " + material1 + " at " + x + "," + y + "," + z));
    }

    public static void assertEquals(Object object1, String role2, Object object2, String type, int x, int y, int z) {
        if (!object1.equals(object2)) {
            throw new AssertionError((Object)(role2 + " " + type + " " + object2 + " != " + object1 + " at " + x + "," + y + "," + z));
        }
    }
}

