/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.MixedMaterialManager;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.layers.Bo2Layer;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.Resources;
import org.pepsoft.worldpainter.layers.exporters.ResourcesExporter;
import org.pepsoft.worldpainter.layers.plants.Plant;
import org.pepsoft.worldpainter.layers.plants.PlantLayer;
import org.pepsoft.worldpainter.objects.WPObject;

public class MaterialUtils {
    public static Map<String, Set<String>> gatherBlocksWithoutIds(World2 world, Platform platform) {
        HashMap<String, Set<String>> nameOnlyMaterials = new HashMap<String, Set<String>>();
        Arrays.stream(MixedMaterialManager.getInstance().getMaterials()).forEach(material -> {
            for (MixedMaterial.Row row : material.getRows()) {
                if (row.material.blockType != -1) continue;
                nameOnlyMaterials.computeIfAbsent(row.material.name, m -> new HashSet()).add("custom material " + material.getName());
            }
        });
        for (Dimension dimension : world.getDimensions()) {
            Set<Layer> allLayers = dimension.getAllLayers(true);
            allLayers.addAll(dimension.getMinimumLayers());
            for (Layer layer : allLayers) {
                Cloneable nameOnlyMaterialsForLayer;
                if (layer instanceof Bo2Layer) {
                    nameOnlyMaterialsForLayer = new HashMap();
                    for (WPObject object : ((Bo2Layer)layer).getObjectProvider().getAllObjects()) {
                        object.getAllMaterials().forEach(arg_0 -> MaterialUtils.lambda$gatherBlocksWithoutIds$3((Map)((Object)nameOnlyMaterialsForLayer), object, arg_0));
                    }
                    nameOnlyMaterialsForLayer.forEach((name, objects) -> {
                        if (objects.size() == 1) {
                            nameOnlyMaterials.computeIfAbsent((String)name, m -> new HashSet()).add("object " + ((WPObject)objects.iterator().next()).getName() + " in layer " + layer.getName());
                        } else if (objects.size() <= 3) {
                            nameOnlyMaterials.computeIfAbsent((String)name, m -> new HashSet()).add("objects " + objects.stream().map(WPObject::getName).collect(Collectors.joining(", ")) + " in layer " + layer.getName());
                        } else {
                            nameOnlyMaterials.computeIfAbsent((String)name, m -> new HashSet()).add("objects " + objects.subList(0, 2).stream().map(WPObject::getName).collect(Collectors.joining(", ")) + " and " + (objects.size() - 2) + " more in layer " + layer.getName());
                        }
                    });
                    continue;
                }
                if (layer instanceof PlantLayer) {
                    nameOnlyMaterialsForLayer = new HashMap();
                    for (Plant plant : ((PlantLayer)layer).getConfiguredPlants().keySet()) {
                        plant.realise(plant.getMaxGrowth(), platform).getAllMaterials().forEach(arg_0 -> MaterialUtils.lambda$gatherBlocksWithoutIds$9((Map)((Object)nameOnlyMaterialsForLayer), plant, arg_0));
                    }
                    nameOnlyMaterialsForLayer.forEach((name, plants) -> {
                        if (plants.size() == 1) {
                            nameOnlyMaterials.computeIfAbsent((String)name, m -> new HashSet()).add("plant " + ((Plant)plants.iterator().next()).getName() + " in layer " + layer.getName());
                        } else if (plants.size() <= 3) {
                            nameOnlyMaterials.computeIfAbsent((String)name, m -> new HashSet()).add("plants " + plants.stream().map(WPObject::getName).collect(Collectors.joining(", ")) + " in layer " + layer.getName());
                        } else {
                            nameOnlyMaterials.computeIfAbsent((String)name, m -> new HashSet()).add("plants " + plants.subList(0, 2).stream().map(WPObject::getName).collect(Collectors.joining(", ")) + " and " + (plants.size() - 2) + " more in layer " + layer.getName());
                        }
                    });
                    continue;
                }
                if (!(layer instanceof Resources)) continue;
                nameOnlyMaterialsForLayer = new HashSet();
                ResourcesExporter.ResourcesExporterSettings settings = (ResourcesExporter.ResourcesExporterSettings)dimension.getLayerSettings(Resources.INSTANCE);
                for (Material material2 : settings.getMaterials()) {
                    if (settings.getChance(material2) <= 0) continue;
                    if (material2.blockType == -1) {
                        nameOnlyMaterialsForLayer.add(material2.name);
                        continue;
                    }
                    if (material2 != Material.GOLD_ORE || dimension.getAnchor().dim != 1) continue;
                    nameOnlyMaterialsForLayer.add(Material.NETHER_GOLD_ORE.name);
                }
                nameOnlyMaterialsForLayer.forEach(name -> nameOnlyMaterials.computeIfAbsent((String)name, m -> new HashSet()).add("Resources layer"));
            }
        }
        return nameOnlyMaterials;
    }

    public static Set<Material> gatherAllMaterials(World2 world, Platform platform) {
        HashSet<Material> allMaterials = new HashSet<Material>();
        Arrays.stream(MixedMaterialManager.getInstance().getMaterials()).forEach(material -> {
            for (MixedMaterial.Row row : material.getRows()) {
                allMaterials.add(row.material);
            }
        });
        for (Dimension dimension : world.getDimensions()) {
            for (Layer layer : dimension.getAllLayers(true)) {
                if (layer instanceof Bo2Layer) {
                    for (WPObject object : ((Bo2Layer)layer).getObjectProvider().getAllObjects()) {
                        allMaterials.addAll(object.getAllMaterials());
                    }
                    continue;
                }
                if (!(layer instanceof PlantLayer)) continue;
                for (Plant plant : ((PlantLayer)layer).getConfiguredPlants().keySet()) {
                    allMaterials.addAll(plant.realise(plant.getMaxGrowth(), platform).getAllMaterials());
                }
            }
            dimension.visitTiles().andDo(tile -> tile.getAllTerrains().forEach(terrain -> allMaterials.addAll(terrain.getAllMaterials())));
            allMaterials.addAll(dimension.getSubsurfaceMaterial().getAllMaterials());
        }
        return allMaterials;
    }

    private static /* synthetic */ void lambda$gatherBlocksWithoutIds$9(Map nameOnlyMaterialsForLayer, Plant plant, Material material) {
        if (material.blockType == -1) {
            nameOnlyMaterialsForLayer.computeIfAbsent(material.name, m -> new ArrayList()).add(plant);
        }
    }

    private static /* synthetic */ void lambda$gatherBlocksWithoutIds$3(Map nameOnlyMaterialsForLayer, WPObject object, Material material) {
        if (material.blockType == -1) {
            nameOnlyMaterialsForLayer.computeIfAbsent(material.name, m -> new ArrayList()).add(object);
        }
    }
}

