/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.util;

import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.MC115AnvilChunk;
import org.pepsoft.minecraft.MC118AnvilChunk;
import org.pepsoft.minecraft.SectionedChunk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkUtils {
    private static final Logger logger = LoggerFactory.getLogger(ChunkUtils.class);

    private ChunkUtils() {
    }

    public static boolean skipChunk(Chunk chunk) {
        if (chunk instanceof MC115AnvilChunk || chunk instanceof MC118AnvilChunk) {
            String status;
            String string = status = chunk instanceof MC115AnvilChunk ? ((MC115AnvilChunk)chunk).getStatus() : ((MC118AnvilChunk)chunk).getStatus();
            if (status.equals("structure_starts") || status.equals("biomes")) {
                boolean nonEmptySectionFound = false;
                for (SectionedChunk.Section section : ((SectionedChunk)chunk).getSections()) {
                    if (section == null || section.isEmpty()) continue;
                    nonEmptySectionFound = true;
                    break;
                }
                if (!nonEmptySectionFound) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Skipping chunk {},{} because the status is {} and it is empty", new Object[]{chunk.getxPos(), chunk.getzPos(), status});
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

