/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.heightMaps.TransformingHeightMap;
import org.pepsoft.worldpainter.layers.Annotations;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.panels.DefaultFilter;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class MappingOp
extends AbstractOperation<Void> {
    private final int[] mapping = new int[65536];
    private final Map<Integer, Integer> colourMapping = new HashMap<Integer, Integer>();
    private HeightMap heightMap;
    private Layer layer;
    private World2 world;
    private int dimIndex;
    private int storedLowerFrom;
    private int storedUpperFrom;
    private int scale = 100;
    private int offsetX;
    private int offsetY;
    private int terrainIndex;
    private int layerValue;
    private long storedColour = -1L;
    private Mode mode = Mode.SET;
    private Filter filter;
    private boolean dimInverted;

    public MappingOp(ScriptingContext context, HeightMap heightMap) throws ScriptException {
        super(context);
        if (heightMap == null) {
            throw new ScriptException("heightMap may not be null");
        }
        this.heightMap = heightMap;
        Arrays.fill(this.mapping, -1);
    }

    public MappingOp(ScriptingContext context, Layer layer) throws ScriptException {
        super(context);
        if (layer == null) {
            throw new ScriptException("layer may not be null");
        }
        this.layer = layer;
        switch (layer.dataSize) {
            case BIT: 
            case BIT_PER_CHUNK: {
                this.layerValue = 1;
                break;
            }
            case NIBBLE: {
                this.layerValue = 8;
                break;
            }
            case BYTE: {
                this.layerValue = 128;
                break;
            }
            default: {
                throw new ScriptException("Layer type " + layer.getClass().getSimpleName() + " not supported");
            }
        }
        Arrays.fill(this.mapping, -1);
    }

    public MappingOp(ScriptingContext context, int terrainIndex) throws ScriptException {
        super(context);
        if (terrainIndex < 0 || terrainIndex >= Terrain.VALUES.length) {
            throw new ScriptException("Invalid terrain index specified");
        }
        this.terrainIndex = terrainIndex;
        this.mode = Mode.SET_TERRAIN;
        Arrays.fill(this.mapping, -1);
    }

    public MappingOp applyToLayer(Layer layer) {
        this.layer = layer;
        if (this.mode == Mode.SET_TERRAIN) {
            this.mode = Mode.SET;
        }
        return this;
    }

    public MappingOp applyToTerrain() {
        this.layer = null;
        this.mode = Mode.SET_TERRAIN;
        return this;
    }

    public MappingOp toWorld(World2 world) {
        this.world = world;
        return this;
    }

    public MappingOp applyToSurface() {
        this.dimIndex = 0;
        this.dimInverted = false;
        return this;
    }

    public MappingOp applyToNether() {
        this.dimIndex = 1;
        this.dimInverted = false;
        return this;
    }

    public MappingOp applyToEnd() {
        this.dimIndex = 2;
        this.dimInverted = false;
        return this;
    }

    public MappingOp applyToSurfaceCeiling() {
        this.dimIndex = 0;
        this.dimInverted = true;
        return this;
    }

    public MappingOp applyToNetherCeiling() {
        this.dimIndex = 1;
        this.dimInverted = true;
        return this;
    }

    public MappingOp applyToEndCeiling() {
        this.dimIndex = 2;
        this.dimInverted = true;
        return this;
    }

    public MappingOp fromLevel(int level) throws ScriptException {
        if (!this.colourMapping.isEmpty()) {
            throw new ScriptException("Cannot mix grey scale and colour mapping");
        }
        this.storedLowerFrom = level;
        this.storedUpperFrom = level;
        return this;
    }

    public MappingOp fromLevels(int lower, int upper) throws ScriptException {
        if (!this.colourMapping.isEmpty()) {
            throw new ScriptException("Cannot mix grey scale and colour mapping");
        }
        this.storedLowerFrom = lower;
        this.storedUpperFrom = upper;
        return this;
    }

    public MappingOp fromColour(int red, int green, int blue) throws ScriptException {
        this.validateRGB(red, green, blue);
        this.storedColour = 0xFF000000L | (long)(red << 16) | (long)(green << 8) | (long)blue;
        return this;
    }

    public MappingOp fromColour(int alpha, int red, int green, int blue) throws ScriptException {
        if (alpha < 0 || alpha > 255) {
            throw new ScriptException("Invalid alpha value " + alpha + " specified");
        }
        this.validateRGB(red, green, blue);
        this.storedColour = (long)alpha << 24 | (long)(red << 16) | (long)(green << 8) | (long)blue;
        return this;
    }

    public MappingOp toLevel(int level) throws ScriptException {
        if (level < 0 || level > 255) {
            throw new ScriptException("Illegal value for layer: " + level);
        }
        this.mapStoredValuesTo(level);
        this.layerValue = level;
        return this;
    }

    public MappingOp toTerrain(int terrain) throws ScriptException {
        if (terrain < 0 || terrain >= Terrain.VALUES.length) {
            throw new ScriptException("Illegal value for terrain index: " + terrain);
        }
        this.mapStoredValuesTo(terrain);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MappingOp toLevels(int lower, int upper) {
        if (this.storedColour != -1L) {
            throw new IllegalArgumentException("Cannot map a colour to a range");
        }
        if (this.storedLowerFrom == this.storedUpperFrom) {
            if (lower != upper) throw new IllegalArgumentException("Cannot map a single value to a range");
            this.mapping[this.storedLowerFrom] = lower;
            return this;
        } else if (lower == upper) {
            for (int i = this.storedLowerFrom; i <= this.storedUpperFrom; ++i) {
                this.mapping[i] = lower;
            }
            return this;
        } else {
            float factor = (float)(upper - lower) / (float)(this.storedUpperFrom - this.storedLowerFrom);
            for (int i = this.storedLowerFrom; i <= this.storedUpperFrom; ++i) {
                this.mapping[i] = lower + Math.round((float)(i - this.storedLowerFrom) * factor);
            }
        }
        return this;
    }

    public MappingOp setAlways() {
        this.mode = Mode.SET;
        return this;
    }

    public MappingOp setWhenLower() {
        this.mode = Mode.SET_WHEN_LOWER;
        return this;
    }

    public MappingOp setWhenHigher() {
        this.mode = Mode.SET_WHEN_HIGHER;
        return this;
    }

    public MappingOp scale(int scale) {
        this.scale = scale;
        return this;
    }

    public MappingOp shift(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public MappingOp withFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public Void go() throws ScriptException {
        boolean bitLayer;
        HeightMap scaledHeightMap;
        boolean smoothScalingAllowed;
        Dimension dimension;
        boolean colourMapPresent;
        this.goCalled();
        if (this.heightMap == null && this.layer == null && this.terrainIndex == -1) {
            throw new ScriptException("No data source (heightMap, layer or terrain) specified");
        }
        if (this.mode != Mode.SET_TERRAIN && this.layer == null) {
            throw new ScriptException("layer not specified");
        }
        if (this.world == null) {
            throw new ScriptException("world not specified");
        }
        boolean greyScaleMapPresent = false;
        for (int mappedValue : this.mapping) {
            if (mappedValue == -1) continue;
            greyScaleMapPresent = true;
            break;
        }
        boolean bl = colourMapPresent = !this.colourMapping.isEmpty();
        if ((greyScaleMapPresent || colourMapPresent) && this.heightMap == null && this.layer == null) {
            throw new ScriptException("Mapping specified but no height map or layer specified");
        }
        if (this.heightMap != null) {
            if (!greyScaleMapPresent && !colourMapPresent) {
                throw new ScriptException("mapping not specified");
            }
            if (greyScaleMapPresent && colourMapPresent) {
                throw new ScriptException("Cannot mix grey scale and colour mapping");
            }
            if (this.layer != null) {
                int bits;
                if (this.layer.dataSize == Layer.DataSize.NONE) {
                    throw new ScriptException("Layer of unsupported type specified: " + this.layer);
                }
                switch (this.layer.dataSize) {
                    case BIT: 
                    case BIT_PER_CHUNK: {
                        bits = 1;
                        break;
                    }
                    case NIBBLE: {
                        bits = 4;
                        break;
                    }
                    case BYTE: {
                        bits = 8;
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                int maxValue = (1 << bits) - 1;
                if (greyScaleMapPresent) {
                    for (int mappedValue : this.mapping) {
                        if (mappedValue >= -1 && mappedValue <= maxValue) continue;
                        throw new ScriptException("Invalid destination level " + (int)mappedValue + " specified for " + bits + "-bit layer " + this.layer);
                    }
                } else {
                    Object mappedValue = this.colourMapping.entrySet().iterator();
                    while (mappedValue.hasNext()) {
                        Map.Entry entry = (Map.Entry)mappedValue.next();
                        int mappedValue2 = (Integer)entry.getValue();
                        if (mappedValue2 >= 0 && mappedValue2 <= maxValue) continue;
                        throw new ScriptException("Invalid destination level " + mappedValue2 + " specified for " + bits + "-bit layer " + this.layer);
                    }
                }
            } else if (greyScaleMapPresent) {
                for (int mappedValue : this.mapping) {
                    if (mappedValue >= -1 && mappedValue < Terrain.VALUES.length) continue;
                    throw new ScriptException("Invalid terrain index " + mappedValue + " specified");
                }
            } else {
                for (Map.Entry<Integer, Integer> entry : this.colourMapping.entrySet()) {
                    int mappedValue;
                    mappedValue = entry.getValue();
                    if (mappedValue >= 0 && mappedValue < Terrain.VALUES.length) continue;
                    throw new ScriptException("Invalid terrain index " + mappedValue + " specified");
                }
            }
        }
        if ((dimension = this.world.getDimension(new Dimension.Anchor(this.dimIndex, Dimension.Role.DETAIL, this.dimInverted, 0))) == null) {
            throw new ScriptException("Non existent dimension specified");
        }
        Rectangle extent = new Rectangle(dimension.getLowestX() << 7, dimension.getLowestY() << 7, dimension.getWidth() << 7, dimension.getHeight() << 7);
        boolean bl2 = smoothScalingAllowed = greyScaleMapPresent && this.mode != Mode.SET_TERRAIN && !Biome.INSTANCE.equals(this.layer) && !Annotations.INSTANCE.equals(this.layer);
        if (this.heightMap != null) {
            if (this.scale != 100 || this.offsetX != 0 || this.offsetY != 0) {
                boolean smoothScaling = this.scale != 100 && smoothScalingAllowed;
                scaledHeightMap = TransformingHeightMap.build().withHeightMap(this.heightMap).withScale((float)this.scale / 100.0f).withOffset(this.offsetX, this.offsetY).now();
            } else {
                scaledHeightMap = this.heightMap;
            }
            if (scaledHeightMap.getExtent() != null) {
                extent = extent.intersection(scaledHeightMap.getExtent());
            }
        } else {
            scaledHeightMap = null;
        }
        int x1 = extent.x;
        int y1 = extent.y;
        int x2 = extent.x + extent.width;
        int y2 = extent.y + extent.height;
        boolean bl3 = bitLayer = this.layer != null && (this.layer.getDataSize() == Layer.DataSize.BIT || this.layer.getDataSize() == Layer.DataSize.BIT_PER_CHUNK);
        if (this.filter instanceof DefaultFilter) {
            ((DefaultFilter)this.filter).setDimension(dimension);
        }
        for (int x = x1; x < x2; ++x) {
            block17: for (int y = y1; y < y2; ++y) {
                int valueOut;
                if (scaledHeightMap != null) {
                    if (colourMapPresent) {
                        int colour = scaledHeightMap.getColour(x, y);
                        if (!this.colourMapping.containsKey(colour)) continue;
                        valueOut = this.colourMapping.get(colour);
                    } else {
                        long valueIn = Math.round(scaledHeightMap.getHeight(x, y));
                        if (valueIn < 0L || valueIn > 65535L || (valueOut = this.mapping[(int)valueIn]) == -1) {
                            continue;
                        }
                    }
                } else {
                    valueOut = this.layer != null ? this.layerValue : this.terrainIndex;
                }
                if (this.filter != null) {
                    float filterValue = this.filter.modifyStrength(x, y, 1.0f);
                    if (filterValue == 0.0f) continue;
                    if (smoothScalingAllowed && filterValue != 1.0f) {
                        valueOut = Math.round(filterValue * (float)valueOut);
                    }
                }
                switch (this.mode) {
                    case SET_TERRAIN: {
                        dimension.setTerrainAt(x, y, Terrain.VALUES[valueOut]);
                        continue block17;
                    }
                    case SET: {
                        if (bitLayer) {
                            dimension.setBitLayerValueAt(this.layer, x, y, valueOut != 0);
                            continue block17;
                        }
                        dimension.setLayerValueAt(this.layer, x, y, valueOut);
                        continue block17;
                    }
                    case SET_WHEN_HIGHER: {
                        if (bitLayer) {
                            if (valueOut == 0) continue block17;
                            dimension.setBitLayerValueAt(this.layer, x, y, true);
                            continue block17;
                        }
                        if (dimension.getLayerValueAt(this.layer, x, y) >= valueOut) continue block17;
                        dimension.setLayerValueAt(this.layer, x, y, valueOut);
                        continue block17;
                    }
                    case SET_WHEN_LOWER: {
                        if (bitLayer) {
                            if (valueOut != 0) continue block17;
                            dimension.setBitLayerValueAt(this.layer, x, y, false);
                            continue block17;
                        }
                        if (dimension.getLayerValueAt(this.layer, x, y) <= valueOut) continue block17;
                        dimension.setLayerValueAt(this.layer, x, y, valueOut);
                    }
                }
            }
        }
        return null;
    }

    private void validateRGB(int red, int green, int blue) throws ScriptException {
        if (red < 0 || red > 255) {
            throw new ScriptException("Invalid red value " + red + " specified");
        }
        if (green < 0 || green > 255) {
            throw new ScriptException("Invalid green value " + green + " specified");
        }
        if (blue < 0 || blue > 255) {
            throw new ScriptException("Invalid blue value " + blue + " specified");
        }
    }

    private void mapStoredValuesTo(int value) {
        if (this.storedColour >= 0L) {
            this.colourMapping.put((int)this.storedColour, value);
            this.storedColour = -1L;
        } else {
            for (int i = this.storedLowerFrom; i <= this.storedUpperFrom; ++i) {
                this.mapping[i] = value;
            }
        }
    }

    static enum Mode {
        SET,
        SET_WHEN_LOWER,
        SET_WHEN_HIGHER,
        SET_TERRAIN;

    }
}

