/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class InstallCustomTerrainOp
extends AbstractOperation<Integer> {
    private final MixedMaterial terrain;
    private World2 world;
    private int index = 0;

    public InstallCustomTerrainOp(ScriptingContext context, MixedMaterial terrain) throws ScriptException {
        super(context);
        if (terrain == null) {
            throw new ScriptException("terrain may not be null");
        }
        this.terrain = terrain;
    }

    public InstallCustomTerrainOp toWorld(World2 world) {
        this.world = world;
        return this;
    }

    public InstallCustomTerrainOp inSlot(int index) {
        this.index = index;
        return this;
    }

    @Override
    public Integer go() throws ScriptException {
        this.goCalled();
        if (this.world == null) {
            throw new ScriptException("world not set");
        }
        if (this.index > 0) {
            this.world.setMixedMaterial(this.index - 1, this.terrain);
            return Terrain.getCustomTerrain(this.index - 1).ordinal();
        }
        for (int i = 0; i < 96; ++i) {
            if (this.world.getMixedMaterial(i) != null) continue;
            this.world.setMixedMaterial(i, this.terrain);
            return Terrain.getCustomTerrain(i).ordinal();
        }
        throw new ScriptException("No free custom terrain slots");
    }
}

