/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class GetTerrainOp
extends AbstractOperation<MixedMaterial> {
    private String fileName;

    protected GetTerrainOp(ScriptingContext context) {
        super(context);
    }

    public GetTerrainOp fromFile(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MixedMaterial go() throws ScriptException {
        this.goCalled();
        File file = this.sanityCheckFileName(this.fileName);
        try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(file)));){
            MixedMaterial mixedMaterial = (MixedMaterial)in.readObject();
            return mixedMaterial;
        }
        catch (IOException e) {
            throw new ScriptException("I/O error while loading terrain " + this.fileName, e);
        }
        catch (ClassCastException e) {
            throw new ScriptException(this.fileName + " is not a WorldPainter custom terrain file", e);
        }
        catch (ClassNotFoundException e) {
            throw new ScriptException("Class not found exception while loading terrain " + this.fileName + " (not a WorldPainter custom terrain?)", e);
        }
    }
}

