/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.pepsoft.worldpainter.HeightMap;
import org.pepsoft.worldpainter.heightMaps.BitmapHeightMap;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class GetHeightMapOp
extends AbstractOperation<HeightMap> {
    private String fileName;
    private int channel = -1;

    protected GetHeightMapOp(ScriptingContext context) {
        super(context);
    }

    public GetHeightMapOp fromFile(String fileName) throws ScriptException {
        if (fileName == null) {
            throw new ScriptException("fileName may not be null");
        }
        this.fileName = fileName;
        return this;
    }

    public GetHeightMapOp selectRedChannel() {
        this.channel = 0;
        return this;
    }

    public GetHeightMapOp selectGreenChannel() {
        this.channel = 1;
        return this;
    }

    public GetHeightMapOp selectBlueChannel() {
        this.channel = 2;
        return this;
    }

    @Override
    public HeightMap go() throws ScriptException {
        this.goCalled();
        File file = this.sanityCheckFileName(this.fileName);
        try {
            boolean greyscale;
            BufferedImage image = ImageIO.read(file);
            boolean bl = greyscale = image.getType() == 12 || image.getType() == 10;
            if (this.channel == -1) {
                return BitmapHeightMap.build().withName(file.getName()).withImage(image).withFile(file).now();
            }
            if (greyscale) {
                throw new ScriptException("Colour channel selected for grey scale image");
            }
            return BitmapHeightMap.build().withName(file.getName()).withImage(image).withChannel(this.channel).withFile(file).now();
        }
        catch (IOException e) {
            throw new ScriptException("I/O error while loading image " + this.fileName, e);
        }
    }
}

