/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools.scripts;

import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.operations.Filter;
import org.pepsoft.worldpainter.panels.DefaultFilter;
import org.pepsoft.worldpainter.tools.scripts.AbstractOperation;
import org.pepsoft.worldpainter.tools.scripts.ScriptException;
import org.pepsoft.worldpainter.tools.scripts.ScriptingContext;

public class CreateFilterOp
extends AbstractOperation<Filter> {
    private int aboveLevel = Integer.MIN_VALUE;
    private int belowLevel = Integer.MIN_VALUE;
    private int degrees = -1;
    private boolean feather;
    private boolean slopeIsAbove;
    private boolean exceptOnLastSet;
    private boolean inSelection;
    private boolean outsideSelection;
    private Object onlyOn;
    private Object exceptOn;

    public CreateFilterOp(ScriptingContext context) {
        super(context);
    }

    public CreateFilterOp aboveLevel(int aboveLevel) {
        this.aboveLevel = aboveLevel;
        return this;
    }

    public CreateFilterOp belowLevel(int belowLevel) {
        this.belowLevel = belowLevel;
        return this;
    }

    public CreateFilterOp feather() {
        this.feather = true;
        return this;
    }

    public CreateFilterOp onlyOnTerrain(int terrainIndex) throws ScriptException {
        if (this.onlyOn != null) {
            throw new ScriptException("Only one \"only on\" or condition may be specified");
        }
        this.onlyOn = Terrain.VALUES[terrainIndex];
        this.exceptOnLastSet = false;
        return this;
    }

    public CreateFilterOp onlyOnLayer(Layer layer) throws ScriptException {
        if (this.onlyOn != null) {
            throw new ScriptException("Only one \"only on\" or condition may be specified");
        }
        this.onlyOn = layer;
        this.exceptOnLastSet = false;
        return this;
    }

    public CreateFilterOp withValue(int value) throws ScriptException {
        if (this.exceptOnLastSet) {
            if (!(this.exceptOn instanceof Layer)) {
                throw new ScriptException("No \"except on\" layer selected for \"with value\", or more than one \"with value\" specified");
            }
            if (((Layer)this.exceptOn).getDataSize() == Layer.DataSize.BIT || ((Layer)this.exceptOn).getDataSize() == Layer.DataSize.BIT_PER_CHUNK || ((Layer)this.exceptOn).getDataSize() == Layer.DataSize.NONE) {
                throw new ScriptException("A value may only be specified for continuous or discrete layer types");
            }
            this.exceptOn = new DefaultFilter.LayerValue((Layer)this.exceptOn, value);
        } else {
            if (!(this.onlyOn instanceof Layer)) {
                throw new ScriptException("No \"only on\" layer selected for \"with value\", or more than one \"with value\" specified");
            }
            if (((Layer)this.onlyOn).getDataSize() == Layer.DataSize.BIT || ((Layer)this.onlyOn).getDataSize() == Layer.DataSize.BIT_PER_CHUNK || ((Layer)this.onlyOn).getDataSize() == Layer.DataSize.NONE) {
                throw new ScriptException("A value may only be specified for continuous or discrete layer types");
            }
            this.onlyOn = new DefaultFilter.LayerValue((Layer)this.onlyOn, value);
        }
        return this;
    }

    public CreateFilterOp orHigher() throws ScriptException {
        if (this.exceptOnLastSet) {
            if (this.exceptOn instanceof Layer) {
                throw new ScriptException("No \"except on\" layer value specified for \"or higher\"");
            }
            if (((DefaultFilter.LayerValue)this.exceptOn).condition != null) {
                throw new ScriptException("Only one of \"or lower\" and \"or higher\" may be specified for \"except on\" value");
            }
            this.exceptOn = new DefaultFilter.LayerValue(((DefaultFilter.LayerValue)this.exceptOn).layer, ((DefaultFilter.LayerValue)this.exceptOn).value, DefaultFilter.Condition.HIGHER_THAN_OR_EQUAL);
        } else {
            if (this.onlyOn == null) {
                throw new ScriptException("No \"only on\" layer specified for \"or higher\"");
            }
            if (this.onlyOn instanceof Layer) {
                throw new ScriptException("No \"only on\" layer value specified for \"or higher\"");
            }
            if (((DefaultFilter.LayerValue)this.onlyOn).condition != null) {
                throw new ScriptException("Only one of \"or lower\" and \"or higher\" may be specified for \"only on\" value");
            }
            this.onlyOn = new DefaultFilter.LayerValue(((DefaultFilter.LayerValue)this.onlyOn).layer, ((DefaultFilter.LayerValue)this.onlyOn).value, DefaultFilter.Condition.HIGHER_THAN_OR_EQUAL);
        }
        return this;
    }

    public CreateFilterOp orLower() throws ScriptException {
        if (this.exceptOnLastSet) {
            if (this.exceptOn instanceof Layer) {
                throw new ScriptException("No \"except on\" layer value specified for \"or lower\"");
            }
            if (((DefaultFilter.LayerValue)this.exceptOn).condition != null) {
                throw new ScriptException("Only one of \"or lower\" and \"or higher\" may be specified for \"except on\" value");
            }
            this.exceptOn = new DefaultFilter.LayerValue(((DefaultFilter.LayerValue)this.exceptOn).layer, ((DefaultFilter.LayerValue)this.exceptOn).value, DefaultFilter.Condition.LOWER_THAN_OR_EQUAL);
        } else {
            if (this.onlyOn == null) {
                throw new ScriptException("No \"only on\" layer specified for \"or lower\"");
            }
            if (this.onlyOn instanceof Layer) {
                throw new ScriptException("No \"only on\" layer value specified for \"or lower\"");
            }
            if (((DefaultFilter.LayerValue)this.onlyOn).condition != null) {
                throw new ScriptException("Only one of \"or lower\" and \"or higher\" may be specified for \"only on\" value");
            }
            this.onlyOn = new DefaultFilter.LayerValue(((DefaultFilter.LayerValue)this.onlyOn).layer, ((DefaultFilter.LayerValue)this.onlyOn).value, DefaultFilter.Condition.LOWER_THAN_OR_EQUAL);
        }
        return this;
    }

    public CreateFilterOp onlyOnBiome(int biomeIndex) throws ScriptException {
        if (this.onlyOn != null) {
            throw new ScriptException("Only one \"only on\" or condition may be specified");
        }
        this.onlyOn = new DefaultFilter.LayerValue(Biome.INSTANCE, biomeIndex);
        this.exceptOnLastSet = false;
        return this;
    }

    public CreateFilterOp onlyOnAutoBiome(int biomeIndex) throws ScriptException {
        if (this.onlyOn != null) {
            throw new ScriptException("Only one \"only on\" or condition may be specified");
        }
        this.onlyOn = new DefaultFilter.LayerValue(Biome.INSTANCE, -biomeIndex);
        this.exceptOnLastSet = false;
        return this;
    }

    public CreateFilterOp onlyOnAutoBiomes() throws ScriptException {
        if (this.onlyOn != null) {
            throw new ScriptException("Only one \"only on\" or condition may be specified");
        }
        this.onlyOn = "Automatic Biomes";
        this.exceptOnLastSet = false;
        return this;
    }

    public CreateFilterOp onlyOnWater() throws ScriptException {
        if (this.onlyOn != null) {
            throw new ScriptException("Only one \"only on\" or condition may be specified");
        }
        this.onlyOn = "Water";
        this.exceptOnLastSet = false;
        return this;
    }

    public CreateFilterOp onlyOnLand() throws ScriptException {
        if (this.onlyOn != null) {
            throw new ScriptException("Only one \"only on\" or condition may be specified");
        }
        this.onlyOn = "Land";
        this.exceptOnLastSet = false;
        return this;
    }

    public CreateFilterOp exceptOnTerrain(int terrainIndex) throws ScriptException {
        if (this.exceptOn != null) {
            throw new ScriptException("Only one or \"except on\" condition may be specified");
        }
        this.exceptOn = Terrain.VALUES[terrainIndex];
        this.exceptOnLastSet = true;
        return this;
    }

    public CreateFilterOp exceptOnLayer(Layer layer) throws ScriptException {
        if (this.exceptOn != null) {
            throw new ScriptException("Only one or \"except on\" condition may be specified");
        }
        this.exceptOn = layer;
        this.exceptOnLastSet = true;
        return this;
    }

    public CreateFilterOp exceptOnBiome(int biomeIndex) throws ScriptException {
        if (this.exceptOn != null) {
            throw new ScriptException("Only one or \"except on\" condition may be specified");
        }
        this.exceptOn = new DefaultFilter.LayerValue(Biome.INSTANCE, biomeIndex);
        this.exceptOnLastSet = true;
        return this;
    }

    public CreateFilterOp exceptOnAutoBiome(int biomeIndex) throws ScriptException {
        if (this.exceptOn != null) {
            throw new ScriptException("Only one or \"except on\" condition may be specified");
        }
        this.exceptOn = new DefaultFilter.LayerValue(Biome.INSTANCE, -biomeIndex);
        this.exceptOnLastSet = true;
        return this;
    }

    public CreateFilterOp exceptOnAutoBiomes() throws ScriptException {
        if (this.exceptOn != null) {
            throw new ScriptException("Only one or \"except on\" condition may be specified");
        }
        this.exceptOn = "Automatic Biomes";
        this.exceptOnLastSet = true;
        return this;
    }

    public CreateFilterOp exceptOnWater() throws ScriptException {
        if (this.exceptOn != null) {
            throw new ScriptException("Only one or \"except on\" condition may be specified");
        }
        this.exceptOn = "Water";
        this.exceptOnLastSet = true;
        return this;
    }

    public CreateFilterOp exceptOnLand() throws ScriptException {
        if (this.exceptOn != null) {
            throw new ScriptException("Only one or \"except on\" condition may be specified");
        }
        this.exceptOn = "Land";
        this.exceptOnLastSet = true;
        return this;
    }

    public CreateFilterOp aboveDegrees(int aboveDegrees) throws ScriptException {
        if (aboveDegrees < 0 || aboveDegrees > 90) {
            throw new ScriptException("Degrees must be between 0 and 90 (inclusive)");
        }
        if (this.degrees != -1) {
            throw new ScriptException("aboveDegrees and belowDegrees may not both be specified");
        }
        this.degrees = aboveDegrees;
        this.slopeIsAbove = true;
        return this;
    }

    public CreateFilterOp belowDegrees(int belowDegrees) throws ScriptException {
        if (belowDegrees < 0 || belowDegrees > 90) {
            throw new ScriptException("Degrees must be between 0 and 90 (inclusive)");
        }
        if (this.degrees != -1) {
            throw new ScriptException("aboveDegrees and belowDegrees may not both be specified");
        }
        this.degrees = belowDegrees;
        return this;
    }

    public CreateFilterOp inSelection() throws ScriptException {
        if (this.outsideSelection) {
            throw new ScriptException("inSelection and outsideSelection may not both be specified");
        }
        this.inSelection = true;
        return this;
    }

    public CreateFilterOp outsideSelection() throws ScriptException {
        if (this.inSelection) {
            throw new ScriptException("inSelection and outsideSelection may not both be specified");
        }
        this.outsideSelection = true;
        return this;
    }

    @Override
    public Filter go() throws ScriptException {
        this.goCalled();
        return new DefaultFilter(null, this.inSelection, this.outsideSelection, this.aboveLevel, this.belowLevel, this.feather, this.onlyOn, this.exceptOn, this.degrees, this.slopeIsAbove);
    }
}

