/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jnbt.CompoundTag;
import org.jnbt.ListTag;
import org.jnbt.NBTInputStream;
import org.jnbt.StringTag;
import org.jnbt.Tag;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.MC115AnvilChunk;
import org.pepsoft.minecraft.MC12AnvilChunk;
import org.pepsoft.minecraft.MCRegionChunk;
import org.pepsoft.minecraft.RegionFile;
import org.pepsoft.minecraft.SectionedChunk;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.worldpainter.AbstractTool;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.platforms.JavaPlatformProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;
import org.pepsoft.worldpainter.plugins.PlatformProvider;

public class ScanMap
extends AbstractTool {
    public static void main(String[] args) throws IOException {
        ScanMap.initialisePlatform();
        ScanMap.dumpTileEntities(args);
    }

    private static void dumpTileEntities(String[] args) {
        File worldDir = new File(args[0]);
        PlatformManager platformManager = PlatformManager.getInstance();
        Platform platform = platformManager.identifyPlatform(worldDir);
        ChunkStore chunkStore = platformManager.getChunkStore(platform, worldDir, 0);
        chunkStore.visitChunks(chunk -> {
            List<TileEntity> tileEntities = chunk.getTileEntities();
            if (tileEntities != null) {
                tileEntities.forEach(System.out::println);
            }
            return true;
        });
    }

    private static void findTag(String[] args) throws IOException {
        Platform platform;
        File worldDir = new File(args[0]);
        PlatformManager platformManager = PlatformManager.getInstance();
        PlatformProvider platformProvider = platformManager.getPlatformProvider(platform = platformManager.identifyPlatform(worldDir));
        if (platformProvider instanceof JavaPlatformProvider) {
            JavaPlatformProvider javaPlatformProvider = (JavaPlatformProvider)platformProvider;
            for (DataType dataType : javaPlatformProvider.getDataTypes(platform)) {
                File[] regionFiles = javaPlatformProvider.getRegionFiles(platform, new File(worldDir, "region"), dataType);
                if (regionFiles == null) continue;
                for (File file : regionFiles) {
                    try (RegionFile regionFile = new RegionFile(file, true);){
                        System.out.println("Scanning region " + (Object)((Object)dataType) + ": " + regionFile.getX() + "," + regionFile.getZ());
                        for (int x = 0; x < 32; ++x) {
                            for (int z = 0; z < 32; ++z) {
                                if (!regionFile.containsChunk(x, z)) continue;
                                try (NBTInputStream in = new NBTInputStream((InputStream)regionFile.getChunkDataInputStream(x, z));){
                                    Tag tag = in.readTag();
                                    if (!ScanMap.scanTag(tag, args[1])) continue;
                                    System.out.println('\"' + args[1] + "\" found in chunk: ");
                                    System.out.println(tag);
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static boolean scanTag(Tag tag, String searchString) {
        block6: {
            block7: {
                block5: {
                    if (tag.getName().contains(searchString)) {
                        return true;
                    }
                    if (!(tag instanceof CompoundTag)) break block5;
                    for (Map.Entry entry : ((CompoundTag)tag).getValue().entrySet()) {
                        if (((String)entry.getKey()).contains(searchString)) {
                            return true;
                        }
                        if (!ScanMap.scanTag((Tag)entry.getValue(), searchString)) continue;
                        return true;
                    }
                    break block6;
                }
                if (!(tag instanceof StringTag)) break block7;
                if (((StringTag)tag).getValue().contains(searchString)) {
                    return true;
                }
                break block6;
            }
            if (!(tag instanceof ListTag)) break block6;
            for (Tag value : ((ListTag)tag).getValue()) {
                if (!ScanMap.scanTag(value, searchString)) continue;
                return true;
            }
        }
        return false;
    }

    private static void findTileEntity(String[] args) {
        File worldDir = new File(args[0]);
        PlatformManager platformManager = PlatformManager.getInstance();
        Platform platform = platformManager.identifyPlatform(worldDir);
        ChunkStore chunkStore = platformManager.getChunkStore(platform, worldDir, 0);
        chunkStore.visitChunks(chunk -> {
            if (chunk instanceof SectionedChunk) {
                SectionedChunk sectionedChunk = (SectionedChunk)chunk;
                for (SectionedChunk.Section section : sectionedChunk.getSections()) {
                    List<TileEntity> tileEntities;
                    if (section == null || (tileEntities = chunk.getTileEntities()) == null) continue;
                    for (TileEntity tileEntity : tileEntities) {
                        if (!tileEntity.getId().equals(args[1])) continue;
                        System.out.println("Sign found @ " + tileEntity.getX() + "," + tileEntity.getY() + "," + tileEntity.getZ() + ": " + tileEntity);
                        System.out.println("Text2 in base 64: " + Base64.getEncoder().encodeToString(((StringTag)tileEntity.toNBT().getTag("Text2")).getValue().getBytes(StandardCharsets.UTF_8)));
                    }
                }
                return true;
            }
            throw new UnsupportedOperationException("Non sectioned chunks not yet supported");
        });
    }

    private static void dumpChunks(String[] args) {
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE};
        Map statusMap = Collections.synchronizedMap(new HashMap());
        Set heightmapTypes = Collections.synchronizedSet(new HashSet());
        File worldDir = new File(args[0]);
        PlatformManager platformManager = PlatformManager.getInstance();
        Platform platform = platformManager.identifyPlatform(worldDir);
        ChunkStore chunkStore = platformManager.getChunkStore(platform, worldDir, 0);
        chunkStore.visitChunks(chunk -> {
            String status = "???";
            if (chunk instanceof MC115AnvilChunk) {
                status = ((MC115AnvilChunk)chunk).getStatus();
                heightmapTypes.addAll(((MC115AnvilChunk)chunk).getHeightMaps().keySet());
            } else if (chunk instanceof MC12AnvilChunk) {
                status = "112";
            } else if (chunk instanceof MCRegionChunk) {
                status = "MCR";
            }
            int[] nArray = bounds;
            synchronized (bounds) {
                if (chunk.getxPos() < bounds[0]) {
                    bounds[0] = chunk.getxPos();
                }
                if (chunk.getxPos() > bounds[1]) {
                    bounds[1] = chunk.getxPos();
                }
                if (chunk.getzPos() < bounds[2]) {
                    bounds[2] = chunk.getzPos();
                }
                if (chunk.getzPos() > bounds[3]) {
                    bounds[3] = chunk.getzPos();
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                statusMap.put(new Point(chunk.getxPos(), chunk.getzPos()), status);
                return true;
            }
        });
        char[] line = new char[(bounds[1] - bounds[0]) * 4 + 3];
        for (int z = bounds[2]; z <= bounds[3]; ++z) {
            Arrays.fill(line, ' ');
            for (int x = bounds[0]; x <= bounds[1]; ++x) {
                Point coords;
                if (x > bounds[0]) {
                    line[(x - bounds[0]) * 4 - 1] = 124;
                }
                if (!statusMap.containsKey(coords = new Point(x, z))) continue;
                String status2 = (String)statusMap.get(coords);
                if (status2 != null) {
                    line[(x - bounds[0]) * 4] = status2.charAt(0);
                    line[(x - bounds[0]) * 4 + 1] = status2.charAt(1);
                    line[(x - bounds[0]) * 4 + 2] = status2.charAt(2);
                    continue;
                }
                line[(x - bounds[0]) * 4] = 88;
                line[(x - bounds[0]) * 4 + 1] = 88;
                line[(x - bounds[0]) * 4 + 2] = 88;
            }
            System.out.println(String.valueOf(line));
        }
        System.out.println("Statuses:");
        statusMap.values().stream().sorted().distinct().forEach(status -> System.out.println(status.substring(0, 3) + " -> " + status));
        System.out.println("XXX -> Chunk present but no status");
        System.out.println("Height map types encountered: " + heightmapTypes);
    }
}

