/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.IntTag;
import org.jnbt.ListTag;
import org.jnbt.NBTInputStream;
import org.jnbt.NBTOutputStream;
import org.jnbt.ShortTag;
import org.jnbt.Tag;

public class RespawnPlayer {
    public static void respawnPlayer(File levelDatFile) throws IOException {
        CompoundTag outerTag;
        try (NBTInputStream in = new NBTInputStream((InputStream)new GZIPInputStream(new FileInputStream(levelDatFile)));){
            outerTag = (CompoundTag)in.readTag();
        }
        CompoundTag dataTag = (CompoundTag)outerTag.getTag("Data");
        int spawnX = ((IntTag)dataTag.getTag("SpawnX")).getValue();
        int spawnY = ((IntTag)dataTag.getTag("SpawnY")).getValue();
        int spawnZ = ((IntTag)dataTag.getTag("SpawnZ")).getValue();
        CompoundTag playerTag = (CompoundTag)dataTag.getTag("Player");
        playerTag.setTag("DeathTime", (Tag)new ShortTag("DeathTime", 0));
        playerTag.setTag("Health", (Tag)new ShortTag("Health", 20));
        ArrayList<DoubleTag> motionList = new ArrayList<DoubleTag>(3);
        motionList.add(new DoubleTag(null, 0.0));
        motionList.add(new DoubleTag(null, 0.0));
        motionList.add(new DoubleTag(null, 0.0));
        playerTag.setTag("Motion", (Tag)new ListTag("Motion", DoubleTag.class, motionList));
        ArrayList<DoubleTag> posList = new ArrayList<DoubleTag>(3);
        posList.add(new DoubleTag(null, (double)spawnX + 0.5));
        posList.add(new DoubleTag(null, (double)(spawnY + 3)));
        posList.add(new DoubleTag(null, (double)spawnZ + 0.5));
        playerTag.setTag("Pos", (Tag)new ListTag("Pos", DoubleTag.class, posList));
        try (NBTOutputStream out = new NBTOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(levelDatFile)));){
            out.writeTag((Tag)outerTag);
        }
    }
}

