/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.World2;

public class IntegrityChecker {
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        World2 world;
        System.out.println("Loading " + args[0]);
        try (ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(args[0])));){
            world = (World2)in.readObject();
        }
        for (Dimension dimension : world.getDimensions()) {
            float minHeight = (float)dimension.getMinHeight() - 0.5f;
            float maxHeight = (float)(dimension.getMaxHeight() - 1) + 0.5f;
            System.out.println("Checking integrity of " + dimension.getName() + " dimension");
            for (Tile tile : dimension.getTiles()) {
                boolean tileReported = false;
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        float height = tile.getHeight(x, y);
                        if (height < minHeight) {
                            if (!tileReported) {
                                System.out.println("Tile " + tile.getX() + "," + tile.getY());
                                tileReported = true;
                            }
                            System.out.println("Height " + height + " < " + minHeight + " @ " + x + "," + y);
                            continue;
                        }
                        if (!(height > maxHeight)) continue;
                        if (!tileReported) {
                            System.out.println("Tile " + tile.getX() + "," + tile.getY());
                            tileReported = true;
                        }
                        System.out.println("Height " + height + " > " + maxHeight + " @ " + x + "," + y);
                    }
                }
            }
        }
    }
}

