/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.util.HashMap;
import org.pepsoft.minecraft.DataType;
import org.pepsoft.minecraft.MinecraftCoords;
import org.pepsoft.worldpainter.AbstractTool;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.platforms.JavaPlatformProvider;
import org.pepsoft.worldpainter.plugins.PlatformManager;

public class DumpRegions
extends AbstractTool {
    public static void main(String[] args) {
        DumpRegions.initialisePlatform();
        File worldDir = new File(args[0]);
        PlatformManager platformManager = PlatformManager.getInstance();
        Platform platform = platformManager.identifyPlatform(worldDir);
        JavaPlatformProvider platformProvider = (JavaPlatformProvider)platformManager.getPlatformProvider(platform);
        File[] regionFiles = platformProvider.getRegionFiles(platform, new File(worldDir, "region"), DataType.REGION);
        if (regionFiles == null) {
            return;
        }
        int lowestX = Integer.MAX_VALUE;
        int highestX = Integer.MIN_VALUE;
        int lowestZ = Integer.MAX_VALUE;
        int highestZ = Integer.MIN_VALUE;
        HashMap<MinecraftCoords, File> regions = new HashMap<MinecraftCoords, File>();
        for (File file : regionFiles) {
            String[] parts = file.getName().split("\\.");
            int x = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            regions.put(new MinecraftCoords(x, z), file);
            if (x < lowestX) {
                lowestX = x;
            }
            if (x > highestX) {
                highestX = x;
            }
            if (z < lowestZ) {
                lowestZ = z;
            }
            if (z <= highestZ) continue;
            highestZ = z;
        }
        for (int z = lowestZ; z <= highestZ; ++z) {
            for (int x = lowestX; x <= highestX; ++x) {
                MinecraftCoords key = new MinecraftCoords(x, z);
                if (regions.containsKey(key)) {
                    if (((File)regions.get(key)).length() == 0L) {
                        System.out.print("[ len==0]");
                        continue;
                    }
                    System.out.printf("[%3d,%3d]", x, z);
                    continue;
                }
                System.out.print("         ");
            }
            System.out.println();
        }
    }
}

