/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import org.pepsoft.minecraft.Block;
import org.pepsoft.minecraft.JavaLevel;
import org.pepsoft.minecraft.MC12AnvilChunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.SuperflatGenerator;
import org.pepsoft.minecraft.SuperflatPreset;
import org.pepsoft.util.FileUtils;
import org.pepsoft.util.ObjectMapperHolder;
import org.pepsoft.worldpainter.Configuration;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.exporting.JavaMinecraftWorld;
import org.pepsoft.worldpainter.plugins.WPPluginManager;
import org.pepsoft.worldpainter.util.MinecraftUtil;

public class BlockNameHarvester {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        try {
            Class.forName("org.pepsoft.worldpainter.DefaultPlugin");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Configuration config = Configuration.load();
        if (config == null) {
            System.out.println("Creating new configuration");
            config = new Configuration();
        }
        Configuration.setInstance(config);
        System.out.println("Installation ID: " + config.getUuid());
        WPPluginManager.initialise(config.getUuid());
        if (args[0].equals("--create")) {
            File savesDir = new File(MinecraftUtil.findMinecraftDir(), "saves");
            File worldDir = new File(savesDir, "BlockNames");
            if (worldDir.isDirectory()) {
                FileUtils.deleteDir((File)worldDir);
            }
            JavaLevel level = JavaLevel.create(DefaultPlugin.JAVA_ANVIL, 0, 256);
            level.setSeed(0L);
            level.setName("BlockNames");
            level.setGameType(1);
            level.setHardcore(false);
            level.setDifficulty(0);
            level.setAllowCommands(true);
            level.setMapFeatures(false);
            level.setGenerator(0, new SuperflatGenerator(SuperflatPreset.defaultPreset(DefaultPlugin.JAVA_ANVIL)));
            level.setSpawnX(0);
            level.setSpawnY(5);
            level.setSpawnZ(0);
            level.save(worldDir);
            File regionDir = new File(worldDir, "region");
            regionDir.mkdirs();
            JavaMinecraftWorld world = new JavaMinecraftWorld(worldDir, 0, 0, 256, DefaultPlugin.JAVA_ANVIL, false, 256);
            try {
                for (int x = -32; x < 32; ++x) {
                    for (int z = -32; z < 32; ++z) {
                        if (x % 16 == 0 && z % 16 == 0) {
                            world.addChunk(new MC12AnvilChunk(x >> 4, z >> 4, 256));
                        }
                        world.setMaterialAt(x, z, 0, Material.BEDROCK);
                        world.setMaterialAt(x, z, 1, Material.DIRT);
                        world.setMaterialAt(x, z, 2, Material.DIRT);
                        world.setMaterialAt(x, z, 3, Material.GRASS_BLOCK);
                        int index = z + 32 + 64 * (x + 32);
                        int blockId = index >> 4;
                        if (blockId == 36 || blockId == 253 || blockId == 254 || blockId == 8 || blockId == 9 || blockId == 10 || blockId == 11 || blockId == 51) continue;
                        world.setMaterialAt(x, z, 4, Material.getByCombinedIndex(index));
                        if (blockId == 81) {
                            world.setMaterialAt(x, z, 3, Material.SAND);
                            continue;
                        }
                        if (!Block.BLOCKS[blockId].vegetation) continue;
                        world.setMaterialAt(x, z, 3, Material.FARMLAND);
                    }
                }
            }
            finally {
                world.flush();
            }
        }
        if (args[0].equals("--scan")) {
            ArrayList blockSpecs = new ArrayList();
            File savesDir = new File(MinecraftUtil.findMinecraftDir(), "saves");
            File worldDir = new File(savesDir, "BlockNames");
            JavaMinecraftWorld world = new JavaMinecraftWorld(worldDir, 0, 0, 256, DefaultPlugin.JAVA_ANVIL_1_15, true, 256);
            for (int x = -32; x < 32; ++x) {
                for (int z = -32; z < 32; ++z) {
                    int index = z + 32 + 64 * (x + 32);
                    int blockId = index >> 4;
                    int dataValue = index & 0xF;
                    Material material = world.getMaterialAt(x, z, 4);
                    System.out.printf("%s:%d -> %s%n", Block.BLOCKS[blockId].name, dataValue, material.toString());
                    if (material == Material.AIR && (blockId != 0 || dataValue != 0)) continue;
                    HashMap<String, Object> blockSpec = new HashMap<String, Object>();
                    blockSpec.put("blockId", blockId);
                    blockSpec.put("dataValue", dataValue);
                    blockSpec.put("name", material.name);
                    if (material.getProperties() != null) {
                        blockSpec.put("properties", material.getProperties());
                    }
                    blockSpecs.add(blockSpec);
                }
            }
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream("legacy-mc-blocks.json"), StandardCharsets.UTF_8);){
                ObjectMapperHolder.OBJECT_MAPPER.writeValue((Writer)out, blockSpecs);
            }
        }
    }
}

