/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes.impl.fancy;

import java.util.HashSet;
import java.util.Random;
import javax.vecmath.Point3i;
import org.pepsoft.util.undo.UndoManager;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.gardenofeden.Garden;
import org.pepsoft.worldpainter.themes.impl.fancy.RiverNode;

public class RiverGenerator {
    private final Dimension dimension;
    private final int minHeight;
    private Dimension snapshot;
    private Garden garden;

    public RiverGenerator(Dimension dimension) {
        this.dimension = dimension;
        this.minHeight = dimension.getMinHeight();
    }

    public void generateRivers() {
        this.dimension.setEventsInhibited(true);
        UndoManager undoManager = new UndoManager(2);
        this.dimension.registerUndoManager(undoManager);
        this.snapshot = this.dimension.getSnapshot();
        this.dimension.armSavePoint();
        this.garden = this.dimension.getGarden();
        try {
            this.dimension.getTiles().forEach(this::generateRivers);
            while (!this.garden.tick()) {
            }
            this.dimension.getGarden().getSeeds().stream().filter(seed -> seed instanceof RiverNode && seed.getParent() == null).forEach(seed -> ((RiverNode)seed).apply(this.dimension, this.snapshot, new HashSet<RiverNode>()));
        }
        finally {
            this.garden = null;
            this.snapshot = null;
            this.dimension.unregisterUndoManager();
            this.dimension.setEventsInhibited(false);
        }
    }

    public void generateRivers(Tile tile) {
        long seed = this.dimension.getSeed() + (long)(tile.getX() * 65537) + (long)tile.getY();
        Random random = new Random(seed);
        for (int x = 0; x < 128; ++x) {
            for (int y = 0; y < 128; ++y) {
                if (random.nextInt(1000) != 0) continue;
                this.generateRiver(tile.getX() << 7 | x, tile.getY() << 7 | y);
            }
        }
    }

    public void generateRiver(int x, int y) {
        float height;
        int intHeight;
        int waterLevel = this.snapshot.getWaterLevelAt(x, y);
        if (waterLevel <= (intHeight = Math.round(height = this.snapshot.getHeightAt(x, y)))) {
            this.garden.plantSeed(new RiverNode(this.garden, new Point3i(x, y, -1), 1));
        }
    }

    public int getLowestSurroundingDryHeight(int x, int y) {
        int lowestSurroundingDryHeight = Integer.MAX_VALUE;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                int height;
                if (dx == 0 && dy == 0 || (height = this.snapshot.getIntHeightAt(x + dx, y + dy)) < this.snapshot.getWaterLevelAt(x + dx, y + dy) || height >= lowestSurroundingDryHeight) continue;
                if (height == this.minHeight) {
                    return this.minHeight;
                }
                lowestSurroundingDryHeight = height;
            }
        }
        return lowestSurroundingDryHeight;
    }

    public int getLowestSurroundingWaterLevel(int x, int y) {
        int lowestSurroundingWaterLevel = Integer.MAX_VALUE;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                int waterLevel;
                if (dx == 0 && dy == 0 || (waterLevel = this.snapshot.getWaterLevelAt(x + dx, y + dy)) <= this.snapshot.getIntHeightAt(x + dx, y + dy) || waterLevel >= lowestSurroundingWaterLevel) continue;
                if (waterLevel == this.minHeight) {
                    return this.minHeight;
                }
                lowestSurroundingWaterLevel = waterLevel;
            }
        }
        return lowestSurroundingWaterLevel;
    }
}

