/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.themes;

import org.pepsoft.worldpainter.themes.Filter;

public class HeightFilter
implements Filter {
    private final int start;
    private final int fullStart;
    private final int end;
    private final int fullEnd;
    private final int startHeight;
    private final int stopHeight;
    private final boolean feather;
    private static final long serialVersionUID = 1L;

    public HeightFilter(int minHeight, int maxHeight, int startHeight, int stopHeight, boolean feather) {
        this.startHeight = startHeight;
        this.stopHeight = stopHeight;
        this.feather = feather;
        if (feather) {
            if (startHeight > minHeight) {
                this.start = Math.max(startHeight - 2, minHeight);
                this.fullStart = startHeight + 2;
            } else {
                this.start = minHeight;
                this.fullStart = minHeight;
            }
            if (stopHeight < maxHeight - 1) {
                this.fullEnd = stopHeight - 2;
                this.end = Math.min(stopHeight + 2, maxHeight - 1);
            } else {
                this.fullEnd = maxHeight - 1;
                this.end = maxHeight - 1;
            }
        } else {
            this.start = this.fullStart = startHeight;
            this.end = this.fullEnd = stopHeight;
        }
    }

    @Override
    public int getLevel(int x, int y, int z, int inputLevel) {
        if (z < this.start || z > this.end) {
            return 0;
        }
        if (z < this.fullStart) {
            return inputLevel - (this.fullStart - z) * inputLevel / (this.fullStart - this.start + 1);
        }
        if (z <= this.fullEnd) {
            return inputLevel;
        }
        return inputLevel - (z - this.fullEnd) * inputLevel / (this.end - this.fullEnd + 1);
    }

    public int getStartHeight() {
        return this.startHeight;
    }

    public int getStopHeight() {
        return this.stopHeight;
    }

    public boolean isFeather() {
        return this.feather;
    }
}

