/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.plugins;

import java.io.File;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.InvalidPathException;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipException;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.ChunkStore;
import org.pepsoft.util.ExceptionUtils;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.World2;
import org.pepsoft.worldpainter.exporting.PostProcessor;
import org.pepsoft.worldpainter.exporting.WorldExportSettings;
import org.pepsoft.worldpainter.exporting.WorldExporter;
import org.pepsoft.worldpainter.plugins.AbstractProviderManager;
import org.pepsoft.worldpainter.plugins.BlockBasedPlatformProvider;
import org.pepsoft.worldpainter.plugins.PlatformProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformManager
extends AbstractProviderManager<Platform, PlatformProvider> {
    private static final PlatformManager INSTANCE = new PlatformManager();
    private static final Logger logger = LoggerFactory.getLogger(PlatformManager.class);

    private PlatformManager() {
        super(PlatformProvider.class);
    }

    public List<Platform> getAllPlatforms() {
        return this.getKeys();
    }

    public PlatformProvider getPlatformProvider(Platform platform) {
        return (PlatformProvider)this.getImplementation(platform);
    }

    public Chunk createChunk(Platform platform, int x, int z, int minHeight, int maxHeight) {
        return ((BlockBasedPlatformProvider)this.getImplementation(platform)).createChunk(platform, x, z, minHeight, maxHeight);
    }

    public ChunkStore getChunkStore(Platform platform, File worldDir, int dimension) {
        return ((BlockBasedPlatformProvider)this.getImplementation(platform)).getChunkStore(platform, worldDir, dimension);
    }

    public WorldExporter getExporter(World2 world, WorldExportSettings exportSettings) {
        return ((PlatformProvider)this.getImplementation(world.getPlatform())).getExporter(world, exportSettings);
    }

    public File getDefaultExportDir(Platform platform) {
        return ((PlatformProvider)this.getImplementation(platform)).getDefaultExportDir(platform);
    }

    public PostProcessor getPostProcessor(Platform platform) {
        return ((BlockBasedPlatformProvider)this.getImplementation(platform)).getPostProcessor(platform);
    }

    public Platform identifyPlatform(File worldDir) {
        PlatformProvider.MapInfo mapInfo = this.identifyMap(worldDir);
        return mapInfo != null ? mapInfo.platform : null;
    }

    public PlatformProvider.MapInfo identifyMap(File worldDir) {
        HashSet<PlatformProvider.MapInfo> candidates = new HashSet<PlatformProvider.MapInfo>();
        for (PlatformProvider provider : this.getImplementations()) {
            try {
                PlatformProvider.MapInfo mapInfo2 = provider.identifyMap(worldDir);
                if (mapInfo2 == null) continue;
                candidates.add(mapInfo2);
            }
            catch (RuntimeException e) {
                if (ExceptionUtils.chainContains((Throwable)e, ClosedByInterruptException.class) || ExceptionUtils.chainContains((Throwable)e, InvalidPathException.class) || ExceptionUtils.chainContains((Throwable)e, ZipException.class)) {
                    logger.debug("{} while asking provider {} to identify {}; skipping platform", new Object[]{e.getClass().getSimpleName(), provider.getClass().getName(), worldDir, e});
                    continue;
                }
                logger.warn("{} while asking provider {} to identify {}; skipping platform", new Object[]{e.getClass().getSimpleName(), provider.getClass().getName(), worldDir, e});
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (PlatformProvider.MapInfo)candidates.iterator().next();
        }
        HashSet defaultCandidates = new HashSet();
        HashSet pluginCandidates = new HashSet();
        candidates.forEach(mapInfo -> {
            if (DefaultPlugin.DEFAULT_JAVA_PLATFORMS.contains(mapInfo.platform)) {
                defaultCandidates.add(mapInfo);
            } else {
                pluginCandidates.add(mapInfo);
            }
        });
        if (pluginCandidates.size() == 1) {
            return (PlatformProvider.MapInfo)pluginCandidates.iterator().next();
        }
        if (pluginCandidates.size() > 1) {
            throw new RuntimeException("Multiple platform providers (" + pluginCandidates + ") claimed support for this map");
        }
        for (int i = DefaultPlugin.DEFAULT_JAVA_PLATFORMS.size() - 1; i >= 0; --i) {
            Platform platform = DefaultPlugin.DEFAULT_JAVA_PLATFORMS.get(i);
            List mapInfos = defaultCandidates.stream().filter(mapInfo -> mapInfo.platform == platform).collect(Collectors.toList());
            if (mapInfos.isEmpty()) continue;
            return (PlatformProvider.MapInfo)mapInfos.get(0);
        }
        throw new InternalError("Should never happen");
    }

    public static PlatformManager getInstance() {
        return INSTANCE;
    }
}

