/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.ExportSettings;
import org.pepsoft.worldpainter.exporting.ExportSettingsEditor;
import org.pepsoft.worldpainter.platforms.JavaExportSettings;

public class JavaExportSettingsEditor
extends ExportSettingsEditor {
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private ButtonGroup buttonGroup5;
    private JCheckBox checkBoxBlockLight;
    private JCheckBox checkBoxLavaFlow;
    private JCheckBox checkBoxLeafDistance;
    private JCheckBox checkBoxMakeAllLeavesPersistent;
    private JCheckBox checkBoxRemoveFloatingLeaves;
    private JCheckBox checkBoxRemovePlants;
    private JCheckBox checkBoxSkyLight;
    private JCheckBox checkBoxWaterFlow;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JRadioButton radioButtonCementDrop;
    private JRadioButton radioButtonCementFloat;
    private JRadioButton radioButtonCementSupport;
    private JRadioButton radioButtonGravelDrop;
    private JRadioButton radioButtonGravelFloat;
    private JRadioButton radioButtonGravelSupport;
    private JRadioButton radioButtonLavaDrop;
    private JRadioButton radioButtonLavaFloat;
    private JRadioButton radioButtonSandDrop;
    private JRadioButton radioButtonSandFloat;
    private JRadioButton radioButtonSandSupport;
    private JRadioButton radioButtonWaterDrop;
    private JRadioButton radioButtonWaterFloat;
    private final Platform platform;

    public JavaExportSettingsEditor(Platform platform) {
        this.platform = platform;
        this.initComponents();
    }

    @Override
    public void setExportSettings(ExportSettings exportSettings) {
        JavaExportSettings javaSettings = (JavaExportSettings)exportSettings;
        switch (javaSettings.waterMode) {
            case LEAVE_FLOATING: {
                this.radioButtonWaterFloat.setSelected(true);
                break;
            }
            case DROP: {
                this.radioButtonWaterDrop.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid water mode " + (Object)((Object)javaSettings.waterMode));
            }
        }
        switch (javaSettings.lavaMode) {
            case LEAVE_FLOATING: {
                this.radioButtonLavaFloat.setSelected(true);
                break;
            }
            case DROP: {
                this.radioButtonLavaDrop.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid lava mode " + (Object)((Object)javaSettings.lavaMode));
            }
        }
        switch (javaSettings.sandMode) {
            case LEAVE_FLOATING: {
                this.radioButtonSandFloat.setSelected(true);
                break;
            }
            case DROP: {
                this.radioButtonSandDrop.setSelected(true);
                break;
            }
            case SUPPORT: {
                this.radioButtonSandSupport.setSelected(true);
            }
        }
        switch (javaSettings.gravelMode) {
            case LEAVE_FLOATING: {
                this.radioButtonGravelFloat.setSelected(true);
                break;
            }
            case DROP: {
                this.radioButtonGravelDrop.setSelected(true);
                break;
            }
            case SUPPORT: {
                this.radioButtonGravelSupport.setSelected(true);
            }
        }
        switch (javaSettings.cementMode) {
            case LEAVE_FLOATING: {
                this.radioButtonCementFloat.setSelected(true);
                break;
            }
            case DROP: {
                this.radioButtonCementDrop.setSelected(true);
                break;
            }
            case SUPPORT: {
                this.radioButtonCementSupport.setSelected(true);
            }
        }
        this.checkBoxWaterFlow.setSelected(javaSettings.flowWater);
        this.checkBoxLavaFlow.setSelected(javaSettings.flowLava);
        this.checkBoxSkyLight.setSelected(javaSettings.calculateSkyLight);
        this.checkBoxBlockLight.setSelected(javaSettings.calculateBlockLight);
        this.checkBoxLeafDistance.setSelected(javaSettings.calculateLeafDistance);
        this.checkBoxRemoveFloatingLeaves.setSelected(javaSettings.removeFloatingLeaves);
        this.checkBoxMakeAllLeavesPersistent.setSelected(javaSettings.makeAllLeavesPersistent);
        this.checkBoxRemovePlants.setSelected(javaSettings.isRemovePlants());
        this.setControlStates();
    }

    @Override
    public JavaExportSettings getExportSettings() {
        return new JavaExportSettings(this.radioButtonWaterFloat.isSelected() ? JavaExportSettings.FloatMode.LEAVE_FLOATING : JavaExportSettings.FloatMode.DROP, this.radioButtonLavaFloat.isSelected() ? JavaExportSettings.FloatMode.LEAVE_FLOATING : JavaExportSettings.FloatMode.DROP, this.radioButtonSandFloat.isSelected() ? JavaExportSettings.FloatMode.LEAVE_FLOATING : (this.radioButtonSandSupport.isSelected() ? JavaExportSettings.FloatMode.SUPPORT : JavaExportSettings.FloatMode.DROP), this.radioButtonGravelFloat.isSelected() ? JavaExportSettings.FloatMode.LEAVE_FLOATING : (this.radioButtonGravelSupport.isSelected() ? JavaExportSettings.FloatMode.SUPPORT : JavaExportSettings.FloatMode.DROP), this.radioButtonCementFloat.isSelected() ? JavaExportSettings.FloatMode.LEAVE_FLOATING : (this.radioButtonCementSupport.isSelected() ? JavaExportSettings.FloatMode.SUPPORT : JavaExportSettings.FloatMode.DROP), this.checkBoxWaterFlow.isSelected(), this.checkBoxLavaFlow.isSelected(), this.checkBoxSkyLight.isSelected(), this.checkBoxBlockLight.isSelected(), this.checkBoxLeafDistance.isSelected(), this.checkBoxLeafDistance.isSelected() && this.checkBoxRemoveFloatingLeaves.isSelected(), this.checkBoxMakeAllLeavesPersistent.isSelected(), this.checkBoxRemovePlants.isSelected());
    }

    private void setControlStates() {
        this.checkBoxSkyLight.setEnabled(this.platform.capabilities.contains((Object)Platform.Capability.PRECALCULATED_LIGHT));
        this.checkBoxBlockLight.setEnabled(this.platform.capabilities.contains((Object)Platform.Capability.PRECALCULATED_LIGHT));
        this.checkBoxLeafDistance.setEnabled(this.platform.capabilities.contains((Object)Platform.Capability.NAME_BASED));
        this.checkBoxRemoveFloatingLeaves.setEnabled(this.platform.capabilities.contains((Object)Platform.Capability.NAME_BASED) && this.checkBoxLeafDistance.isSelected());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.buttonGroup5 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.radioButtonWaterFloat = new JRadioButton();
        this.radioButtonWaterDrop = new JRadioButton();
        this.checkBoxWaterFlow = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.radioButtonLavaFloat = new JRadioButton();
        this.radioButtonLavaDrop = new JRadioButton();
        this.checkBoxLavaFlow = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.radioButtonGravelFloat = new JRadioButton();
        this.radioButtonGravelSupport = new JRadioButton();
        this.radioButtonGravelDrop = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.radioButtonCementFloat = new JRadioButton();
        this.radioButtonCementSupport = new JRadioButton();
        this.radioButtonCementDrop = new JRadioButton();
        this.radioButtonSandFloat = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.radioButtonSandSupport = new JRadioButton();
        this.radioButtonSandDrop = new JRadioButton();
        this.checkBoxLeafDistance = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.checkBoxRemoveFloatingLeaves = new JCheckBox();
        this.checkBoxSkyLight = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.checkBoxBlockLight = new JCheckBox();
        this.checkBoxMakeAllLeavesPersistent = new JCheckBox();
        this.checkBoxRemovePlants = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.jLabel1.setText("Water:");
        this.buttonGroup1.add(this.radioButtonWaterFloat);
        this.radioButtonWaterFloat.setText("leave floating");
        this.buttonGroup1.add(this.radioButtonWaterDrop);
        this.radioButtonWaterDrop.setText("drop");
        this.checkBoxWaterFlow.setText("make unbounded water flow");
        this.jLabel2.setText("Lava:");
        this.buttonGroup2.add(this.radioButtonLavaFloat);
        this.radioButtonLavaFloat.setText("leave floating");
        this.buttonGroup2.add(this.radioButtonLavaDrop);
        this.radioButtonLavaDrop.setText("drop");
        this.checkBoxLavaFlow.setText("make unbounded lava flow");
        this.jLabel3.setText("Gravel:");
        this.buttonGroup3.add(this.radioButtonGravelFloat);
        this.radioButtonGravelFloat.setText("leave floating");
        this.buttonGroup3.add(this.radioButtonGravelSupport);
        this.radioButtonGravelSupport.setText("support with stone");
        this.buttonGroup3.add(this.radioButtonGravelDrop);
        this.radioButtonGravelDrop.setText("drop");
        this.jLabel4.setText("Cement:");
        this.buttonGroup4.add(this.radioButtonCementFloat);
        this.radioButtonCementFloat.setText("leave floating");
        this.buttonGroup4.add(this.radioButtonCementSupport);
        this.radioButtonCementSupport.setText("support with stone");
        this.buttonGroup4.add(this.radioButtonCementDrop);
        this.radioButtonCementDrop.setText("drop");
        this.buttonGroup5.add(this.radioButtonSandFloat);
        this.radioButtonSandFloat.setText("leave floating");
        this.jLabel5.setText("Sand:");
        this.buttonGroup5.add(this.radioButtonSandSupport);
        this.radioButtonSandSupport.setText("support with sandstone");
        this.buttonGroup5.add(this.radioButtonSandDrop);
        this.radioButtonSandDrop.setText("drop");
        this.checkBoxLeafDistance.setText("calculate distance property");
        this.checkBoxLeafDistance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaExportSettingsEditor.this.checkBoxLeafDistanceActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Leaves:");
        this.checkBoxRemoveFloatingLeaves.setText("remove floating leaf blocks");
        this.checkBoxSkyLight.setText("calculate sky light");
        this.jLabel7.setText("Light:");
        this.checkBoxBlockLight.setText("calculate block light");
        this.checkBoxMakeAllLeavesPersistent.setText("<html>make <i>all</i> leaves persistent</html>");
        this.checkBoxRemovePlants.setText("remove from invalid blocks or if other half is missing");
        this.jLabel8.setText("Plants:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBoxRemovePlants).addComponent(this.checkBoxMakeAllLeavesPersistent, -2, -1, -2).addComponent(this.checkBoxLeafDistance).addGroup(layout.createSequentialGroup().addComponent(this.checkBoxSkyLight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxBlockLight)).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonSandFloat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonSandSupport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonSandDrop)).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonCementFloat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonCementSupport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonCementDrop)).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonLavaFloat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonLavaDrop)).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonWaterFloat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonWaterDrop)).addComponent(this.checkBoxWaterFlow).addComponent(this.checkBoxLavaFlow).addGroup(layout.createSequentialGroup().addComponent(this.radioButtonGravelFloat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonGravelSupport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButtonGravelDrop)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.checkBoxRemoveFloatingLeaves))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.radioButtonWaterFloat).addComponent(this.radioButtonWaterDrop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxWaterFlow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.radioButtonLavaFloat).addComponent(this.radioButtonLavaDrop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxLavaFlow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonSandFloat).addComponent(this.jLabel5).addComponent(this.radioButtonSandSupport).addComponent(this.radioButtonSandDrop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonGravelFloat).addComponent(this.jLabel3).addComponent(this.radioButtonGravelSupport).addComponent(this.radioButtonGravelDrop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonCementFloat).addComponent(this.jLabel4).addComponent(this.radioButtonCementSupport).addComponent(this.radioButtonCementDrop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxSkyLight).addComponent(this.jLabel7).addComponent(this.checkBoxBlockLight)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxLeafDistance).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxRemoveFloatingLeaves).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkBoxMakeAllLeavesPersistent, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkBoxRemovePlants).addComponent(this.jLabel8)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void checkBoxLeafDistanceActionPerformed(ActionEvent evt) {
        this.setControlStates();
    }
}

