/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.platforms;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.plugins.AbstractPlugin;
import org.pepsoft.worldpainter.plugins.PlatformProvider;

public abstract class AbstractPlatformProvider
extends AbstractPlugin
implements PlatformProvider {
    private final Set<Platform> platforms;

    protected AbstractPlatformProvider(String version, Collection<Platform> platforms, String name) {
        super(name, version);
        this.platforms = ImmutableSet.copyOf(platforms);
    }

    @Override
    public final Collection<Platform> getKeys() {
        return this.platforms;
    }

    protected final void ensurePlatformSupported(Platform platform) {
        if (!this.platforms.contains(platform)) {
            throw new IllegalArgumentException("Platform " + platform + " not supported");
        }
    }
}

