/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.objects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.CollectionUtils;
import org.pepsoft.worldpainter.objects.NamedObjectWithAttributes;
import org.pepsoft.worldpainter.objects.WPObject;

public final class GenericObject
extends NamedObjectWithAttributes {
    private final int dimX;
    private final int dimY;
    private final int dimZ;
    private final Material[] data;
    private final List<Entity> entities;
    private final List<TileEntity> tileEntities;
    private static final long serialVersionUID = 1L;

    public GenericObject(String name, int dimX, int dimY, int dimZ, Material[] data) {
        this(name, dimX, dimY, dimZ, data, null, null, null);
    }

    public GenericObject(String name, int dimX, int dimY, int dimZ, Material[] data, List<Entity> entities, List<TileEntity> tileEntities, Map<String, Serializable> attributes) {
        super(name, attributes != null && !attributes.isEmpty() ? new HashMap<String, Serializable>(attributes) : null);
        this.dimX = dimX;
        this.dimY = dimY;
        this.dimZ = dimZ;
        this.data = Arrays.copyOf(data, data.length);
        this.entities = entities != null && !entities.isEmpty() ? new ArrayList<Entity>(entities) : null;
        List<TileEntity> list = this.tileEntities = tileEntities != null && !tileEntities.isEmpty() ? new ArrayList<TileEntity>(tileEntities) : null;
        if (dimX * dimY * dimZ != data.length) {
            throw new IllegalArgumentException();
        }
    }

    public GenericObject(WPObject object) {
        super(object.getName(), object.getAttributes() != null && !object.getAttributes().isEmpty() ? new HashMap<String, Serializable>(object.getAttributes()) : null);
        Point3i dims = object.getDimensions();
        this.dimX = dims.x;
        this.dimY = dims.y;
        this.dimZ = dims.z;
        this.data = new Material[this.dimX * this.dimY * this.dimY];
        for (int x = 0; x < this.dimX; ++x) {
            for (int y = 0; y < this.dimY; ++y) {
                for (int z = 0; z < this.dimZ; ++z) {
                    if (!object.getMask(x, y, z)) continue;
                    this.data[x + y * this.dimX + z * this.dimX * this.dimY] = object.getMaterial(x, y, z);
                }
            }
        }
        this.entities = CollectionUtils.copyOf(object.getEntities());
        this.tileEntities = CollectionUtils.copyOf(object.getTileEntities());
    }

    @Override
    public Point3i getDimensions() {
        return new Point3i(this.dimX, this.dimY, this.dimZ);
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.data[x + y * this.dimX + z * this.dimX * this.dimY];
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        return this.data[x + y * this.dimX + z * this.dimX * this.dimY] != null;
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }
}

