/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.layers.tunnel.TunnelDimension;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerHelper;

public class TunnelRoofDimension
extends TunnelDimension {
    private final int reflectionPoint;

    public TunnelRoofDimension(Dimension dimension, TunnelLayer layer, TunnelLayerHelper helper) {
        super(dimension, layer, helper);
        this.reflectionPoint = dimension.getMaxHeight() + dimension.getMinHeight() - 1;
    }

    @Override
    public int getWaterLevelAt(int x, int y) {
        return this.getMinHeight();
    }

    @Override
    protected float determineHeight(boolean inTunnelLayer, int tunnelFloorLevel, int tunnelRoofLevel, float realHeight) {
        return (float)this.reflectionPoint - (inTunnelLayer && tunnelRoofLevel > tunnelFloorLevel ? (float)(tunnelRoofLevel + 1) : realHeight);
    }
}

