/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.tunnel;

import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.MathUtils;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.IncidentalLayerExporter;
import org.pepsoft.worldpainter.exporting.InvertedWorld;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.exporting.WorldPainterChunkFactory;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.layers.Biome;
import org.pepsoft.worldpainter.layers.FloodWithLava;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.NotPresentBlock;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.AbstractCavesExporter;
import org.pepsoft.worldpainter.layers.tunnel.TunnelFloorDimension;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayer;
import org.pepsoft.worldpainter.layers.tunnel.TunnelLayerHelper;
import org.pepsoft.worldpainter.layers.tunnel.TunnelRoofDimension;
import org.pepsoft.worldpainter.util.BiomeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelLayerExporter
extends AbstractCavesExporter<TunnelLayer>
implements SecondPassLayerExporter {
    private final TunnelLayerHelper helper;
    private static final Font HEIGHT_MARKER_FONT = new Font("SansSerif", 0, 10);
    private static final long MATERIAL_SEED = 7533162017218592268L;
    private static final Set<Layer> SKIP_LAYERS = ImmutableSet.of((Object)NotPresentBlock.INSTANCE, (Object)FloodWithLava.INSTANCE);
    private static final Logger logger = LoggerFactory.getLogger(TunnelLayerExporter.class);

    public TunnelLayerExporter(Dimension dimension, Platform platform, TunnelLayer layer, TunnelLayerHelper helper) {
        super(dimension, platform, null, layer);
        this.helper = helper;
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return EnumSet.of(SecondPassLayerExporter.Stage.CARVE, SecondPassLayerExporter.Stage.ADD_FEATURES);
    }

    @Override
    public List<Fixup> carve(Rectangle area, Rectangle exportedArea, MinecraftWorld world) {
        int defaultBiome;
        ArrayList<Fixup> fixups = new ArrayList<Fixup>();
        int floodLevel = ((TunnelLayer)this.layer).getFloodLevel();
        int biome = ((TunnelLayer)this.layer).getTunnelBiome() != null ? ((TunnelLayer)this.layer).getTunnelBiome() : -1;
        Dimension.Anchor anchor = this.dimension.getAnchor();
        switch (anchor.dim) {
            case 0: {
                defaultBiome = 1;
                break;
            }
            case 1: {
                defaultBiome = 8;
                break;
            }
            case 2: {
                defaultBiome = 9;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        boolean removeWater = ((TunnelLayer)this.layer).isRemoveWater();
        boolean floodWithLava = ((TunnelLayer)this.layer).isFloodWithLava();
        Dimension floorDimension = ((TunnelLayer)this.layer).getFloorMode() == TunnelLayer.Mode.CUSTOM_DIMENSION && ((TunnelLayer)this.layer).getFloorDimensionId() != null ? this.dimension.getWorld().getDimension(new Dimension.Anchor(anchor.dim, Dimension.Role.CAVE_FLOOR, anchor.invert, ((TunnelLayer)this.layer).getFloorDimensionId())) : null;
        boolean customDimension = floorDimension != null;
        boolean set3DBiomes = !(!this.platform.capabilities.contains((Object)Platform.Capability.BIOMES_3D) && !this.platform.capabilities.contains((Object)Platform.Capability.NAMED_BIOMES) || !customDimension && ((TunnelLayer)this.layer).getTunnelBiome() == null);
        BiomeUtils biomeUtils = new BiomeUtils(customDimension ? floorDimension : this.dimension);
        MixedMaterial floorMaterial = !customDimension ? ((TunnelLayer)this.layer).getFloorMaterial() : null;
        MixedMaterial wallMaterial = ((TunnelLayer)this.layer).getWallMaterial();
        MixedMaterial roofMaterial = ((TunnelLayer)this.layer).getRoofMaterial();
        if (floorMaterial != null || wallMaterial != null || roofMaterial != null) {
            this.visitChunksForLayerInAreaForEditing(world, this.layer, area, this.dimension, (tile, chunkX, chunkZ, chunkSupplier) -> this.whereTunnelIsRealisedDo(tile, chunkX, chunkZ, chunkSupplier, (chunk, x, y, xInTile, yInTile, terrainHeight, actualFloorLevel, floorLedgeHeight, actualRoofLevel, roofLedgeHeight) -> {
                int startZ;
                int z;
                if (this.dimension.getBitLayerValueAt(Void.INSTANCE, x, y)) {
                    return true;
                }
                int waterLevel = tile.getWaterLevel(xInTile, yInTile);
                boolean flooded = waterLevel > terrainHeight;
                for (z = startZ = Math.min(removeWater ? Math.max(terrainHeight, waterLevel) : terrainHeight, actualRoofLevel); z > actualFloorLevel; --z) {
                    if (floorLedgeHeight == 0 && floorMaterial != null) {
                        this.setIfSolid(world, chunk, x, y, z - 1, this.minZ, this.maxZ, floorMaterial.getMaterial(7533162017218592268L, x, y, z - 1), flooded, terrainHeight, waterLevel, removeWater);
                    }
                    if (wallMaterial != null) {
                        if (floorLedgeHeight > 0) {
                            this.setIfSolid(world, chunk, x, y, z - 1, this.minZ, this.maxZ, wallMaterial.getMaterial(7533162017218592268L, x, y, z - 1), flooded, terrainHeight, waterLevel, removeWater);
                        }
                        if (roofLedgeHeight > 0) {
                            this.setIfSolid(world, chunk, x, y, z + 1, this.minZ, this.maxZ, wallMaterial.getMaterial(7533162017218592268L, x, y, z + 1), flooded, terrainHeight, waterLevel, removeWater);
                        }
                    }
                    if (roofLedgeHeight != 0 || roofMaterial == null) continue;
                    this.setIfSolid(world, chunk, x, y, z + 1, this.minZ, this.maxZ, roofMaterial.getMaterial(7533162017218592268L, x, y, z + 1), flooded, terrainHeight, waterLevel, removeWater);
                }
                if (wallMaterial != null) {
                    terrainHeight = this.dimension.getIntHeightAt(x - 1, y);
                    waterLevel = this.dimension.getWaterLevelAt(x - 1, y);
                    flooded = waterLevel > terrainHeight;
                    for (z = Math.min(removeWater ? Math.max(terrainHeight, waterLevel) : terrainHeight, actualRoofLevel); z > actualFloorLevel; --z) {
                        this.setIfSolid(world, chunk, x - 1, y, z, this.minZ, this.maxZ, wallMaterial.getMaterial(7533162017218592268L, x - 1, y, z), flooded, terrainHeight, waterLevel, removeWater);
                    }
                    terrainHeight = this.dimension.getIntHeightAt(x, y - 1);
                    waterLevel = this.dimension.getWaterLevelAt(x, y - 1);
                    flooded = waterLevel > terrainHeight;
                    for (z = Math.min(removeWater ? Math.max(terrainHeight, waterLevel) : terrainHeight, actualRoofLevel); z > actualFloorLevel; --z) {
                        this.setIfSolid(world, chunk, x, y - 1, z, this.minZ, this.maxZ, wallMaterial.getMaterial(7533162017218592268L, x, y - 1, z), flooded, terrainHeight, waterLevel, removeWater);
                    }
                    terrainHeight = this.dimension.getIntHeightAt(x + 1, y);
                    waterLevel = this.dimension.getWaterLevelAt(x + 1, y);
                    flooded = waterLevel > terrainHeight;
                    for (z = Math.min(removeWater ? Math.max(terrainHeight, waterLevel) : terrainHeight, actualRoofLevel); z > actualFloorLevel; --z) {
                        this.setIfSolid(world, chunk, x + 1, y, z, this.minZ, this.maxZ, wallMaterial.getMaterial(7533162017218592268L, x + 1, y, z), flooded, terrainHeight, waterLevel, removeWater);
                    }
                    terrainHeight = this.dimension.getIntHeightAt(x, y + 1);
                    waterLevel = this.dimension.getWaterLevelAt(x, y + 1);
                    flooded = waterLevel > terrainHeight;
                    for (z = Math.min(removeWater ? Math.max(terrainHeight, waterLevel) : terrainHeight, actualRoofLevel); z > actualFloorLevel; --z) {
                        this.setIfSolid(world, chunk, x, y + 1, z, this.minZ, this.maxZ, wallMaterial.getMaterial(7533162017218592268L, x, y + 1, z), flooded, terrainHeight, waterLevel, removeWater);
                    }
                }
                return true;
            }));
        }
        this.visitChunksForLayerInAreaForEditing(world, this.layer, area, this.dimension, (tile, chunkX, chunkZ, chunkSupplier) -> this.whereTunnelIsRealisedDo(tile, chunkX, chunkZ, chunkSupplier, (chunk, x, y, xInTile, yInTile, terrainHeight, actualFloorLevel, floorLedgeHeight, actualRoofLevel, roofLedgeHeight) -> {
            int myBiome;
            boolean myFloodWithLava;
            int myFloodLevel;
            if (this.dimension.getBitLayerValueAt(Void.INSTANCE, x, y)) {
                return true;
            }
            int waterLevel = tile.getWaterLevel(xInTile, yInTile);
            if (customDimension) {
                int layerValue;
                myFloodLevel = floorDimension.getWaterLevelAt(x, y);
                myFloodWithLava = floorDimension.getBitLayerValueAt(FloodWithLava.INSTANCE, x, y);
                myBiome = set3DBiomes ? ((layerValue = floorDimension.getLayerValueAt(Biome.INSTANCE, x, y)) == 255 ? floorDimension.getAutoBiome(x, y, defaultBiome) : layerValue) : -1;
            } else {
                myFloodLevel = floodLevel;
                myFloodWithLava = floodWithLava;
                myBiome = biome;
            }
            for (int z = Math.min(removeWater ? Math.max(terrainHeight, waterLevel) : terrainHeight, actualRoofLevel); z > actualFloorLevel; --z) {
                if (!removeWater && z > terrainHeight && z <= waterLevel) continue;
                if (z <= myFloodLevel) {
                    chunk.setMaterial(x & 0xF, z, y & 0xF, myFloodWithLava ? Material.LAVA : Material.WATER);
                } else {
                    chunk.setMaterial(x & 0xF, z, y & 0xF, Material.AIR);
                }
                if (!set3DBiomes) continue;
                biomeUtils.set3DBiome(chunk, (x & 0xF) >> 2, z >> 2, (y & 0xF) >> 2, myBiome);
            }
            if (actualFloorLevel == this.minHeight) {
                if (myFloodLevel > this.minHeight) {
                    chunk.setMaterial(x & 0xF, this.minHeight, y & 0xF, myFloodWithLava ? Material.STATIONARY_LAVA : Material.STATIONARY_WATER);
                } else {
                    chunk.setMaterial(x & 0xF, this.minHeight, y & 0xF, Material.AIR);
                }
            }
            return true;
        }));
        if (customDimension) {
            ArrayList<Layer> floorLayers = new ArrayList<Layer>(floorDimension.getAllLayers(false));
            floorLayers.addAll(floorDimension.getMinimumLayers());
            Collections.sort(floorLayers);
            ArrayList firstPassExporters = new ArrayList();
            ArrayList secondPassExporters = new ArrayList();
            floorLayers.stream().filter(layer -> !SKIP_LAYERS.contains(layer)).sorted().forEach(layer -> {
                Class<? extends LayerExporter> exporterType = layer.getExporterType();
                if (exporterType != null) {
                    if (FirstPassLayerExporter.class.isAssignableFrom(exporterType) || SecondPassLayerExporter.class.isAssignableFrom(exporterType)) {
                        LayerExporter exporter = layer.getExporter(floorDimension, this.platform, floorDimension.getLayerSettings((Layer)layer));
                        if (exporter instanceof FirstPassLayerExporter) {
                            firstPassExporters.add((FirstPassLayerExporter)exporter);
                        }
                        if (exporter instanceof SecondPassLayerExporter && ((SecondPassLayerExporter)exporter).getStages().contains((Object)SecondPassLayerExporter.Stage.CARVE)) {
                            secondPassExporters.add((SecondPassLayerExporter)exporter);
                        }
                    } else {
                        logger.debug("Skipping layer {} for stage CARVE while processing TunnelLayer floor dimension", (Object)layer.getName());
                    }
                } else if (!(layer instanceof Biome)) {
                    throw new UnsupportedOperationException("Layer " + layer.getName() + " of type " + layer.getClass().getSimpleName() + " not yet supported for cave floor dimensions");
                }
            });
            WorldPainterChunkFactory chunkFactory = new WorldPainterChunkFactory(floorDimension, null, this.platform, this.maxHeight);
            this.visitChunksForLayerInAreaForEditing(world, this.layer, area, this.dimension, (tile, chunkX, chunkZ, chunkSupplier) -> {
                Tile floorTile = floorDimension.getTile(tile.getX(), tile.getY());
                this.whereTunnelIsRealisedDo(tile, chunkX, chunkZ, chunkSupplier, (chunk, x, y, xInTile, yInTile, terrainHeight, actualFloorLevel, floorLedgeHeight, actualRoofLevel, roofLedgeHeight) -> {
                    if (!this.dimension.getBitLayerValueAt(Void.INSTANCE, x, y)) {
                        chunkFactory.applyTopLayer(floorTile, chunk, xInTile, yInTile, true);
                    }
                    return true;
                });
                if (!firstPassExporters.isEmpty()) {
                    Chunk chunk2 = (Chunk)chunkSupplier.get();
                    for (FirstPassLayerExporter exporter : firstPassExporters) {
                        exporter.render(floorTile, chunk2);
                    }
                }
                return true;
            });
            for (SecondPassLayerExporter exporter : secondPassExporters) {
                List<Fixup> layerFixups = exporter.carve(area, exportedArea, world);
                if (layerFixups == null) continue;
                fixups.addAll(layerFixups);
            }
        }
        return fixups.isEmpty() ? null : fixups;
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld world) {
        List<TunnelLayer.LayerSettings> roofLayers;
        int index;
        LayerExporter[] floorExporters;
        List<TunnelLayer.LayerSettings> floorLayers;
        Dimension floorDimension = ((TunnelLayer)this.layer).getFloorMode() == TunnelLayer.Mode.CUSTOM_DIMENSION && ((TunnelLayer)this.layer).getFloorDimensionId() != null ? this.dimension.getWorld().getDimension(new Dimension.Anchor(this.dimension.getAnchor().dim, Dimension.Role.CAVE_FLOOR, this.dimension.getAnchor().invert, ((TunnelLayer)this.layer).getFloorDimensionId())) : null;
        ArrayList<Fixup> fixups = new ArrayList<Fixup>();
        if (floorDimension != null) {
            floorLayers = new ArrayList<Layer>(floorDimension.getAllLayers(false));
            floorLayers.addAll(floorDimension.getMinimumLayers());
            Collections.sort(floorLayers);
            for (LayerExporter exporter : floorExporters = (SecondPassLayerExporter[])floorLayers.stream().filter(layer -> !SKIP_LAYERS.contains(layer)).map(layer -> {
                SecondPassLayerExporter exporter;
                Class<? extends LayerExporter> exporterType = layer.getExporterType();
                if (exporterType != null && SecondPassLayerExporter.class.isAssignableFrom(exporterType) && (exporter = (SecondPassLayerExporter)layer.getExporter(floorDimension, this.platform, floorDimension.getLayerSettings((Layer)layer))).getStages().contains((Object)SecondPassLayerExporter.Stage.ADD_FEATURES)) {
                    return exporter;
                }
                logger.debug("Skipping layer {} for stage ADD_FEATURES while processing TunnelLayer floor dimension", (Object)layer.getName());
                return null;
            }).filter(Objects::nonNull).toArray(SecondPassLayerExporter[]::new)) {
                List<Fixup> layerFixups = exporter.addFeatures(area, exportedArea, world);
                if (layerFixups == null) continue;
                fixups.addAll(layerFixups);
            }
        } else {
            floorLayers = ((TunnelLayer)this.layer).getFloorLayers();
            if (floorLayers != null && !floorLayers.isEmpty()) {
                floorExporters = new IncidentalLayerExporter[floorLayers.size()];
                TunnelLayer.LayerSettings[] floorLayerSettings = new TunnelLayer.LayerSettings[floorLayers.size()];
                NoiseHeightMap[] floorLayerNoise = new NoiseHeightMap[floorLayers.size()];
                index = 0;
                for (TunnelLayer.LayerSettings layerSettings : floorLayers) {
                    floorExporters[index] = (IncidentalLayerExporter)layerSettings.getLayer().getExporter(new TunnelFloorDimension(this.dimension, (TunnelLayer)this.layer, this.helper), this.platform, null);
                    floorLayerSettings[index] = layerSettings;
                    if (layerSettings.getVariation() != null) {
                        floorLayerNoise[index] = new NoiseHeightMap(layerSettings.getVariation(), index);
                        floorLayerNoise[index].setSeed(this.dimension.getSeed());
                    }
                    ++index;
                }
                this.visitChunksForLayerInAreaForEditing(world, this.layer, area, this.dimension, (arg_0, arg_1, arg_2, arg_3) -> this.lambda$addFeatures$12((IncidentalLayerExporter[])floorExporters, floorLayerSettings, floorLayerNoise, exportedArea, world, fixups, arg_0, arg_1, arg_2, arg_3));
            }
        }
        if ((roofLayers = ((TunnelLayer)this.layer).getRoofLayers()) != null && !roofLayers.isEmpty()) {
            IncidentalLayerExporter[] roofExporters = new IncidentalLayerExporter[roofLayers.size()];
            TunnelLayer.LayerSettings[] roofLayerSettings = new TunnelLayer.LayerSettings[roofLayers.size()];
            NoiseHeightMap[] roofLayerNoise = new NoiseHeightMap[roofLayers.size()];
            index = 0;
            for (TunnelLayer.LayerSettings layerSettings : roofLayers) {
                roofExporters[index] = (IncidentalLayerExporter)layerSettings.getLayer().getExporter(new TunnelRoofDimension(this.dimension, (TunnelLayer)this.layer, this.helper), this.platform, null);
                roofLayerSettings[index] = layerSettings;
                if (layerSettings.getVariation() != null) {
                    roofLayerNoise[index] = new NoiseHeightMap(layerSettings.getVariation(), index);
                    roofLayerNoise[index].setSeed(this.dimension.getSeed());
                }
                ++index;
            }
            InvertedWorld invertedWorld = new InvertedWorld(world, 0, this.platform);
            this.visitChunksForLayerInAreaForEditing(world, this.layer, area, this.dimension, (tile, chunkX, chunkZ, chunkSupplier) -> this.whereTunnelIsRealisedDo(tile, chunkX, chunkZ, chunkSupplier, (chunk, x, y, xInTile, yInTile, terrainHeight, actualFloorLevel, floorLedgeHeight, actualRoofLevel, roofLedgeHeight) -> {
                int z = actualRoofLevel;
                Point3i location = new Point3i(x, y, this.maxHeight + this.minHeight - 1 - z);
                for (int i = 0; i < roofExporters.length; ++i) {
                    int intensity;
                    if (z < roofLayerSettings[i].getMinLevel() || z > roofLayerSettings[i].getMaxLevel()) continue;
                    int n = intensity = roofLayerNoise[i] != null ? (int)MathUtils.clamp((long)0L, (long)Math.round((double)roofLayerSettings[i].getIntensity() + roofLayerNoise[i].getValue(x, y, z) - roofLayerNoise[i].getHeight() / 2.0), (long)100L) : roofLayerSettings[i].getIntensity();
                    if (intensity <= 0) continue;
                    roofExporters[i].apply(location, intensity, exportedArea, invertedWorld);
                }
                return true;
            }));
        }
        return fixups.isEmpty() ? null : fixups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage generatePreview(TunnelLayer layer, int width, int height, int waterLevel, int minHeight, int baseHeight, int heightDifference) {
        TunnelLayer.Mode floorMode = layer.getFloorMode();
        int tunnelExtent = width - 34;
        int floodLevel = layer.getFloodLevel();
        boolean removeWater = layer.isRemoveWater();
        boolean floodWithLava = layer.isFloodWithLava();
        PerlinNoise noise = new PerlinNoise(0L);
        BufferedImage preview = new BufferedImage(width, height, 1);
        TunnelLayerHelper helper = layer.getHelper(null);
        for (int x = 0; x < width; ++x) {
            int actualRoofLevel;
            int actualFloorLevel;
            int terrainHeight = MathUtils.clamp((int)minHeight, (int)((int)(Math.sin(((double)x / (double)width * 1.5 + 1.25) * Math.PI) * (double)heightDifference / 2.0 + (double)(heightDifference / 2) + (double)baseHeight + (double)(noise.getPerlinNoise((double)x / 20.0) * 32.0f) + (double)(noise.getPerlinNoise((double)x / 10.0) * 16.0f) + (double)(noise.getPerlinNoise((double)x / 5.0) * 8.0f))), (int)(baseHeight + heightDifference - 1));
            for (int z = height - 1 + minHeight; z > terrainHeight; --z) {
                preview.setRGB(x, height - 1 - z + minHeight, z <= waterLevel ? 255 : 0xFFFFFF);
            }
            if (x > tunnelExtent) continue;
            if (floorMode == TunnelLayer.Mode.CUSTOM_DIMENSION) {
                actualFloorLevel = helper.calculateFloorLevel(x, 0, terrainHeight, minHeight + 1, height - 1);
                actualRoofLevel = helper.calculateRoofLevel(x, 0, terrainHeight, minHeight + 1, height - 1, actualFloorLevel);
                int roofLedgeHeight = helper.calculateTopLedgeHeight(tunnelExtent - x);
                actualRoofLevel = Math.min(actualRoofLevel - roofLedgeHeight, Math.max(terrainHeight, 62));
                int tint = 127;
                for (int z = actualRoofLevel; z >= minHeight; --z) {
                    if (z <= floodLevel) {
                        if (floodWithLava) {
                            preview.setRGB(x, height - 1 - z + minHeight, 0xFF8000);
                        } else {
                            preview.setRGB(x, height - 1 - z + minHeight, 255);
                        }
                    } else if (z > terrainHeight) {
                        if (removeWater) {
                            preview.setRGB(x, height - 1 - z + minHeight, tint << 16 | tint << 8 | 0xFF);
                        }
                    } else {
                        preview.setRGB(x, height - 1 - z + minHeight, tint << 16 | tint << 8 | tint);
                    }
                    if (tint <= 0) continue;
                    tint = Math.max(tint - 2, 0);
                }
                continue;
            }
            actualFloorLevel = helper.calculateFloorLevel(x, 0, terrainHeight, minHeight + 1, height - 1);
            actualRoofLevel = helper.calculateRoofLevel(x, 0, terrainHeight, minHeight + 1, height - 1, actualFloorLevel);
            if (actualRoofLevel <= actualFloorLevel) continue;
            float distanceToWall = tunnelExtent - x;
            int floorLedgeHeight = helper.calculateBottomLedgeHeight(distanceToWall);
            int roofLedgeHeight = helper.calculateTopLedgeHeight(distanceToWall);
            actualRoofLevel = Math.min(actualRoofLevel - roofLedgeHeight, Math.max(terrainHeight, 62));
            for (int z = (actualFloorLevel += floorLedgeHeight) + 1; z <= actualRoofLevel; ++z) {
                if (z <= floodLevel) {
                    if (floodWithLava) {
                        preview.setRGB(x, height - 1 - z + minHeight, 0xFF8000);
                        continue;
                    }
                    preview.setRGB(x, height - 1 - z + minHeight, 255);
                    continue;
                }
                if (z > terrainHeight) {
                    if (!removeWater) continue;
                    preview.setRGB(x, height - 1 - z + minHeight, 0x7F7FFF);
                    continue;
                }
                preview.setRGB(x, height - 1 - z + minHeight, 0x7F7F7F);
            }
        }
        Graphics2D g2 = preview.createGraphics();
        try {
            g2.setColor(Color.GRAY);
            g2.setFont(HEIGHT_MARKER_FONT);
            for (int y = minHeight / 20 * 20; y < height + minHeight; y += 20) {
                g2.drawLine(width - 10, height + minHeight - y, width - 1, height + minHeight - y);
                g2.drawString(Integer.toString(y), width - 30, height + minHeight - y + 4);
            }
        }
        finally {
            g2.dispose();
        }
        return preview;
    }

    private boolean whereTunnelIsRealisedDo(Tile tile, int chunkX, int chunkZ, Supplier<Chunk> chunkSupplier, ColumnVisitor visitor) {
        Chunk chunk = null;
        for (int xInChunk = 0; xInChunk < 16; ++xInChunk) {
            for (int zInChunk = 0; zInChunk < 16; ++zInChunk) {
                int actualFloorLevel;
                int terrainHeight;
                int actualRoofLevel;
                int x = chunkX << 4 | xInChunk;
                int xInTile = x & 0x7F;
                int y = chunkZ << 4 | zInChunk;
                int yInTile = y & 0x7F;
                if (!tile.getBitLayerValue(this.layer, xInTile, yInTile) || (actualRoofLevel = this.helper.calculateRoofLevel(x, y, terrainHeight = tile.getIntHeight(xInTile, yInTile), this.minZ, this.maxZ, actualFloorLevel = this.helper.calculateFloorLevel(x, y, terrainHeight, this.minZ, this.maxZ))) <= actualFloorLevel) continue;
                int floorLedgeHeight = this.helper.calculateBottomLedgeHeight(x, y);
                int roofLedgeHeight = this.helper.calculateTopLedgeHeight(x, y);
                if ((actualRoofLevel -= roofLedgeHeight) <= (actualFloorLevel += floorLedgeHeight)) continue;
                if (chunk == null) {
                    chunk = chunkSupplier.get();
                }
                if (visitor.visitColumn(chunk, x, y, xInTile, yInTile, terrainHeight, actualFloorLevel, floorLedgeHeight, actualRoofLevel, roofLedgeHeight)) continue;
                return false;
            }
        }
        return true;
    }

    private void setIfSolid(MinecraftWorld world, Chunk chunk, int x, int y, int z, int minZ, int maxZ, Material material, boolean flooded, int terrainHeight, int waterLevel, boolean removeWater) {
        if (z >= minZ && z <= maxZ && (removeWater || !flooded || z <= terrainHeight || z > waterLevel)) {
            if (x >> 4 == chunk.getxPos() && y >> 4 == chunk.getzPos()) {
                Material existingBlock = chunk.getMaterial(x & 0xF, z, y & 0xF);
                if (existingBlock != Material.AIR && !existingBlock.insubstantial) {
                    chunk.setMaterial(x & 0xF, z, y & 0xF, material);
                }
            } else {
                Material existingBlock = world.getMaterialAt(x, y, z);
                if (existingBlock != Material.AIR && !existingBlock.insubstantial) {
                    world.setMaterialAt(x, y, z, material);
                }
            }
        }
    }

    private /* synthetic */ boolean lambda$addFeatures$12(IncidentalLayerExporter[] floorExporters, TunnelLayer.LayerSettings[] floorLayerSettings, NoiseHeightMap[] floorLayerNoise, Rectangle exportedArea, MinecraftWorld world, List fixups, Tile tile, int chunkX, int chunkZ, Supplier chunkSupplier) {
        return this.whereTunnelIsRealisedDo(tile, chunkX, chunkZ, chunkSupplier, (chunk, x, y, xInTile, yInTile, terrainHeight, actualFloorLevel, floorLedgeHeight, actualRoofLevel, roofLedgeHeight) -> {
            int z = actualFloorLevel + 1;
            Point3i location = new Point3i(x, y, z);
            for (int i = 0; i < floorExporters.length; ++i) {
                Fixup fixup;
                int intensity;
                if (z < floorLayerSettings[i].getMinLevel() || z > floorLayerSettings[i].getMaxLevel()) continue;
                int n = intensity = floorLayerNoise[i] != null ? (int)MathUtils.clamp((long)0L, (long)Math.round((double)floorLayerSettings[i].getIntensity() + floorLayerNoise[i].getValue(x, y, z) - floorLayerNoise[i].getHeight() / 2.0), (long)100L) : floorLayerSettings[i].getIntensity();
                if (intensity <= 0 || (fixup = floorExporters[i].apply(location, intensity, exportedArea, world)) == null) continue;
                fixups.add(fixup);
            }
            return true;
        });
    }

    @FunctionalInterface
    static interface ColumnVisitor {
        public boolean visitColumn(Chunk var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);
    }
}

