/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.plants;

import java.util.Random;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.layers.plants.AgingPlant;
import org.pepsoft.worldpainter.layers.plants.Category;
import org.pepsoft.worldpainter.layers.plants.DoubleHighPlant;
import org.pepsoft.worldpainter.layers.plants.Plant;
import org.pepsoft.worldpainter.layers.plants.PlantWithGrowth;
import org.pepsoft.worldpainter.layers.plants.SimplePlant;
import org.pepsoft.worldpainter.layers.plants.VariableHeightPlant;

public class Plants {
    public static final Plant GRASS = new SimplePlant("Grass", Material.GRASS, Category.PLANTS_AND_FLOWERS);
    public static final Plant FERN = new SimplePlant("Fern", Material.FERN, Category.PLANTS_AND_FLOWERS);
    public static final Plant DEAD_SHRUB = new SimplePlant("Dead Shrub", Material.DEAD_SHRUBS, new Category[]{Category.PLANTS_AND_FLOWERS}){

        @Override
        public Category isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return !checkBlockBelow || material.modded || material.isNamedOneOf("minecraft:grass_block", "minecraft:sand", "minecraft:red_sand", "minecraft:dirt", "minecraft:terracotta", "minecraft:podzol", "minecraft:coarse_dirt", "minecraft:rooted_dirt", "minecraft:moss_block", "minecraft:mud") || material.name.endsWith("_terracotta") ? Category.PLANTS_AND_FLOWERS : null;
        }
    };
    public static final Plant DANDELION = new SimplePlant("Dandelion", Material.DANDELION, Category.PLANTS_AND_FLOWERS);
    public static final Plant POPPY = new SimplePlant("Poppy", Material.ROSE, Category.PLANTS_AND_FLOWERS);
    public static final Plant BLUE_ORCHID = new SimplePlant("Blue Orchid", Material.BLUE_ORCHID, Category.PLANTS_AND_FLOWERS);
    public static final Plant ALLIUM = new SimplePlant("Allium", Material.ALLIUM, Category.PLANTS_AND_FLOWERS);
    public static final Plant AZURE_BLUET = new SimplePlant("Azure Bluet", Material.AZURE_BLUET, Category.PLANTS_AND_FLOWERS);
    public static final Plant TULIP_RED = new SimplePlant("Red Tulip", Material.RED_TULIP, Category.PLANTS_AND_FLOWERS);
    public static final Plant TULIP_ORANGE = new SimplePlant("Orange Tulip", Material.ORANGE_TULIP, Category.PLANTS_AND_FLOWERS);
    public static final Plant TULIP_WHITE = new SimplePlant("White Tulip", Material.WHITE_TULIP, Category.PLANTS_AND_FLOWERS);
    public static final Plant TULIP_PINK = new SimplePlant("Pink Tulip", Material.PINK_TULIP, Category.PLANTS_AND_FLOWERS);
    public static final Plant OXEYE_DAISY = new SimplePlant("Oxeye Daisy", Material.OXEYE_DAISY, Category.PLANTS_AND_FLOWERS);
    public static final Plant CORNFLOWER = new SimplePlant("Cornflower", Material.CORNFLOWER, Category.PLANTS_AND_FLOWERS);
    public static final Plant LILY_OF_THE_VALLEY = new SimplePlant("Lily of the Valley", Material.LILY_OF_THE_VALLEY, Category.PLANTS_AND_FLOWERS);
    public static final Plant WITHER_ROSE = new SimplePlant("Wither Rose", Material.WITHER_ROSE, Category.NETHER);
    public static final Plant SUNFLOWER = new DoubleHighPlant("Sunflower", Material.SUNFLOWER_LOWER, "block/sunflower_front.png", Category.PLANTS_AND_FLOWERS);
    public static final Plant LILAC = new DoubleHighPlant("Lilac", Material.LILAC_LOWER, Category.PLANTS_AND_FLOWERS);
    public static final Plant TALL_GRASS = new DoubleHighPlant("Tall Grass", Material.TALL_GRASS_LOWER, Category.PLANTS_AND_FLOWERS);
    public static final Plant LARGE_FERN = new DoubleHighPlant("Large Fern", Material.LARGE_FERN_LOWER, Category.PLANTS_AND_FLOWERS);
    public static final Plant ROSE_BUSH = new DoubleHighPlant("Rose Bush", Material.ROSE_BUSH_LOWER, Category.PLANTS_AND_FLOWERS);
    public static final Plant PEONY = new DoubleHighPlant("Peony", Material.PEONY_LOWER, Category.PLANTS_AND_FLOWERS);
    public static final Plant SAPLING_OAK = new SimplePlant("Oak Sapling", Material.OAK_SAPLING, Category.SAPLINGS);
    public static final Plant SAPLING_DARK_OAK = new SimplePlant("Dark Oak Sapling", Material.DARK_OAK_SAPLING, Category.SAPLINGS);
    public static final Plant SAPLING_PINE = new SimplePlant("Pine Sapling", Material.PINE_SAPLING, Category.SAPLINGS);
    public static final Plant SAPLING_BIRCH = new SimplePlant("Birch Sapling", Material.BIRCH_SAPLING, Category.SAPLINGS);
    public static final Plant SAPLING_JUNGLE = new SimplePlant("Jungle Sapling", Material.JUNGLE_SAPLING, Category.SAPLINGS);
    public static final Plant SAPLING_ACACIA = new SimplePlant("Acacia Sapling", Material.ACACIA_SAPLING, Category.SAPLINGS);
    public static final Plant MUSHROOM_RED = new SimplePlant("Red Mushroom", Material.RED_MUSHROOM, Category.MUSHROOMS);
    public static final Plant MUSHROOM_BROWN = new SimplePlant("Brown Mushroom", Material.BROWN_MUSHROOM, Category.MUSHROOMS);
    public static final Plant WHEAT = new AgingPlant("Wheat", Material.WHEAT, "block/wheat_stage7.png", 8, Category.CROPS);
    public static final Plant CARROTS = new AgingPlant("Carrots", Material.CARROTS, "block/carrots_stage3.png", 8, Category.CROPS);
    public static final Plant POTATOES = new AgingPlant("Potatoes", Material.POTATOES, "block/potatoes_stage3.png", 8, Category.CROPS);
    public static final Plant PUMPKIN_STEMS = new AgingPlant("Pumpkin Stem", Material.PUMPKIN_STEM, "block/pumpkin_side.png", 8, new Category[]{Category.CROPS}){

        @Override
        public Plant realise(int growth, Platform platform) {
            return new SimplePlant("Pumpkin Stem", Material.PUMPKIN_STEM.withProperty(Material.AGE, growth - 1).withProperty(Material.FACING, Direction.values()[RANDOM.nextInt(4)]), this.categories);
        }
    };
    public static final Plant MELON_STEMS = new AgingPlant("Melon Stem", Material.MELON_STEM, "block/melon_side.png", 8, new Category[]{Category.CROPS}){

        @Override
        public Plant realise(int growth, Platform platform) {
            return new SimplePlant("Melon Stem", Material.MELON_STEM.withProperty(Material.AGE, growth - 1).withProperty(Material.FACING, Direction.values()[RANDOM.nextInt(4)]), this.categories);
        }
    };
    public static final Plant BEETROOTS = new AgingPlant("Beetroots", Material.BEETROOTS, "block/beetroots_stage3.png", 4, Category.CROPS);
    public static final Plant SWEET_BERRY_BUSH = new AgingPlant("Sweet Berry Bush", Material.SWEET_BERRY_BUSH, "block/sweet_berry_bush_stage3.png", 4, Category.PLANTS_AND_FLOWERS);
    public static final Plant CACTUS = new VariableHeightPlant("Cactus", Material.CACTUS, "block/cactus_side.png", 3, Category.CACTUS);
    public static final Plant SUGAR_CANE = new VariableHeightPlant("Sugar Cane", Material.SUGAR_CANE, 3, Category.SUGAR_CANE);
    public static final Plant LILY_PAD = new SimplePlant("Lily Pad", Material.LILY_PAD, Category.FLOATING_PLANTS);
    public static final Plant NETHER_WART = new AgingPlant("Nether Wart", Material.NETHER_WART, "block/nether_wart_stage2.png", 4, new Category[]{Category.NETHER}){

        @Override
        public Plant realise(int growth, Platform platform) {
            return new SimplePlant("Nether Wart", Material.NETHER_WART.withProperty(Material.AGE, growth - 1), this.categories){

                @Override
                public Category isValidFoundation(MinecraftWorld world, int x, int y, int height, boolean checkBlockBelow) {
                    Material material = world.getMaterialAt(x, y, height);
                    return !checkBlockBelow || material.modded || material.isNamed("minecraft:soul_sand") ? Category.NETHER : null;
                }
            };
        }
    };
    public static final Plant CHORUS_PLANT = new VariableHeightPlant("Chorus Plant", Material.CHORUS_PLANT, Material.CHORUS_FLOWER, "block/chorus_flower.png", 5, Category.END);
    public static final Plant TUBE_CORAL = new SimplePlant("Tube Coral", Material.TUBE_CORAL, Category.WATER_PLANTS);
    public static final Plant BRAIN_CORAL = new SimplePlant("Brain Coral", Material.BRAIN_CORAL, Category.WATER_PLANTS);
    public static final Plant BUBBLE_CORAL = new SimplePlant("Bubble Coral", Material.BUBBLE_CORAL, Category.WATER_PLANTS);
    public static final Plant FIRE_CORAL = new SimplePlant("Fire Coral", Material.FIRE_CORAL, Category.WATER_PLANTS);
    public static final Plant HORN_CORAL = new SimplePlant("Horn Coral", Material.HORN_CORAL, Category.WATER_PLANTS);
    public static final Plant TUBE_CORAL_FAN = new SimplePlant("Tube Coral Fan", Material.TUBE_CORAL_FAN, Category.WATER_PLANTS);
    public static final Plant BRAIN_CORAL_FAN = new SimplePlant("Brain Coral Fan", Material.BRAIN_CORAL_FAN, Category.WATER_PLANTS);
    public static final Plant BUBBLE_CORAL_FAN = new SimplePlant("Bubble Coral Fan", Material.BUBBLE_CORAL_FAN, Category.WATER_PLANTS);
    public static final Plant FIRE_CORAL_FAN = new SimplePlant("Fire Coral Fan", Material.FIRE_CORAL_FAN, Category.WATER_PLANTS);
    public static final Plant HORN_CORAL_FAN = new SimplePlant("Horn Coral Fan", Material.HORN_CORAL_FAN, Category.WATER_PLANTS);
    public static final Plant KELP = new VariableHeightPlant("Kelp", Material.KELP_PLANT, Material.KELP, 26, new Category[]{Category.WATER_PLANTS}){

        @Override
        public VariableHeightPlant realise(int growth, Platform platform) {
            return new VariableHeightPlant("Kelp", Material.KELP_PLANT, Material.KELP.withProperty(Material.AGE, RANDOM.nextInt(26)), growth, this.categories);
        }
    };
    public static final Plant SEAGRASS = new SimplePlant("Seagrass", Material.SEAGRASS, Category.WATER_PLANTS);
    public static final Plant TALL_SEAGRASS = new DoubleHighPlant("Tall Seagrass", Material.TALL_SEAGRASS_LOWER, Category.WATER_PLANTS);
    public static final Plant SEA_PICKLE = new PlantWithGrowth("Sea Pickle", Material.SEA_PICKLE_1, "item/sea_pickle.png", 4, new Category[]{Category.WATER_PLANTS}){

        @Override
        public SimplePlant realise(int growth, Platform platform) {
            return new SimplePlant(this.name, this.material.withProperty(Material.PICKLES, growth), this.iconName, this.categories);
        }
    };
    public static final Plant BAMBOO = new VariableHeightPlant("Bamboo", Material.BAMBOO_NO_LEAVES, Material.BAMBOO_LARGE_LEAVES, "item/bamboo.png", 16, new Category[]{Category.PLANTS_AND_FLOWERS}){

        @Override
        public Plant realise(int growth, Platform platform) {
            return new VariableHeightPlant("Bamboo", Material.BAMBOO_NO_LEAVES, Material.BAMBOO_LARGE_LEAVES, "item/bamboo.png", growth, new Category[]{Category.PLANTS_AND_FLOWERS}){

                @Override
                public Material getMaterial(int x, int y, int z) {
                    int age = this.growth > 4 ? 1 : 0;
                    switch (z) {
                        case 0: {
                            return Material.BAMBOO_NO_LEAVES.withProperty(Material.AGE, age);
                        }
                        case 1: 
                        case 2: {
                            if (this.growth <= 4) {
                                return Material.BAMBOO_SMALL_LEAVES.withProperty(Material.AGE, age);
                            }
                            return Material.BAMBOO_NO_LEAVES.withProperty(Material.AGE, age);
                        }
                    }
                    if (z >= this.growth - 2) {
                        return Material.BAMBOO_LARGE_LEAVES.withProperty(Material.AGE, age);
                    }
                    if (z == this.growth - 3) {
                        return Material.BAMBOO_SMALL_LEAVES.withProperty(Material.AGE, age);
                    }
                    return Material.BAMBOO_NO_LEAVES.withProperty(Material.AGE, age);
                }
            };
        }
    };
    public static final Plant SAPLING_AZALEA = new SimplePlant("Azalea", Material.AZALEA, "block/azalea_plant.png", Category.SAPLINGS);
    public static final Plant SAPLING_FLOWERING_AZALEA = new SimplePlant("Flowering Azalea", Material.FLOWERING_AZALEA, "block/flowering_azalea_side.png", Category.SAPLINGS);
    public static final Plant CRIMSON_FUNGUS = new SimplePlant("Crimson Fungus", Material.CRIMSON_FUNGUS, Category.NETHER);
    public static final Plant WARPED_FUNGUS = new SimplePlant("Warped Fungus", Material.WARPED_FUNGUS, Category.NETHER);
    public static final Plant CRIMSON_ROOTS = new SimplePlant("Crimson Roots", Material.CRIMSON_ROOTS, Category.NETHER);
    public static final Plant WARPED_ROOTS = new SimplePlant("Warped Roots", Material.WARPED_ROOTS, Category.NETHER);
    public static final Plant NETHER_SPROUTS = new SimplePlant("Nether Sprouts", Material.NETHER_SPROUTS, Category.NETHER);
    public static final Plant TWISTING_VINES = new VariableHeightPlant("Twisting Vines", Material.TWISTING_VINES_PLANT, Material.TWISTING_VINES_25, 10, Category.MUSHROOMS);
    public static final Plant GLOW_LICHEN = new SimplePlant("Glow Lichen", Material.GLOW_LICHEN_DOWN, Category.MUSHROOMS, Category.WATER_PLANTS, Category.HANGING_DRY_PLANTS, Category.HANGING_WATER_PLANTS);
    public static final Plant MOSS_CARPET = new SimplePlant("Moss Carpet", Material.MOSS_CARPET, "block/moss_block.png", Category.MUSHROOMS);
    public static final Plant BIG_DRIPLEAF = new VariableHeightPlant("Big Dripleaf", Material.BIG_DRIPLEAF_STEM_SOUTH, Material.BIG_DRIPLEAF_SOUTH, "block/big_dripleaf_top.png", 10, new Category[]{Category.PLANTS_AND_FLOWERS, Category.DRIPLEAF}){

        @Override
        public VariableHeightPlant realise(int growth, Platform platform) {
            Direction facing = Direction.values()[RANDOM.nextInt(4)];
            return new VariableHeightPlant("Big Dripleaf", Material.BIG_DRIPLEAF_STEM_SOUTH.withProperty("facing", facing.toString()), Material.BIG_DRIPLEAF_SOUTH.withProperty("facing", facing.toString()), growth, this.categories);
        }
    };
    public static final Plant PUMPKIN = new SimplePlant("Pumpkin", Material.PUMPKIN, "block/pumpkin_side.png", new Category[]{Category.PLANTS_AND_FLOWERS}){

        @Override
        public Category isValidFoundation(MinecraftWorld world, int x, int y, int height, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, height);
            return !checkBlockBelow || material.modded || material.solid ? Category.PLANTS_AND_FLOWERS : null;
        }
    };
    public static final Plant MELON = new SimplePlant("Melon", Material.MELON, "block/melon_side.png", new Category[]{Category.PLANTS_AND_FLOWERS}){

        @Override
        public Category isValidFoundation(MinecraftWorld world, int x, int y, int height, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, height);
            return !checkBlockBelow || material.modded || material.solid ? Category.PLANTS_AND_FLOWERS : null;
        }
    };
    public static final Plant CARVED_PUMPKIN = new SimplePlant("Carved Pumpkin", Material.CARVED_PUMPKIN_SOUTH_FACE, new Category[]{Category.MUSHROOMS}){

        @Override
        public Plant realise(int growth, Platform platform) {
            return new SimplePlant("Carved Pumpkin", Material.CARVED_PUMPKIN_SOUTH_FACE.withProperty(Material.FACING, Direction.values()[RANDOM.nextInt(4)]), this.categories){

                @Override
                public Category isValidFoundation(MinecraftWorld world, int x, int y, int height, boolean checkBlockBelow) {
                    Material material = world.getMaterialAt(x, y, height);
                    return !checkBlockBelow || material.modded || material.solid ? Category.MUSHROOMS : null;
                }
            };
        }
    };
    public static final Plant JACK_O_LANTERN = new SimplePlant("Jack-o'-lantern", Material.JACK_O_LANTERN_SOUTH_FACE, new Category[]{Category.MUSHROOMS}){

        @Override
        public Plant realise(int growth, Platform platform) {
            return new SimplePlant("Jack-o'-lantern", Material.JACK_O_LANTERN_SOUTH_FACE.withProperty(Material.FACING, Direction.values()[RANDOM.nextInt(4)]), this.categories){

                @Override
                public Category isValidFoundation(MinecraftWorld world, int x, int y, int height, boolean checkBlockBelow) {
                    Material material = world.getMaterialAt(x, y, height);
                    return !checkBlockBelow || material.modded || material.solid ? Category.MUSHROOMS : null;
                }
            };
        }
    };
    public static final Plant VINE = new VariableHeightPlant("Vine", Material.VINE, 10, new Category[]{Category.HANGING_DRY_PLANTS}){

        @Override
        public Plant realise(int growth, Platform platform) {
            String directionProperty = Direction.values()[RANDOM.nextInt(4)].name().toLowerCase();
            return new VariableHeightPlant("Vine", Material.VINE.withProperty(Material.DOWN, true).withProperty(directionProperty, "true"), Material.VINE.withProperty(directionProperty, "true"), Material.VINE.withProperty(directionProperty, "true"), growth, this.categories);
        }
    };
    public static final Plant SPORE_BLOSSOM = new SimplePlant("Spore Blossoms", Material.SPORE_BLOSSOM, Category.HANGING_DRY_PLANTS);
    public static final Plant WEEPING_VINES = new VariableHeightPlant("Weeping Vines", Material.WEEPING_VINES_PLANT, Material.WEEPING_VINES, "block/weeping_vines_plant.png", 10, Category.HANGING_DRY_PLANTS);
    public static final Plant HANGING_ROOTS = new SimplePlant("Hanging Roots", Material.HANGING_ROOTS, Category.HANGING_DRY_PLANTS, Category.HANGING_WATER_PLANTS);
    public static final Plant GLOW_BERRIES = new VariableHeightPlant("Glow Berries", Material.CAVE_VINES_PLANT_NO_BERRIES, Material.CAVE_VINES_NO_BERRIES, "block/cave_vines_lit.png", 10, new Category[]{Category.HANGING_DRY_PLANTS}){

        @Override
        public Plant realise(int growth, Platform platform) {
            return new VariableHeightPlant("Glow Berries", Material.CAVE_VINES_PLANT_NO_BERRIES, Material.CAVE_VINES_NO_BERRIES, "block/cave_vines_lit.png", growth, this.categories){

                @Override
                public Material getMaterial(int x, int y, int z) {
                    return super.getMaterial(x, y, z).withProperty(Material.BERRIES, RANDOM.nextInt(4) == 0);
                }
            };
        }
    };
    public static final Plant SMALL_DRIPLEAF = new DoubleHighPlant("Small Dripleaf", Material.SMALL_DRIPLEAF_SOUTH_LOWER, Category.DRIPLEAF){

        @Override
        public DoubleHighPlant realise(int growth, Platform platform) {
            return new DoubleHighPlant("Small Dripleaf", Material.SMALL_DRIPLEAF_SOUTH_LOWER.withProperty(Material.FACING, Direction.values()[RANDOM.nextInt(4)]), Category.DRIPLEAF, platform);
        }
    };
    public static final Plant MANGROVE_PROPAGULE = new SimplePlant("Mangrove Propagule", Material.MANGROVE_PROPAGULE, Category.SAPLINGS, Category.WATER_PLANTS);
    public static final Plant[] ALL_PLANTS = new Plant[]{GRASS, TALL_GRASS, FERN, LARGE_FERN, DEAD_SHRUB, DANDELION, POPPY, BLUE_ORCHID, ALLIUM, AZURE_BLUET, TULIP_RED, TULIP_ORANGE, TULIP_WHITE, TULIP_PINK, OXEYE_DAISY, SUNFLOWER, LILAC, ROSE_BUSH, PEONY, SAPLING_OAK, SAPLING_DARK_OAK, SAPLING_PINE, SAPLING_BIRCH, SAPLING_JUNGLE, SAPLING_ACACIA, MUSHROOM_RED, MUSHROOM_BROWN, WHEAT, CARROTS, POTATOES, PUMPKIN_STEMS, MELON_STEMS, CACTUS, SUGAR_CANE, LILY_PAD, BEETROOTS, NETHER_WART, CHORUS_PLANT, TUBE_CORAL, BRAIN_CORAL, BUBBLE_CORAL, FIRE_CORAL, HORN_CORAL, TUBE_CORAL_FAN, BRAIN_CORAL_FAN, BUBBLE_CORAL_FAN, FIRE_CORAL_FAN, HORN_CORAL_FAN, KELP, SEAGRASS, TALL_SEAGRASS, SEA_PICKLE, CORNFLOWER, LILY_OF_THE_VALLEY, WITHER_ROSE, SWEET_BERRY_BUSH, BAMBOO, SAPLING_AZALEA, SAPLING_FLOWERING_AZALEA, CRIMSON_FUNGUS, WARPED_FUNGUS, CRIMSON_ROOTS, WARPED_ROOTS, NETHER_SPROUTS, TWISTING_VINES, GLOW_LICHEN, MOSS_CARPET, BIG_DRIPLEAF, PUMPKIN, MELON, CARVED_PUMPKIN, JACK_O_LANTERN, VINE, SPORE_BLOSSOM, WEEPING_VINES, HANGING_ROOTS, GLOW_BERRIES, SMALL_DRIPLEAF, MANGROVE_PROPAGULE};
    private static final Random RANDOM = new Random();

    public static void main(String[] args) {
        for (Plant plant : ALL_PLANTS) {
            System.out.println(plant);
        }
    }
}

