/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.plants;

import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;

public enum Category {
    PLANTS_AND_FLOWERS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return (!checkBlockBelow || material.modded || material.isNamed("minecraft:grass_block") || material.isNamed("minecraft:dirt") || material.isNamed("minecraft:coarse_dirt") || material.isNamed("minecraft:podzol") || material.isNamed("minecraft:farmland") || material.isNamed("minecraft:rooted_dirt") || material.isNamed("minecraft:moss_block") || material.isNamed("minecraft:mud")) && !this.isFlooded(world, x, y, z);
        }
    }
    ,
    SAPLINGS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            return PLANTS_AND_FLOWERS.isValidFoundation(world, x, y, z, checkBlockBelow);
        }
    }
    ,
    MUSHROOMS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return (!checkBlockBelow || material.modded || material.solid && material.opaque && material.natural) && !this.isFlooded(world, x, y, z);
        }
    }
    ,
    CROPS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return (!checkBlockBelow || material.modded || material.isNamedOneOf("minecraft:farmland", "minecraft:grass_block", "minecraft:dirt", "minecraft:coarse_dirt", "minecraft:rooted_dirt", "minecraft:grass_path", "minecraft:dirt_path")) && !this.isFlooded(world, x, y, z);
        }
    }
    ,
    SUGAR_CANE{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return !(checkBlockBelow && !material.modded && !material.isNamedOneOf("minecraft:grass_block", "minecraft:dirt", "minecraft:coarse_dirt", "minecraft:podzol", "minecraft:sand", "minecraft:red_sand", "minecraft:rooted_dirt", "minecraft:moss_block", "minecraft:mud") || !this.isWatery(world, x - 1, y, z) && !this.isWatery(world, x, y - 1, z) && !this.isWatery(world, x + 1, y, z) && !this.isWatery(world, x, y + 1, z) || this.isFlooded(world, x, y, z));
        }
    }
    ,
    CACTUS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return (!checkBlockBelow || material.modded || material.isNamed("minecraft:sand") || material.isNamed("minecraft:red_sand")) && !this.isSolidOrCactus(world, x - 1, y, z + 1) && !this.isSolidOrCactus(world, x, y - 1, z + 1) && !this.isSolidOrCactus(world, x + 1, y, z + 1) && !this.isSolidOrCactus(world, x, y + 1, z + 1) && !this.isFlooded(world, x, y, z);
        }
    }
    ,
    FLOATING_PLANTS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            return this.isWatery(world, x, y, z + 1);
        }
    }
    ,
    NETHER{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return PLANTS_AND_FLOWERS.isValidFoundation(world, x, y, z, checkBlockBelow) || (!checkBlockBelow || material.modded || material.isNamed("minecraft:soul_soil")) && !this.isFlooded(world, x, y, z);
        }
    }
    ,
    END{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return (!checkBlockBelow || material.modded || material.isNamed("minecraft:end_stone") || material.isNamed("minecraft:chorus_plant")) && !this.isFlooded(world, x, y, z);
        }
    }
    ,
    WATER_PLANTS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return (!checkBlockBelow || material.modded || material.solid && material.opaque && material.natural) && world.getMaterialAt(x, y, z + 1).containsWater();
        }
    }
    ,
    HANGING_DRY_PLANTS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return (!checkBlockBelow || material.modded || material.solid && material.opaque && material.natural) && !this.isFlooded(world, x, y, z);
        }
    }
    ,
    HANGING_WATER_PLANTS{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            Material material = world.getMaterialAt(x, y, z);
            return (!checkBlockBelow || material.modded || material.solid && material.opaque && material.natural) && this.isFlooded(world, x, y, z);
        }
    }
    ,
    DRIPLEAF{

        @Override
        boolean isValidFoundation(MinecraftWorld world, int x, int y, int z, boolean checkBlockBelow) {
            if (checkBlockBelow) {
                Material material = world.getMaterialAt(x, y, z);
                return material.modded || (world.getMaterialAt(x, y, z + 1).containsWater() ? material.isNamedOneOf("minecraft:clay", "minecraft:moss_block", "minecraft:dirt", "minecraft:coarse_dirt", "minecraft:farmland", "minecraft:grass_block", "minecraft:podzol", "minecraft:rooted_dirt", "minecraft:mycelium", "minecraft:mud") : material.isNamedOneOf("minecraft:clay", "minecraft:moss_block"));
            }
            return true;
        }
    };


    abstract boolean isValidFoundation(MinecraftWorld var1, int var2, int var3, int var4, boolean var5);

    protected final boolean isSolidOrCactus(MinecraftWorld world, int x, int y, int z) {
        Material material = world.getMaterialAt(x, y, z);
        return material.isNamed("minecraft:cactus") || !material.veryInsubstantial;
    }

    protected final boolean isWatery(MinecraftWorld world, int x, int y, int z) {
        return world.getMaterialAt(x, y, z).containsWater();
    }

    protected final boolean isFlooded(MinecraftWorld world, int x, int y, int z) {
        Material materialAbove = world.getMaterialAt(x, y, z + 1);
        return materialAbove.containsWater() || materialAbove.isNamed("minecraft:lava");
    }
}

