/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.groundcover;

import java.awt.Rectangle;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.MixedMaterial;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.FirstPassLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.IncidentalLayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.layers.groundcover.GroundCoverLayer;

public class GroundCoverLayerExporter
extends AbstractLayerExporter<GroundCoverLayer>
implements FirstPassLayerExporter,
IncidentalLayerExporter {
    private final NoiseHeightMap noiseHeightMap;
    private final int noiseOffset;
    private static final long NOISE_SEED_OFFSET = 135101785L;

    public GroundCoverLayerExporter(Dimension dimension, Platform platform, GroundCoverLayer layer) {
        super(dimension, platform, null, layer);
        NoiseSettings noiseSettings = layer.getNoiseSettings();
        if (noiseSettings != null) {
            this.noiseHeightMap = new NoiseHeightMap(noiseSettings, 135101785L);
            this.noiseOffset = noiseSettings.getRange();
        } else {
            this.noiseHeightMap = null;
            this.noiseOffset = 0;
        }
    }

    @Override
    public void render(Tile tile, Chunk chunk) {
        if (this.noiseHeightMap != null) {
            this.noiseHeightMap.setSeed(this.dimension.getSeed());
        }
        int xOffset = (chunk.getxPos() & 7) << 4;
        int zOffset = (chunk.getzPos() & 7) << 4;
        MixedMaterial mixedMaterial = ((GroundCoverLayer)this.layer).getMaterial();
        int thickness = ((GroundCoverLayer)this.layer).getThickness();
        int edgeThickness = Math.abs(thickness) - 2;
        GroundCoverLayer.EdgeShape edgeShape = ((GroundCoverLayer)this.layer).getEdgeShape();
        boolean taperedEdge = edgeShape != GroundCoverLayer.EdgeShape.SHEER && Math.abs(thickness) > 1;
        int edgeWidth = ((GroundCoverLayer)this.layer).getEdgeWidth();
        int edgeWidthPlusOne = edgeWidth + 1;
        int edgeWidthMinusOne = edgeWidth - 1;
        double edgeFactor = (double)edgeThickness / 2.0;
        double edgeOffset = 1.5 + edgeFactor;
        long seed = this.dimension.getSeed();
        boolean smooth = ((GroundCoverLayer)this.layer).isSmooth() || mixedMaterial.getSingleMaterial() == Material.SNOW_EIGHT_LAYERS;
        int patternHeight = mixedMaterial.getPatternHeight();
        GroundCoverLayer.LayerAnchor layeredMaterialAnchor = mixedMaterial.getMode() == MixedMaterial.Mode.LAYERED ? ((GroundCoverLayer)this.layer).getLayerAnchor() : GroundCoverLayer.LayerAnchor.BEDROCK;
        boolean namedBlocks = this.platform.capabilities.contains((Object)Platform.Capability.NAME_BASED);
        for (int x = 0; x < 16; ++x) {
            int localX = xOffset + x;
            int worldX = (chunk.getxPos() << 4) + x;
            for (int z = 0; z < 16; ++z) {
                int y;
                int yOffset;
                float distanceToEdge;
                Material blockBelow;
                int localY = zOffset + z;
                if (!tile.getBitLayerValue(this.layer, localX, localY)) continue;
                int terrainheight = tile.getIntHeight(localX, localY);
                Material material = blockBelow = terrainheight >= this.minHeight && terrainheight < this.maxHeight ? chunk.getMaterial(x, terrainheight, z) : Material.AIR;
                if (blockBelow == Material.AIR || blockBelow.insubstantial) continue;
                int effectiveThickness = Math.abs(thickness);
                int worldY = (chunk.getzPos() << 4) + z;
                if (taperedEdge && (distanceToEdge = this.dimension.getDistanceToEdge(this.layer, worldX, worldY, edgeWidthPlusOne)) < (float)edgeWidthPlusOne) {
                    double normalisedDistance = (distanceToEdge - 1.0f) / (float)edgeWidthMinusOne;
                    switch (edgeShape) {
                        case LINEAR: {
                            effectiveThickness = (int)(1.5 + normalisedDistance * (double)edgeThickness);
                            break;
                        }
                        case SMOOTH: {
                            effectiveThickness = (int)(edgeOffset + -Math.cos(normalisedDistance * Math.PI) * edgeFactor);
                            break;
                        }
                        case ROUNDED: {
                            double reversedNormalisedDistance = 1.0 - ((double)distanceToEdge - 0.5) / (double)edgeWidth;
                            effectiveThickness = (int)(1.5 + Math.sqrt(1.0 - reversedNormalisedDistance * reversedNormalisedDistance) * (double)edgeThickness);
                        }
                    }
                }
                if (this.noiseHeightMap != null) {
                    effectiveThickness = (int)((double)effectiveThickness + (this.noiseHeightMap.getHeight(worldX, worldY) - (double)this.noiseOffset));
                }
                if (thickness > 0) {
                    switch (layeredMaterialAnchor) {
                        case BEDROCK: {
                            yOffset = 0;
                            break;
                        }
                        case TERRAIN: {
                            yOffset = -(terrainheight + 1);
                            break;
                        }
                        case TOP_OF_LAYER: {
                            yOffset = -(terrainheight + effectiveThickness - patternHeight + 1);
                            break;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                    if (smooth) {
                        int y2;
                        float distanceToEdge2;
                        float fEffectiveThickness = Math.abs(thickness);
                        if (taperedEdge && (distanceToEdge2 = this.dimension.getDistanceToEdge(this.layer, worldX, worldY, edgeWidthPlusOne)) < (float)edgeWidth) {
                            double normalisedDistance = distanceToEdge2 / (float)edgeWidthPlusOne;
                            switch (edgeShape) {
                                case LINEAR: {
                                    fEffectiveThickness = (float)(normalisedDistance * (double)thickness);
                                    break;
                                }
                                case SMOOTH: {
                                    fEffectiveThickness = (float)((-Math.cos(normalisedDistance * Math.PI) + 1.0) * (double)thickness / 2.0);
                                    break;
                                }
                                case ROUNDED: {
                                    double reversedNormalisedDistance = 1.0 - ((double)distanceToEdge2 - 0.5) / (double)edgeWidth;
                                    fEffectiveThickness = (float)(Math.sqrt(1.0 - reversedNormalisedDistance * reversedNormalisedDistance) * (double)thickness);
                                }
                            }
                        }
                        if (this.noiseHeightMap != null) {
                            fEffectiveThickness = (float)((double)fEffectiveThickness + (this.noiseHeightMap.getHeight(worldX, worldY) - (double)this.noiseOffset));
                        }
                        int dy = 0;
                        for (int layerHeight = Math.max(Math.round((this.dimension.getHeightAt(worldX, worldY) + fEffectiveThickness - (float)this.dimension.getIntHeightAt(worldX, worldY)) / 0.125f), 1); layerHeight > 0 && (y2 = terrainheight + dy + 1) <= this.maxZ; layerHeight -= 8) {
                            Material existingMaterial = chunk.getMaterial(x, y2, z);
                            Material material2 = mixedMaterial.getMaterial(seed, worldX, worldY, y2 + yOffset);
                            if (material2 != Material.AIR && (!material2.veryInsubstantial || existingMaterial == Material.AIR || existingMaterial.insubstantial)) {
                                if (layerHeight < 8) {
                                    if (namedBlocks) {
                                        chunk.setMaterial(x, y2, z, material2.withProperty(Material.LAYERS, layerHeight));
                                    } else {
                                        chunk.setMaterial(x, y2, z, Material.get(material2.blockType, layerHeight - 1));
                                    }
                                } else {
                                    chunk.setMaterial(x, y2, z, material2 == Material.SNOW_EIGHT_LAYERS ? Material.SNOW_BLOCK : material2);
                                }
                            }
                            ++dy;
                        }
                        continue;
                    }
                    for (int dy = 0; dy < effectiveThickness && (y = terrainheight + dy + 1) <= this.maxZ; ++dy) {
                        Material existingMaterial = chunk.getMaterial(x, y, z);
                        Material material3 = mixedMaterial.getMaterial(seed, worldX, worldY, y + yOffset);
                        if (material3 == Material.AIR || material3.veryInsubstantial && existingMaterial != Material.AIR && !existingMaterial.insubstantial) continue;
                        chunk.setMaterial(x, y, z, material3);
                    }
                    continue;
                }
                switch (layeredMaterialAnchor) {
                    case BEDROCK: {
                        yOffset = 0;
                        break;
                    }
                    case TERRAIN: {
                        yOffset = -(terrainheight - effectiveThickness + 1);
                        break;
                    }
                    case TOP_OF_LAYER: {
                        yOffset = -(terrainheight - patternHeight + 1);
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                for (int dy = 0; dy < effectiveThickness && (y = terrainheight - dy) >= this.minZ; ++dy) {
                    Material existingMaterial = chunk.getMaterial(x, y, z);
                    if (existingMaterial == Material.AIR) continue;
                    chunk.setMaterial(x, y, z, mixedMaterial.getMaterial(seed, worldX, worldY, y + yOffset));
                }
            }
        }
    }

    @Override
    public Fixup apply(Point3i location, int intensity, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        block5: {
            Material blockBelow;
            if (intensity <= 0 || (blockBelow = minecraftWorld.getMaterialAt(location.x, location.y, location.z - 1)) == Material.AIR || blockBelow.insubstantial) break block5;
            int thickness = ((GroundCoverLayer)this.layer).getThickness();
            MixedMaterial mixedMaterial = ((GroundCoverLayer)this.layer).getMaterial();
            long seed = this.dimension.getSeed();
            int effectiveThickness = Math.abs(thickness);
            if (this.noiseHeightMap != null) {
                this.noiseHeightMap.setSeed(seed);
                effectiveThickness = (int)((double)effectiveThickness + (this.noiseHeightMap.getHeight(location.x, location.y) - (double)this.noiseOffset));
            }
            if (thickness > 0) {
                int z;
                for (int dz = 0; dz < effectiveThickness && (z = location.z + dz) <= this.maxZ; ++dz) {
                    Material existingMaterial = minecraftWorld.getMaterialAt(location.x, location.y, z);
                    Material material = mixedMaterial.getMaterial(seed, location.x, location.y, z);
                    if (material == Material.AIR || material.veryInsubstantial && existingMaterial != Material.AIR && !existingMaterial.insubstantial) continue;
                    minecraftWorld.setMaterialAt(location.x, location.y, z, material);
                }
            } else {
                int z;
                for (int dz = 0; dz < effectiveThickness && (z = location.z - 1 - dz) >= this.minZ; ++dz) {
                    Material existingMaterial = minecraftWorld.getMaterialAt(location.x, location.y, z);
                    if (existingMaterial == Material.AIR) continue;
                    minecraftWorld.setMaterialAt(location.x, location.y, z, mixedMaterial.getMaterial(seed, location.x, location.y, z));
                }
            }
        }
        return null;
    }
}

