/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.pepsoft.minecraft.Material;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Terrain;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.CliffCarver;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.util.GeometryUtil;

public class CliffCarverExporter
extends AbstractLayerExporter<CliffCarver>
implements SecondPassLayerExporter {
    private int minCliffHeight = 2;

    public CliffCarverExporter(Dimension dimension, Platform platform, ExporterSettings settings, CliffCarver layer) {
        super(dimension, platform, settings, layer);
    }

    public int getMinCliffHeight() {
        return this.minCliffHeight;
    }

    public void setMinCliffHeight(int minCliffHeight) {
        this.minCliffHeight = minCliffHeight;
    }

    @Override
    public List<Fixup> carve(Rectangle area, Rectangle exportedArea, MinecraftWorld world) {
        for (int x = area.x; x < area.x + area.width; ++x) {
            for (int y = area.y; y < area.y + area.height; ++y) {
                if (!this.dimension.getBitLayerValueAt(this.layer, x, y)) continue;
                this.carveColumn(world, x, y);
            }
        }
        return null;
    }

    private void carveColumn(MinecraftWorld world, int x, int y) {
        float terrainHeight = this.dimension.getHeightAt(x, y);
        Terrain terrain = this.dimension.getTerrainAt(x, y);
        long seed = this.dimension.getSeed();
        float cliffTop = Math.max(Math.max(this.dimension.getHeightAt(x - 1, y), this.dimension.getHeightAt(x, y - 1)), Math.max(this.dimension.getHeightAt(x + 1, y), this.dimension.getHeightAt(x, y + 1)));
        float cliffHeight = cliffTop - terrainHeight;
        boolean replaceTerrain = true;
        float previousCarveDepth = 0.0f;
        if (cliffHeight > (float)this.minCliffHeight) {
            for (int z = Math.round(terrainHeight) + 1; z < Math.round(cliffTop); ++z) {
                float carveDepth = this.getCarveDepth(x, y, terrainHeight, (float)z - terrainHeight, cliffHeight);
                if (replaceTerrain && carveDepth <= previousCarveDepth) {
                    replaceTerrain = false;
                }
                previousCarveDepth = carveDepth;
                for (Point p : GeometryUtil.getFilledCircleCoordinates(carveDepth)) {
                    int worldX = x + p.x;
                    int worldY = y + p.y;
                    if (p.x == 0 && p.y == 0 || !this.dimension.getBitLayerValueAt(this.layer, worldX, worldY)) continue;
                    world.setMaterialAt(worldX, worldY, z, Material.AIR);
                    int zBelow = z - 1;
                    if (!replaceTerrain || !world.getMaterialAt((int)worldX, (int)worldY, (int)zBelow).solid) continue;
                    world.setMaterialAt(worldX, worldY, zBelow, terrain.getMaterial(this.platform, seed, worldX, worldY, zBelow, zBelow));
                    System.out.println(world.getMaterialAt(worldX, worldY, zBelow));
                }
            }
        }
    }

    private float getCarveDepth(int x, int y, float terrainHeight, float dz, float cliffHeight) {
        return Math.min(Math.min(dz, cliffHeight - dz), 16.0f);
    }
}

