/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import com.google.common.collect.ImmutableSet;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.Fixup;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.exporting.SecondPassLayerExporter;
import org.pepsoft.worldpainter.layers.Chasms;
import org.pepsoft.worldpainter.layers.Void;
import org.pepsoft.worldpainter.layers.exporters.AbstractCavesExporter;
import org.pepsoft.worldpainter.layers.exporters.CaveSettings;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;

public class ChasmsExporter
extends AbstractCavesExporter<Chasms>
implements SecondPassLayerExporter {
    private final PerlinNoise perlinNoise = new PerlinNoise(0L);
    private final PerlinNoise perlinNoise2 = new PerlinNoise(0L);
    private final PerlinNoise perlinNoise3 = new PerlinNoise(0L);
    private final PerlinNoise perlinNoise4 = new PerlinNoise(0L);
    private final PerlinNoise perlinNoise5 = new PerlinNoise(0L);
    private final PerlinNoise perlinNoise6 = new PerlinNoise(0L);
    private static final float CHASM_CHANCE = 0.5f;
    private static final long SEED_OFFSET = 37L;
    private static final long SEED_OFFSET2 = 41L;
    private static final long SEED_OFFSET3 = 43L;
    private static final long SEED_OFFSET4 = 47L;
    private static final long SEED_OFFSET5 = 49L;
    private static final long SEED_OFFSET6 = 51L;

    public ChasmsExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        super(dimension, platform, settings instanceof ChasmsSettings ? (ChasmsSettings)settings : new ChasmsSettings(), Chasms.INSTANCE);
    }

    @Override
    public Set<SecondPassLayerExporter.Stage> getStages() {
        return this.decorationEnabled ? ImmutableSet.of((Object)((Object)SecondPassLayerExporter.Stage.CARVE), (Object)((Object)SecondPassLayerExporter.Stage.ADD_FEATURES)) : Collections.singleton(SecondPassLayerExporter.Stage.CARVE);
    }

    @Override
    public List<Fixup> carve(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        ChasmsSettings settings = (ChasmsSettings)this.settings;
        boolean surfaceBreaking = settings.isSurfaceBreaking();
        boolean glassCeiling = settings.isGlassCeiling();
        int minimumLevel = settings.getChasmsEverywhereLevel();
        int minY = settings.getMinimumLevel();
        int maxY = Math.min(settings.getMaximumLevel(), this.maxZ);
        int extremeY = Integer.MAX_VALUE - Math.max(-minY, 0);
        boolean fallThrough = minY == this.minHeight && this.dimension.isBottomless();
        int minYAdjusted = Math.max(minY, this.minHeight + 1);
        long seed = this.dimension.getSeed();
        if (seed + 37L != this.perlinNoise.getSeed()) {
            this.perlinNoise.setSeed(seed + 37L);
            this.perlinNoise2.setSeed(seed + 41L);
            this.perlinNoise3.setSeed(seed + 43L);
            this.perlinNoise4.setSeed(seed + 47L);
            this.perlinNoise5.setSeed(seed + 49L);
            this.perlinNoise6.setSeed(seed + 51L);
        }
        this.visitChunksForLayerInAreaForEditing(minecraftWorld, this.layer, area, this.dimension, (tile, chunkX, chunkZ, chunkSupplier) -> {
            Chunk chunk = (Chunk)chunkSupplier.get();
            int xOffset = (chunkX & 7) << 4;
            int zOffset = (chunkZ & 7) << 4;
            this.setupForColumn(seed, tile, maxY, settings.getWaterLevel() >= this.minHeight ? settings.getWaterLevel() : this.minHeight - 1, glassCeiling, surfaceBreaking, settings.isLeaveWater(), settings.isFloodWithLava());
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int localX = xOffset + x;
                    int localY = zOffset + z;
                    if (tile.getBitLayerValue(Void.INSTANCE, localX, localY)) continue;
                    int chasmsValue = Math.max(minimumLevel, tile.getLayerValue(Chasms.INSTANCE, localX, localY));
                    if (chasmsValue > 0) {
                        int terrainheight;
                        int worldX = tile.getX() * 128 + localX;
                        int worldY = tile.getY() * 128 + localY;
                        float px = (float)worldX / 32.771f;
                        float py = (float)worldY / 32.771f;
                        int y = terrainheight = Math.min(tile.getIntHeight(localX, localY), maxY);
                        while (fallThrough ? y >= this.minHeight : y >= minYAdjusted) {
                            if (chunk.getMaterial(x, y, z) == Material.AIR) {
                                this.emptyBlockEncountered();
                            } else {
                                float bias = 0.5f * Math.max(0.1f * (float)(10 - Math.min(Math.min(surfaceBreaking ? Integer.MAX_VALUE : terrainheight - Math.max(this.dimension.getTopLayerDepth(worldX, worldY, terrainheight), 3) - y, (fallThrough ? extremeY : y - 1) - minY), 10)), 1.0f - (float)chasmsValue / 15.0f);
                                if (fallThrough && y < this.minHeight + 5) {
                                    bias -= (float)(this.minHeight + 5 - y) * 0.05f;
                                }
                                float pz = (float)(y + 15) / 32.771f;
                                double cavernLikelyhood = Math.min((double)(this.perlinNoise3.getPerlinNoise((double)px, (double)py, (double)pz) - bias), Math.min(Math.sin(this.perlinNoise.getPerlinNoise((double)px, (double)py, (double)pz) * 25.0f), Math.cos(this.perlinNoise2.getPerlinNoise((double)px, (double)py, (double)pz) * 25.0f)) / 2.0) + 0.5;
                                double cavernLikelyhood2 = Math.min((double)(this.perlinNoise6.getPerlinNoise((double)px, (double)py, (double)pz) - bias), Math.min(Math.sin(this.perlinNoise4.getPerlinNoise((double)px, (double)py, (double)pz) * 25.0f), Math.cos(this.perlinNoise5.getPerlinNoise((double)px, (double)py, (double)pz) * 25.0f)) / 2.0) + 0.5;
                                this.processBlock(chunk, x, y, z, cavernLikelyhood > 0.5 || cavernLikelyhood2 > 0.5);
                            }
                            --y;
                        }
                    }
                    if (glassCeiling) {
                        chunk.setHeight(x, z, 1);
                    }
                    this.resetColumn();
                }
            }
            return true;
        });
        return null;
    }

    @Override
    public List<Fixup> addFeatures(Rectangle area, Rectangle exportedArea, MinecraftWorld minecraftWorld) {
        ChasmsSettings settings = (ChasmsSettings)this.settings;
        boolean surfaceBreaking = settings.isSurfaceBreaking();
        int minimumLevel = settings.getChasmsEverywhereLevel();
        int minY = settings.getMinimumLevel();
        int maxY = Math.min(settings.getMaximumLevel(), this.maxZ);
        int extremeY = Integer.MAX_VALUE - Math.max(-minY, 0);
        boolean fallThrough = minY == this.minHeight && this.dimension.isBottomless();
        int minYAdjusted = Math.max(minY, this.minHeight + 1);
        long seed = this.dimension.getSeed();
        if (seed + 37L != this.perlinNoise.getSeed()) {
            this.perlinNoise.setSeed(seed + 37L);
            this.perlinNoise2.setSeed(seed + 41L);
            this.perlinNoise3.setSeed(seed + 43L);
            this.perlinNoise4.setSeed(seed + 47L);
            this.perlinNoise5.setSeed(seed + 49L);
            this.perlinNoise6.setSeed(seed + 51L);
        }
        Random random = new Random(seed + 37L + 1L);
        this.visitChunksForLayerInAreaForEditing(minecraftWorld, this.layer, area, this.dimension, (tile, chunkX, chunkZ, chunkSupplier) -> {
            int xOffset = (chunkX & 7) << 4;
            int zOffset = (chunkZ & 7) << 4;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    int terrainheight;
                    int chasmsValue;
                    int localX = xOffset + x;
                    int localY = zOffset + z;
                    if (tile.getBitLayerValue(Void.INSTANCE, localX, localY) || (chasmsValue = Math.max(minimumLevel, tile.getLayerValue(Chasms.INSTANCE, localX, localY))) <= 0) continue;
                    int worldX = tile.getX() * 128 + localX;
                    int worldY = tile.getY() * 128 + localY;
                    float px = (float)worldX / 32.771f;
                    float py = (float)worldY / 32.771f;
                    int y = terrainheight = Math.min(tile.getIntHeight(localX, localY), maxY);
                    while (fallThrough ? y >= this.minHeight : y >= minYAdjusted) {
                        float bias = 0.5f * Math.max(0.1f * (float)(10 - Math.min(Math.min(surfaceBreaking ? Integer.MAX_VALUE : terrainheight - Math.max(this.dimension.getTopLayerDepth(worldX, worldY, terrainheight), 3) - y, (fallThrough ? extremeY : y - 1) - minY), 10)), 1.0f - (float)chasmsValue / 15.0f);
                        if (fallThrough && y < this.minHeight + 5) {
                            bias -= (float)(this.minHeight + 5 - y) * 0.05f;
                        }
                        float pz = (float)(y + 15) / 32.771f;
                        double cavernLikelyhood = Math.min((double)(this.perlinNoise3.getPerlinNoise((double)px, (double)py, (double)pz) - bias), Math.min(Math.sin(this.perlinNoise.getPerlinNoise((double)px, (double)py, (double)pz) * 25.0f), Math.cos(this.perlinNoise2.getPerlinNoise((double)px, (double)py, (double)pz) * 25.0f)) / 2.0) + 0.5;
                        double cavernLikelyhood2 = Math.min((double)(this.perlinNoise6.getPerlinNoise((double)px, (double)py, (double)pz) - bias), Math.min(Math.sin(this.perlinNoise4.getPerlinNoise((double)px, (double)py, (double)pz) * 25.0f), Math.cos(this.perlinNoise5.getPerlinNoise((double)px, (double)py, (double)pz) * 25.0f)) / 2.0) + 0.5;
                        if (cavernLikelyhood > 0.5 || cavernLikelyhood2 > 0.5) {
                            this.decorateBlock(minecraftWorld, random, worldX, worldY, y);
                        }
                        --y;
                    }
                }
            }
            return true;
        });
        return null;
    }

    public static class ChasmsSettings
    implements CaveSettings {
        private int waterLevel = Integer.MIN_VALUE;
        private int chasmsEverywhereLevel;
        private boolean floodWithLava;
        private boolean glassCeiling;
        private boolean surfaceBreaking;
        private boolean leaveWater = true;
        private int minimumLevel = Integer.MIN_VALUE;
        private int maximumLevel = Integer.MAX_VALUE;
        private AbstractCavesExporter.CaveDecorationSettings decorationSettings = new AbstractCavesExporter.CaveDecorationSettings();
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isApplyEverywhere() {
            return this.chasmsEverywhereLevel > 0;
        }

        @Override
        public Chasms getLayer() {
            return Chasms.INSTANCE;
        }

        public boolean isFloodWithLava() {
            return this.floodWithLava;
        }

        public void setFloodWithLava(boolean floodWithLava) {
            this.floodWithLava = floodWithLava;
        }

        public boolean isGlassCeiling() {
            return this.glassCeiling;
        }

        public void setGlassCeiling(boolean glassCeiling) {
            this.glassCeiling = glassCeiling;
        }

        public boolean isSurfaceBreaking() {
            return this.surfaceBreaking;
        }

        public void setSurfaceBreaking(boolean surfaceBreaking) {
            this.surfaceBreaking = surfaceBreaking;
        }

        public int getWaterLevel() {
            return this.waterLevel;
        }

        public void setWaterLevel(int waterLevel) {
            this.waterLevel = waterLevel;
        }

        public int getChasmsEverywhereLevel() {
            return this.chasmsEverywhereLevel;
        }

        public void setChasmsEverywhereLevel(int chasmsEverywhereLevel) {
            this.chasmsEverywhereLevel = chasmsEverywhereLevel;
        }

        public boolean isLeaveWater() {
            return this.leaveWater;
        }

        public void setLeaveWater(boolean leaveWater) {
            this.leaveWater = leaveWater;
        }

        public int getMinimumLevel() {
            return this.minimumLevel;
        }

        public void setMinimumLevel(int minimumLevel) {
            this.minimumLevel = minimumLevel;
        }

        public int getMaximumLevel() {
            return this.maximumLevel;
        }

        public void setMaximumLevel(int maximumLevel) {
            this.maximumLevel = maximumLevel;
        }

        @Override
        public AbstractCavesExporter.CaveDecorationSettings getCaveDecorationSettings() {
            return this.decorationSettings;
        }

        public void setCaveDecorationSettings(AbstractCavesExporter.CaveDecorationSettings decorationSettings) {
            this.decorationSettings = decorationSettings;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChasmsSettings other = (ChasmsSettings)obj;
            if (this.waterLevel != other.waterLevel) {
                return false;
            }
            if (this.chasmsEverywhereLevel != other.chasmsEverywhereLevel) {
                return false;
            }
            if (this.floodWithLava != other.floodWithLava) {
                return false;
            }
            if (this.glassCeiling != other.glassCeiling) {
                return false;
            }
            if (this.surfaceBreaking != other.surfaceBreaking) {
                return false;
            }
            if (this.leaveWater != other.leaveWater) {
                return false;
            }
            if (this.minimumLevel != other.minimumLevel) {
                return false;
            }
            if (this.maximumLevel != other.maximumLevel) {
                return false;
            }
            return Objects.equals(this.decorationSettings, other.decorationSettings);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + this.waterLevel;
            hash = 29 * hash + this.chasmsEverywhereLevel;
            hash = 29 * hash + (this.floodWithLava ? 1 : 0);
            hash = 29 * hash + (this.glassCeiling ? 1 : 0);
            hash = 29 * hash + (this.surfaceBreaking ? 1 : 0);
            hash = 29 * hash + (this.leaveWater ? 1 : 0);
            hash = 29 * hash + this.minimumLevel;
            hash = 29 * hash + this.maximumLevel;
            hash = 29 * hash + (this.decorationSettings != null ? this.decorationSettings.hashCode() : 0);
            return hash;
        }

        @Override
        public ChasmsSettings clone() {
            try {
                ChasmsSettings clone = (ChasmsSettings)super.clone();
                if (this.decorationSettings != null) {
                    clone.decorationSettings = this.decorationSettings.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.maximumLevel == 0) {
                this.maximumLevel = Integer.MAX_VALUE;
            }
            if (this.decorationSettings == null) {
                this.decorationSettings = new AbstractCavesExporter.CaveDecorationSettings(true, false, false, false);
            }
        }
    }
}

