/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.exporters;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.pepsoft.minecraft.Chunk;
import org.pepsoft.minecraft.Direction;
import org.pepsoft.minecraft.Material;
import org.pepsoft.util.mdc.MDCWrappingRuntimeException;
import org.pepsoft.worldpainter.Constants;
import org.pepsoft.worldpainter.DefaultPlugin;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.NoiseSettings;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.Tile;
import org.pepsoft.worldpainter.exporting.AbstractLayerExporter;
import org.pepsoft.worldpainter.exporting.MinecraftWorld;
import org.pepsoft.worldpainter.heightMaps.NoiseHeightMap;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.CaveSettings;
import org.pepsoft.worldpainter.layers.exporters.WPObjectExporter;
import org.pepsoft.worldpainter.layers.plants.Plants;
import org.pepsoft.worldpainter.util.BiomeUtils;

public abstract class AbstractCavesExporter<L extends Layer>
extends AbstractLayerExporter<L> {
    protected final boolean decorationEnabled;
    private final CaveDecorationSettings decorationSettings;
    private final NoiseHeightMap lushCaveNoise;
    private final NoiseHeightMap dripstoneCaveNoise;
    private final BiomeUtils biomeUtils;
    private final boolean decorateBrownMushrooms;
    private final boolean decorateGlowLichen;
    private final boolean decorateLushCaves;
    private final boolean decorateDripstoneCaves;
    private final boolean setBiomes;
    private static final ThreadLocal<State> STATE_HOLDER = new ThreadLocal();
    private static final int MUSHROOM_CHANCE = 250;
    private static final float LUSH_CAVE_THRESHOLD = 600.0f;
    private static final float DRIPSTONE_CAVE_THRESHOLD = 675.0f;
    private static final Set<String> SUPPORTS_DRIPSTONE = ImmutableSet.of((Object)"minecraft:bedrock", (Object)"minecraft:stone", (Object)"minecraft:granite", (Object)"minecraft:andesite", (Object)"minecraft:diorite", (Object)"minecraft:calcite", (Object[])new String[]{"minecraft:basalt", "minecraft:deepslate", "minecraft:coal_ore", "minecraft:iron_ore", "minecraft:gold_ore", "minecraft:redstone_ore", "minecraft:diamond_ore", "minecraft:lapis_ore", "minecraft:emerald_ore", "minecraft:nether_quartz_ore", "minecraft:copper_ore", "minecraft:deepslate_coal_ore", "minecraft:deepslate_iron_ore", "minecraft:deepslate_gold_ore", "minecraft:deepslate_redstone_ore", "minecraft:deepslate_diamond_ore", "minecraft:deepslate_lapis_ore", "minecraft:deepslate_emerald_ore", "minecraft:deepslate_copper_ore"});

    public AbstractCavesExporter(Dimension dimension, Platform platform, CaveSettings settings, L layer) {
        super(dimension, platform, settings, layer);
        CaveDecorationSettings caveDecorationSettings = this.decorationSettings = settings != null ? settings.getCaveDecorationSettings() : null;
        if (this.decorationSettings != null) {
            this.decorateBrownMushrooms = this.decorationSettings.isEnabled(CaveDecorationSettings.Decoration.BROWN_MUSHROOM);
            boolean mcVersionAtLeast1_17 = platform.getAttribute(DefaultPlugin.ATTRIBUTE_MC_VERSION).isAtLeast(Constants.V_1_17);
            this.decorateGlowLichen = this.decorationSettings.isEnabled(CaveDecorationSettings.Decoration.GLOW_LICHEN) && mcVersionAtLeast1_17;
            this.decorateLushCaves = this.decorationSettings.isEnabled(CaveDecorationSettings.Decoration.LUSH_CAVE_PATCHES) && mcVersionAtLeast1_17;
            this.decorateDripstoneCaves = this.decorationSettings.isEnabled(CaveDecorationSettings.Decoration.DRIPSTONE_CAVE_PATCHES) && mcVersionAtLeast1_17;
            this.decorationEnabled = this.decorateBrownMushrooms || this.decorateGlowLichen || this.decorateLushCaves || this.decorateDripstoneCaves;
            this.lushCaveNoise = this.decorateLushCaves ? new NoiseHeightMap(this.decorationSettings.noiseSettingsMap.get((Object)CaveDecorationSettings.Decoration.LUSH_CAVE_PATCHES), dimension.getSeed() + 1L) : null;
            this.dripstoneCaveNoise = this.decorateDripstoneCaves ? new NoiseHeightMap(this.decorationSettings.noiseSettingsMap.get((Object)CaveDecorationSettings.Decoration.DRIPSTONE_CAVE_PATCHES), dimension.getSeed() + 2L) : null;
            this.biomeUtils = new BiomeUtils(dimension);
            this.setBiomes = platform.capabilities.contains((Object)Platform.Capability.BIOMES_3D) || platform.capabilities.contains((Object)Platform.Capability.NAMED_BIOMES);
        } else {
            this.setBiomes = false;
            this.decorateDripstoneCaves = false;
            this.decorateLushCaves = false;
            this.decorateGlowLichen = false;
            this.decorateBrownMushrooms = false;
            this.decorationEnabled = false;
            this.dripstoneCaveNoise = null;
            this.lushCaveNoise = null;
            this.biomeUtils = null;
        }
    }

    protected final void setupForColumn(long seed, Tile tile, int maxY, int waterLevel, boolean glassCeiling, boolean surfaceBreaking, boolean leaveWater, boolean floodWithLava) {
        State state = new State();
        state.seed = seed;
        state.tile = tile;
        state.maxY = maxY;
        state.waterLevel = waterLevel;
        state.glassCeiling = glassCeiling;
        state.surfaceBreaking = surfaceBreaking;
        state.leaveWater = leaveWater;
        state.floodWithLava = floodWithLava;
        STATE_HOLDER.set(state);
    }

    protected final void resetColumn() {
        State state = STATE_HOLDER.get();
        state.breachedCeiling = false;
        state.previousBlockInCavern = false;
    }

    protected final void emptyBlockEncountered() {
        State state = STATE_HOLDER.get();
        state.breachedCeiling = true;
        state.previousBlockInCavern = true;
    }

    protected final void processBlock(Chunk chunk, int x, int y, int z, boolean excavate) {
        State state = STATE_HOLDER.get();
        if (excavate) {
            if (!state.breachedCeiling && y < state.maxY) {
                if (state.glassCeiling) {
                    int terrainheight = state.tile.getIntHeight(x, z);
                    for (int yy = y + 1; yy <= terrainheight; ++yy) {
                        chunk.setMaterial(x, yy, z, Material.GLASS);
                    }
                }
                if (state.surfaceBreaking) {
                    Material blockAbove = chunk.getMaterial(x, y + 1, z);
                    if (!state.leaveWater) {
                        int terrainheight = state.tile.getIntHeight(x, z);
                        if (blockAbove.isNamed("minecraft:water")) {
                            for (int yy = y + 1; yy <= terrainheight && chunk.getMaterial(x, yy, z).isNamed("minecraft:water"); ++yy) {
                                chunk.setMaterial(x, yy, z, Material.AIR);
                            }
                        } else if (blockAbove.isNamed("minecraft:lava")) {
                            for (int yy = y + 1; yy <= terrainheight && chunk.getMaterial(x, yy, z).isNamed("minecraft:lava"); ++yy) {
                                chunk.setMaterial(x, yy, z, Material.AIR);
                            }
                        }
                    }
                }
            }
            state.breachedCeiling = true;
            if (y > state.waterLevel) {
                chunk.setMaterial(x, y, z, Material.AIR);
                state.previousBlockInCavern = true;
            } else {
                if (state.floodWithLava) {
                    chunk.setMaterial(x, y, z, Material.LAVA);
                } else {
                    chunk.setMaterial(x, y, z, Material.WATER);
                }
                state.previousBlockInCavern = false;
            }
        } else if (state.previousBlockInCavern && y >= state.waterLevel && !chunk.getMaterial((int)x, (int)y, (int)z).veryInsubstantial) {
            state.previousBlockInCavern = false;
        }
    }

    protected final void decorateBlock(MinecraftWorld world, Random rng, int x, int y, int height) {
        int terrainHeight;
        int biomeUpperLimit;
        boolean inDripstoneCave;
        if (!this.decorationEnabled || height < this.minZ || height > this.maxZ) {
            return;
        }
        Material material = world.getMaterialAt(x, y, height);
        boolean inLushCave = this.decorateLushCaves && this.decorationSettings.isEnabledAt(CaveDecorationSettings.Decoration.LUSH_CAVE_PATCHES, height) && this.lushCaveNoise.getValue(x, y, (double)height * 2.0) >= 600.0;
        boolean bl = inDripstoneCave = this.decorateDripstoneCaves && this.decorationSettings.isEnabledAt(CaveDecorationSettings.Decoration.DRIPSTONE_CAVE_PATCHES, height) && this.dripstoneCaveNoise.getValue(x, y, (double)height * 2.0) >= 675.0;
        if (this.setBiomes && (inLushCave || inDripstoneCave) && height <= (biomeUpperLimit = ((terrainHeight = this.dimension.getIntHeightAt(x, y)) - this.dimension.getTopLayerDepth(x, y, terrainHeight) >> 2 << 2) - 1)) {
            this.biomeUtils.set3DBiome(world.getChunkForEditing(x >> 4, y >> 4), (x & 0xF) >> 2, height >> 2, (y & 0xF) >> 2, inLushCave ? 175 : 174);
        }
        if (material == Material.AIR || material.isNamed("minecraft:water")) {
            Material materialAbove;
            int spaceAvailable;
            Material materialBelow;
            Material material2 = materialBelow = height > this.minHeight ? world.getMaterialAt(x, y, height - 1) : null;
            if (materialBelow != null && !materialBelow.veryInsubstantial && !materialBelow.isNamed("minecraft:pointed_dripstone")) {
                int waterDepth = material == Material.AIR ? 1 : 0;
                spaceAvailable = 1;
                for (int dz = 1; dz < 7 && height + dz < this.maxHeight; ++dz) {
                    if (world.getMaterialAt(x, y, height + dz).isNamed("minecraft:water")) {
                        ++waterDepth;
                    } else if (world.getMaterialAt(x, y, height + dz) != Material.AIR) break;
                    ++spaceAvailable;
                }
                if (this.decorateFloor(world, rng, x, y, height, inLushCave, inDripstoneCave, material, materialBelow, spaceAvailable, waterDepth)) {
                    return;
                }
            }
            Material material3 = materialAbove = height < this.maxHeight - 1 ? world.getMaterialAt(x, y, height + 1) : null;
            if (materialAbove != null && !materialAbove.veryInsubstantial && !materialAbove.isNamed("minecraft:pointed_dripstone")) {
                Material material1;
                spaceAvailable = 1;
                int drySpaceAvailable = material == Material.AIR ? 1 : 0;
                for (int dz = 1; !(dz >= 7 || height - dz < this.minHeight || (material1 = world.getMaterialAt(x, y, height - dz)) != Material.AIR && material1.isNotNamed("minecraft:water")); ++dz) {
                    if (material1 == Material.AIR && drySpaceAvailable != 0) {
                        ++drySpaceAvailable;
                    }
                    ++spaceAvailable;
                }
                if (this.decorateRoof(world, rng, x, y, height, inLushCave, inDripstoneCave, material, materialAbove, spaceAvailable, drySpaceAvailable)) {
                    return;
                }
            }
            Material materialNorth = world.getMaterialAt(x, y - 1, height);
            Material materialSouth = world.getMaterialAt(x, y + 1, height);
            Material materialEast = world.getMaterialAt(x + 1, y, height);
            Material materialWest = world.getMaterialAt(x - 1, y, height);
            if (!materialNorth.veryInsubstantial && !materialNorth.isNamed("minecraft:pointed_dripstone") || !materialSouth.veryInsubstantial && !materialSouth.isNamed("minecraft:pointed_dripstone") || !materialEast.veryInsubstantial && !materialEast.isNamed("minecraft:pointed_dripstone") || !materialWest.veryInsubstantial && !materialWest.isNamed("minecraft:pointed_dripstone")) {
                this.decorateWall(world, rng, x, y, height, inLushCave, material, materialNorth, materialSouth, materialEast, materialWest);
            }
        }
    }

    private boolean decorateFloor(MinecraftWorld world, Random rng, int x, int y, int height, boolean inLushCave, boolean inDripstoneCave, Material existingMaterial, Material materialBelow, int spaceAvailable, int waterDepth) {
        if (this.decorateBrownMushrooms && this.decorationSettings.isEnabledAt(CaveDecorationSettings.Decoration.BROWN_MUSHROOM, height) && rng.nextInt(250) == 0 && existingMaterial.isNotNamed("minecraft:water")) {
            world.setMaterialAt(x, y, height, Material.BROWN_MUSHROOM);
            return true;
        }
        if (this.decorateGlowLichen && this.decorationSettings.isEnabledAt(CaveDecorationSettings.Decoration.GLOW_LICHEN, height) && rng.nextInt(250) == 0) {
            if (existingMaterial.isNamed("minecraft:water")) {
                world.setMaterialAt(x, y, height, Material.GLOW_LICHEN_DOWN.withProperty(Material.WATERLOGGED, true));
            } else {
                world.setMaterialAt(x, y, height, Material.GLOW_LICHEN_DOWN);
            }
            return true;
        }
        if (inDripstoneCave && waterDepth <= 2 && rng.nextInt(4) == 0) {
            for (int z = height + 1; z <= this.dimension.getIntHeightAt(x, y); ++z) {
                Material material = world.getMaterialAt(x, y, z);
                if (SUPPORTS_DRIPSTONE.contains(material.name) || material.isNamed("minecraft:pointed_dripstone")) {
                    this.renderStalagmite(world, x, y, height, rng.nextInt(Math.min(5, spaceAvailable)) + 1, rng);
                    return true;
                }
                if (material.solid) break;
            }
        }
        if (inLushCave) {
            if (height - 1 >= this.minZ) {
                world.setMaterialAt(x, y, height - 1, Material.MOSS_BLOCK);
            }
            if (existingMaterial.isNamed("minecraft:water")) {
                switch (rng.nextInt(10)) {
                    case 0: 
                    case 1: {
                        if (spaceAvailable <= 1) break;
                        WPObjectExporter.renderObject(world, this.dimension, this.platform, Plants.SMALL_DRIPLEAF.realise(2, this.platform), x, y, height);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (spaceAvailable <= 2) break;
                        WPObjectExporter.renderObject(world, this.dimension, this.platform, Plants.BIG_DRIPLEAF.realise(rng.nextInt(Math.min(5, spaceAvailable - 2)) + 3, this.platform), x, y, height);
                    }
                }
            } else {
                switch (rng.nextInt(20)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        WPObjectExporter.renderObject(world, this.dimension, this.platform, Plants.GRASS.realise(1, this.platform), x, y, height);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (spaceAvailable <= 1) break;
                        WPObjectExporter.renderObject(world, this.dimension, this.platform, Plants.TALL_GRASS.realise(2, this.platform), x, y, height);
                        break;
                    }
                    case 6: {
                        WPObjectExporter.renderObject(world, this.dimension, this.platform, Plants.SAPLING_FLOWERING_AZALEA.realise(1, this.platform), x, y, height);
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        WPObjectExporter.renderObject(world, this.dimension, this.platform, Plants.MOSS_CARPET.realise(1, this.platform), x, y, height);
                    }
                }
            }
        }
        return false;
    }

    private boolean decorateRoof(MinecraftWorld world, Random rng, int x, int y, int height, boolean inLushCave, boolean inDripstoneCave, Material existingMaterial, Material materialAbove, int spaceAvailable, int drySpaceAvailable) {
        if (this.decorateGlowLichen && this.decorationSettings.isEnabledAt(CaveDecorationSettings.Decoration.GLOW_LICHEN, height) && rng.nextInt(250) == 0) {
            if (existingMaterial.isNamed("minecraft:water")) {
                world.setMaterialAt(x, y, height, Material.GLOW_LICHEN_UP.withProperty(Material.WATERLOGGED, true));
            } else {
                world.setMaterialAt(x, y, height, Material.GLOW_LICHEN_UP);
            }
            return true;
        }
        if (inDripstoneCave && SUPPORTS_DRIPSTONE.contains(materialAbove.name) && rng.nextInt(4) == 0) {
            this.renderStalactite(world, x, y, height, rng.nextInt(Math.min(5, spaceAvailable)) + 1, rng);
        }
        if (inLushCave) {
            if (height + 1 <= this.maxZ) {
                world.setMaterialAt(x, y, height + 1, Material.MOSS_BLOCK);
            }
            if (!existingMaterial.isNamed("minecraft:water")) {
                switch (rng.nextInt(50)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        WPObjectExporter.renderObjectInverted(world, this.platform, Plants.GLOW_BERRIES.realise(rng.nextInt(Math.min(5, drySpaceAvailable)) + 1, this.platform), x, y, height);
                        break;
                    }
                    case 5: {
                        WPObjectExporter.renderObject(world, this.dimension, this.platform, Plants.SPORE_BLOSSOM.realise(1, this.platform), x, y, height);
                    }
                }
            }
        }
        return false;
    }

    private void decorateWall(MinecraftWorld world, Random rng, int x, int y, int height, boolean inLushCave, Material existingMaterial, Material materialNorth, Material materialSouth, Material materialEast, Material materialWest) {
        if (this.decorateGlowLichen && this.decorationSettings.isEnabledAt(CaveDecorationSettings.Decoration.GLOW_LICHEN, height) && rng.nextInt(250) == 0) {
            Material material = Material.GLOW_LICHEN_NONE;
            if (existingMaterial.isNamed("minecraft:water")) {
                material = Material.GLOW_LICHEN_NONE.withProperty(Material.WATERLOGGED, true);
            }
            ArrayList<Direction> directions = new ArrayList<Direction>(4);
            if (!materialNorth.veryInsubstantial && !materialNorth.isNamed("minecraft:pointed_dripstone")) {
                directions.add(Direction.NORTH);
            }
            if (!materialSouth.veryInsubstantial && !materialSouth.isNamed("minecraft:pointed_dripstone")) {
                directions.add(Direction.SOUTH);
            }
            if (!materialEast.veryInsubstantial && !materialEast.isNamed("minecraft:pointed_dripstone")) {
                directions.add(Direction.EAST);
            }
            if (!materialWest.veryInsubstantial && !materialWest.isNamed("minecraft:pointed_dripstone")) {
                directions.add(Direction.WEST);
            }
            world.setMaterialAt(x, y, height, material.withProperty(((Direction)((Object)directions.get(rng.nextInt(directions.size())))).name().toLowerCase(), "true"));
        }
        if (inLushCave) {
            if (!materialNorth.veryInsubstantial && !materialNorth.isNamed("minecraft:pointed_dripstone")) {
                world.setMaterialAt(x, y - 1, height, Material.MOSS_BLOCK);
            }
            if (!materialSouth.veryInsubstantial && !materialSouth.isNamed("minecraft:pointed_dripstone")) {
                world.setMaterialAt(x, y + 1, height, Material.MOSS_BLOCK);
            }
            if (!materialEast.veryInsubstantial && !materialEast.isNamed("minecraft:pointed_dripstone")) {
                world.setMaterialAt(x + 1, y, height, Material.MOSS_BLOCK);
            }
            if (!materialWest.veryInsubstantial && !materialWest.isNamed("minecraft:pointed_dripstone")) {
                world.setMaterialAt(x - 1, y, height, Material.MOSS_BLOCK);
            }
        }
    }

    private void renderStalagmite(MinecraftWorld world, int x, int y, int height, int length, Random rng) {
        int dz;
        if (height - 1 >= this.minZ) {
            world.setMaterialAt(x, y, height - 1, Material.DRIPSTONE_BLOCK);
        }
        for (dz = -2; dz <= 0; ++dz) {
            if (height + dz < this.minZ) continue;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    if (dx == 0 && dy == 0 && dz == -1 || rng.nextInt(3) <= 0) continue;
                    Material material = world.getMaterialAt(x + dx, y + dy, height + dz);
                    if (!material.opaque || !material.solid || !material.natural || material == Material.DRIPSTONE_BLOCK) continue;
                    world.setMaterialAt(x + dx, y + dy, height + dz, Material.DRIPSTONE_BLOCK);
                }
            }
        }
        for (dz = 0; dz < Math.max(length, 3); ++dz) {
            Material material = world.getMaterialAt(x, y, height + dz);
            if (material.insubstantial || material == Material.AIR || !material.isNotNamed("minecraft:water")) continue;
            length = dz;
            break;
        }
        for (dz = 0; dz < length; ++dz) {
            if (dz == length - 1) {
                this.setWaterloggedBlock(world, x, y, height + dz, Material.POINTED_DRIPSTONE_UP_TIP);
                continue;
            }
            if (dz == length - 2) {
                this.setWaterloggedBlock(world, x, y, height + dz, Material.POINTED_DRIPSTONE_UP_FRUSTUM);
                continue;
            }
            if (dz == 0) {
                this.setWaterloggedBlock(world, x, y, height + dz, Material.POINTED_DRIPSTONE_UP_BASE);
                continue;
            }
            this.setWaterloggedBlock(world, x, y, height + dz, Material.POINTED_DRIPSTONE_UP_MIDDLE);
        }
    }

    private void renderStalactite(MinecraftWorld world, int x, int y, int height, int length, Random rng) {
        int dz;
        if (height + 1 <= this.maxZ) {
            world.setMaterialAt(x, y, height + 1, Material.DRIPSTONE_BLOCK);
        }
        for (dz = 0; dz <= 2; ++dz) {
            if (height + dz > this.maxZ) continue;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    if (dx == 0 && dy == 0 && dz == 1 || rng.nextInt(3) <= 0) continue;
                    Material material = world.getMaterialAt(x + dx, y + dy, height + dz);
                    if (!material.opaque || !material.solid || !material.natural || material == Material.DRIPSTONE_BLOCK) continue;
                    world.setMaterialAt(x + dx, y + dy, height + dz, Material.DRIPSTONE_BLOCK);
                }
            }
        }
        for (dz = 0; dz < length; ++dz) {
            Material material = world.getMaterialAt(x, y, height - dz);
            if (material.insubstantial || material == Material.AIR) continue;
            length = dz;
            break;
        }
        for (dz = 0; dz < length; ++dz) {
            if (dz == length - 1) {
                this.setWaterloggedBlock(world, x, y, height - dz, Material.POINTED_DRIPSTONE_DOWN_TIP);
                continue;
            }
            if (dz == length - 2) {
                this.setWaterloggedBlock(world, x, y, height - dz, Material.POINTED_DRIPSTONE_DOWN_FRUSTUM);
                continue;
            }
            if (dz == 0) {
                this.setWaterloggedBlock(world, x, y, height - dz, Material.POINTED_DRIPSTONE_DOWN_BASE);
                continue;
            }
            this.setWaterloggedBlock(world, x, y, height - dz, Material.POINTED_DRIPSTONE_DOWN_MIDDLE);
        }
    }

    private void setWaterloggedBlock(MinecraftWorld world, int x, int y, int height, Material material) {
        world.setMaterialAt(x, y, height, material.withProperty(Material.WATERLOGGED, world.getMaterialAt(x, y, height).isNamed("minecraft:water")));
    }

    static class State {
        long seed;
        Tile tile;
        int maxY;
        int waterLevel;
        boolean glassCeiling;
        boolean breachedCeiling;
        boolean surfaceBreaking;
        boolean leaveWater;
        boolean previousBlockInCavern;
        boolean floodWithLava;

        State() {
        }
    }

    public static class CaveDecorationSettings
    implements Serializable,
    Cloneable {
        final Map<Decoration, int[]> enabledDecorations = new HashMap<Decoration, int[]>();
        final Map<Decoration, NoiseSettings> noiseSettingsMap = new HashMap<Decoration, NoiseSettings>();
        private static final long serialVersionUID = 1L;

        public CaveDecorationSettings() {
            this.enabledDecorations.put(Decoration.BROWN_MUSHROOM, null);
            this.enabledDecorations.put(Decoration.GLOW_LICHEN, null);
        }

        public CaveDecorationSettings(boolean brownMushrooms, boolean glowLichen, boolean lushCavePatches, boolean dripstoneCavePatches) {
            if (brownMushrooms) {
                this.enabledDecorations.put(Decoration.BROWN_MUSHROOM, null);
            }
            if (glowLichen) {
                this.enabledDecorations.put(Decoration.GLOW_LICHEN, null);
            }
            if (lushCavePatches) {
                this.enabledDecorations.put(Decoration.LUSH_CAVE_PATCHES, null);
                this.noiseSettingsMap.put(Decoration.LUSH_CAVE_PATCHES, new NoiseSettings(0L, 500, 1, 2.5f));
            }
            if (dripstoneCavePatches) {
                this.enabledDecorations.put(Decoration.DRIPSTONE_CAVE_PATCHES, null);
                this.noiseSettingsMap.put(Decoration.DRIPSTONE_CAVE_PATCHES, new NoiseSettings(1L, 500, 1, 2.5f));
            }
        }

        public boolean isEnabled(Decoration decoration) {
            return this.enabledDecorations.containsKey((Object)decoration);
        }

        public boolean isEnabledAt(Decoration decoration, int height) {
            if (this.enabledDecorations.containsKey((Object)decoration)) {
                int[] limits = this.enabledDecorations.get((Object)decoration);
                return limits == null || height >= limits[0] && height <= limits[1];
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaveDecorationSettings that = (CaveDecorationSettings)o;
            return this.enabledDecorations.equals(that.enabledDecorations);
        }

        public int hashCode() {
            return this.enabledDecorations.hashCode();
        }

        public CaveDecorationSettings clone() {
            try {
                return (CaveDecorationSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new MDCWrappingRuntimeException((Throwable)e);
            }
        }

        public static enum Decoration {
            BROWN_MUSHROOM,
            GLOW_LICHEN,
            LUSH_CAVE_PATCHES,
            DRIPSTONE_CAVE_PATCHES;

        }
    }
}

