/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.vecmath.Point3i;
import org.jnbt.CompoundTag;
import org.jnbt.DoubleTag;
import org.jnbt.ListTag;
import org.jnbt.NBTInputStream;
import org.jnbt.Tag;
import org.pepsoft.minecraft.AbstractNBTItem;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.objects.WPObject;

public final class Schematic
extends AbstractNBTItem
implements WPObject,
Bo2ObjectProvider {
    private String name;
    private final String materials;
    private final byte[] data;
    private final byte[] blocks;
    private final byte[] addBlocks;
    private final short width;
    private final short length;
    private final short height;
    private final int weOffsetX;
    private final int weOffsetY;
    private final int weOffsetZ;
    private final int weOriginX;
    private final int weOriginY;
    private final int weOriginZ;
    private List<Entity> entities;
    private List<TileEntity> tileEntities;
    private Point3i dimensions;
    @Deprecated
    private Point3i origin;
    private Map<String, Serializable> attributes;
    private int version = 2;
    private static final long serialVersionUID = 1L;

    public Schematic(String name, CompoundTag tag, Map<String, Serializable> attributes) {
        super(tag);
        this.name = name;
        this.materials = this.getString("Materials");
        if (this.materials == null) {
            throw new IllegalArgumentException("Invalid schematic file; Materials tag missing");
        }
        if (!this.materials.equalsIgnoreCase("Alpha")) {
            throw new IllegalArgumentException("Unsupported materials type " + this.materials);
        }
        this.blocks = this.getByteArray("Blocks");
        this.addBlocks = this.getByteArray("AddBlocks");
        this.data = this.getByteArray("Data");
        List entityTags = this.getList("Entities");
        if (entityTags == null || entityTags.isEmpty()) {
            this.entities = null;
        } else {
            this.entities = new ArrayList<Entity>(entityTags.size());
            this.entities.addAll(entityTags.stream().map(entityTag -> Entity.fromNBT(entityTag, ((ListTag)entityTag.getTag("Pos")).getValue().stream().mapToDouble(DoubleTag::getValue).toArray())).collect(Collectors.toList()));
        }
        List tileEntityTags = this.getList("TileEntities");
        if (tileEntityTags == null || tileEntityTags.isEmpty()) {
            this.tileEntities = null;
        } else {
            this.tileEntities = new ArrayList<TileEntity>(tileEntityTags.size());
            this.tileEntities.addAll(tileEntityTags.stream().map(TileEntity::fromNBT).collect(Collectors.toList()));
        }
        this.width = this.getShort("Width");
        this.length = this.getShort("Length");
        this.height = this.getShort("Height");
        Point3i offset = null;
        if (this.containsTag("WEOffsetX")) {
            this.weOffsetX = this.getInt("WEOffsetX");
            this.weOffsetY = this.getInt("WEOffsetY");
            this.weOffsetZ = this.getInt("WEOffsetZ");
            if (this.weOffsetX > -this.width && this.weOffsetX <= 0 && this.weOffsetZ > -this.length && this.weOffsetZ <= 0 && this.weOffsetY > -this.height && this.weOffsetY <= 0) {
                offset = new Point3i(this.weOffsetX, this.weOffsetZ, this.weOffsetY);
            }
        } else {
            this.weOffsetZ = 0;
            this.weOffsetY = 0;
            this.weOffsetX = 0;
        }
        this.dimensions = new Point3i((int)this.width, (int)this.length, (int)this.height);
        if (offset == null) {
            offset = this.guestimateOffset();
        }
        if (offset != null && (offset.x != 0 || offset.y != 0 || offset.z != 0)) {
            if (attributes == null) {
                attributes = new HashMap<String, Serializable>();
            }
            attributes.put(Schematic.ATTRIBUTE_OFFSET.key, (Serializable)offset);
        }
        if (this.containsTag("WEOriginX")) {
            this.weOriginX = this.getInt("WEOriginX");
            this.weOriginY = this.getInt("WEOriginY");
            this.weOriginZ = this.getInt("WEOriginZ");
        } else {
            this.weOriginZ = 0;
            this.weOriginY = 0;
            this.weOriginX = 0;
        }
        this.attributes = attributes;
    }

    @Override
    public Point3i getDimensions() {
        return this.dimensions;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        int offset = this.blockOffset(x, y, z);
        int blockId = this.blocks[offset] & 0xFF;
        if (this.addBlocks != null) {
            blockId = (offset & 1) == 0 ? (blockId |= (this.addBlocks[offset >> 1] & 0xF) << 8) : (blockId |= (this.addBlocks[offset >> 1] & 0xF0) << 4);
        }
        return Material.get(blockId, this.data[offset] & 0xF);
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        return this.blocks[this.blockOffset(x, y, z)] != 0;
    }

    @Override
    public List<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public void prepareForExport(Dimension dimension) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public WPObject getObject() {
        return this;
    }

    @Override
    public List<WPObject> getAllObjects() {
        return Collections.singletonList(this);
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        this.attributes = attributes;
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Serializable>();
            }
            this.attributes.put(key.key, value);
        } else if (this.attributes != null) {
            this.attributes.remove(key.key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public Point3i getOffset() {
        return (Point3i)this.getAttribute(ATTRIBUTE_OFFSET);
    }

    @Override
    public Schematic clone() {
        Schematic clone = (Schematic)super.clone();
        clone.dimensions = (Point3i)this.dimensions.clone();
        if (this.origin != null) {
            clone.origin = (Point3i)this.origin.clone();
        }
        if (this.entities != null) {
            clone.entities = new ArrayList<Entity>(this.entities.size());
            clone.entities.addAll(this.entities.stream().map(entity -> entity.clone()).collect(Collectors.toList()));
        }
        if (this.tileEntities != null) {
            clone.tileEntities = new ArrayList<TileEntity>(this.tileEntities.size());
            clone.tileEntities.addAll(this.tileEntities.stream().map(tileEntity -> (TileEntity)tileEntity.clone()).collect(Collectors.toList()));
        }
        if (this.attributes != null) {
            clone.attributes = new HashMap<String, Serializable>(this.attributes);
        }
        return clone;
    }

    public static Schematic load(File file) throws IOException {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        if (p != -1) {
            name = name.substring(0, p);
        }
        return Schematic.load(name, file);
    }

    public static Schematic load(String name, File file) throws IOException {
        Schematic object = Schematic.load(name, new FileInputStream(file));
        object.setAttribute(WPObject.ATTRIBUTE_FILE, file);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schematic load(String name, InputStream stream) throws IOException {
        try (FilterInputStream in = new BufferedInputStream(stream);){
            NBTInputStream nbtIn;
            Tag tag;
            byte[] magicNumber = new byte[2];
            ((InputStream)in).mark(2);
            ((InputStream)in).read(magicNumber);
            ((InputStream)in).reset();
            if (magicNumber[0] == 31 && magicNumber[1] == -117) {
                in = new GZIPInputStream(in);
            }
            if (!((tag = (nbtIn = new NBTInputStream((InputStream)in)).readTag()) instanceof CompoundTag)) {
                throw new IllegalArgumentException("Invalid schematic file; unexpected NBT tag type " + tag.getClass().getSimpleName());
            }
            Schematic schematic = new Schematic(name, (CompoundTag)tag, null);
            return schematic;
        }
    }

    private int blockOffset(int x, int y, int z) {
        return x + this.width * y + this.width * this.length * z;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.origin != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Serializable>();
            }
            this.attributes.put(Schematic.ATTRIBUTE_OFFSET.key, (Serializable)new Point3i(-this.origin.x, -this.origin.y, -this.origin.z));
            this.origin = null;
        }
        if (this.version < 1 && !this.attributes.containsKey(Schematic.ATTRIBUTE_LEAF_DECAY_MODE.key)) {
            this.attributes.put(Schematic.ATTRIBUTE_LEAF_DECAY_MODE.key, Integer.valueOf(2));
        }
        if (this.version < 2 && this.entities != null) {
            for (Entity entity : this.entities) {
                entity.setRelPos(entity.getPos());
            }
        }
        this.version = 2;
    }
}

