/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import com.khorn.terraincontrol.util.minecraftTypes.DefaultMaterial;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.vecmath.Point3i;
import org.jnbt.CompoundTag;
import org.jnbt.NBTInputStream;
import org.pepsoft.minecraft.Entity;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.util.AttributeKey;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.layers.bo2.Bo3BlockSpec;
import org.pepsoft.worldpainter.objects.AbstractObject;
import org.pepsoft.worldpainter.objects.WPObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Bo3Object
extends AbstractObject
implements Bo2ObjectProvider {
    private String name;
    private final Map<String, String> properties;
    private final Map<Point3i, Bo3BlockSpec> blocks;
    private Point3i origin;
    private Point3i dimensions;
    private Map<String, Serializable> attributes;
    private int version = 1;
    private transient List<TileEntity> tileEntities;
    public static final String KEY_RANDOM_ROTATION = "RotateRandomly";
    private static final Logger logger = LoggerFactory.getLogger(Bo3Object.class);
    private static final long serialVersionUID = 1L;

    private Bo3Object(String name, Map<String, String> properties, Map<Point3i, Bo3BlockSpec> blocks, Point3i origin, Point3i dimensions, Map<String, Serializable> attributes) {
        this.name = name;
        this.properties = properties;
        this.blocks = blocks;
        this.origin = origin;
        this.dimensions = dimensions;
        if (origin.x != 0 || origin.y != 0 || origin.z != 0) {
            if (attributes == null) {
                attributes = new HashMap<String, Serializable>();
            }
            attributes.put(Bo3Object.ATTRIBUTE_OFFSET.key, (Serializable)new Point3i(-origin.x, -origin.y, -origin.z));
        }
        if (!properties.containsKey(KEY_RANDOM_ROTATION) || !Boolean.valueOf(properties.get(KEY_RANDOM_ROTATION)).booleanValue()) {
            if (attributes == null) {
                attributes = new HashMap<String, Serializable>();
            }
            attributes.put(Bo3Object.ATTRIBUTE_RANDOM_ROTATION.key, Boolean.valueOf(false));
        }
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Point3i getDimensions() {
        return this.dimensions;
    }

    @Override
    public Material getMaterial(int x, int y, int z) {
        return this.blocks.get(new Point3i(x - this.origin.x, y - this.origin.y, z - this.origin.z)).getMaterial();
    }

    @Override
    public boolean getMask(int x, int y, int z) {
        return this.blocks.containsKey(new Point3i(x - this.origin.x, y - this.origin.y, z - this.origin.z));
    }

    @Override
    public Bo3Object getObject() {
        return this;
    }

    @Override
    public List<Entity> getEntities() {
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        if (this.tileEntities == null) {
            this.tileEntities = this.blocks.values().stream().flatMap(block -> block.getTileEntities().stream()).map(tileEntity -> {
                TileEntity clone = (TileEntity)tileEntity.clone();
                clone.setX(clone.getX() + this.origin.x);
                clone.setY(clone.getY() + this.origin.z);
                clone.setZ(clone.getZ() + this.origin.y);
                return clone;
            }).collect(Collectors.toList());
        }
        if (this.tileEntities.isEmpty()) {
            return null;
        }
        return this.tileEntities;
    }

    @Override
    public List<WPObject> getAllObjects() {
        return Collections.singletonList(this);
    }

    @Override
    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
        this.attributes = attributes;
    }

    @Override
    public <T extends Serializable> void setAttribute(AttributeKey<T> key, T value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Serializable>();
            }
            this.attributes.put(key.key, value);
        } else if (this.attributes != null) {
            this.attributes.remove(key.key);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    public boolean visitBlocks(WPObject.BlockVisitor visitor) {
        for (Map.Entry<Point3i, Bo3BlockSpec> entry : this.blocks.entrySet()) {
            Point3i coords = entry.getKey();
            if (visitor.visitBlock(this, coords.x + this.origin.x, coords.y + this.origin.y, coords.z + this.origin.z, entry.getValue().getMaterial())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Bo3Object clone() {
        Bo3Object clone = (Bo3Object)super.clone();
        clone.origin = (Point3i)this.origin.clone();
        clone.dimensions = (Point3i)this.dimensions.clone();
        if (this.attributes != null) {
            clone.attributes = new HashMap<String, Serializable>(this.attributes);
        }
        return clone;
    }

    public static Bo3Object load(File file) throws IOException {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        if (p != -1) {
            name = name.substring(0, p);
        }
        return Bo3Object.load(name, file);
    }

    public static Bo3Object load(String objectName, File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("US-ASCII")));){
            String line;
            HashMap<String, String> properties = new HashMap<String, String>();
            HashMap<Point3i, Bo3BlockSpec> blocks = new HashMap<Point3i, Bo3BlockSpec>();
            int lowestX = Integer.MAX_VALUE;
            int highestX = Integer.MIN_VALUE;
            int lowestY = Integer.MAX_VALUE;
            int highestY = Integer.MIN_VALUE;
            int lowestZ = Integer.MAX_VALUE;
            int highestZ = Integer.MIN_VALUE;
            while ((line = in.readLine()) != null) {
                int y;
                int z;
                int x;
                Deque<String> args;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("Block")) {
                    args = Bo3Object.getArgs(line);
                    x = Integer.parseInt(args.pop());
                    z = Integer.parseInt(args.pop());
                    y = Integer.parseInt(args.pop());
                    if (x < lowestX) {
                        lowestX = x;
                    }
                    if (x > highestX) {
                        highestX = x;
                    }
                    if (y < lowestY) {
                        lowestY = y;
                    }
                    if (y > highestY) {
                        highestY = y;
                    }
                    if (z < lowestZ) {
                        lowestZ = z;
                    }
                    if (z > highestZ) {
                        highestZ = z;
                    }
                    Material material = Bo3Object.decodeMaterial(args.pop());
                    TileEntity tileEntity = null;
                    if (!args.isEmpty()) {
                        tileEntity = Bo3Object.loadTileEntity(file, args.pop());
                    }
                    Point3i coords = new Point3i(x, y, z);
                    blocks.put(coords, new Bo3BlockSpec(coords, material, tileEntity));
                    continue;
                }
                if (line.startsWith("RandomBlock")) {
                    args = Bo3Object.getArgs(line);
                    x = Integer.parseInt(args.pop());
                    z = Integer.parseInt(args.pop());
                    y = Integer.parseInt(args.pop());
                    if (x < lowestX) {
                        lowestX = x;
                    }
                    if (x > highestX) {
                        highestX = x;
                    }
                    if (y < lowestY) {
                        lowestY = y;
                    }
                    if (y > highestY) {
                        highestY = y;
                    }
                    if (z < lowestZ) {
                        lowestZ = z;
                    }
                    if (z > highestZ) {
                        highestZ = z;
                    }
                    ArrayList<Bo3BlockSpec.RandomBlock> randomBlocks = new ArrayList<Bo3BlockSpec.RandomBlock>();
                    do {
                        int chance;
                        Material material = Bo3Object.decodeMaterial(args.pop());
                        String nbtOrChance = args.pop();
                        TileEntity tileEntity = null;
                        try {
                            chance = Integer.parseInt(nbtOrChance);
                        }
                        catch (NumberFormatException e) {
                            tileEntity = Bo3Object.loadTileEntity(file, nbtOrChance);
                            chance = Integer.parseInt(args.pop());
                        }
                        randomBlocks.add(new Bo3BlockSpec.RandomBlock(material, tileEntity, chance));
                    } while (!args.isEmpty());
                    Point3i coords = new Point3i(x, y, z);
                    blocks.put(coords, new Bo3BlockSpec(coords, randomBlocks.toArray(new Bo3BlockSpec.RandomBlock[randomBlocks.size()])));
                    continue;
                }
                if (line.startsWith("BlockCheck") || line.startsWith("LightCheck") || line.startsWith("Branch") || line.startsWith("WeightedBranch")) {
                    logger.warn("Ignoring unsupported bo3 feature " + line);
                    continue;
                }
                int p = line.indexOf(58);
                if (p != -1) {
                    properties.put(line.substring(0, p).trim(), line.substring(p + 1).trim());
                    continue;
                }
                logger.warn("Ignoring unrecognised line: " + line);
            }
            if (blocks.isEmpty()) {
                throw new IOException("No blocks found in the file; is this a bo3 object?");
            }
            HashMap<String, Serializable> attributes = new HashMap<String, Serializable>(Collections.singletonMap(Bo3Object.ATTRIBUTE_FILE.key, file));
            Bo3Object bo3Object = new Bo3Object(objectName, properties, blocks, new Point3i(-lowestX, -lowestY, -lowestZ), new Point3i(highestX - lowestX + 1, highestY - lowestY + 1, highestZ - lowestZ + 1), attributes);
            return bo3Object;
        }
    }

    private static Deque<String> getArgs(String line) {
        int end;
        int start = line.indexOf(40);
        if (start != -1 && (end = line.lastIndexOf(41)) != -1) {
            ArrayDeque<String> args = new ArrayDeque<String>();
            args.addAll(Arrays.asList(line.substring(start + 1, end).split(",")));
            return args;
        }
        throw new IllegalArgumentException("Could not parse line \"" + line + "\"");
    }

    private static Material decodeMaterial(String materialSpec) {
        int p = materialSpec.indexOf(58);
        if (p == -1) {
            if (Character.isDigit(materialSpec.charAt(0))) {
                return Material.get(Integer.parseInt(materialSpec));
            }
            return Material.get(DefaultMaterial.valueOf((String)materialSpec).id);
        }
        String idSpec = materialSpec.substring(0, p).trim();
        String dataSpec = materialSpec.substring(p + 1).trim();
        if (Character.isDigit(idSpec.charAt(0))) {
            return Material.get(Integer.parseInt(idSpec), Integer.parseInt(dataSpec));
        }
        return Material.get(DefaultMaterial.valueOf((String)idSpec).id, Integer.parseInt(dataSpec));
    }

    private static TileEntity loadTileEntity(File bo3File, String nbtFileName) throws IOException {
        File nbtFile = new File(bo3File.getParentFile(), nbtFileName);
        try (NBTInputStream in = new NBTInputStream((InputStream)new GZIPInputStream(new FileInputStream(nbtFile)));){
            CompoundTag tag = (CompoundTag)in.readTag();
            Map map = tag.getValue();
            if (map.size() == 1 && map.values().iterator().next() instanceof CompoundTag) {
                TileEntity tileEntity = TileEntity.fromNBT((CompoundTag)tag.getValue().values().iterator().next());
                return tileEntity;
            }
            TileEntity tileEntity = TileEntity.fromNBT(tag);
            return tileEntity;
        }
    }
}

