/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.vecmath.Point3i;
import org.pepsoft.minecraft.Material;
import org.pepsoft.minecraft.TileEntity;
import org.pepsoft.worldpainter.layers.bo2.Bo2BlockSpec;

public class Bo3BlockSpec
extends Bo2BlockSpec {
    private final TileEntity tileEntity;
    private final RandomBlock[] randomBlocks;
    private static final Random RANDOM = new Random();
    private static final long serialVersionUID = 1L;

    public Bo3BlockSpec(Point3i coords, Material material, TileEntity tileEntity) {
        super(coords, material, null);
        this.tileEntity = tileEntity;
        if (tileEntity != null) {
            tileEntity.setX(coords.x);
            tileEntity.setY(coords.z);
            tileEntity.setZ(coords.y);
        }
        this.randomBlocks = null;
    }

    public Bo3BlockSpec(Point3i coords, RandomBlock[] randomBlocks) {
        super(coords, null, null);
        this.tileEntity = null;
        this.randomBlocks = randomBlocks;
        Arrays.stream(randomBlocks).filter(b -> b.tileEntity != null).forEach(b -> {
            b.tileEntity.setX(coords.x);
            b.tileEntity.setY(coords.z);
            b.tileEntity.setZ(coords.y);
        });
    }

    public Set<TileEntity> getTileEntities() {
        if (this.randomBlocks != null) {
            return Arrays.stream(this.randomBlocks).filter(b -> b.tileEntity != null).map(b -> b.tileEntity).collect(Collectors.toSet());
        }
        if (this.tileEntity != null) {
            return Collections.singleton(this.tileEntity);
        }
        return Collections.emptySet();
    }

    @Override
    public Material getMaterial() {
        if (this.randomBlocks != null) {
            for (RandomBlock randomBlock : this.randomBlocks) {
                if (randomBlock.chance < 100 && RANDOM.nextInt(100) >= randomBlock.chance) continue;
                return randomBlock.material;
            }
            return this.randomBlocks[this.randomBlocks.length - 1].material;
        }
        return super.getMaterial();
    }

    public static class RandomBlock {
        final Material material;
        final TileEntity tileEntity;
        final int chance;

        RandomBlock(Material material, TileEntity tileEntity, int chance) {
            this.material = material;
            this.tileEntity = tileEntity;
            this.chance = chance;
        }
    }
}

