/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers.bo2;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import org.pepsoft.worldpainter.layers.bo2.Bo2ObjectProvider;
import org.pepsoft.worldpainter.objects.WPObject;
import org.pepsoft.worldpainter.plugins.CustomObjectManager;

public final class Bo2ObjectTube
implements Bo2ObjectProvider {
    private final String name;
    private final List<WPObject> objects;
    private transient Random random = new Random();
    private transient SortedMap<Integer, WPObject> weightedObjects;
    private transient int totalObjectWeight;
    private static final long serialVersionUID = 1L;

    public Bo2ObjectTube(String name, List<WPObject> objects) {
        this.name = name;
        this.objects = Collections.unmodifiableList(objects);
        this.initWeightedObjects();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public WPObject getObject() {
        return this.weightedObjects.tailMap(this.random.nextInt(this.totalObjectWeight)).values().iterator().next();
    }

    @Override
    public List<WPObject> getAllObjects() {
        return this.objects;
    }

    @Override
    public Bo2ObjectTube clone() {
        ArrayList<WPObject> clonedObjects = new ArrayList<WPObject>(this.objects.size());
        this.objects.forEach(object -> clonedObjects.add(object.clone()));
        return new Bo2ObjectTube(this.name, clonedObjects);
    }

    private void initWeightedObjects() {
        this.weightedObjects = new TreeMap<Integer, WPObject>();
        this.totalObjectWeight = 0;
        for (WPObject object : this.objects) {
            int frequency = object.getAttribute(WPObject.ATTRIBUTE_FREQUENCY);
            this.totalObjectWeight += frequency;
            this.weightedObjects.put(this.totalObjectWeight, object);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.random = new Random();
        this.initWeightedObjects();
    }

    public static Bo2ObjectTube load(File dir) throws IOException {
        return Bo2ObjectTube.load(dir.getName(), dir);
    }

    public static Bo2ObjectTube load(String name, File dir) throws IOException {
        File[] files = dir.listFiles(CustomObjectManager.getInstance().getFileFilter());
        return Bo2ObjectTube.load(name, Arrays.asList(files));
    }

    public static Bo2ObjectTube load(String name, Collection<File> files) throws IOException {
        if (files.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an object tube with no objects");
        }
        ArrayList<WPObject> objects = new ArrayList<WPObject>(files.size());
        CustomObjectManager customObjectManager = CustomObjectManager.getInstance();
        for (File file : files) {
            objects.add(customObjectManager.loadObject(file));
        }
        return new Bo2ObjectTube(name, objects);
    }
}

