/*
 * Decompiled with CFR 0.152.
 */
package org.pepsoft.worldpainter.layers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Random;
import org.pepsoft.util.PerlinNoise;
import org.pepsoft.worldpainter.Dimension;
import org.pepsoft.worldpainter.Platform;
import org.pepsoft.worldpainter.exporting.LayerExporter;
import org.pepsoft.worldpainter.layers.Layer;
import org.pepsoft.worldpainter.layers.exporters.ExporterSettings;
import org.pepsoft.worldpainter.layers.exporters.TreesExporter;
import org.pepsoft.worldpainter.layers.trees.TreeType;

public abstract class TreeLayer
extends Layer {
    private static final int MUSHROOM_INCIDENCE = 25;
    private static final float MUSHROOM_CHANCE = PerlinNoise.getLevelForPromillage((int)10);
    private static final long serialVersionUID = 2011032901L;

    protected TreeLayer(String treeName, String treeDescription, int priority, char mnemonic) {
        super(treeName, "Generate " + treeDescription, Layer.DataSize.NIBBLE, false, priority, mnemonic);
    }

    protected TreeLayer(String treeName, String treeDescription, int priority) {
        super(treeName, "Generate " + treeDescription, Layer.DataSize.NIBBLE, false, priority);
    }

    @Override
    public Class<? extends LayerExporter> getExporterType() {
        return TreesExporter.class;
    }

    @Override
    public TreesExporter<? extends TreeLayer> getExporter(Dimension dimension, Platform platform, ExporterSettings settings) {
        return new TreesExporter<TreeLayer>(dimension, platform, settings, this);
    }

    public int getDefaultMaxWaterDepth() {
        return 0;
    }

    public int getDefaultTreeChance() {
        return 1280;
    }

    public int getDefaultMushroomIncidence() {
        return 25;
    }

    public float getDefaultMushroomChance() {
        return MUSHROOM_CHANCE;
    }

    public int getDefaultLayerStrengthCap() {
        return Integer.MAX_VALUE;
    }

    public abstract TreeType pickTree(Random var1);

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

